/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;

public class ProbePerfTracker {
    public static int PROCESS_CIMSCANNER = 0;
    public static int CIMOM_ENUMERATOR = PROCESS_CIMSCANNER + 1;
    public static int CIMOM_ENUMERATOR_NAMES = CIMOM_ENUMERATOR + 1;
    public static int CIMOM_ASSOCIATORS = CIMOM_ENUMERATOR_NAMES + 1;
    public static int CIMOM_ASSOCIATORS_NAMES = CIMOM_ASSOCIATORS + 1;
    public static int CIMOM_REFERENCES = CIMOM_ASSOCIATORS_NAMES + 1;
    public static int CIMOM_REFERENCES_NAMES = CIMOM_REFERENCES + 1;
    public static int CIMOM_GETINSTANCE = CIMOM_REFERENCES_NAMES + 1;
    public static int DISKCIMPROCESSOR_HANDLE_ASSOCIATION = CIMOM_GETINSTANCE + 1;
    public static int DISKCIMPROCESSOR_HANDLE_ENTITY = DISKCIMPROCESSOR_HANDLE_ASSOCIATION + 1;
    public static int STEP_PERSIST_STORAGESETTING = DISKCIMPROCESSOR_HANDLE_ENTITY + 1;
    public static int MAPPER_PERSIST = STEP_PERSIST_STORAGESETTING + 1;
    public static int DBC_COMMIT = MAPPER_PERSIST + 1;
    public static int DBC_QUERY = DBC_COMMIT + 1;
    public static int PROCESSOR_END = DBC_QUERY + 1;
    public static int POST_PROCESSING = PROCESSOR_END + 1;
    public static int NUMBER_OF_ACTIONTYPES = POST_PROCESSING + 1;
    public static String NEWLINE = System.getProperty("line.separator");
    public static String[] sActionDesc = new String[NUMBER_OF_ACTIONTYPES];
    ProbeAction[] cProbeActions = new ProbeAction[NUMBER_OF_ACTIONTYPES];
    String cScannerId;
    long cProbeStart = 0L;

    public ProbePerfTracker(String pScannerId) {
        this.cScannerId = pScannerId;
        this.cProbeStart = System.currentTimeMillis();
        for (int bCounter = 0; bCounter < this.cProbeActions.length; ++bCounter) {
            this.cProbeActions[bCounter] = new ProbeAction();
        }
    }

    public ProbeAction startAction(int pActionType) {
        if (pActionType >= 0 && pActionType < NUMBER_OF_ACTIONTYPES) {
            ProbeAction mProbeAction = this.cProbeActions[pActionType];
            mProbeAction.start();
            return mProbeAction;
        }
        return null;
    }

    public void finishedAction(int pActionType) {
        if (pActionType > 0 && pActionType < NUMBER_OF_ACTIONTYPES) {
            ProbeAction mProbeAction = this.cProbeActions[pActionType];
            mProbeAction.finished();
        }
    }

    public void probeFinished(LogTraceHelper pLTH) {
        long mProbeFinished = System.currentTimeMillis();
        Date mFinishedTime = new Date(mProbeFinished);
        Date mStartTime = new Date(this.cProbeStart);
        DecimalFormat mDf = new DecimalFormat("0000");
        StringBuffer mReport = new StringBuffer();
        mReport.append("Probe performance Tracker Report").append(NEWLINE);
        mReport.append("====================================================================").append(NEWLINE);
        mReport.append("Probe scanner id: ").append(this.cScannerId).append(NEWLINE);
        mReport.append("Probe started:  ").append(mStartTime.toString()).append(NEWLINE);
        mReport.append("Probe finished: ").append(mFinishedTime.toString()).append(NEWLINE);
        mReport.append("Probe duration: ").append(this.formatDuration(mProbeFinished - this.cProbeStart)).append(NEWLINE);
        mReport.append("Monitored probe Actions:").append(NEWLINE);
        for (int bCounter = 0; bCounter < this.cProbeActions.length; ++bCounter) {
            ProbeAction bProbeAction = this.cProbeActions[bCounter];
            int bCallCount = bProbeAction.getCallCount();
            long bDuration = bProbeAction.getDuration();
            long bAvgDuration = bCallCount > 0 ? bDuration / (long)bCallCount : 0L;
            mReport.append(sActionDesc[bCounter]).append(": No. of calls: ").append(mDf.format(bCallCount));
            mReport.append(", Total time: ").append(this.formatDuration(bDuration));
            mReport.append(", Average time: ").append(this.formatDuration(bAvgDuration)).append(NEWLINE);
        }
        mReport.append("====================================================================").append(NEWLINE);
        pLTH.traceAlways(mReport.toString());
    }

    private StringBuffer formatDuration(long pDuration) {
        DecimalFormat mDf = new DecimalFormat("00");
        DecimalFormat m000Df = new DecimalFormat("000");
        long mHours = pDuration / 3600000L;
        long mMinutes = (pDuration %= 3600000L) / 60000L;
        long mSeconds = (pDuration %= 60000L) / 1000L;
        long mMillisecs = pDuration % 1000L;
        return new StringBuffer().append(mDf.format(mHours)).append(':').append(mDf.format(mMinutes)).append(':').append(mDf.format(mSeconds)).append('.').append(m000Df.format(mMillisecs));
    }

    static {
        ProbePerfTracker.sActionDesc[ProbePerfTracker.PROCESS_CIMSCANNER] = "process CIMScanner          ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_ENUMERATOR] = "CIM call Enumerator         ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_ENUMERATOR_NAMES] = "CIM call EnumeratorNames    ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_ASSOCIATORS] = "CIM call Associators        ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_ASSOCIATORS_NAMES] = "CIM call AssociatorNames    ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_REFERENCES] = "CIM call References         ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_REFERENCES_NAMES] = "CIM call ReferencesNames    ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.CIMOM_GETINSTANCE] = "CIM call getInstance        ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.DISKCIMPROCESSOR_HANDLE_ASSOCIATION] = "DiskCIMProc.handleAssoc.    ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.DISKCIMPROCESSOR_HANDLE_ENTITY] = "DiskCIMProc.handleEntity    ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.STEP_PERSIST_STORAGESETTING] = "Step.PersistStorageSetting  ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.MAPPER_PERSIST] = "Mapper.persist              ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.DBC_COMMIT] = "DBConnection.commit         ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.DBC_QUERY] = "DB.executeQuery             ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.PROCESSOR_END] = "Processor.end               ";
        ProbePerfTracker.sActionDesc[ProbePerfTracker.POST_PROCESSING] = "Post Processing             ";
    }

    public class ProbeAction {
        long cDuration = 0L;
        long cStartTime = 0L;
        int cCallCounter = 0;

        protected void start() {
            this.cStartTime = System.currentTimeMillis();
        }

        protected void finished() {
            this.cDuration += System.currentTimeMillis() - this.cStartTime;
            ++this.cCallCounter;
        }

        protected long getDuration() {
            return this.cDuration;
        }

        protected int getCallCount() {
            return this.cCallCounter;
        }
    }
}

