/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.Map;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;

public class ProcessProcessor
extends Thread {
    public static String queueName = "Processes";
    private boolean shutdown = false;
    Thread thread = null;

    public ProcessProcessor() {
        this.setName(queueName + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.start();
    }

    public void run() {
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            try {
                if (Configuration.debug) {
                    System.out.println(queueName + ": waiting for a job");
                }
                JobInfo job = QueueController.getInstance().getNextJob(queueName);
                if (this.shutdown) continue;
                if (job == null) {
                    System.out.println(queueName + ":Error - got a NULL job from the queue");
                    continue;
                }
                try {
                    Object[] request = (Object[])job.getRequest().getData();
                    if (Configuration.debug) {
                        System.out.println(queueName + ": invoking " + request);
                    }
                    String[] ID = Router.getRouter().perform((String)request[0], (Map)request[1], job.getDiscoverRequest());
                    job.setResponse((Response)new ObjectResponse(ID, job));
                    job.setReturnCode(0);
                    job.complete(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    job.setReturnCode(103);
                    job.complete(false);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.thread != null) {
            try {
                this.thread.interrupt();
                this.thread.join(30000L);
                this.thread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

