/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.cimom;

import java.util.Hashtable;
import org.eclipse.aperi.discovery.cimom.CIMScanner;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.pool.ResourceCreator;

class CimomWrapperCreator
implements ResourceCreator {
    public static final String MESSAGE_NAME = "aperi.logger.message.CimomCreator";
    public static final String TRACE_NAME = "aperi.logger.trace.CimomCreator";
    public static String MSG_FILE = "org.eclipse.aperi.resources.CimomCreator";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    public static boolean trace = false;
    public static String className = CIMScanner.class.getName();

    CimomWrapperCreator() {
    }

    public Object createResource(Hashtable parameters) {
        String methodName = "createResource()";
        if (traceLogger != null && traceLogger.isLogging()) {
            trace = true;
        }
        if (trace) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String user = (String)parameters.get("USERID");
        String password = (String)parameters.get("PASSWORD");
        String URL2 = (String)parameters.get("URL");
        String namespace = (String)parameters.get("NAMESPACE");
        CIMClientWrapper cimClient = new CIMClientWrapper(user, password, URL2, namespace);
        if (trace) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return cimClient;
    }

    public void initializeResource(Object resource) {
        if (resource instanceof CIMClientWrapper) {
            ((CIMClientWrapper)resource).clearInstance();
        } else {
            System.out.println(resource + " is not a CIMClientWrapper");
        }
    }

    public void freeResource(Object resource) {
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

