/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.cimom;

import java.net.InetAddress;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.sblim.slp.Locator;
import org.sblim.slp.ServiceLocationEnumeration;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.ServiceLocationManager;
import org.sblim.slp.ServiceType;
import org.sblim.slp.ServiceURL;

public class SLPScanner
extends Thread {
    public static String queueName = "SLP";
    public static String discoverAll = "DiscoverAll";
    private boolean shutdown = false;
    private Thread thread = null;
    public static final String MESSAGE_NAME = "aperi.logger.message.SLPScanner";
    public static final String TRACE_NAME = "aperi.logger.trace.SLPScanner";
    public static String MSG_FILE = "org.eclipse.aperi.discovery.parser.resources.MsgLoggingTMS";
    public static final String SERVICE_WBEM_HTTPS = "service:wbem:https";
    public static final String SERVICE_WBEM_HTTP = "service:wbem:http";
    private static String className = SLPScanner.class.getName();
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;

    public SLPScanner() {
        this.setName(queueName + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getCIMOMServices(Locator locator, Vector scope, boolean local, Vector DAs) throws ServiceLocationException {
        ServiceType servicetype;
        String msg;
        String methodName = "getCIMOMServices";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Vector<ServiceURL> res = new Vector<ServiceURL>();
        if (locator == null) {
            return res;
        }
        ServiceLocationEnumeration e = null;
        if (local) {
            if (traceLogger.isLogging()) {
                msg = queueName + ":Multicast discovery in progress";
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, msg);
            }
            servicetype = new ServiceType(SERVICE_WBEM_HTTPS);
            String daAddresses = System.getProperty("net.slp.DAAddresses");
            try {
                ServiceURL s;
                System.setProperty("net.slp.DAAddresses", "");
                e = locator.findServices(servicetype, scope, "");
                while (e.hasMoreElements()) {
                    s = (ServiceURL)e.nextElement();
                    res.add(s);
                }
                servicetype = new ServiceType(SERVICE_WBEM_HTTP);
                e = locator.findServices(servicetype, scope, "");
                while (e.hasMoreElements()) {
                    s = (ServiceURL)e.nextElement();
                    res.add(s);
                }
            }
            finally {
                try {
                    System.setProperty("net.slp.DAAddresses", daAddresses);
                }
                catch (Exception ex) {}
            }
        }
        if (DAs != null && DAs.size() > 0) {
            ServiceURL s;
            if (traceLogger.isLogging()) {
                msg = queueName + ":DA discovery in progress";
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, msg);
            }
            servicetype = new ServiceType(SERVICE_WBEM_HTTPS);
            e = locator.findServices(servicetype, scope, "", DAs);
            while (e.hasMoreElements()) {
                s = (ServiceURL)e.nextElement();
                res.add(s);
            }
            servicetype = new ServiceType(SERVICE_WBEM_HTTP);
            e = locator.findServices(servicetype, scope, "", DAs);
            while (e.hasMoreElements()) {
                s = (ServiceURL)e.nextElement();
                res.add(s);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector findAttributes(Locator locator, ServiceURL servicetype, Vector scopes, Vector attributeIds, boolean local, Vector directoryAgents) throws ServiceLocationException {
        String methodName = "findAttributes";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Vector result = new Vector();
        ServiceLocationEnumeration e = null;
        if (local) {
            String daAddresses = System.getProperty("net.slp.DAAddresses");
            try {
                System.setProperty("net.slp.DAAddresses", "");
                e = locator.findAttributes(servicetype, scopes, attributeIds);
                while (e.hasMoreElements()) {
                    result.add(e.nextElement());
                }
            }
            finally {
                System.setProperty("net.slp.DAAddresses", daAddresses);
            }
        }
        if (directoryAgents != null && directoryAgents.size() > 0) {
            e = locator.findAttributes(servicetype, scopes, attributeIds, directoryAgents);
            while (e.hasMoreElements()) {
                result.add(e.nextElement());
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public void run() {
        String msg;
        Locator locator;
        String methodName;
        block43: {
            methodName = "run";
            this.thread = Thread.currentThread();
            locator = null;
            try {
                locator = ServiceLocationManager.getLocator((Locale)Locale.getDefault());
            }
            catch (ServiceLocationException e) {
                msg = queueName + ":Error - Failed to start service - no locale object found for the SLP client";
                if (Configuration.debug) {
                    System.out.println(msg);
                }
                if (!traceLogger.isLogging()) break block43;
                traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, methodName, msg);
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        while (!this.shutdown) {
            if (Configuration.debug) {
                System.out.println(queueName + ": waiting for a job");
            }
            if (traceLogger.isLogging()) {
                String msg2 = queueName + ": waiting for a job";
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, msg2);
            }
            JobInfo job = QueueController.getInstance().getNextJob(queueName);
            if (this.shutdown) {
                msg = queueName + ":Shutting down SLPScanner";
                if (!traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, msg);
                continue;
            }
            if (job == null) {
                msg = queueName + ":Error - got a NULL job from the queue";
                if (!traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, methodName, msg);
                continue;
            }
            try {
                String msg3;
                Response resp;
                if (Configuration.debug) {
                    System.out.println(queueName + ": performing SLP scan");
                }
                if (traceLogger.isLogging()) {
                    msg = queueName + ": performing SLP scan";
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, msg);
                }
                if ((resp = job.getRequest()) == null) {
                    String msg4 = queueName + ":Error got a NULL scope parameter";
                    if (Configuration.debug) {
                        System.out.println(msg4);
                    }
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, methodName, msg4);
                    continue;
                }
                Vector params = (Vector)resp.getData();
                if (params == null || params.size() != 2) {
                    String msg5 = null;
                    msg5 = params == null && Configuration.debug ? queueName + ":Error got a NULL parameter for the SLP scanner" : queueName + ":Error got invalid number of parameters. Total parameters:" + params.size() + ", it should be 2";
                    if (Configuration.debug) {
                        System.out.println(msg5);
                    }
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, methodName, msg5);
                    continue;
                }
                String[] scopeList = null;
                String[] DAs = null;
                if (!(params.elementAt(0) instanceof String[])) {
                    msg3 = queueName + ":Error got an invalid parameter for 'scope'. A String[] must be used.";
                    if (Configuration.debug) {
                        System.out.println(msg3);
                    }
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, methodName, msg3);
                    continue;
                }
                if (!(params.elementAt(1) instanceof String[])) {
                    msg3 = queueName + ":Error got an invalid parameter for 'DA'. A String[] must be used.";
                    if (Configuration.debug) {
                        System.out.println(msg3);
                    }
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, methodName, msg3);
                    continue;
                }
                scopeList = (String[])params.elementAt(0);
                DAs = (String[])params.elementAt(1);
                Vector<String> scope = new Vector<String>();
                if (scopeList == null || scopeList.length == 0) {
                    if (traceLogger.isLogging()) {
                        String msg6 = queueName + ":Using'default' scope...";
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, msg6);
                    }
                    scope.add("default");
                } else {
                    for (int i = 0; i < scopeList.length; ++i) {
                        if (scopeList[i] == null) continue;
                        scope.add(scopeList[i]);
                    }
                }
                boolean local = false;
                Vector<InetAddress> DAList = new Vector<InetAddress>();
                for (int i = 0; i < DAs.length; ++i) {
                    if (DAs[i] == null || "local".equals(DAs[i])) {
                        local = true;
                        continue;
                    }
                    try {
                        InetAddress ia = InetAddress.getByName(DAs[i]);
                        DAList.add(ia);
                        continue;
                    }
                    catch (Exception e) {
                        String msg7 = queueName + ":Can not resolve address:" + DAs[i];
                        if (Configuration.debug) {
                            System.out.println(msg7);
                        }
                        if (!traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, methodName, msg7);
                    }
                }
                if (DAList.size() == 0) {
                    local = true;
                }
                try {
                    Vector cimomServicesList = this.getCIMOMServices(locator, scope, local, DAList);
                    Vector<Vector> cimomAttributes = new Vector<Vector>();
                    for (ServiceURL url : cimomServicesList) {
                        Vector attributes = this.findAttributes(locator, url, scope, new Vector(), local, DAList);
                        if (Configuration.debug) {
                            System.out.println(url);
                            if (traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, url.toString());
                            }
                            for (Object o : attributes) {
                                System.out.println(o);
                                if (!traceLogger.isLogging()) continue;
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, o.toString());
                            }
                        }
                        cimomAttributes.add(attributes);
                    }
                    ObjectResponse oResp = new ObjectResponse(cimomAttributes, job);
                    job.setResponse((Response)oResp);
                    job.setReturnCode(0);
                    job.queryComplete(true);
                }
                catch (ServiceLocationException e) {
                    short errorCode = e.getErrorCode();
                    job.setReturnCode((int)errorCode);
                    if (Configuration.debug) {
                        e.printStackTrace();
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    job.complete(false);
                }
                catch (Exception e) {
                    if (Configuration.debug) {
                        e.printStackTrace();
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    job.setReturnCode(10);
                    job.complete(false);
                }
            }
            catch (Throwable e) {
                if (Configuration.debug) {
                    e.printStackTrace();
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, e);
                }
                job.setReturnCode(10);
                job.complete(false);
            }
            if (!Configuration.debug) continue;
            System.out.println(queueName + ": finishing job");
        }
    }

    public void shutdown() {
        block4: {
            String methodName = "shutdown";
            this.shutdown = true;
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread.join(30000L);
                    this.thread = null;
                }
                catch (Exception e) {
                    if (Configuration.debug) {
                        e.printStackTrace();
                    }
                    if (!traceLogger.isLogging()) break block4;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
    }

    public static void main(String[] args) {
        SLPScanner scanner = new SLPScanner();
        System.out.println("");
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

