/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.discovery.interfaces.DiscoveryException;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.parser.Processor;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;

public class CIMProcessor
extends Processor {
    public CIMProcessor() {
        super("SMIS");
    }

    public static Hashtable convertPropertiesToHashtable(Vector properties, Hashtable htProperties) {
        Enumeration parms = properties.elements();
        while (parms.hasMoreElements()) {
            CIMProperty property = (CIMProperty)parms.nextElement();
            CIMValue value = property.getValue();
            if (value == null) continue;
            String bPropertyName = property.getName().toLowerCase();
            if (value.getValue() instanceof CIMObjectPath) {
                CIMObjectPath path = (CIMObjectPath)value.getValue();
                Hashtable<String, String> newProps = new Hashtable<String, String>();
                newProps.put("instance", path.getObjectName().toString());
                htProperties.put(bPropertyName, CIMProcessor.convertPropertiesToHashtable(path.getKeys(), newProps));
                continue;
            }
            if (value.isArrayValue()) {
                Vector v = (Vector)value.getValue();
                Vector<String> newV = new Vector<String>();
                for (int i = 0; i < v.size(); ++i) {
                    newV.add(v.elementAt(i).toString());
                }
                htProperties.put(bPropertyName, newV.toString());
                continue;
            }
            htProperties.put(bPropertyName, property.getValue().getValue().toString());
        }
        return htProperties;
    }

    public void handleInstance(JobInfo job, CIMInstance instance) throws DiscoveryException {
        Hashtable group;
        Hashtable properties = CIMProcessor.convertPropertiesToHashtable(instance.getProperties(), new Hashtable());
        Hashtable part = (Hashtable)properties.get("partcomponent");
        if (part == null) {
            part = (Hashtable)properties.get("dependent");
        }
        if ((group = (Hashtable)properties.get("groupcomponent")) == null) {
            group = (Hashtable)properties.get("antecedent");
        }
        if (part != null && group != null) {
            this.handleAssociation(job, instance.getClassName(), (String)group.get("instance"), group, (String)part.get("instance"), part, properties);
        } else {
            this.handleEntity(job, instance.getClassName(), properties);
        }
    }

    public void handleEntity(JobInfo job, String instance, Hashtable properties) throws DiscoveryException {
        properties.put("ref_serviceurl", job.getTarget()[0]);
        properties.put("ref_namespace", job.getTarget()[1]);
        super.handleEntity(job, instance, properties);
    }

    public void handleAssociation(JobInfo job, String association, String entity1, Hashtable entity1_properties, String entity2, Hashtable entity2_properties, Hashtable properties) throws DiscoveryException {
        entity1_properties.put("ref_serviceurl", job.getTarget()[0]);
        entity1_properties.put("ref_namespace", job.getTarget()[1]);
        entity2_properties.put("ref_serviceurl", job.getTarget()[0]);
        entity2_properties.put("ref_namespace", job.getTarget()[1]);
        properties.put("ref_serviceurl", job.getTarget()[0]);
        properties.put("ref_namespace", job.getTarget()[1]);
        super.handleAssociation(job, association, entity1, entity1_properties, entity2, entity2_properties, properties);
    }
}

