/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.io.InvalidClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.NOPHandler;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskIndicationHandlerFactory {
    private static DiskIndicationHandlerFactory stSingletonInstance = new DiskIndicationHandlerFactory();
    private Map cHandlerMap = new HashMap(50);
    private Map cSuperclassMap = Collections.synchronizedMap(new HashMap(100));

    public static DiskIndicationHandlerFactory getInstance() {
        return stSingletonInstance;
    }

    private DiskIndicationHandlerFactory() {
        this.cHandlerMap = new HashMap();
    }

    public ICIMIndicationHandler getHandler(String pIndicationClassname, String pCimClassname, CIMIndicationEvent pEvent) {
        Class<NOPHandler> mHandler = this.findHandler(pIndicationClassname, pCimClassname);
        if (mHandler == null && (mHandler = this.findHandler(pIndicationClassname, this.getSuperclass(pCimClassname, pEvent))) == null) {
            mHandler = NOPHandler.class;
        }
        try {
            Class[] mArgumentTypes = new Class[]{String.class, String.class, CIMIndicationEvent.class};
            Constructor mCtor = mHandler.getConstructor(mArgumentTypes);
            Object[] mArguments = new Object[]{pIndicationClassname, pCimClassname, pEvent};
            return (ICIMIndicationHandler)mCtor.newInstance(mArguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getSuperclass(String pClassName, CIMIndicationEvent pEvent) {
        String mSuperclass = (String)this.cSuperclassMap.get(pClassName);
        if (mSuperclass == null) {
            mSuperclass = this.getSuperclassFromCimom(pClassName, pEvent);
            this.cSuperclassMap.put(pClassName, mSuperclass);
        }
        return mSuperclass;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSuperclassFromCimom(String pClassName, CIMIndicationEvent pEvent) {
        String string;
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"getSuperclassFromCimom", (Object[])new Object[]{pClassName, pEvent});
        String mResult = null;
        try {
            CIMClientWrapper mClient = pEvent.getCIMClient();
            CIMObjectPath mClassCop = new CIMObjectPath(pClassName, pEvent.getCIMNameSpace());
            CIMClass mClass = mClient.getClass(mClassCop, false, false, false, mLTH);
            string = mResult = mClass.getSuperClass();
        }
        catch (CIMException e) {
            try {
                mLTH.traceError("getSuperclassFromCimom failed", (Throwable)e);
                throw new RuntimeException(e);
                catch (DiskManagerTimeoutException e2) {
                    mLTH.traceError("getSuperclassFromCimom failed", (Throwable)e2);
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                mLTH.exit(mResult);
                throw throwable;
            }
        }
        mLTH.exit((Object)mResult);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findHandler(String pIndicationClassname, String pCimClassname) {
        Map map = this.cHandlerMap;
        synchronized (map) {
            Map mInnerMap = (Map)this.cHandlerMap.get(pIndicationClassname);
            return mInnerMap != null ? (Class)mInnerMap.get(pCimClassname) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(Class pHandler) throws InvalidClassException {
        CIMIndicationHandler.RegistrationData[] mRegistrations;
        Comparator mToStringComparator = new Comparator(){

            public int compare(Object pO1, Object pO2) {
                return pO1.toString().compareTo(pO2.toString());
            }

            public boolean equals(Object pObj) {
                return false;
            }
        };
        Class<?>[] mInterfaces = pHandler.getInterfaces();
        Arrays.sort(mInterfaces, mToStringComparator);
        if (Arrays.binarySearch(mInterfaces, ICIMIndicationHandler.class.toString(), mToStringComparator) < 0) {
            throw new InvalidClassException(pHandler.getName(), "Class doesn't implement " + ICIMIndicationHandler.class.getName());
        }
        try {
            Method mGetRegistrationData = pHandler.getMethod("getRegistrationData", new Class[0]);
            mRegistrations = (CIMIndicationHandler.RegistrationData[])mGetRegistrationData.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new InvalidClassException(pHandler.getName(), "Class doesn't implement getRegistrationData() properly.");
        }
        Map map = this.cHandlerMap;
        synchronized (map) {
            for (int i = 0; i < mRegistrations.length; ++i) {
                CIMIndicationHandler.RegistrationData bCurrent = mRegistrations[i];
                Map bInnerMap = this.getOrCreateInnerMap(this.cHandlerMap, bCurrent.getIndicationType());
                if (bInnerMap.containsKey(bCurrent.getCIMClassName())) {
                    throw new IllegalArgumentException("Pattern already registered.");
                }
                bInnerMap.put(bCurrent.getCIMClassName(), pHandler);
            }
        }
    }

    private Map getOrCreateInnerMap(Map pMap, String pKey) {
        HashMap mInnerMap = (HashMap)pMap.get(pKey);
        if (mInnerMap == null) {
            mInnerMap = new HashMap();
            pMap.put(pKey, mInnerMap);
        }
        return mInnerMap;
    }
}

