/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.dbaccess.FabricDBConstants;
import org.eclipse.aperi.discovery.DeviceClassConstants;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.tables.TResBackendControllerTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDiskGroupTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class EventDBAccessor {
    static ILogger msgLogger = EventCorrelatorFactory.msgLogger;
    static ILogger traceLogger = EventCorrelatorFactory.traceLogger;
    static final String className = EventDBAccessor.class.getName();
    public static String EMPTY_STRING_VALUE = "";
    private static ThreadLocal threadLocal = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new Hashtable();
        }
    };
    private static PreparedStatement portStmt = null;
    private static PreparedStatement nodeStmt = null;
    private static PreparedStatement switchStmt = null;
    private static PreparedStatement fabricStmt = null;
    private static PreparedStatement hostStmt = null;
    private static PreparedStatement hbaStmt = null;
    private static PreparedStatement peStmt = null;
    private static PreparedStatement zoneStmt = null;
    private static PreparedStatement zoneSetStmt = null;
    private static PreparedStatement HLDStmt = null;
    private static PreparedStatement nodeHLDStmt = null;
    private static PreparedStatement zoneAliasStmt = null;
    private static PreparedStatement zoneMemberStmt = null;
    private static PreparedStatement bladeStmt = null;
    private static PreparedStatement clusterStmt = null;
    private static final String portQueryString = "select NAME, NAME_FORMAT, DISPLAY_NAME, OPERATIONAL_STATUS, DISPLAY_ICON_TYPE, PORT_NUMBER, TYPE, NODE_ID FROM T_RES_PORT WHERE PORT_ID = ";
    private static final String nodeQueryString = "select NAME, NAME_FORMAT, DISPLAY_NAME, OPERATIONAL_STATUS, PLATFORM_TYPE, RNID_TYPE, DISPLAY_ICON_TYPE FROM T_RES_NODE WHERE NODE_ID = ";
    private static final String switchQueryString = "select SWITCH_WWN, DISPLAY_NAME, OPERATIONAL_STATUS FROM T_RES_SWITCH WHERE SWITCH_ID = ";
    private static final String fabricQueryString = "select FABRIC_WWN, DISPLAY_NAME, SAN_WWN, NAME, OPERATIONAL_STATUS FROM T_RES_FABRIC WHERE FABRIC_ID = ";
    private static final String hostQueryString = "select COMPUTER_ID, HOST_NAME, NETWORK_NAME, OPERATIONAL_STATUS FROM T_RES_HOST WHERE COMPUTER_ID = ";
    private static final String hbaQueryString = "select HBA_WWN, NAME, SERIAL_NUMBER, HOST_ID, OPERATIONAL_STATUS FROM T_RES_HBA WHERE HBA_ID = ";
    private static final String peQueryString = "select PE_NAME, SERIAL_NUMBER, VENDOR_ID, DISPLAY_NAME, SCSI_TYPE, PLATFORM_TYPE, RNID_TYPE FROM T_RES_PHY_PE WHERE PHY_PE_ID = ";
    private static final String zoneQueryString = "select FABRIC_WWN, ZONE_NAME, ZONE_TYPE, ACTIVE FROM T_RES_ZONE WHERE ZONE_ID = ";
    private static final String zoneSetQueryString = "select ZSET_NAME, FABRIC_WWN, ACTIVE FROM T_RES_ZSET WHERE ZSET_ID = ";
    private static final String HLDQueryString = null;
    private static final String nodeHLDQueryString = null;
    private static final String zoneMemberQueryString = "select T1.MEMBER_NAME, T2.ZONE_ID, T1.TYPE FROM T_RES_ZONE_MEMBER T1, T_RES_ZONE2MEMBER T2 WHERE T1.ZONE_MEMBER_ID = T2.ZONE_MEMBER_ID AND T1.ZONE_MEMBER_ID = ";
    private static final String bladeQueryString = "select T1.SERIAL_NUMBER, T1.Vendor_ID, T1.SWITCH_BLADE_TYPE_ID as TYPE, T1.OPERATIONAL_STATUS, T2.SWITCH_ID FROM T_RES_SWITCH_BLADE T1 left outer join T_RES_SWITCH T2 on (T1.SWITCH_WWN = T2.SWITCH_WWN) WHERE T1.SWITCH_BLADE_ID = ";
    private static final String clusterQueryString = "select CLUSTER_NAME, CLUSTER_TYPE FROM T_RES_CLUSTER WHERE CLUSTER_ID = ";
    private static final String subsystemQueryString = "select NAME, DISPLAY_NAME, SERIAL_NUMBER, TYPE, OPERATIONAL_STATUS from T_RES_STORAGE_SUBSYSTEM WHERE SUBSYSTEM_ID = ";
    private static final String pVolumeQueryString = "select SERIAL_NUMBER, NAME, DISPLAY_NAME, OPERATIONAL_STATUS from T_RES_PHYSICAL_VOLUME WHERE PHYSICAL_VOLUME_ID = ";
    private static final String spoolQueryString = "select NAME, INSTANCE_ID, DISPLAY_NAME, OPERATIONAL_STATUS from T_RES_STORAGE_POOL WHERE POOL_ID = ";
    private static final String svolumeQueryString = "select SERIAL_NUMBER, NAME, DISPLAY_NAME, OPERATIONAL_STATUS from T_RES_STORAGE_VOLUME WHERE SVID = ";
    private static final String diskgroupQueryString = "select NAME, TAG from T_RES_DISK_GROUP WHERE DISK_GROUP_ID = ";
    private static final String datapathQueryString = "select TRP1.NAME AS IPORTNAME, TRP2.NAME AS TPORTNAME, TRSV.NAME AS VOLNAME, TRDP.UNKNOWN_HOST_NAME AS HOSTNAME from T_RES_DATA_PATH TRDP, T_RES_STORAGE_VOLUME TRSV, T_RES_PORT TRP1, T_RES_PORT TRP2 WHERE TRSV.SVID = TRDP.VOLUME_ID and TRP1.PORT_ID = TRDP.INITIATOR_PORT_ID and TRP2.PORT_ID = TRDP.TARGET_PORT_ID and TRDP.DATA_PATH_ID =  ";
    private static final String sextentQueryString = "select NAME, DISPLAY_NAME, OPERATIONAL_STATUS from T_RES_STORAGE_EXTENT WHERE STORAGE_EXTENT_ID = ";
    private static final String backendcontrollerQueryString = "select BACKEND_CONTROLLER_ID, SERIAL_NUMBERE, OPERATIONAL_STATUS from T_RES_BACKEND_CONTROLLER WHERE BACKEND_CONTROLLER_ID = ";
    private static final String zset2ZoneQueryString = "select * from T_RES_ZSET2ZONE WHERE ZSET2ZONE_ID = ";
    private static final String zone2AliasQueryString = "select * from T_RES_ZONE2ALIAS WHERE ZONE2ALIAS_ID = ";
    private static final String aliasQueryString = "select * from T_RES_ALIAS WHERE ALIAS_ID = ";
    private static final String zone2MemberQueryString = "select * from T_RES_ZONE2MEMBER WHERE ZONE2MEMBER_ID = ";
    private static final String alias2MemberQueryString = "select * from T_RES_ALIAS2MEMBER WHERE ALIAS2MEMBER_ID = ";
    private static final String port2PortQueryString = "select * from T_RES_PORT2PORT WHERE PORT2PORT_ID = ";
    private static final String node2HBAQueryString = "select * from T_RES_NODE2HBA WHERE NODE2HBA_ID = ";
    private static final String pe2NodeQueryString = "select * from T_RES_PE2NODE WHERE PE2NODE_ID = ";
    private static final String switch2PortQueryString = "select * from T_RES_SWITCH2PORT WHERE SWITCH2PORT_ID = ";
    private static final String fabric2SwitchQueryString = "select T1.FABRIC_WWN, T2.FABRIC_ID, T1.SWITCH_WWN, T3.SWITCH_ID from T_RES_FABRIC2SWITCH T1, T_RES_FABRIC T2, T_RES_SWITCH T3 WHERE T1.FABRIC_WWN = T2.FABRIC_WWN AND T1.SWITCH_WWN = T3.SWITCH_WWN AND T1.FABRIC2SWITCH_ID = ";
    public static String HLDQUERYSTMT = "  select distinct PORT.WWN as WWN,  'port' as CLASS,        case            when (Port.DISPLAY_NAME is not null) then Port.DISPLAY_NAME            else Port.NAME   end  as NAME,  cast (case  when (PORT.DISPLAY_ICON_TYPE is not null) then cast (PORT.DISPLAY_ICON_TYPE as char(2))  when (PORT.TYPE is not null) then cast (PORT.TYPE as char(2))  end as smallint)  as TYPE,  from  T_RES_PORT PORT left outer join T_RES_SWITCH2PORT S2P on (S2P.PORT_ID=PORT.PORT_ID)  where  PORT.WWN=? and PORT.NODE_ID = 0  and S2P.SWITCH_WWN is null UNION  select distinct  SWITCH.SWITCH_WWN as WWN,  'switch' as CLASS,   case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end  as NAME,  0  as TYPE,   from  T_RES_PORT PORT, T_RES_SWITCH SWITCH, T_RES_SWITCH2PORT S2P   where  S2P.PORT_ID=PORT.PORT_ID and PORT.PORT_ID=?  and S2P.SWITCH_WWN=SWITCH.SWITCH_WWN  UNION  select  NODE.NODE_ID as WWN,  'node' as CLASS,        case            when (Node.DISPLAY_NAME is not null) then Node.DISPLAY_NAME            else Node.NAME   end  as NAME, " + FabricDBConstants.NODE_TYPE_SQL + " as TYPE, " + " from " + " T_RES_NODE NODE left outer join T_RES_PE2NODE PE2NODE on (NODE.NODE_ID=PE2NODE.NODE_ID) " + " left outer join T_RES_NODE2HBA NODE2HBA on (NODE.NODE_ID=NODE2HBA.NODE_ID), " + " T_RES_PORT PORT, T_RES_NODE_TYPE PLATFORMTYPE, T_RES_NODE_TYPE RNIDTYPE " + " where " + " PORT.NODE_ID = NODE.NODE_ID and PORT.WWN=? " + " and PE2NODE.node_id is null " + " and NODE2HBA.node_id is null " + " and NODE.PLATFORM_TYPE=PLATFORMTYPE.ID " + " and NODE.RNID_TYPE=RNIDTYPE.ID " + " UNION " + " select distinct " + " PE.PHY_PE_ID as WWN, " + " '" + "pe" + "' as CLASS, " + "       case            when (PE.DISPLAY_NAME is not null) then PE.DISPLAY_NAME            else PE.PE_NAME   end " + " as NAME, " + FabricDBConstants.PE_TYPE_SQL + " as TYPE, " + " from " + " T_RES_PORT PORT, T_RES_PE2NODE PE2NODE, T_RES_PE_SCSI_TYPE SCSITYPE, T_RES_NODE_TYPE PLATFORMTYPE, T_RES_NODE_TYPE RNIDTYPE, T_RES_MODEL MODEL, " + " T_RES_PE PE " + " where " + " NODE.NODE_ID=PORT.NODE_ID and PORT.WWN=? " + " and NODE.NODE_ID=PE2NODE.NODE_ID" + " and PE2NODE.PHY_PE_ID=PE.PHY_PE_ID" + " and PE.SCSI_TYPE=SCSITYPE.ID " + " and PE.MODEL_ID = MODEL.MODEL_ID " + " and PE.PLATFORM_TYPE=PLATFORMTYPE.ID " + " and PE.RNID_TYPE=RNIDTYPE.ID " + " UNION " + " select distinct" + " HOST.COMPUTER_ID as WWN, " + " '" + "host" + "' as CLASS, " + " case when HOST.HOST_NAME is not null then HOST.HOST_NAME else HOST.ORIGINAL_ALIAS end " + " as NAME, " + " 0 " + " as TYPE, " + " from " + " T_RES_PORT PORT, T_RES_NODE NODE, T_RES_NODE2HBA NODE2HBA, T_RES_HBA HBA, T_RES_HOST HOST " + " where " + " NODE.NODE_ID=PORT.NODE_ID and PORT.WWN=? " + " and NODE.NODE_ID=HBA2NODE.NODE" + " and NODE2HBA.HBA_ID=HBA.HBA_ID" + " and HBA.HOST_ID=HOST.COMPUTER_ID";

    private static DBConnection getConnection() {
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            return (DBConnection)ds.getPooledConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getFabricData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getFabricData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "fabric");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = fabricQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("fabricId", deviceId);
                    snmpValues.put("entityName", dbr.getString("FABRIC_WWN"));
                    String name = dbr.getString("DISPLAY_NAME");
                    if (name == null && (name = dbr.getString("NAME")) == null) {
                        name = dbr.getString("FABRIC_WWN");
                    }
                    snmpValues.put("label", name);
                    snmpValues.put("SANName", name);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    snmpValues.put("type", "fabric");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getSwitchData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getSwitchData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "switch");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = switchQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("switchId", deviceId);
                    snmpValues.put("entityName", dbr.getString("SWITCH_WWN"));
                    String name = dbr.getString("DISPLAY_NAME");
                    if (name == null) {
                        name = dbr.getString("SWITCH_WWN");
                    }
                    snmpValues.put("label", name);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    snmpValues.put("type", "switch");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getNodeData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getNodeData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "node");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = nodeQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("entityName", dbr.getString("NAME"));
                    String name = dbr.getString("DISPLAY_NAME");
                    if (name == null) {
                        name = dbr.getString("NAME");
                    }
                    snmpValues.put("label", name);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    String type = null;
                    if (name.substring(0, 3).equals("IBM")) {
                        String substr1 = name.substring(7, 11);
                        String substr2 = name.substring(8, 12);
                        if (substr1.equals("1750") || substr2.equals("1750")) {
                            type = "DS6000";
                        }
                        if (substr1.equals("2107") || substr2.equals("2107")) {
                            type = "DS8000";
                        }
                        if (substr1.equals("2105") || substr2.equals("2105")) {
                            type = "Shark";
                        }
                        if (substr1.equals("2145") || substr2.equals("2145")) {
                            type = "Lodestone";
                        }
                    }
                    if (type == null && ((type = dbr.getString("PLATFORM_TYPE")) == null || type == DeviceClassConstants.PLATFORM_UNKNOWN) && (type = dbr.getString("RNID_TYPE")) == null && (type = dbr.getString("DISPLAY_ICON_TYPE")) == null) {
                        type = "Unknown";
                    }
                    snmpValues.put("type", type);
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                    if (EventDBAccessor.getHighLevelDeviceForNode(deviceId, snmpValues)) {
                        tecValues.putAll(snmpValues);
                        retrieveOK = true;
                    }
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getPortData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getPortData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "port");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = portQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("entityName", dbr.getString("NAME"));
                    if (dbr.getString("PORT_NUMBER") != null) {
                        snmpValues.put("portPhysicalNumber", dbr.getString("PORT_NUMBER"));
                    } else {
                        snmpValues.put("portPhysicalNumber", "");
                    }
                    String name = dbr.getString("DISPLAY_NAME");
                    if (name == null) {
                        name = dbr.getString("NAME");
                    }
                    snmpValues.put("label", name);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    String port_type = dbr.getString("TYPE");
                    if (port_type.equals("4") || port_type.equals("6") || port_type.equals("7") || port_type.equals("9") || port_type.equals("10") || port_type.equals("11")) {
                        snmpValues.put("type", "switch");
                    } else if (dbr.getString("DISPLAY_ICON_TYPE") != null) {
                        snmpValues.put("type", dbr.getString("DISPLAY_ICON_TYPE"));
                    } else {
                        snmpValues.put("type", "Unknown");
                    }
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                    if (EventDBAccessor.getHighLevelDeviceForPort(deviceId, snmpValues)) {
                        tecValues.putAll(snmpValues);
                        retrieveOK = true;
                    }
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getPEData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getPEData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "pe");
        DBResultSet dbr = null;
        DBResultSet dbrv = null;
        if (connection != null) {
            try {
                String query = peQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    String scsiType;
                    snmpValues.put("entityName", dbr.getString("PE_NAME"));
                    String name = dbr.getString("DISPLAY_NAME");
                    if (name == null) {
                        name = dbr.getString("SERIAL_NUMBER");
                    }
                    if (name == null) {
                        name = dbr.getString("PE_NAME");
                    }
                    snmpValues.put("label", name);
                    query = "select VENDOR_NAME from " + connection.getSchema() + ".T_RES_VENDOR " + " where " + "VENDOR_ID = " + dbr.getString("VENDOR_ID");
                    dbrv = null;
                    String vendor_name = null;
                    dbrv = EventDBAccessor.tryQuery(connection, query);
                    if (EventDBAccessor.tryNext(connection, dbrv)) {
                        vendor_name = dbrv.getString("VENDOR_NAME");
                    }
                    String type = null;
                    if (vendor_name.substring(0, 3).equals("IBM")) {
                        // empty if block
                    }
                    if (type == null && (scsiType = dbr.getString("SCSI_TYPE")) != null && !scsiType.equals(DeviceClassConstants.SCSITYPE_EXTERNALCONTROLLER)) {
                        type = DBConstants.getKeyFromValue((String)"PE_SCSI_Type", (String)dbr.getString("SCSI_TYPE"));
                    }
                    if (type == null && ((type = dbr.getString("PLATFORM_TYPE")) == null || type == DeviceClassConstants.PLATFORM_UNKNOWN) && (type = dbr.getString("RNID_TYPE")) == null) {
                        type = "ExternalController";
                    }
                    snmpValues.put("type", type);
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbrv != null) {
                        dbrv.getStatement().close();
                        dbrv = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getHostData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getHostData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "host");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = hostQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("entityName", dbr.getString("HOST_NAME"));
                    if (dbr.getString("HOST_NAME") != null) {
                        snmpValues.put("label", dbr.getString("HOST_NAME"));
                    } else if (dbr.getString("NETWORK_NAME") != null) {
                        snmpValues.put("label", dbr.getString("NETWORK_NAME"));
                    } else {
                        snmpValues.put("label", "");
                    }
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    snmpValues.put("type", "host");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    private static void getOperationalStatus(Hashtable snmpValues, DBResultSet dbr) {
        String status;
        block3: {
            String methodName = "getOperationalStatus";
            status = null;
            try {
                status = dbr.getString("OPERATIONAL_STATUS");
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (!traceLogger.isLogging()) break block3;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (status == null) {
            status = DBConstants.getKeyFromValue((String)"Operational_Status", (String)"0");
        }
        snmpValues.put("state", status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getHbaData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getHbaData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "hba");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = hbaQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("entityName", dbr.getString("HBA_WWN"));
                    String name = dbr.getString("NAME");
                    if (name == null && (name = dbr.getString("SERIAL_NUMBER")) == null) {
                        name = dbr.getString("HBA_WWN");
                    }
                    snmpValues.put("label", name);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    snmpValues.put("type", "hba");
                    String HLD_UID = "";
                    String CLASS = "";
                    String HLD_LABEL = "";
                    String HLD_NAME = "";
                    String HLD_TYPE = "";
                    if (dbr.getString("HOST_ID") != null) {
                        Hashtable<ColumnInfo, String> where = new Hashtable<ColumnInfo, String>();
                        Host host = null;
                        HLD_UID = dbr.getString("HOST_ID");
                        where.put(Host.getColumnInfo((String)"COMPUTER_ID"), HLD_UID);
                        host = Host.retrieve((DBConnection)connection, where);
                        CLASS = "host";
                        if (host.getHostName() != null) {
                            HLD_LABEL = host.getHostName();
                            HLD_NAME = host.getHostName();
                        }
                        HLD_TYPE = "host";
                    }
                    snmpValues.put("HLDUniqueId", HLD_UID);
                    snmpValues.put("CLASS", CLASS);
                    snmpValues.put("highLevelDevice", HLD_NAME);
                    snmpValues.put("HLDLabel", HLD_LABEL);
                    snmpValues.put("HLDType", HLD_TYPE);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getZoneData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getZoneData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "zone");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = zoneQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("zoneId", deviceId);
                    snmpValues.put("entityName", dbr.getString("ZONE_NAME"));
                    snmpValues.put("zoneName", dbr.getString("ZONE_NAME"));
                    snmpValues.put("active", dbr.getString("ACTIVE"));
                    String name = dbr.getString("ZONE_NAME");
                    snmpValues.put("label", name);
                    snmpValues.put("type", dbr.getString("ZONE_TYPE"));
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    EventDBAccessor.getFabricDataFromFabricWWN(connection, snmpValues, dbr.getString("FABRIC_WWN"));
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getZoneSetData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getZoneSetData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "zset");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = zoneSetQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("zonesetId", deviceId);
                    snmpValues.put("entityName", dbr.getString("ZSET_NAME"));
                    snmpValues.put("zoneSetName", dbr.getString("ZSET_NAME"));
                    snmpValues.put("active", dbr.getString("ACTIVE"));
                    String name = dbr.getString("ZSET_NAME");
                    snmpValues.put("label", name);
                    snmpValues.put("type", "zset");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    EventDBAccessor.getFabricDataFromFabricWWN(connection, snmpValues, dbr.getString("FABRIC_WWN"));
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getZoneMemberData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getZoneMemberData";
        String zoneID = null;
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "zonemember");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = zoneMemberQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    Hashtable att = new Hashtable();
                    Hashtable dummy = new Hashtable();
                    snmpValues.put("entityName", dbr.getString("MEMBER_NAME"));
                    String name = dbr.getString("MEMBER_NAME");
                    zoneID = dbr.getString("ZONE_ID");
                    snmpValues.put("label", name);
                    snmpValues.put("type", dbr.getString("TYPE"));
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    if (EventDBAccessor.getZoneData(zoneID, att, dummy)) {
                        snmpValues.put("zoneId", zoneID);
                        snmpValues.put("zoneName", att.get("zoneName"));
                        snmpValues.put("fabricId", att.get("fabricId"));
                        snmpValues.put("SANName", att.get("SANName"));
                        tecValues.putAll(snmpValues);
                        retrieveOK = true;
                    }
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBladeData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getBladeData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "blade");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = bladeQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("entityName", dbr.getString("SERIAL_NUMBER"));
                    String name = dbr.getString("SERIAL_NUMBER");
                    snmpValues.put("label", name);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    String type = dbr.getString("TYPE");
                    if (type == null) {
                        type = "0";
                    }
                    String typeName = EventDBAccessor.getBladeNameByTypeId(Integer.parseInt(type));
                    snmpValues.put("type", typeName);
                    String switch_id = dbr.getString("SWITCH_ID");
                    if (switch_id == null) {
                        switch_id = "";
                    }
                    snmpValues.put("switchId", switch_id);
                    if (EventDBAccessor.getHighLevelDeviceForBlade(switch_id, snmpValues)) {
                        tecValues.putAll(snmpValues);
                        retrieveOK = true;
                    }
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    public static boolean getHighLevelDeviceForBlade(String switchId, Hashtable att) {
        String methodName = "getHighLevelDeviceForBlade";
        boolean retrieveOK = false;
        Hashtable temp = new Hashtable();
        Hashtable dummy = new Hashtable();
        String HLD_UID = "";
        String CLASS = "";
        String HLD_LABEL = "";
        String HLD_NAME = "";
        String HLD_TYPE = "";
        if (EventDBAccessor.getSwitchData(switchId, temp, dummy)) {
            att.put("HLDUniqueId", switchId);
            att.put("CLASS", "switch");
            att.put("highLevelDevice", temp.get("label"));
            att.put("HLDLabel", temp.get("label"));
            att.put("HLDType", temp.get("entityType"));
            retrieveOK = true;
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getClusterData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getClusterData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "cluster");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = clusterQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("entityName", dbr.getString("CLUSTER_NAME"));
                    String name = dbr.getString("CLUSTER_NAME");
                    snmpValues.put("label", name);
                    snmpValues.put("type", dbr.getString("CLUSTER_TYPE"));
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getSubSystemData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getSubSystemData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "subsystem");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = subsystemQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("entityName", dbr.getString("NAME"));
                    String name = dbr.getString("DISPLAY_NAME");
                    if (name == null) {
                        name = dbr.getString("NAME");
                    }
                    snmpValues.put("label", name);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    if (dbr.getString("TYPE") != null) {
                        snmpValues.put("type", dbr.getString("TYPE"));
                    } else {
                        snmpValues.put("type", "subsystem");
                    }
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBackendControllerData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getBackendControllerData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "backendcontroller");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = backendcontrollerQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("entityName", dbr.getString("BACKEND_CONTROLLER_ID"));
                    snmpValues.put("label", dbr.getString("SERIAL_NUMBERE"));
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    snmpValues.put("type", "backendcontroller");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getPVolumeData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getPVolumeData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "physicalvolume");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = pVolumeQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    if (dbr.getString("SERIAL_NUMBER") != null) {
                        snmpValues.put("entityName", dbr.getString("SERIAL_NUMBER"));
                    } else {
                        snmpValues.put("entityName", "");
                    }
                    String name = dbr.getString("DISPLAY_NAME");
                    if (name == null) {
                        name = dbr.getString("NAME");
                    }
                    if (name == null) {
                        name = dbr.getString("SERIAL_NUMBER");
                    }
                    if (name == null) {
                        name = "";
                    }
                    snmpValues.put("label", name);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    snmpValues.put("type", "physicalvolume");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getAliasData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getAliasData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "zonealias");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = aliasQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("entityName", dbr.getString("ALIAS_NAME"));
                    String name = dbr.getString("ALIAS_NAME");
                    snmpValues.put("label", name);
                    snmpValues.put("type", "zonealias");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    EventDBAccessor.getFabricDataFromFabricWWN(connection, snmpValues, dbr.getString("FABRIC_WWN"));
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getSVolumeData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getSVolumeData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "storagevolume");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = svolumeQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    if (dbr.getString("SERIAL_NUMBER") != null) {
                        snmpValues.put("entityName", dbr.getString("SERIAL_NUMBER"));
                    } else {
                        snmpValues.put("entityName", "");
                    }
                    String name = dbr.getString("DISPLAY_NAME");
                    if (name == null) {
                        name = dbr.getString("NAME");
                    }
                    if (name == null) {
                        name = dbr.getString("SERIAL_NUMBER");
                    }
                    if (name == null) {
                        name = "";
                    }
                    snmpValues.put("label", name);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    snmpValues.put("type", "storagevolume");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getDiskGroupData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getDiskGroupData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "diskgroup");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = diskgroupQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    if (dbr.getString("NAME") != null) {
                        snmpValues.put("entityName", dbr.getString("NAME"));
                    } else {
                        snmpValues.put("entityName", "");
                    }
                    String name = dbr.getString("TAG");
                    if (name == null) {
                        name = "";
                    }
                    snmpValues.put("label", name);
                    snmpValues.put("type", "diskgroup");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getDataPathData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getDataPathData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "datapath");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = datapathQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    String dpKey = "";
                    if (dbr.getString("IPORTNAME") != null) {
                        dpKey = dpKey + dbr.getString("IPORTNAME");
                    }
                    dpKey = dpKey + "-";
                    if (dbr.getString("TPORTNAME") != null) {
                        dpKey = dpKey + dbr.getString("TPORTNAME");
                    }
                    dpKey = dpKey + "-";
                    if (dbr.getString("VOLNAME") != null) {
                        dpKey = dpKey + dbr.getString("VOLNAME");
                    }
                    snmpValues.put("entityName", dpKey);
                    String host = dbr.getString("HOSTNAME");
                    if (host == null) {
                        host = "";
                    }
                    snmpValues.put("label", host);
                    snmpValues.put("type", "datapath");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getSextentData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getSextentData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "storageextent");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = sextentQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("entityName", dbr.getString("NAME"));
                    String name = dbr.getString("DISPLAY_NAME");
                    if (name == null) {
                        name = dbr.getString("NAME");
                    }
                    if (name == null) {
                        name = "";
                    }
                    snmpValues.put("label", name);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    snmpValues.put("type", "storageextent");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getSpoolData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getSpoolData";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        snmpValues.put("uniqueId", deviceId);
        snmpValues.put("entityType", "storagepool");
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = spoolQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    String name = dbr.getString("NAME");
                    if (name == null) {
                        name = dbr.getString("INSTANCE_ID");
                    }
                    if (name == null) {
                        name = "";
                    }
                    snmpValues.put("entityName", name);
                    String dname = dbr.getString("DISPLAY_NAME");
                    if (dname == null) {
                        dname = dbr.getString("NAME");
                    }
                    if (dname == null) {
                        dname = "";
                    }
                    snmpValues.put("label", dname);
                    EventDBAccessor.getOperationalStatus(snmpValues, dbr);
                    snmpValues.put("type", "storagepool");
                    EventDBAccessor.setSelfAsHLD(snmpValues);
                    tecValues.putAll(snmpValues);
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getZset2ZoneData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getZset2ZoneData";
        String fromDeviceId = null;
        String toDeviceId = null;
        boolean retrieveOK = false;
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = zset2ZoneQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    fromDeviceId = dbr.getString("ZSET_ID");
                    toDeviceId = dbr.getString("ZONE_ID");
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        if (retrieveOK) {
            boolean fromOK = false;
            boolean toOK = false;
            Hashtable from = new Hashtable();
            Hashtable to = new Hashtable();
            Hashtable dummy = new Hashtable();
            fromOK = EventDBAccessor.getZoneSetData(fromDeviceId, from, dummy);
            toOK = EventDBAccessor.getZoneData(toDeviceId, to, dummy);
            String state = "";
            String entityType = "zset2zone";
            if (fromOK && toOK) {
                snmpValues.put("zonesetId", from.get("zonesetId"));
                snmpValues.put("zoneSetName", from.get("zoneSetName"));
                snmpValues.put("zoneId", to.get("zoneId"));
                snmpValues.put("zoneName", to.get("zoneName"));
                snmpValues.put("uniqueId", deviceId);
                snmpValues.put("entityType", entityType);
                snmpValues.put("entityName", "");
                snmpValues.put("label", "");
                snmpValues.put("type", "");
                snmpValues.put("state", "");
                snmpValues.put("fromObjectUniqueId", from.get("uniqueId"));
                snmpValues.put("fromObjectLabel", from.get("label"));
                snmpValues.put("fromObjectType", from.get("entityType"));
                snmpValues.put("fromObjectName", from.get("zoneSetName"));
                snmpValues.put("zoneSetName", from.get("zoneSetName"));
                snmpValues.put("fromObjectHLDUniqueId", from.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", from.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", from.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", from.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", to.get("uniqueId"));
                snmpValues.put("toObjectLabel", to.get("label"));
                snmpValues.put("toObjectType", to.get("entityType"));
                snmpValues.put("toObjectName", to.get("zoneName"));
                snmpValues.put("zoneName", to.get("zoneName"));
                snmpValues.put("toObjectHLDUniqueId", to.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", to.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", to.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", to.get("highLevelDevice"));
                snmpValues.put("SANName", to.get("SANName"));
                snmpValues.put("fabricId", to.get("fabricId"));
                snmpValues.put("active", from.get("active"));
                tecValues.putAll(snmpValues);
            } else {
                retrieveOK = false;
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getZone2AliasData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getZone2AliasData";
        DBConnection connection = EventDBAccessor.getConnection();
        String fromDeviceId = null;
        String toDeviceId = null;
        boolean retrieveOK = false;
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = zone2AliasQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    fromDeviceId = dbr.getString("ZONE_ID");
                    toDeviceId = dbr.getString("ALIAS_ID");
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        if (retrieveOK) {
            boolean fromOK = false;
            boolean toOK = false;
            Hashtable from = new Hashtable();
            Hashtable to = new Hashtable();
            Hashtable dummy = new Hashtable();
            fromOK = EventDBAccessor.getZoneData(fromDeviceId, from, dummy);
            toOK = EventDBAccessor.getAliasData(toDeviceId, to, dummy);
            String state = "";
            String entityType = "zone2alias";
            if (fromOK && toOK) {
                snmpValues.put("zoneId", from.get("zoneId"));
                snmpValues.put("zoneName", from.get("zoneName"));
                snmpValues.put("uniqueId", deviceId);
                snmpValues.put("entityType", entityType);
                snmpValues.put("entityName", "");
                snmpValues.put("label", "");
                snmpValues.put("type", "");
                snmpValues.put("state", "");
                snmpValues.put("fromObjectUniqueId", from.get("uniqueId"));
                snmpValues.put("fromObjectLabel", from.get("label"));
                snmpValues.put("fromObjectType", from.get("entityType"));
                snmpValues.put("fromObjectName", from.get("zoneName"));
                snmpValues.put("zoneName", from.get("zoneName"));
                snmpValues.put("fromObjectHLDUniqueId", from.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", from.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", from.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", from.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", to.get("uniqueId"));
                snmpValues.put("toObjectLabel", to.get("label"));
                snmpValues.put("toObjectType", to.get("entityType"));
                snmpValues.put("toObjectName", to.get("entityName"));
                snmpValues.put("toObjectHLDUniqueId", to.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", to.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", to.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", to.get("highLevelDevice"));
                snmpValues.put("SANName", from.get("SANName"));
                snmpValues.put("fabricId", from.get("fabricId"));
                snmpValues.put("active", from.get("active"));
                tecValues.putAll(snmpValues);
            } else {
                retrieveOK = false;
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getZone2MemberData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getZone2MemberData";
        DBConnection connection = EventDBAccessor.getConnection();
        String fromDeviceId = null;
        String toDeviceId = null;
        boolean retrieveOK = false;
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = zone2MemberQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    fromDeviceId = dbr.getString("ZONE_ID");
                    toDeviceId = dbr.getString("ZONE_MEMBER_ID");
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        if (retrieveOK) {
            boolean fromOK = false;
            boolean toOK = false;
            Hashtable from = new Hashtable();
            Hashtable to = new Hashtable();
            Hashtable dummy = new Hashtable();
            fromOK = EventDBAccessor.getZoneData(fromDeviceId, from, dummy);
            toOK = EventDBAccessor.getZoneMemberData(toDeviceId, to, dummy);
            String state = "";
            String entityType = "zone2member";
            if (fromOK && toOK) {
                snmpValues.put("zoneId", from.get("zoneId"));
                snmpValues.put("zoneName", from.get("zoneName"));
                snmpValues.put("uniqueId", deviceId);
                snmpValues.put("entityType", entityType);
                snmpValues.put("entityName", "");
                snmpValues.put("label", "");
                snmpValues.put("type", "");
                snmpValues.put("state", "");
                snmpValues.put("fromObjectUniqueId", from.get("uniqueId"));
                snmpValues.put("fromObjectLabel", from.get("label"));
                snmpValues.put("fromObjectType", from.get("entityType"));
                snmpValues.put("fromObjectName", from.get("zoneName"));
                snmpValues.put("zoneName", from.get("zoneName"));
                snmpValues.put("fromObjectHLDUniqueId", from.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", from.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", from.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", from.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", to.get("uniqueId"));
                snmpValues.put("toObjectLabel", to.get("label"));
                snmpValues.put("toObjectType", to.get("entityType"));
                snmpValues.put("toObjectName", to.get("entityName"));
                snmpValues.put("toObjectHLDUniqueId", to.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", to.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", to.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", to.get("highLevelDevice"));
                snmpValues.put("SANName", from.get("SANName"));
                snmpValues.put("fabricId", from.get("fabricId"));
                snmpValues.put("active", from.get("active"));
                tecValues.putAll(snmpValues);
            } else {
                retrieveOK = false;
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getAlias2MemberData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getAlias2MemberData";
        String fromDeviceId = null;
        String toDeviceId = null;
        boolean retrieveOK = false;
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = alias2MemberQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    fromDeviceId = dbr.getString("ALIAS_ID");
                    toDeviceId = dbr.getString("ZONE_MEMBER_ID");
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        if (retrieveOK) {
            boolean fromOK = false;
            boolean toOK = false;
            Hashtable from = new Hashtable();
            Hashtable to = new Hashtable();
            Hashtable dummy = new Hashtable();
            fromOK = EventDBAccessor.getAliasData(fromDeviceId, from, dummy);
            toOK = EventDBAccessor.getZoneMemberData(toDeviceId, to, dummy);
            String state = "";
            String entityType = "alias2member";
            if (fromOK && toOK) {
                snmpValues.put("uniqueId", deviceId);
                snmpValues.put("entityType", entityType);
                snmpValues.put("entityName", "");
                snmpValues.put("label", "");
                snmpValues.put("type", "");
                snmpValues.put("state", "");
                snmpValues.put("fromObjectUniqueId", from.get("uniqueId"));
                snmpValues.put("fromObjectLabel", from.get("label"));
                snmpValues.put("fromObjectType", from.get("entityType"));
                snmpValues.put("fromObjectName", from.get("entityName"));
                snmpValues.put("fromObjectHLDUniqueId", from.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", from.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", from.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", from.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", to.get("uniqueId"));
                snmpValues.put("toObjectLabel", to.get("label"));
                snmpValues.put("toObjectType", to.get("entityType"));
                snmpValues.put("toObjectName", to.get("entityName"));
                snmpValues.put("toObjectHLDUniqueId", to.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", to.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", to.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", to.get("highLevelDevice"));
                tecValues.putAll(snmpValues);
            } else {
                retrieveOK = false;
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getPort2PortData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getPort2PortData";
        String fromDeviceId = null;
        String toDeviceId = null;
        boolean retrieveOK = false;
        String state = "";
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = port2PortQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    fromDeviceId = dbr.getString("PORT_ID1");
                    toDeviceId = dbr.getString("PORT_ID2");
                    if (dbr.getString("OPERATIONAL_STATUS") != null) {
                        state = dbr.getString("OPERATIONAL_STATUS");
                    }
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        if (retrieveOK) {
            boolean fromOK = false;
            boolean toOK = false;
            Hashtable from = new Hashtable();
            Hashtable to = new Hashtable();
            Hashtable dummy = new Hashtable();
            fromOK = EventDBAccessor.getPortData(fromDeviceId, from, dummy);
            toOK = EventDBAccessor.getPortData(toDeviceId, to, dummy);
            String entityType = "port2port";
            if (fromOK && toOK) {
                snmpValues.put("uniqueId", deviceId);
                snmpValues.put("entityType", entityType);
                snmpValues.put("entityName", "");
                snmpValues.put("label", "");
                snmpValues.put("type", "");
                snmpValues.put("state", state);
                snmpValues.put("fromObjectUniqueId", from.get("uniqueId"));
                snmpValues.put("fromObjectLabel", from.get("label"));
                snmpValues.put("fromObjectType", from.get("entityType"));
                snmpValues.put("fromObjectName", from.get("entityName"));
                snmpValues.put("fromPortPhysicalNumber", from.get("portPhysicalNumber"));
                snmpValues.put("fromObjectHLDUniqueId", from.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", from.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", from.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", from.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", to.get("uniqueId"));
                snmpValues.put("toObjectLabel", to.get("label"));
                snmpValues.put("toObjectType", to.get("entityType"));
                snmpValues.put("toObjectName", to.get("entityName"));
                snmpValues.put("toPortPhysicalNumber", to.get("portPhysicalNumber"));
                snmpValues.put("toObjectHLDUniqueId", to.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", to.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", to.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", to.get("highLevelDevice"));
                snmpValues.put("fabricId", EventDBAccessor.getFabricIDFromPorts(fromDeviceId, toDeviceId));
                tecValues.putAll(snmpValues);
            } else {
                retrieveOK = false;
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getNode2HBAData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getnode2HBAData";
        String fromDeviceId = null;
        String toDeviceId = null;
        boolean retrieveOK = false;
        String state = "";
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = node2HBAQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    fromDeviceId = dbr.getString("NODE_ID");
                    toDeviceId = dbr.getString("HBA_ID");
                    if (dbr.getString("OPERATIONAL_STATUS") != null) {
                        state = dbr.getString("OPERATIONAL_STATUS");
                    }
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        if (retrieveOK) {
            boolean fromOK = false;
            boolean toOK = false;
            Hashtable from = new Hashtable();
            Hashtable to = new Hashtable();
            Hashtable dummy = new Hashtable();
            fromOK = EventDBAccessor.getNodeData(fromDeviceId, from, dummy);
            toOK = EventDBAccessor.getHbaData(toDeviceId, to, dummy);
            String entityType = "node2hba";
            if (fromOK && toOK) {
                snmpValues.put("uniqueId", deviceId);
                snmpValues.put("entityType", entityType);
                snmpValues.put("entityName", "");
                snmpValues.put("label", "");
                snmpValues.put("type", "");
                snmpValues.put("state", state);
                snmpValues.put("fromObjectUniqueId", from.get("uniqueId"));
                snmpValues.put("fromObjectLabel", from.get("label"));
                snmpValues.put("fromObjectType", from.get("entityType"));
                snmpValues.put("fromObjectName", from.get("entityName"));
                snmpValues.put("fromObjectHLDUniqueId", from.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", from.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", from.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", from.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", to.get("uniqueId"));
                snmpValues.put("toObjectLabel", to.get("label"));
                snmpValues.put("toObjectType", to.get("entityType"));
                snmpValues.put("toObjectName", to.get("entityName"));
                snmpValues.put("toObjectHLDUniqueId", to.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", to.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", to.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", to.get("highLevelDevice"));
                tecValues.putAll(snmpValues);
            } else {
                retrieveOK = false;
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getPE2NodeData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getpe2NodeData";
        String fromDeviceId = null;
        String toDeviceId = null;
        boolean retrieveOK = false;
        String state = "";
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = pe2NodeQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    fromDeviceId = dbr.getString("PHY_PE_ID");
                    toDeviceId = dbr.getString("NODE_ID");
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        if (retrieveOK) {
            boolean fromOK = false;
            boolean toOK = false;
            Hashtable from = new Hashtable();
            Hashtable to = new Hashtable();
            Hashtable dummy = new Hashtable();
            fromOK = EventDBAccessor.getPEData(fromDeviceId, from, dummy);
            toOK = EventDBAccessor.getNodeData(toDeviceId, to, dummy);
            String entityType = "pe2node";
            if (fromOK && toOK) {
                snmpValues.put("uniqueId", deviceId);
                snmpValues.put("entityType", entityType);
                snmpValues.put("entityName", "");
                snmpValues.put("label", "");
                snmpValues.put("type", "");
                snmpValues.put("state", state);
                snmpValues.put("fromObjectUniqueId", from.get("uniqueId"));
                snmpValues.put("fromObjectLabel", from.get("label"));
                snmpValues.put("fromObjectType", from.get("entityType"));
                snmpValues.put("fromObjectName", from.get("entityName"));
                snmpValues.put("fromObjectHLDUniqueId", from.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", from.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", from.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", from.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", to.get("uniqueId"));
                snmpValues.put("toObjectLabel", to.get("label"));
                snmpValues.put("toObjectType", to.get("entityType"));
                snmpValues.put("toObjectName", to.get("entityName"));
                snmpValues.put("toObjectHLDUniqueId", to.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", to.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", to.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", to.get("highLevelDevice"));
                tecValues.putAll(snmpValues);
            } else {
                retrieveOK = false;
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getSwitch2PortData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getswitch2PortData";
        String fromDeviceId = null;
        String toDeviceId = null;
        boolean retrieveOK = false;
        String state = "";
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = switch2PortQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    fromDeviceId = dbr.getString("SWITCH_WWN");
                    Hashtable<ColumnInfo, String> where = new Hashtable<ColumnInfo, String>();
                    where.put(Switch.getColumnInfo((String)"SWITCH_WWN"), fromDeviceId);
                    Switch sw = Switch.retrieve((DBConnection)connection, where);
                    fromDeviceId = Integer.toString(sw.getSwitchId());
                    toDeviceId = dbr.getString("PORT_ID");
                    retrieveOK = true;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        if (retrieveOK) {
            boolean fromOK = false;
            boolean toOK = false;
            Hashtable from = new Hashtable();
            Hashtable to = new Hashtable();
            Hashtable dummy = new Hashtable();
            fromOK = EventDBAccessor.getSwitchData(fromDeviceId, from, dummy);
            toOK = EventDBAccessor.getPortData(toDeviceId, to, dummy);
            String entityType = "switch2port";
            if (fromOK && toOK) {
                snmpValues.put("switchId", from.get("switchId"));
                snmpValues.put("uniqueId", deviceId);
                snmpValues.put("entityType", entityType);
                snmpValues.put("entityName", "");
                snmpValues.put("label", "");
                snmpValues.put("type", "");
                snmpValues.put("state", state);
                snmpValues.put("fromObjectUniqueId", from.get("uniqueId"));
                snmpValues.put("fromObjectLabel", from.get("label"));
                snmpValues.put("fromObjectType", from.get("entityType"));
                snmpValues.put("fromObjectName", from.get("entityName"));
                snmpValues.put("fromObjectHLDUniqueId", from.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", from.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", from.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", from.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", to.get("uniqueId"));
                snmpValues.put("toObjectLabel", to.get("label"));
                snmpValues.put("toObjectType", to.get("entityType"));
                snmpValues.put("toObjectName", to.get("entityName"));
                snmpValues.put("portPhysicalNumber", to.get("portPhysicalNumber"));
                snmpValues.put("toObjectHLDUniqueId", to.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", to.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", to.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", to.get("highLevelDevice"));
                tecValues.putAll(snmpValues);
            } else {
                retrieveOK = false;
            }
        }
        return retrieveOK;
    }

    public static void setSelfAsHLD(Hashtable snmpValues) {
        snmpValues.put("HLDUniqueId", snmpValues.get("uniqueId"));
        snmpValues.put("HLDLabel", snmpValues.get("label"));
        snmpValues.put("HLDType", snmpValues.get("entityType"));
        snmpValues.put("highLevelDevice", snmpValues.get("entityName"));
        snmpValues.put("CLASS", snmpValues.get("entityType"));
    }

    private static void getFabricDataFromFabricWWN(DBConnection connection, Hashtable att, String wwn) throws SQLException {
        Hashtable<ColumnInfo, String> where = new Hashtable<ColumnInfo, String>();
        att.put("fabricId", "");
        att.put("SANName", "");
        where.put(Fabric.getColumnInfo((String)"FABRIC_WWN"), wwn);
        Fabric fabric = Fabric.retrieve((DBConnection)connection, where);
        if (fabric != null) {
            Hashtable att1 = new Hashtable();
            String fabric_id = Integer.toString(fabric.getFabricId());
            att.put("fabricId", fabric_id);
            EventDBAccessor.getFabricData(fabric_id, att1, new Hashtable());
            att.put("SANName", att1.get("SANName"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getHighLevelDeviceForPort(String portId, Hashtable att) {
        String methodName = "getHighLevelDeviceForPort";
        boolean retrieveOK = false;
        String inputId = portId;
        DBConnection connection = null;
        DBResultSet dbr = null;
        try {
            connection = EventDBAccessor.getConnection();
            String query = "  select distinct PORT.PORT_ID as HLD_UID,  'port' as CLASS,        case            when (Port.DISPLAY_NAME is not null) then Port.DISPLAY_NAME            else Port.NAME   end  as HLD_LABEL,  PORT.NAME as HLD_NAME,  cast (case  when (PORT.DISPLAY_ICON_TYPE is not null) then cast (PORT.DISPLAY_ICON_TYPE as char(2))  when (PORT.TYPE is not null) then cast (PORT.TYPE as char(2))  end as smallint)  as HLD_TYPE  from  T_RES_PORT PORT left outer join T_RES_SWITCH2PORT S2P on (S2P.PORT_ID=PORT.PORT_ID)  where  PORT.NODE_ID is null  and S2P.SWITCH_WWN is null  and PORT.PORT_ID = " + inputId + " UNION " + " select distinct " + " SUBSYSTEM.SUBSYSTEM_ID as HLD_UID, " + " '" + "subsystem" + " ' as CLASS, " + " SUBSYSTEM.DISPLAY_NAME as HLD_LABEL," + " SUBSYSTEM.NAME as HLD_NAME, " + " 0 as HLD_TYPE " + " from " + " T_RES_PORT PORT, T_RES_STORAGE_SUBSYSTEM SUBSYSTEM  " + " where " + " PORT.SUBSYSTEM_ID = SUBSYSTEM.SUBSYSTEM_ID" + " and PORT.PORT_ID= " + inputId + " UNION " + " select distinct " + " SWITCH.SWITCH_ID as HLD_ID, " + " '" + "switch" + "' as CLASS, " + "  case  when Switch.DISPLAY_NAME is not null then Switch.DISPLAY_NAME  when Switch.LOGICAL_NAME is not null then Switch.LOGICAL_NAME  else Switch.SWITCH_WWN end " + " as HLD_LABEL, " + " SWITCH.SWITCH_WWN as HLD_NAME, " + " 0 " + " as HLD_TYPE " + "  from " + " T_RES_PORT PORT, T_RES_SWITCH SWITCH, T_RES_SWITCH2PORT S2P  " + " where " + " S2P.PORT_ID=PORT.PORT_ID " + " and S2P.SWITCH_WWN=SWITCH.SWITCH_WWN " + " and PORT.PORT_ID=" + inputId + " UNION " + " select " + " NODE.NODE_ID as HLD_UID, " + " '" + "node" + "' as CLASS, " + "       case            when (Node.DISPLAY_NAME is not null) then Node.DISPLAY_NAME            else Node.NAME   end " + " as HLD_LABEL, " + " NODE.NAME as HLD_NAME, " + FabricDBConstants.NODE_TYPE_SQL + " as HLD_TYPE " + " from " + " T_RES_NODE NODE left outer join T_RES_PE2NODE PE2NODE on (NODE.NODE_ID=PE2NODE.NODE_ID) " + " left outer join T_RES_NODE2HBA NODE2HBA on (NODE.NODE_ID=NODE2HBA.NODE_ID), " + " T_RES_PORT PORT " + " where " + " PORT.NODE_ID = NODE.NODE_ID  " + " and PE2NODE.node_id is null " + " and NODE2HBA.node_id is null " + " and PORT.PORT_ID= " + inputId + " UNION " + " select distinct " + " PE.PHY_PE_ID as HLD_UID, " + " '" + "pe" + "' as CLASS, " + "       case            when (PE.DISPLAY_NAME is not null) then PE.DISPLAY_NAME            else PE.PE_NAME   end " + " as HLD_LABEL, " + "PE.PE_NAME as HLD_NAME, " + FabricDBConstants.PE_TYPE_SQL + " as HLD_TYPE " + " from " + " T_RES_PORT PORT, T_RES_PE2NODE PE2NODE, T_RES_PHY_PE PE, T_RES_NODE NODE, T_RES_VENDOR VENDOR, T_RES_MODEL MODEL " + " where " + " NODE.NODE_ID=PORT.NODE_ID " + " and NODE.NODE_ID=PE2NODE.NODE_ID" + " and PE2NODE.PHY_PE_ID=PE.PHY_PE_ID" + " and PE.MODEL_ID = MODEL.MODEL_ID " + " and PORT.PORT_ID = " + inputId + " UNION " + " select distinct" + " HOST.COMPUTER_ID as HLD_UID, " + " '" + "host" + "' as CLASS, " + " case when HOST.HOST_NAME is not null then HOST.HOST_NAME else HOST.ORIGINAL_ALIAS end " + " as HLD_LABEL, " + " HOST.HOST_NAME as HLD_NAME, " + " 0 " + " as HLD_TYPE " + " from " + " T_RES_PORT PORT, T_RES_NODE NODE, T_RES_NODE2HBA NODE2HBA, T_RES_HBA HBA, T_RES_HOST HOST " + " where " + " NODE.NODE_ID=PORT.NODE_ID " + " and NODE.NODE_ID=NODE2HBA.NODE_ID" + " and NODE2HBA.HBA_ID=HBA.HBA_ID" + " and HBA.HOST_ID=HOST.COMPUTER_ID" + " and PORT.PORT_ID = " + inputId;
            String HLD_UID = "";
            String CLASS = "";
            String HLD_LABEL = "";
            String HLD_NAME = "";
            String HLD_TYPE = "";
            dbr = EventDBAccessor.tryQuery(connection, query);
            if (dbr != null) {
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    HLD_UID = dbr.getString(1);
                    if (HLD_UID == null) {
                        HLD_UID = "";
                    }
                    if ((CLASS = dbr.getString(2)) == null) {
                        CLASS = "";
                    }
                    if ((HLD_LABEL = dbr.getString(3)) == null) {
                        HLD_LABEL = "";
                    }
                    if ((HLD_NAME = dbr.getString(4)) == null) {
                        HLD_LABEL = "";
                    }
                    if ((HLD_TYPE = dbr.getString(2)) == null) {
                        HLD_TYPE = "";
                    }
                } else {
                    String msg = "No object found in the database for a port with portId = " + portId;
                }
            }
            att.put("HLDUniqueId", HLD_UID);
            att.put("CLASS", CLASS);
            att.put("highLevelDevice", HLD_NAME);
            att.put("HLDLabel", HLD_LABEL);
            att.put("HLDType", HLD_TYPE);
            retrieveOK = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            try {
                if (dbr != null) {
                    dbr.getStatement().close();
                    dbr = null;
                }
            }
            catch (Exception ignore) {}
            try {
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception ignore) {}
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getHighLevelDeviceForNode(String nodeId, Hashtable att) {
        String methodName = "getHighLevelDeviceForNode";
        boolean retrieveOK = false;
        String inputId = nodeId;
        DBConnection connection = null;
        DBResultSet dbr = null;
        try {
            connection = EventDBAccessor.getConnection();
            String query = " select distinct  NODE.NODE_ID as HLD_UID,  'node ' as CLASS,        case            when (Node.DISPLAY_NAME is not null) then Node.DISPLAY_NAME            else Node.NAME   end  as HLD_LABEL,  NODE.NAME as HLD_NAME, " + FabricDBConstants.NODE_TYPE_SQL + " as HLD_TYPE " + " from " + " T_RES_NODE NODE left outer join T_RES_PE2NODE P2N on (P2N.NODE_ID=NODE.NODE_ID)  " + " left outer join T_RES_NODE2HBA N2H on (N2H.NODE_ID=NODE.NODE_ID) " + " where " + " NODE.SYSTEM_ID is null " + " and NODE.NODE_ID=" + inputId + " UNION " + " select distinct " + " SUBSYSTEM.SUBSYSTEM_ID as HLD_UID, " + " '" + "subsystem" + " ' as CLASS, " + " SUBSYSTEM.DISPLAY_NAME as HLD_LABEL," + " SUBSYSTEM.NAME as HLD_NAME, " + " 0 as HLD_TYPE " + " from " + " T_RES_NODE NODE, T_RES_STORAGE_SUBSYSTEM SUBSYSTEM " + " where " + " NODE.SYSTEM_ID = SUBSYSTEM.SUBSYSTEM_ID" + " and NODE.NODE_ID=" + inputId + " UNION " + "  select distinct " + "  PE.PHY_PE_ID as HLD_UID, " + " '" + "pe" + "' as CLASS, " + "       case            when (PE.DISPLAY_NAME is not null) then PE.DISPLAY_NAME            else PE.PE_NAME   end " + " as HLD_LABEL, " + " PE.PE_NAME as HLD_NAME, " + FabricDBConstants.PE_TYPE_SQL + " as HLD_TYPE " + " from " + " T_RES_PE2NODE PE2NODE, T_RES_PHY_PE PE, " + " T_RES_NODE NODE, T_RES_VENDOR VENDOR, T_RES_MODEL MODEL " + " where NODE.SYSTEM_ID is null and PE2NODE.NODE_ID = NODE.NODE_ID " + " and PE.MODEL_ID = MODEL.MODEL_ID" + " and PE2NODE.PHY_PE_ID=PE.PHY_PE_ID " + " and NODE.NODE_ID = " + inputId + " UNION " + " select distinct " + " HOST.COMPUTER_ID as HLD_UID, " + " '" + "host" + "' as CLASS, " + " case when HOST.HOST_NAME is not null then HOST.HOST_NAME else HOST.ORIGINAL_ALIAS end " + " as HLD_LABEL, " + " HOST.HOST_NAME as HLD_NAME, " + " 0 " + " as HLD_TYPE " + " from " + " T_RES_HOST HOST, T_RES_NODE NODE, T_RES_HBA HBA, T_RES_NODE2HBA NODE2HBA " + " where " + " NODE2HBA.NODE_ID = NODE.NODE_ID " + " and NODE2HBA.HBA_ID = HBA.HBA_ID " + " and HBA.HOST_ID = HOST.COMPUTER_ID " + " and NODE.NODE_ID = " + inputId;
            String HLD_UID = "";
            String CLASS = "";
            String HLD_LABEL = "";
            String HLD_NAME = "";
            String HLD_TYPE = "";
            dbr = EventDBAccessor.tryQuery(connection, query);
            if (dbr != null) {
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    HLD_UID = dbr.getString(1);
                    if (HLD_UID == null) {
                        HLD_UID = "";
                    }
                    if ((CLASS = dbr.getString(2)) == null) {
                        CLASS = "";
                    }
                    if ((HLD_LABEL = dbr.getString(3)) == null) {
                        HLD_LABEL = "";
                    }
                    if ((HLD_NAME = dbr.getString(4)) == null) {
                        HLD_LABEL = "";
                    }
                    if ((HLD_TYPE = dbr.getString(2)) == null) {
                        HLD_TYPE = "";
                    }
                } else {
                    String msg = "No object found in the database for a port with portId = " + inputId;
                }
            }
            att.put("HLDUniqueId", HLD_UID);
            att.put("CLASS", CLASS);
            att.put("highLevelDevice", HLD_NAME);
            att.put("HLDLabel", HLD_LABEL);
            att.put("HLDType", HLD_TYPE);
            retrieveOK = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            try {
                if (dbr != null) {
                    dbr.getStatement().close();
                    dbr = null;
                }
            }
            catch (Exception ignore) {}
            try {
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception ignore) {}
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getComputerId(int serverType) {
        String methodName = "getComputerId";
        int computerId = -1;
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = " select server.COMPUTER_ID  from T_RES_SERVER server  where server.SERVER_TYPE = " + serverType;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    computerId = dbr.getInt("COMPUTER_ID");
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Found computerId=" + computerId + " for serverType=" + serverType);
                    }
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        if (computerId == 0) {
            computerId = EventDBAccessor.getComputerId(0);
        }
        return computerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegisteredCimom getCIMOMByID(String deviceId) {
        String methodName = "getCIMOMByID";
        RegisteredCimom cimom = null;
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        String serviceURL = null;
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = " select cimom.SERVICE_URL as SERVICE_URL  from T_RES_REGISTERED_CIMOM cimom where  cimom.REG_CIMOM_ID= " + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    serviceURL = dbr.getString("SERVICE_URL");
                }
                if (serviceURL != null) {
                    Hashtable<ColumnInfo, String> htinput = new Hashtable<ColumnInfo, String>();
                    htinput.put(RegisteredCimom.getColumnInfo((String)"SERVICE_URL"), serviceURL);
                    cimom = RegisteredCimom.retrieve((DBConnection)connection, htinput);
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return cimom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegisteredCimom[] getAllRegisteredCimoms() {
        String methodName = "getAllRegisteredCimoms";
        DBConnection connection = EventDBAccessor.getConnection();
        ArrayList<RegisteredCimom> names = new ArrayList<RegisteredCimom>();
        RegisteredCimom.RegisteredCimomCursor cursor = null;
        try {
            cursor = RegisteredCimom.getCursor((DBConnection)connection, null, null);
            while (cursor.next()) {
                RegisteredCimom cimom = cursor.getObject();
                if (cimom == null) continue;
                names.add(cimom);
            }
            if (traceLogger.isLogging()) {
                String msg = "List of all cimom found: ";
                for (int i = 0; i < names.size(); ++i) {
                    RegisteredCimom cm = (RegisteredCimom)names.get(i);
                    msg = msg.concat(cm.getServiceUrl() + "||");
                }
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, "getAllRegisteredCimoms", msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getAllRegisteredCimoms", (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getAllRegisteredCimoms", (Throwable)e);
            }
        }
        finally {
            block19: {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getAllRegisteredCimoms", (Throwable)e);
                    if (!traceLogger.isLogging()) break block19;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getAllRegisteredCimoms", (Throwable)e);
                }
            }
        }
        if (names.size() > 0) {
            return names.toArray(new RegisteredCimom[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getFabric2SwitchData(String deviceId, Hashtable snmpValues, Hashtable tecValues) {
        String methodName = "getFabric2SwitchData";
        String fabricID = null;
        String switchID = null;
        boolean retrieveOK = false;
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = fabric2SwitchQueryString + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    snmpValues.put("uniqueId", deviceId);
                    snmpValues.put("entityType", "fabric2switch");
                    snmpValues.put("entityName", "");
                    snmpValues.put("label", "");
                    snmpValues.put("type", "");
                    fabricID = dbr.getString("FABRIC_ID");
                    switchID = dbr.getString("SWITCH_ID");
                    snmpValues.put("fabricId", fabricID);
                    snmpValues.put("switchId", switchID);
                    retrieveOK = true;
                } else {
                    retrieveOK = false;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        if (retrieveOK) {
            boolean fromOK = false;
            boolean toOK = false;
            Hashtable from = new Hashtable();
            Hashtable to = new Hashtable();
            Hashtable dummy = new Hashtable();
            fromOK = EventDBAccessor.getFabricData(fabricID, from, dummy);
            toOK = EventDBAccessor.getSwitchData(switchID, to, dummy);
            if (fromOK && toOK) {
                snmpValues.put("fromObjectUniqueId", from.get("uniqueId"));
                snmpValues.put("fromObjectLabel", from.get("label"));
                snmpValues.put("fromObjectType", from.get("entityType"));
                snmpValues.put("fromObjectName", from.get("entityName"));
                snmpValues.put("fromObjectHLDUniqueId", from.get("HLDUniqueId"));
                snmpValues.put("fromObjectHLDType", from.get("HLDType"));
                snmpValues.put("fromObjectHLDLabel", from.get("HLDLabel"));
                snmpValues.put("fromHighLevelDevice", from.get("highLevelDevice"));
                snmpValues.put("toObjectUniqueId", to.get("uniqueId"));
                snmpValues.put("toObjectLabel", to.get("label"));
                snmpValues.put("toObjectType", to.get("entityType"));
                snmpValues.put("toObjectName", to.get("entityName"));
                snmpValues.put("toObjectHLDUniqueId", to.get("HLDUniqueId"));
                snmpValues.put("toObjectHLDType", to.get("HLDType"));
                snmpValues.put("toObjectHLDLabel", to.get("HLDLabel"));
                snmpValues.put("toHighLevelDevice", to.get("highLevelDevice"));
                snmpValues.put("SANName", from.get("SANName"));
                tecValues.putAll(snmpValues);
            } else {
                retrieveOK = false;
            }
        }
        return retrieveOK;
    }

    private static String getFabricIDFromPorts(String from, String to) {
        String fabric_id = null;
        fabric_id = EventDBAccessor.getFabricIDFromPort(from);
        if (fabric_id == null) {
            fabric_id = EventDBAccessor.getFabricIDFromPort(to);
        }
        if (fabric_id == null) {
            fabric_id = "";
        }
        return fabric_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFabricIDFromSwitch(String switchId) {
        String methodName = "getFabricIDFromSwitch";
        String fabric_id = "";
        String query = " select T1.FABRIC_ID from T_RES_FABRIC T1, T_RES_FABRIC2SWITCH T2, T_RES_SWITCH T3  WHERE T1.FABRIC_WWN = T2.FABRIC_WWN AND T2.SWITCH_WWN = T3.SWITCH_WWN  AND T3.SWITCH_ID = " + switchId;
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr) && (fabric_id = dbr.getString("FABRIC_ID")) != null) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Found FabricId=" + fabric_id + " for SwitchId=" + switchId);
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return fabric_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFabricIDFromPort(String port) {
        String methodName = "getFabricIDFromPort";
        String fabric_id = null;
        String query = "SELECT T3.FABRIC_ID from T_RES_SWITCH2PORT T1 left outer join T_RES_FABRIC2SWITCH T2 on (T1.SWITCH_WWN = T2.SWITCH_WWN) left outer join T_RES_FABRIC T3 on (T2.FABRIC_WWN = T3.FABRIC_WWN) where T1.PORT_ID =  " + port;
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    fabric_id = dbr.getString("FABRIC_ID");
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return fabric_id;
    }

    public static void main(String[] args) {
        DBConnPoolDataSource.initialize((String)"COM.ibm.db2.jdbc.app.DB2Driver", (String)args[0], (String)"TPC", (String)args[1], (String)args[2], (int)10);
        Hashtable snmptbl = null;
        Hashtable tectbl = null;
        snmptbl = new Hashtable();
        tectbl = new Hashtable();
        EventDBAccessor.getBladeData(new String("20"), snmptbl, tectbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAlertIDByCondition(int condition) {
        String methodName = "getAlertIDByCondition";
        Object cimom = null;
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        int alertId = -1;
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = " select alertDef.alert_id as alert_id  from T_ALERT_DEFINITION alertDef where  alertDef.condition= " + condition;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    alertId = dbr.getInt("alert_id");
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return alertId;
    }

    public static String getVolumeIDForDataPathID(String pID) {
        String methodName = "getVolumeIDForDataPathID";
        String mColumn = "VOLUME_ID";
        String mTable = TResDataPathTable.getTablename();
        String mAutoId = "DATA_PATH_ID";
        return EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId);
    }

    public static String getSubsystemIDForPortID(String pID) {
        String methodName = "getSubsystemIDForPortID";
        String mColumn = "SUBSYSTEM_ID";
        String mTable = TResPortTable.getTablename();
        String mAutoId = "PORT_ID";
        return EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId);
    }

    public static String getDisplayNameForPortID(String pID) {
        String mAutoId;
        String methodName = "getDisplayNameForPortID";
        String mColumn = "DISPLAY_NAME";
        String mTable = TResPortTable.getTablename();
        String mDisplayName = EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId = "PORT_ID");
        if (mDisplayName != null) {
            return mDisplayName;
        }
        return "ID=" + pID;
    }

    public static String getOwningSubsystemIDForBackendControllerID(String pID) {
        String methodName = "getOwningSubsystemIDForBackendControllerID";
        String mColumn = "OWNING_SUBSYSTEM_ID";
        String mTable = TResBackendControllerTable.getTablename();
        String mAutoId = "BACKEND_CONTROLLER_ID";
        return EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId);
    }

    public static String getReferencedSubsystemIDForBackendControllerID(String pID) {
        String methodName = "getReferencedSubsystemIDForBackendControllerID";
        String mColumn = "REFERENCED_SUBSYSTEM_ID";
        String mTable = TResBackendControllerTable.getTablename();
        String mAutoId = "BACKEND_CONTROLLER_ID";
        return EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId);
    }

    public static String getSubsystemIDForDiskGroupID(String pID) {
        String methodName = "getSubsystemIDForDiskGroupID";
        String mColumn = "SUBSYSTEM_ID";
        String mTable = TResDiskGroupTable.getTablename();
        String mAutoId = "DISK_GROUP_ID";
        return EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId);
    }

    public static String getDisplayNameForDiskGroupID(String pID) {
        String mAutoId;
        String methodName = "getDisplayNameForDiskGroupID";
        String mColumn = "TAG";
        String mTable = TResDiskGroupTable.getTablename();
        String mDisplayName = EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId = "DISK_GROUP_ID");
        if (mDisplayName != null) {
            return mDisplayName;
        }
        return "ID=" + pID;
    }

    public static String getSubsystemIDForExtentID(String pID) {
        String methodName = "getSubsystemIDForExtentID";
        String mColumn = "SUBSYSTEM_ID";
        String mTable = TResStorageExtentTable.getTablename();
        String mAutoId = "STORAGE_EXTENT_ID";
        return EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId);
    }

    public static String getDisplayNameForStorageExtentID(String pID) {
        String mAutoId;
        String methodName = "getDisplayNameForStorageExtentID";
        String mColumn = "DISPLAY_NAME";
        String mTable = TResStorageExtentTable.getTablename();
        String mDisplayName = EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId = "STORAGE_EXTENT_ID");
        if (mDisplayName != null) {
            return mDisplayName;
        }
        return "ID=" + pID;
    }

    public static String getSubsystemIDForPoolID(String pID) {
        String methodName = "getSubsystemIDForPoolID";
        String mColumn = "SUBSYSTEM_ID";
        String mTable = TResStoragePoolTable.getTablename();
        String mAutoId = "POOL_ID";
        return EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId);
    }

    public static String getDisplayNameForStoragePoolID(String pID) {
        String mAutoId;
        String methodName = "getDisplayNameForStoragePoolID";
        String mColumn = "DISPLAY_NAME";
        String mTable = TResStoragePoolTable.getTablename();
        String mDisplayName = EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId = "POOL_ID");
        if (mDisplayName != null) {
            return mDisplayName;
        }
        return "ID=" + pID;
    }

    public static String getSubsystemIDForDiskDriveID(String pID) {
        String methodName = "getSubsystemIDForDiskDriveID";
        String mColumn = "SUBSYSTEM_ID";
        String mTable = TResPhysicalVolumeTable.getTablename();
        String mAutoId = "PHYSICAL_VOLUME_ID";
        return EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId);
    }

    public static String getDisplayNameForDiskDriveID(String pID) {
        String mAutoId;
        String methodName = "getDisplayNameForDiskDriveID";
        String mColumn = "DISPLAY_NAME";
        String mTable = TResPhysicalVolumeTable.getTablename();
        String mDisplayName = EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId = "PHYSICAL_VOLUME_ID");
        if (mDisplayName != null) {
            return mDisplayName;
        }
        return "ID=" + pID;
    }

    public static String getSubsystemIDForVolumeID(String pID) {
        String methodName = "getSubsystemIDForVolumeID";
        String mColumn = "SUBSYSTEM_ID";
        String mTable = TResStorageVolumeTable.getTablename();
        String mAutoId = "SVID";
        return EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId);
    }

    public static String getDisplayNameForStorageVolumeID(String pID) {
        String mAutoId;
        String methodName = "getDisplayNameForStorageVolumeID";
        String mColumn = "DISPLAY_NAME";
        String mTable = TResStorageVolumeTable.getTablename();
        String mDisplayName = EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId = "SVID");
        if (mDisplayName != null) {
            return mDisplayName;
        }
        return "ID=" + pID;
    }

    public static String getDisplayNameForStorageSystemID(String pID) {
        String mAutoId;
        String methodName = "getDisplayNameForStorageSystemID";
        String mColumn = "DISPLAY_NAME";
        String mTable = TResStorageSubsystemTable.getTablename();
        String mDisplayName = EventDBAccessor.getColumnFromTableForAutoId(pID, methodName, mColumn, mTable, mAutoId = "SUBSYSTEM_ID");
        if (mDisplayName != null) {
            return mDisplayName;
        }
        return "ID=" + pID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getColumnFromTableForAutoId(String pID, String pMethodName, String pColumn, String pTable, String pAutoId) {
        String mResult = null;
        String mQuery = "select " + pColumn + " from " + pTable + " where " + pAutoId + " = " + pID;
        DBConnection mConn = ServiceUtils.getConnection();
        DBResultSet mDBR = null;
        if (mConn != null) {
            try {
                mDBR = EventDBAccessor.tryQuery(mConn, mQuery);
                if (EventDBAccessor.tryNext(mConn, mDBR)) {
                    mResult = mDBR.getString(1);
                }
            }
            catch (SQLException pE) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, pMethodName, (Throwable)pE);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, pMethodName, (Throwable)pE);
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, pMethodName, "Unable to get " + pColumn + " for " + pAutoId + " = " + pID + " from " + pTable);
                }
            }
            finally {
                try {
                    if (mDBR != null) {
                        mDBR.closeAll();
                    }
                }
                catch (SQLException ignore) {}
                try {
                    mConn.close();
                }
                catch (SQLException ignore) {}
            }
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAlertIDByConditionForSubsystems(short condition, String ssid) {
        String methodName = "getAlertIDByConditionForSubsystems";
        int alertId = -1;
        if (ssid == null) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Subsystem alert id cannot be determined since subsystem id is null");
            }
            return alertId;
        }
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = "select attribute_id as alert_id from t_res_attribute where exclude='0' and attribute_type in (81,82) and resource_type=78 and resource_id = " + ssid + " and attribute_id in (select alert_id from t_alert_definition where condition = " + condition + " and enabled='1')";
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    alertId = dbr.getInt("alert_id");
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Non-group and non-all subsystem alert id for subsystem " + ssid + " and condition " + condition + " is " + alertId);
                    }
                } else if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "No non-group and non-all subsystem alert id for subsystem " + ssid + " and condition " + condition + " found using " + query);
                }
                if (alertId == -1) {
                    dbr.closeAll();
                    query = "select attribute_id as alert_id from t_res_attribute where exclude='0' and attribute_type in (81,82) and resource_type=13 and resource_id = -1 and attribute_id in (select alert_id from t_alert_definition where condition = " + condition + " and enabled='1')";
                    dbr = EventDBAccessor.tryQuery(connection, query);
                    if (EventDBAccessor.tryNext(connection, dbr)) {
                        alertId = dbr.getInt("alert_id");
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "group-subsystem alert id for subsystem " + ssid + " and condition " + condition + " is " + alertId);
                        }
                    } else if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "No group-subsystem alert id for subsystem " + ssid + " and condition " + condition + " found using " + query);
                    }
                    if (alertId == -1) {
                        dbr.closeAll();
                        query = "select attribute_id from t_res_attribute where exclude='0' and attribute_type in (81,82) and resource_type=77 and resource_id in (select group_id from t_res_storage_subsystem where subsystem_id=" + ssid + ") and attribute_id in (select alert_id from t_alert_definition where condition = " + condition + " and enabled='1')";
                        dbr = EventDBAccessor.tryQuery(connection, query);
                        if (EventDBAccessor.tryNext(connection, dbr)) {
                            alertId = dbr.getInt("alert_id");
                            if (traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "all-subsystem alert id for subsystem " + ssid + " and condition " + condition + " is " + alertId);
                            }
                        } else if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "no subsystem alert id for subsystem " + ssid + " and condition " + condition + " found using " + query);
                        }
                    }
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return alertId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAlertIDByResource(short resourceType, int resourceId, int condition) {
        String methodName = "getAlertIDByCondition";
        Object cimom = null;
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        int alertId = -1;
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = " select ald.alert_id as alert_id  from T_ALERT_DEFINITION ald, T_RES_ATTRIBUTE att  where att.exclude = '0' and att.attribute_id = ald.alert_id  and ((att.resource_type =" + resourceType + " and att.resource_id = " + resourceId + ")" + " or (resource_type = " + resourceType + " and resource_id in" + " (select g2r.resource_id from T_GROUP2RES g2r, T_RES_ATTRIBUTE r " + " where g2r.resource_id = " + resourceId + " and g2r.group_id = r.resource_id ))) and ald.condition = " + condition + " order by alert_id ";
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    alertId = dbr.getInt("alert_id");
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return alertId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFabricIdForPort(String deviceId) {
        String methodName = "getFabricIdForPort";
        String fromDeviceId = null;
        String toDeviceId = null;
        boolean retrieveOK = false;
        String fabricId = "";
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = " select distinct p2p.port_id1, p2p.port_id2  from t_res_port port, t_res_port2port p2p  where (port.port_id = p2p.port_id1 or port.port_id = p2p.port_id2 ) and port.port_id = " + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                while (EventDBAccessor.tryNext(connection, dbr)) {
                    fromDeviceId = dbr.getString("PORT_ID1");
                    fabricId = EventDBAccessor.getFabricIDFromPorts(fromDeviceId, toDeviceId = dbr.getString("PORT_ID2"));
                    if (fabricId == null) continue;
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Found FabricId=" + fabricId + " for PortId=" + deviceId);
                    break;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return fabricId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFabricIdForNode(String deviceId) {
        String methodName = "getFabricIdForNode";
        String fromDeviceId = null;
        String toDeviceId = null;
        boolean retrieveOK = false;
        String fabricId = "";
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = " select distinct p2p.port_id1, p2p.port_id2  from t_res_port port, t_res_port2port p2p  where (port.port_id = p2p.port_id1 or port.port_id = p2p.port_id2 ) and port.node_id = " + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                while (EventDBAccessor.tryNext(connection, dbr)) {
                    fromDeviceId = dbr.getString("PORT_ID1");
                    fabricId = EventDBAccessor.getFabricIDFromPorts(fromDeviceId, toDeviceId = dbr.getString("PORT_ID2"));
                    if (fabricId == null) continue;
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Found FabricId=" + fabricId + " for NodeId=" + deviceId);
                    break;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return fabricId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFabricIdForPE(String deviceId) {
        String methodName = "getFabricIdForPE";
        Object fromDeviceId = null;
        Object toDeviceId = null;
        boolean retrieveOK = false;
        String fabricId = "";
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = " select distinct node.node_id  from t_res_node node, t_res_pe2node p2n where node.node_id = p2n.node_id and p2n.phy_pe_id = " + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                while (EventDBAccessor.tryNext(connection, dbr)) {
                    String nodeId = dbr.getString("NODE_ID");
                    fabricId = EventDBAccessor.getFabricIdForNode(nodeId);
                    if (fabricId == null || fabricId.equals("")) continue;
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Found FabricId=" + fabricId + " for PHY_PE_Id=" + deviceId);
                    break;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return fabricId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFabricIdForHBA(String deviceId) {
        String methodName = "getFabricIdForHBA";
        Object fromDeviceId = null;
        Object toDeviceId = null;
        boolean retrieveOK = false;
        String fabricId = "";
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = " select distinct node.node_id  from t_res_node node, t_res_node2hba n2h, t_res_hba hba  where node.node_id = n2h.node_id  and n2h.hba_id = hba.hba_id and hba.hba_id = " + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                while (EventDBAccessor.tryNext(connection, dbr)) {
                    String nodeId = dbr.getString("node_id");
                    fabricId = EventDBAccessor.getFabricIdForNode(nodeId);
                    if (fabricId == null || fabricId.equals("")) continue;
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Found FabricId=" + fabricId + " for HBA_ID=" + deviceId);
                    break;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return fabricId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFabricIdForHost(String deviceId) {
        String methodName = "getFabricIdForHost";
        Object fromDeviceId = null;
        Object toDeviceId = null;
        boolean retrieveOK = false;
        String fabricId = "";
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = " select distinct node.node_id  from t_res_node node, t_res_node2hba n2h, t_res_hba hba  where node.node_id = n2h.node_id  and n2h.hba_id = hba.hba_id  and hba.host_id = " + deviceId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                while (EventDBAccessor.tryNext(connection, dbr)) {
                    String nodeId = dbr.getString("NODE_ID");
                    fabricId = EventDBAccessor.getFabricIdForNode(nodeId);
                    if (fabricId == null || fabricId.equals("")) continue;
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Found FabricId=" + fabricId + " for HOST_ID=" + deviceId);
                    break;
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return fabricId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getFabricDataFromFabricWWN(Hashtable att, String wwn) {
        String methodName = "getFabricDataFromFabricWWN";
        DBConnection connection = EventDBAccessor.getConnection();
        boolean retrieveOK = false;
        if (connection != null) {
            try {
                Hashtable<ColumnInfo, String> where = new Hashtable<ColumnInfo, String>();
                att.put("fabricId", "");
                att.put("SANName", "");
                where.put(Fabric.getColumnInfo((String)"FABRIC_WWN"), wwn);
                Fabric fabric = Fabric.retrieve((DBConnection)connection, where);
                if (fabric != null) {
                    Hashtable att1 = new Hashtable();
                    String fabric_id = Integer.toString(fabric.getFabricId());
                    att.put("fabricId", fabric_id);
                    String name = fabric.getDisplayName();
                    if (name == null) {
                        name = fabric.getName();
                        name = name == null ? fabric.getFabricWwn() : "";
                    }
                    att.put("SANName", name);
                }
                retrieveOK = true;
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return retrieveOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBladeNameByTypeId(int typeId) {
        String methodName = "getBladeNameByTypeId";
        String typeName = "unknown";
        DBConnection connection = EventDBAccessor.getConnection();
        DBResultSet dbr = null;
        if (connection != null) {
            try {
                String query = " select distinct sbt.type_name  from T_RES_SWITCH_BLADE_TYPE sbt  where sbt.switch_blade_type_id = " + typeId;
                dbr = EventDBAccessor.tryQuery(connection, query);
                if (EventDBAccessor.tryNext(connection, dbr)) {
                    typeName = dbr.getString("type_name");
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                        dbr = null;
                    }
                }
                catch (Exception ignore) {}
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception ignore) {}
            }
        }
        return typeName;
    }

    public static boolean isAnyAlertDefined(short[] conditions) {
        boolean anyAlertDefined = false;
        for (int bI = 0; bI < conditions.length; ++bI) {
            anyAlertDefined = anyAlertDefined || EventDBAccessor.isAlertDefined(conditions[bI]);
        }
        return anyAlertDefined;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAlertDefined(short condition) {
        String methodName = "isAlertDefined";
        Boolean defined = (Boolean)((Hashtable)threadLocal.get()).get(String.valueOf(condition));
        if (defined != null) {
            return defined;
        }
        String sql = "select count(alert_id) from t_alert_definition where condition = ?";
        DBConnection con = null;
        DBPreparedStatement stmt = null;
        int count = 0;
        try {
            con = EventDBAccessor.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setShort(1, condition);
            DBResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)className, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ignore) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception ignore) {}
            }
        }
        ((Hashtable)threadLocal.get()).put(String.valueOf(condition), new Boolean(count > 0));
        return count > 0;
    }

    public static void initializeThreadLocal() {
    }

    public static void clearThreadLocal() {
        ((Hashtable)threadLocal.get()).clear();
    }

    public static Hashtable getThreadLocal() {
        return (Hashtable)threadLocal.get();
    }

    protected static DBResultSet tryQuery(DBConnection connection, String queryString) throws SQLException {
        String methodName = "tryQuery";
        boolean toRetry = false;
        int numRetries = 0;
        Random randomGenerator = new Random();
        DBResultSet dbr = null;
        while (true) {
            try {
                connection.setAutoCommit(true);
                dbr = ComplexQuery.sqlQuery((DBConnection)connection, (String)queryString, new Hashtable());
                toRetry = false;
                return dbr;
            }
            catch (SQLException e) {
                if (SQLExceptionHelper.isDeadlock((DBConnection)connection, (SQLException)e)) {
                    connection.rollback();
                    if (++numRetries <= 6) {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Deadlock within Retry of Operations - Retry " + numRetries + " after deadlock");
                        } else {
                            System.out.println(className + " " + methodName + " Retry " + numRetries + "after deadlock");
                        }
                        toRetry = true;
                        long msWaitPeriod = (long)(15000.0 * randomGenerator.nextDouble() * (double)numRetries);
                        if (msWaitPeriod < 100L) {
                            msWaitPeriod = 100L;
                        }
                        try {
                            Thread.sleep(msWaitPeriod);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Number of Retries exceeded; aborting with SQLException");
                    }
                    throw e;
                }
                throw e;
                if (toRetry) continue;
                return null;
            }
            break;
        }
    }

    protected static boolean tryNext(DBConnection connection, DBResultSet dbr) throws SQLException {
        String methodName = "tryNext";
        boolean toRetry = false;
        int numRetries = 0;
        Random randomGenerator = new Random();
        while (true) {
            try {
                return dbr.next();
            }
            catch (SQLException e) {
                if (SQLExceptionHelper.isDeadlock((DBConnection)connection, (SQLException)e)) {
                    connection.rollback();
                    if (++numRetries <= 6) {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Deadlock within Retry of Operations - Retry " + numRetries + " after deadlock");
                        } else {
                            System.out.println(className + " " + methodName + " Retry " + numRetries + "after deadlock");
                        }
                        toRetry = true;
                        long msWaitPeriod = (long)(15000.0 * randomGenerator.nextDouble() * (double)numRetries);
                        if (msWaitPeriod < 100L) {
                            msWaitPeriod = 100L;
                        }
                        try {
                            Thread.sleep(msWaitPeriod);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        continue;
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Number of Retries exceeded; aborting with SQLException");
                    }
                    throw e;
                }
                throw e;
                if (toRetry) continue;
                return false;
            }
            break;
        }
    }
}

