/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator;

import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.EventHandler;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class EventProcessor
implements Runnable {
    ILogger msgLogger = LogConstants.msgLogger;
    ILogger traceLogger = LogConstants.traceLogger;
    static final String className = EventProcessor.class.getName();
    private Vector eventGroup = new Vector();
    private EventCorrelatorFactory eventMonitor = null;
    private Thread workerThread = null;
    private static EventProcessor eventProcess = null;
    private EventHandler eventHndlr = null;

    private EventProcessor() {
    }

    public static EventProcessor shareInstance() {
        if (eventProcess == null) {
            eventProcess = new EventProcessor();
        }
        return eventProcess;
    }

    public void start(EventCorrelatorFactory publisher) {
        String methodName = "start";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)publisher);
        }
        if (this.eventHndlr == null) {
            this.eventHndlr = new EventHandler(publisher);
        }
        if (this.workerThread == null) {
            this.workerThread = new Thread(this);
            this.workerThread.start();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.workerThread = null;
        EventProcessor eventProcessor = this;
        synchronized (eventProcessor) {
            this.notifyAll();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String methodName;
        block15: {
            methodName = "run";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            try {
                Thread curThread = Thread.currentThread();
                while (this.workerThread == curThread) {
                    String messageInfo;
                    try {
                        while (this.eventGroup.isEmpty()) {
                            EventProcessor eventProcessor = this;
                            synchronized (eventProcessor) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                if (this.workerThread == null) {
                                    if (this.traceLogger.isLogging()) {
                                        messageInfo = "event monitor service was shutdown";
                                        this.traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, messageInfo);
                                        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                                    }
                                    return;
                                }
                            }
                        }
                        Object[] tmpObj = (Object[])this.eventGroup.firstElement();
                        String processId = (String)tmpObj[0];
                        Vector events = (Vector)tmpObj[1];
                        this.process(processId, events);
                        this.eventGroup.removeElement(tmpObj);
                    }
                    catch (Exception ee) {
                        messageInfo = "Failed to publish event.";
                        if (!this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, messageInfo);
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ee);
                    }
                }
            }
            catch (Exception pe) {
                String messageInfo = "Failed to start EventPublishThread";
                if (!this.traceLogger.isLogging()) break block15;
                this.traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, messageInfo);
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pe);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void process(String processId, Vector events) {
        String methodName = "process";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{processId, "allEvents"});
        }
        EventDBAccessor.initializeThreadLocal();
        this.eventHndlr.publishEvents(processId, events);
        EventDBAccessor.clearThreadLocal();
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventsToProcess(String processId, Vector events) {
        String methodName = "addEventsToProcess";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, new Object[]{processId, "allEvents"});
        }
        Object[] tmpEvents = new Object[]{processId, events};
        this.eventGroup.add(tmpEvents);
        EventProcessor eventProcessor = this;
        synchronized (eventProcessor) {
            this.notifyAll();
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public static void main(String[] args) {
    }
}

