/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.AffectedHostAnalyzer;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.data.PopulatorHelper;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class DataPathAlertPopulator
implements IPopulator {
    private String volumeId = null;
    private String subsystemId = null;
    private String initiatorPortId = null;

    public Alert populateNew(String pID) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populateNew", (Object[])new Object[]{pID});
        FabricAlert mResult = null;
        try {
            short bAlertCondition = 112;
            if (!EventDBAccessor.isAlertDefined(bAlertCondition)) {
                mLTH.traceInfo("No alert defined for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int mComputerId = EventDBAccessor.getComputerId(1);
            short mResourceType = 78;
            AlertDefinition mAlertDef = new AlertDefinition();
            mAlertDef.aldCondition = bAlertCondition;
            mAlertDef.aldProductID = (short)3;
            mAlertDef.aldDbmsType = 1;
            mAlertDef.aldType = (short)20;
            int[] mEnterprise = MIBConstants.BTAphysicalEntityEvent;
            int mTrapType = 104;
            Hashtable<int[], String> mSnmpTable = new Hashtable<int[], String>();
            String mTecClass = "PhysicalEntityEvent";
            Hashtable<String, String> mTecTable = new Hashtable<String, String>();
            Hashtable<String, String> bSnmpValues = new Hashtable<String, String>();
            Hashtable<String, String> bTecValues = new Hashtable<String, String>();
            if (!EventDBAccessor.getDataPathData(pID, bSnmpValues, bTecValues)) {
                throw new AlertCreationException("Failed to fill SNMP/TEC data for device: " + pID);
            }
            int[][] bVarBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
            for (int i = 0; i < bVarBindOIDs.length; ++i) {
                mSnmpTable.put(bVarBindOIDs[i], this.getPEValue(i, bSnmpValues));
            }
            String bEventType = "TPC_NEW_DEVICE_EVENT";
            bSnmpValues.put("eventType", bEventType);
            bTecValues.put("eventType", bEventType);
            for (int i = 0; i < peTecSlotNames.length; ++i) {
                String value = (String)bTecValues.get(peTecSlotNames[i]);
                if (value == null) {
                    value = "";
                }
                mTecTable.put(peTecSlotNames[i], value);
            }
            PopulatorHelper.addCommonTecAttributes(mTecTable, "HARMLESS");
            String mMsgId = "ALR4280I";
            this.volumeId = EventDBAccessor.getVolumeIDForDataPathID(pID);
            this.subsystemId = EventDBAccessor.getSubsystemIDForVolumeID(this.volumeId);
            String bSubsystemDisplayName = EventDBAccessor.getDisplayNameForStorageSystemID(this.subsystemId);
            String bVolumeDisplayName = EventDBAccessor.getDisplayNameForStorageVolumeID(this.volumeId);
            Object[] mMsgParms = new Object[]{bVolumeDisplayName, bSubsystemDisplayName};
            int mResourceId = Integer.parseInt(this.subsystemId);
            mAlertDef.aldAlertID = EventDBAccessor.getAlertIDByConditionForSubsystems(bAlertCondition, this.subsystemId);
            if (mAlertDef.aldAlertID <= 0) {
                mLTH.traceInfo("No alertId found for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int[] mAffectedResIDs = PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForDataPath(pID));
            mResult = new FabricAlert(mComputerId, mResourceId, mResourceType, mAlertDef, mEnterprise, mTrapType, mSnmpTable, mTecClass, mTecTable, mMsgId, mMsgParms, mAffectedResIDs);
            this.initValues();
            mLTH.exit((Object)mResult);
        }
        catch (AlertCreationException pE) {
            throw pE;
        }
        catch (Exception pE) {
            mLTH.traceError("Exception during alert population for device: " + pID, (Throwable)pE);
            throw new AlertCreationException("Could not populate alert for device: " + pID);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    public Alert populateStateChange(String pID, int pNewState, int pOldState) throws AlertCreationException {
        return this.populateStateChange(pID, pNewState, pOldState, null);
    }

    public Alert populatePropertyChange(String pID, Hashtable pOldValues, Hashtable pNewValues) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populatePropertyChange", (Object[])new Object[]{pID, pOldValues, pNewValues});
        Alert mResult = null;
        mLTH.exit(mResult);
        return mResult;
    }

    public Alert populateOperationalStatusChange(String pID, int pOldStatus, int pNewStatus) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populateOperationalStatusChange", (Object[])new Object[]{pID, new Integer(pOldStatus), new Integer(pNewStatus)});
        Alert mResult = null;
        mLTH.exit(mResult);
        return mResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Alert populateStateChange(String pID, int pNewState, int pOldState, HashMap pAttributeMap) throws AlertCreationException {
        FabricAlert mResult;
        LogTraceHelper mLTH;
        block19: {
            Alert alert;
            block18: {
                mLTH = LogTraceHelper.entry((Object)this, (String)"populateStateChange", (Object[])new Object[]{pID, new Integer(pNewState), new Integer(pOldState), pAttributeMap});
                this.initValues();
                mResult = null;
                try {
                    if (!EventDBAccessor.isAnyAlertDefined(new short[]{111})) {
                        mLTH.traceInfo("No alert defined for deviceId=" + pID + " with condition=" + 111);
                        Alert alert2 = null;
                        return alert2;
                    }
                    int mComputerId = EventDBAccessor.getComputerId(1);
                    short mResourceType = 78;
                    AlertDefinition mAlertDef = new AlertDefinition();
                    int[] mEnterprise = MIBConstants.BTAphysicalEntityEvent;
                    Hashtable<int[], String> mSnmpTable = new Hashtable<int[], String>();
                    String mTecClass = "PhysicalEntityEvent";
                    Hashtable<String, String> mTecTable = new Hashtable<String, String>();
                    Hashtable<String, String> bSnmpValues = new Hashtable<String, String>();
                    Hashtable<String, String> bTecValues = new Hashtable<String, String>();
                    if (pAttributeMap != null) {
                        this.setSnmpValuesFromEntityValue(bSnmpValues, bTecValues, pAttributeMap);
                    } else if (!EventDBAccessor.getDataPathData(pID, bSnmpValues, bTecValues)) {
                        throw new AlertCreationException("Failed to fill SNMP/TEC data for device: " + pID);
                    }
                    int[][] bVarBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                    for (int i = 0; i < bVarBindOIDs.length; ++i) {
                        mSnmpTable.put(bVarBindOIDs[i], this.getPEValue(i, bSnmpValues));
                    }
                    boolean isOnlineOrDetected = pNewState == 1;
                    String bEventType = isOnlineOrDetected ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                    bSnmpValues.put("eventType", bEventType);
                    bTecValues.put("eventType", bEventType);
                    for (int i = 0; i < peTecSlotNames.length; ++i) {
                        String value = (String)bTecValues.get(peTecSlotNames[i]);
                        if (value == null) {
                            value = "";
                        }
                        mTecTable.put(peTecSlotNames[i], value);
                    }
                    String bSeverity = isOnlineOrDetected ? "HARMLESS" : "CRITICAL";
                    PopulatorHelper.addCommonTecAttributes(mTecTable, bSeverity);
                    int mTrapType = isOnlineOrDetected ? 112 : 101;
                    short bAlertCondition = 111;
                    String mMsgId = "ALR4283W";
                    if (pAttributeMap == null) {
                        this.volumeId = EventDBAccessor.getVolumeIDForDataPathID(pID);
                        this.subsystemId = EventDBAccessor.getSubsystemIDForVolumeID(this.volumeId);
                    } else {
                        Object obj = pAttributeMap.get("VOLUME_ID");
                        this.volumeId = obj != null ? obj.toString() : "0";
                        obj = pAttributeMap.get("SUBSYSTEM_ID");
                        this.subsystemId = obj != null ? obj.toString() : "0";
                        obj = pAttributeMap.get("INITIATOR_PORT_ID");
                        this.initiatorPortId = obj != null ? obj.toString() : "0";
                    }
                    String bSubsystemDisplayName = EventDBAccessor.getDisplayNameForStorageSystemID(this.subsystemId);
                    String bVolumeDisplayName = EventDBAccessor.getDisplayNameForStorageVolumeID(this.volumeId);
                    Object[] mMsgParms = new Object[]{bVolumeDisplayName, bSubsystemDisplayName, String.valueOf(pOldState), String.valueOf(pNewState)};
                    int mResourceId = Integer.parseInt(this.subsystemId);
                    mAlertDef.aldCondition = bAlertCondition;
                    mAlertDef.aldProductID = (short)3;
                    mAlertDef.aldDbmsType = 1;
                    mAlertDef.aldType = (short)20;
                    mAlertDef.aldAlertID = EventDBAccessor.getAlertIDByConditionForSubsystems(bAlertCondition, this.subsystemId);
                    if (mAlertDef.aldAlertID <= 0) {
                        mLTH.traceInfo("No alertId found for deviceId=" + pID + " with condition=" + bAlertCondition);
                        alert = null;
                        System.out.println("populateStateChange is called with DataPathId VolumeId subsystemid " + pID + "||" + this.volumeId + "||" + this.subsystemId + "||" + this.initiatorPortId);
                        break block18;
                    }
                    int[] mAffectedResIDs = null;
                    mAffectedResIDs = this.initiatorPortId == null ? PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForDataPath(pID)) : PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForDataPathWithPortId(this.initiatorPortId));
                    mResult = new FabricAlert(mComputerId, mResourceId, mResourceType, mAlertDef, mEnterprise, mTrapType, mSnmpTable, mTecClass, mTecTable, mMsgId, mMsgParms, mAffectedResIDs);
                    System.out.println("populateStateChange is called with DataPathId VolumeId subsystemid " + pID + "||" + this.volumeId + "||" + this.subsystemId + "||" + this.initiatorPortId);
                    break block19;
                }
                catch (AlertCreationException pE) {
                    throw pE;
                }
                catch (Exception pE) {
                    mLTH.traceError("Exception during alert population for device: " + pID, (Throwable)pE);
                    throw new AlertCreationException("Could not populate alert for device: " + pID);
                }
            }
            mLTH.exit((Object)mResult);
            return alert;
        }
        mLTH.exit((Object)mResult);
        return mResult;
        finally {
            System.out.println("populateStateChange is called with DataPathId VolumeId subsystemid " + pID + "||" + this.volumeId + "||" + this.subsystemId + "||" + this.initiatorPortId);
            mLTH.exit(mResult);
        }
    }

    private String getPEValue(int pIndex, Hashtable pValues) {
        String peVarName = peVarNames[pIndex];
        if (peVarName.equals("description") || peVarName.equals("messageId")) {
            return peVarName;
        }
        String mValue = (String)pValues.get(peVarName);
        if (mValue != null) {
            return mValue;
        }
        return "";
    }

    private void initValues() {
        this.volumeId = null;
        this.subsystemId = null;
        this.initiatorPortId = null;
    }

    private void setSnmpValuesFromEntityValue(Hashtable snmpValues, Hashtable tecValues, HashMap values) {
        snmpValues.put("uniqueId", values.get("DATA_PATH_ID"));
        snmpValues.put("entityType", "datapath");
        snmpValues.put("entityName", values.get("DATA_PATH_ID"));
        snmpValues.put("label", values.get("DATA_PATH_ID"));
        snmpValues.put("type", "datapath");
        EventDBAccessor.setSelfAsHLD(snmpValues);
        tecValues.putAll(snmpValues);
    }
}

