/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class PerEntAlertPopulator
implements IPopulator {
    public static final String deviceType = "pe";
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;
    static final String className = PerEntAlertPopulator.class.getName();

    public PerEntAlertPopulator() {
        msgLogger = EventCorrelatorFactory.msgLogger;
        traceLogger = EventCorrelatorFactory.traceLogger;
    }

    public Alert populateNew(String ID) throws AlertCreationException {
        String methodName = "populateNew";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getPEData(deviceId, snmpValues, tecValues)) {
            String hldType = (String)snmpValues.get("HLDType");
            String eventType = "TPC_NEW_DEVICE_EVENT";
            short alertCondition = this.determineAlertCondition(hldType, eventType);
            int resourceId = Integer.parseInt(deviceId);
            short resourceType = this.determineResourceType(hldType);
            int alertId = -1;
            alertId = alertCondition == 106 ? EventDBAccessor.getAlertIDByCondition(alertCondition) : this.getAlertId(resourceType, resourceId, alertCondition, deviceId);
            if (alertId > 0) {
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = alertCondition;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 104;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4037I";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("type");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("HLDLabel")) == null) {
                    value1 = "";
                }
                msgValues = new Object[]{value0, value1};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: pe" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: pe" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateStateChange(String ID, int newState, int oldState) throws AlertCreationException {
        String methodName = "populateStateChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        if (EventDBAccessor.getPEData(deviceId, snmpValues, tecValues)) {
            String hldType = (String)snmpValues.get("HLDType");
            String eventType = "TPC_DEVICE_STATE_CHANGE_EVENT";
            short alertCondition = this.determineAlertCondition(hldType, eventType);
            int resourceId = Integer.parseInt(deviceId);
            short resourceType = this.determineResourceType(hldType);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition, deviceId);
            if (alertId > 0) {
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = alertCondition;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 101;
                if (newState == 1) {
                    trapType = 112;
                }
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                String eventType1 = newState == 1 ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
                snmpValues.put("eventType", eventType1);
                tecValues.put("eventType", eventType1);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PhysicalEntityEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = newState == 0 ? "CRITICAL" : "HARMLESS";
                this.addCommonTecAttributes(tecTable, severity);
                String msgId = "ALR4038W";
                if (newState == 1) {
                    msgId = "ALR4039I";
                }
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("type");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("HLDLabel")) == null) {
                    value1 = "";
                }
                msgValues = new Object[]{value0, value1};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: pe" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: pe" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populatePropertyChange(String ID, Hashtable oldValues, Hashtable newValues) throws AlertCreationException {
        String methodName = "populatePropertyChange";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(deviceType + ID));
        }
        FabricAlert alert = null;
        String deviceId = ID;
        Hashtable<String, String> snmpValues = new Hashtable<String, String>();
        Hashtable<String, String> tecValues = new Hashtable<String, String>();
        String parameterName = "FIRMWARE_REVISION";
        String oldValue = (String)oldValues.get(parameterName);
        String newValue = (String)newValues.get(parameterName);
        if (oldValue == null || newValue == null) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "Error populating PE Properties, " + parameterName + " value is null - old Value=" + oldValue + ", new Value=" + newValue);
            }
            return null;
        }
        if (EventDBAccessor.getPEData(deviceId, snmpValues, tecValues)) {
            String hldType = (String)snmpValues.get("HLDType");
            String eventType = "TPC_PROPERTY_CHANGE_EVENT";
            short alertCondition = 177;
            int resourceId = Integer.parseInt(ID);
            short resourceType = this.determineResourceType(hldType);
            int alertId = this.getAlertId(resourceType, resourceId, alertCondition, deviceId);
            if (alertId > 0) {
                String value1;
                AlertDefinition alertDef = new AlertDefinition();
                alertDef.aldAlertID = alertId;
                alertDef.aldProductID = 0;
                alertDef.aldCondition = alertCondition;
                int serverType = 1;
                int computerId = EventDBAccessor.getComputerId(serverType);
                int trapType = 102;
                int[] enterprise = MIBConstants.BTAphysicalEntityEvent;
                int[][] varBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
                Hashtable<int[], String> snmpTable = new Hashtable<int[], String>();
                Hashtable<String, String> tecTable = new Hashtable<String, String>();
                snmpValues.put("eventType", eventType);
                tecValues.put("eventType", eventType);
                for (int i = 0; i < varBindOIDs.length; ++i) {
                    String value = this.getPEValue(i, snmpValues);
                    if (value == null) {
                        value = "";
                    }
                    snmpTable.put(varBindOIDs[i], value);
                }
                String tecClass = "PEAttributeModifiedEvent";
                for (int i = 0; i < peTecSlotNames.length; ++i) {
                    String value = (String)tecValues.get(peTecSlotNames[i]);
                    if (value == null) {
                        value = "";
                    }
                    tecTable.put(peTecSlotNames[i], value);
                }
                String severity = "MINOR";
                this.addCommonTecAttributes(tecTable, severity);
                this.addAttributeData(snmpTable, tecTable, parameterName, oldValue, newValue);
                String msgId = "ALR4040W";
                Object[] msgValues = null;
                String value0 = (String)snmpValues.get("type");
                if (value0 == null) {
                    value0 = "";
                }
                if ((value1 = (String)snmpValues.get("HLDLabel")) == null) {
                    value1 = "";
                }
                msgValues = new Object[]{value0, value1, oldValue, newValue};
                alert = new FabricAlert(computerId, resourceId, resourceType, alertDef, enterprise, trapType, snmpTable, tecClass, tecTable, msgId, msgValues);
            } else if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, "No AlertDefinition defined in db for device: pe" + deviceId);
            }
        } else {
            throw new AlertCreationException("No data found in db for device: pe" + deviceId);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alert;
    }

    public Alert populateOperationalStatusChange(String ID, int oldStatus, int newStatus) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }

    private short determineResourceType(String hldType) {
        short type = -1;
        type = hldType.equals("subsystem") ? (short)78 : 139;
        return type;
    }

    private short determineAlertCondition(String hldType, String eventType) {
        int condition = -1;
        if (eventType.equals("TPC_NEW_DEVICE_EVENT")) {
            condition = 106;
            if (hldType.equals("subsystem")) {
                condition = 64;
            }
        } else if (eventType.equals("TPC_DEVICE_STATE_CHANGE_EVENT")) {
            condition = 101;
            if (hldType.equals("subsystem")) {
                condition = 65;
            }
        } else if (eventType.equals("TPC_PROPERTY_CHANGE_EVENT")) {
            condition = 177;
            if (hldType.equals("subsystem")) {
                condition = 123;
            }
        }
        return (short)condition;
    }

    private void addAttributeData(Hashtable snmpTable, Hashtable tecTable, String attName, String oldValue, String newValue) {
        snmpTable.put(MIBConstants.BTAAttributeName, attName);
        snmpTable.put(MIBConstants.BTAOldAttributeValue, oldValue);
        snmpTable.put(MIBConstants.BTANewAttributeValue, newValue);
        tecTable.put("attributeName", attName);
        tecTable.put("oldValue", oldValue);
        tecTable.put("newValue", newValue);
    }

    private void addOperationalStatusData(Hashtable snmpTable, Hashtable tecTable, int oldStatus, int newStatus) {
        snmpTable.put(MIBConstants.BTAOldStatus, "" + oldStatus);
        snmpTable.put(MIBConstants.BTANewStatus, "" + newStatus);
        tecTable.put("oldStatus", "" + oldStatus);
        tecTable.put("oldStatus", "" + newStatus);
    }

    private void addCommonTecAttributes(Hashtable tecTable, String severty) {
        String ipAddress = "";
        String hostName = "";
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipAddress).getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        tecTable.put("hostname", hostName);
        tecTable.put("origin", ipAddress);
        tecTable.put("severity", severty);
    }

    private String getPEValue(int index, Hashtable values) {
        if (peVarNames[index].equals("description")) {
            return peVarNames[index];
        }
        if (peVarNames[index].equals("messageId")) {
            return peVarNames[index];
        }
        return (String)values.get(peVarNames[index]);
    }

    private int getAlertId(short resourceType, int resourceId, short alertCondition, String deviceId) {
        int alertId = -1;
        alertId = EventDBAccessor.getAlertIDByResource(resourceType, resourceId, alertCondition);
        if (alertId <= 0) {
            String fabricId = EventDBAccessor.getFabricIdForPE(deviceId);
            if (fabricId != null && !fabricId.equals("")) {
                alertId = EventDBAccessor.getAlertIDByResource((short)114, Integer.parseInt(fabricId), alertCondition);
            }
            if (alertId <= 0) {
                alertId = resourceType == 139 ? EventDBAccessor.getAlertIDByResource((short)129, -1, alertCondition) : EventDBAccessor.getAlertIDByResource(resourceType, -1, alertCondition);
            }
        }
        return alertId;
    }

    public Alert populateStateChange(String ID, int newState, int oldState, HashMap attributeMap) throws AlertCreationException {
        Alert alert = null;
        return alert;
    }
}

