/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.data;

import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.monitor.AffectedHostAnalyzer;
import org.eclipse.aperi.monitor.eventcorrelator.EventDBAccessor;
import org.eclipse.aperi.monitor.eventcorrelator.data.PopulatorHelper;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.AlertCreationException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IPopulator;
import org.eclipse.aperi.sanmgmt.MIBConstants;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.FabricAlert;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class StorageSystemAlertPopulator
implements IPopulator {
    public Alert populateNew(String pID) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populateNew", (Object[])new Object[]{pID});
        FabricAlert mResult = null;
        try {
            short bAlertCondition = 64;
            if (!EventDBAccessor.isAlertDefined(bAlertCondition)) {
                mLTH.traceInfo("No alert defined for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int mComputerId = EventDBAccessor.getComputerId(1);
            int mResourceId = Integer.parseInt(pID);
            short mResourceType = 78;
            AlertDefinition mAlertDef = new AlertDefinition();
            mAlertDef.aldCondition = bAlertCondition;
            mAlertDef.aldProductID = (short)3;
            mAlertDef.aldDbmsType = 1;
            mAlertDef.aldType = (short)20;
            mAlertDef.aldAlertID = EventDBAccessor.getAlertIDByCondition(bAlertCondition);
            if (mAlertDef.aldAlertID <= 0) {
                mLTH.traceInfo("No alertId found for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int[] mEnterprise = MIBConstants.BTAphysicalEntityEvent;
            int mTrapType = 104;
            Hashtable<int[], String> mSnmpTable = new Hashtable<int[], String>();
            String mTecClass = "PhysicalEntityEvent";
            Hashtable<String, String> mTecTable = new Hashtable<String, String>();
            Hashtable<String, String> bSnmpValues = new Hashtable<String, String>();
            Hashtable<String, String> bTecValues = new Hashtable<String, String>();
            if (!EventDBAccessor.getSubSystemData(pID, bSnmpValues, bTecValues)) {
                throw new AlertCreationException("Failed to fill SNMP/TEC data for device: storagesystem" + pID);
            }
            int[][] bVarBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
            for (int i = 0; i < bVarBindOIDs.length; ++i) {
                mSnmpTable.put(bVarBindOIDs[i], this.getPEValue(i, bSnmpValues));
            }
            String bEventType = "TPC_NEW_DEVICE_EVENT";
            bSnmpValues.put("eventType", bEventType);
            bTecValues.put("eventType", bEventType);
            for (int i = 0; i < peTecSlotNames.length; ++i) {
                String value = (String)bTecValues.get(peTecSlotNames[i]);
                if (value == null) {
                    value = "";
                }
                mTecTable.put(peTecSlotNames[i], value);
            }
            PopulatorHelper.addCommonTecAttributes(mTecTable, "HARMLESS");
            String mMsgId = "ALR1114W";
            Object[] mMsgParms = new Object[]{""};
            int[] mAffectedResIDs = PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForStorageSystem(pID));
            mResult = new FabricAlert(mComputerId, mResourceId, mResourceType, mAlertDef, mEnterprise, mTrapType, mSnmpTable, mTecClass, mTecTable, mMsgId, mMsgParms, mAffectedResIDs);
            mLTH.exit((Object)mResult);
        }
        catch (AlertCreationException pE) {
            throw pE;
        }
        catch (Exception pE) {
            mLTH.traceError("Exception during alert population for device: " + pID, (Throwable)pE);
            throw new AlertCreationException("Could not populate alert for device: " + pID);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    public Alert populateStateChange(String pID, int pNewState, int pOldState) throws AlertCreationException {
        return this.populateStateChange(pID, pNewState, pOldState, null);
    }

    public Alert populatePropertyChange(String pID, Hashtable pOldValues, Hashtable pNewValues) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populatePropertyChange", (Object[])new Object[]{pID, pOldValues, pNewValues});
        FabricAlert mResult = null;
        try {
            Object[] mMsgParms;
            String mMsgId;
            int bAlertCondition;
            if (!EventDBAccessor.isAnyAlertDefined(new short[]{142, 143, 144, 145, 68, 67, 123})) {
                mLTH.traceInfo("No alert defined for deviceId=" + pID + " with conditions=" + 142 + "," + 143 + "," + 144 + "," + 145 + "," + 68 + "," + 67 + "," + 123);
                Alert alert = null;
                return alert;
            }
            int mComputerId = EventDBAccessor.getComputerId(1);
            int mResourceId = Integer.parseInt(pID);
            short mResourceType = 78;
            AlertDefinition mAlertDef = new AlertDefinition();
            int[] mEnterprise = MIBConstants.BTAphysicalEntityEvent;
            int mTrapType = 102;
            Hashtable<int[], String> mSnmpTable = new Hashtable<int[], String>();
            String mTecClass = "PEAttributeModifiedEvent";
            Hashtable<String, String> mTecTable = new Hashtable<String, String>();
            Hashtable<String, String> bSnmpValues = new Hashtable<String, String>();
            Hashtable<String, String> bTecValues = new Hashtable<String, String>();
            if (!EventDBAccessor.getSubSystemData(pID, bSnmpValues, bTecValues)) {
                throw new AlertCreationException("Failed to fill SNMP/TEC data for device: storagesystem" + pID);
            }
            int[][] bVarBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
            for (int i = 0; i < bVarBindOIDs.length; ++i) {
                mSnmpTable.put(bVarBindOIDs[i], this.getPEValue(i, bSnmpValues));
            }
            String bEventType = "TPC_PROPERTY_CHANGE_EVENT";
            bSnmpValues.put("eventType", bEventType);
            bTecValues.put("eventType", bEventType);
            for (int i = 0; i < peTecSlotNames.length; ++i) {
                String value = (String)bTecValues.get(peTecSlotNames[i]);
                if (value == null) {
                    value = "";
                }
                mTecTable.put(peTecSlotNames[i], value);
            }
            PopulatorHelper.addCommonTecAttributes(mTecTable, "MINOR");
            String bParameterName = null;
            String bOldValue = null;
            String bNewValue = null;
            String bDisplayName = EventDBAccessor.getDisplayNameForStorageSystemID(pID);
            if (pOldValues.containsKey("CODE_LEVEL") && pNewValues.containsKey("CODE_LEVEL")) {
                bAlertCondition = 142;
                mMsgId = "ALR4243W";
                bParameterName = "CODE_LEVEL";
                bOldValue = pOldValues.get(bParameterName) == null ? "" : pOldValues.get(bParameterName).toString();
                bNewValue = pNewValues.get(bParameterName) == null ? "" : pNewValues.get(bParameterName).toString();
                mMsgParms = new Object[]{bOldValue, bNewValue, bDisplayName};
            } else if (pOldValues.containsKey("ALLOCATED_CAPACITY") && pNewValues.containsKey("ALLOCATED_CAPACITY")) {
                bAlertCondition = 143;
                mMsgId = "ALR4244W";
                bParameterName = "ALLOCATED_CAPACITY";
                bOldValue = pOldValues.get(bParameterName) == null ? "" : pOldValues.get(bParameterName).toString();
                bNewValue = pNewValues.get(bParameterName) == null ? "" : pNewValues.get(bParameterName).toString();
                mMsgParms = new Object[]{bOldValue, bNewValue, bDisplayName};
            } else if (pOldValues.containsKey("AVAILABLE_CAPACITY") && pNewValues.containsKey("AVAILABLE_CAPACITY")) {
                bAlertCondition = 144;
                mMsgId = "ALR4245W";
                bParameterName = "AVAILABLE_CAPACITY";
                bOldValue = pOldValues.get(bParameterName) == null ? "" : pOldValues.get(bParameterName).toString();
                bNewValue = pNewValues.get(bParameterName) == null ? "" : pNewValues.get(bParameterName).toString();
                mMsgParms = new Object[]{bOldValue, bNewValue, bDisplayName};
            } else if (pOldValues.containsKey("BACKEND_STORAGE_CAPACITY") && pNewValues.containsKey("BACKEND_STORAGE_CAPACITY")) {
                bAlertCondition = 145;
                mMsgId = "ALR4246W";
                bParameterName = "BACKEND_STORAGE_CAPACITY";
                bOldValue = pOldValues.get(bParameterName) == null ? "" : pOldValues.get(bParameterName).toString();
                bNewValue = pNewValues.get(bParameterName) == null ? "" : pNewValues.get(bParameterName).toString();
                mMsgParms = new Object[]{bOldValue, bNewValue, bDisplayName};
            } else if (pOldValues.containsKey("CACHE") && pNewValues.containsKey("CACHE")) {
                bParameterName = "CACHE";
                bOldValue = pOldValues.get(bParameterName) == null ? "" : pOldValues.get(bParameterName).toString();
                bNewValue = pNewValues.get(bParameterName) == null ? "" : pNewValues.get(bParameterName).toString();
                mMsgParms = new Object[]{bDisplayName, "", "", bNewValue, bOldValue};
                mMsgId = "ALR0050W";
                bAlertCondition = Integer.parseInt(bOldValue) > Integer.parseInt(bNewValue) ? 68 : 67;
            } else {
                bAlertCondition = 123;
                mMsgId = "ALR4278W";
                mMsgParms = new Object[]{bDisplayName};
            }
            PopulatorHelper.addAttributeData(mSnmpTable, mTecTable, bParameterName, bOldValue, bNewValue);
            mAlertDef.aldCondition = (short)bAlertCondition;
            mAlertDef.aldProductID = (short)3;
            mAlertDef.aldDbmsType = 1;
            mAlertDef.aldType = (short)20;
            mAlertDef.aldAlertID = EventDBAccessor.getAlertIDByConditionForSubsystems((short)bAlertCondition, pID);
            if (mAlertDef.aldAlertID <= 0) {
                mLTH.traceInfo("No alertId found for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int[] mAffectedResIDs = PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForStorageSystem(pID));
            mResult = new FabricAlert(mComputerId, mResourceId, mResourceType, mAlertDef, mEnterprise, mTrapType, mSnmpTable, mTecClass, mTecTable, mMsgId, mMsgParms, mAffectedResIDs);
            mLTH.exit((Object)mResult);
        }
        catch (AlertCreationException pE) {
            throw pE;
        }
        catch (Exception pE) {
            mLTH.traceError("Exception during alert population for device: " + pID, (Throwable)pE);
            throw new AlertCreationException("Could not populate alert for device: " + pID);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    public Alert populateOperationalStatusChange(String pID, int pOldStatus, int pNewStatus) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populateOperationalStatusChange", (Object[])new Object[]{pID, new Integer(pOldStatus), new Integer(pNewStatus)});
        FabricAlert mResult = null;
        try {
            String mMsgId;
            short bAlertCondition;
            if (!EventDBAccessor.isAnyAlertDefined(new short[]{141, 140})) {
                mLTH.traceInfo("No alert defined for deviceId=" + pID + " with conditions=" + 141 + "," + 140);
                Alert alert = null;
                return alert;
            }
            int mComputerId = EventDBAccessor.getComputerId(1);
            int mResourceId = Integer.parseInt(pID);
            short mResourceType = 78;
            AlertDefinition mAlertDef = new AlertDefinition();
            int[] mEnterprise = MIBConstants.BTAphysicalEntityEvent;
            int mTrapType = 116;
            Hashtable<int[], String> mSnmpTable = new Hashtable<int[], String>();
            String mTecClass = "PEOperationalStatusChangeEvent";
            Hashtable<String, String> mTecTable = new Hashtable<String, String>();
            Hashtable<String, String> bSnmpValues = new Hashtable<String, String>();
            Hashtable<String, String> bTecValues = new Hashtable<String, String>();
            if (!EventDBAccessor.getSubSystemData(pID, bSnmpValues, bTecValues)) {
                throw new AlertCreationException("Failed to fill SNMP/TEC data for device: storagesystem" + pID);
            }
            int[][] bVarBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
            for (int i = 0; i < bVarBindOIDs.length; ++i) {
                mSnmpTable.put(bVarBindOIDs[i], this.getPEValue(i, bSnmpValues));
            }
            String bEventType = "TPC_DEVICE_OPERATIONAL_CHANGE_EVENT";
            bSnmpValues.put("eventType", bEventType);
            bTecValues.put("eventType", bEventType);
            for (int i = 0; i < peTecSlotNames.length; ++i) {
                String value = (String)bTecValues.get(peTecSlotNames[i]);
                if (value == null) {
                    value = "";
                }
                mTecTable.put(peTecSlotNames[i], value);
            }
            PopulatorHelper.addCommonTecAttributes(mTecTable, "MINOR");
            if (pNewStatus == 0) {
                bAlertCondition = 141;
                mMsgId = "ALR4242I";
            } else {
                bAlertCondition = 140;
                mMsgId = "ALR4241W";
            }
            Object[] mMsgParms = new Object[]{EventDBAccessor.getDisplayNameForStorageSystemID(pID)};
            PopulatorHelper.addOperationalStatusData(mSnmpTable, mTecTable, pOldStatus, pNewStatus);
            mAlertDef.aldCondition = bAlertCondition;
            mAlertDef.aldProductID = (short)3;
            mAlertDef.aldDbmsType = 1;
            mAlertDef.aldType = (short)20;
            mAlertDef.aldAlertID = EventDBAccessor.getAlertIDByConditionForSubsystems(bAlertCondition, pID);
            if (mAlertDef.aldAlertID <= 0) {
                mLTH.traceInfo("No alertId found for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int[] mAffectedResIDs = PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForStorageSystem(pID));
            mResult = new FabricAlert(mComputerId, mResourceId, mResourceType, mAlertDef, mEnterprise, mTrapType, mSnmpTable, mTecClass, mTecTable, mMsgId, mMsgParms, mAffectedResIDs);
            mLTH.exit((Object)mResult);
        }
        catch (AlertCreationException pE) {
            throw pE;
        }
        catch (Exception pE) {
            mLTH.traceError("Exception during alert population for device: " + pID, (Throwable)pE);
            throw new AlertCreationException("Could not populate alert for device: " + pID);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    public Alert populateStateChange(String pID, int pNewState, int pOldState, HashMap pAttributeMap) throws AlertCreationException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"populateStateChange", (Object[])new Object[]{pID, new Integer(pNewState), new Integer(pOldState), pAttributeMap});
        FabricAlert mResult = null;
        try {
            Object[] mMsgParms;
            String mMsgId;
            short bAlertCondition;
            int mTrapType;
            if (!EventDBAccessor.isAnyAlertDefined(new short[]{64, 65})) {
                mLTH.traceInfo("No alert defined for deviceId=" + pID + " with conditions=" + 64 + "," + 65);
                Alert alert = null;
                return alert;
            }
            int mComputerId = EventDBAccessor.getComputerId(1);
            int mResourceId = Integer.parseInt(pID);
            short mResourceType = 78;
            AlertDefinition mAlertDef = new AlertDefinition();
            int[] mEnterprise = MIBConstants.BTAphysicalEntityEvent;
            Hashtable<int[], String> mSnmpTable = new Hashtable<int[], String>();
            String mTecClass = "PhysicalEntityEvent";
            Hashtable<String, String> mTecTable = new Hashtable<String, String>();
            Hashtable<String, String> bSnmpValues = new Hashtable<String, String>();
            Hashtable<String, String> bTecValues = new Hashtable<String, String>();
            if (!EventDBAccessor.getSubSystemData(pID, bSnmpValues, bTecValues)) {
                throw new AlertCreationException("Failed to fill SNMP/TEC data for device: storagesystem" + pID);
            }
            int[][] bVarBindOIDs = MIBConstants.physicalDeviceVarBindOIDs;
            for (int i = 0; i < bVarBindOIDs.length; ++i) {
                mSnmpTable.put(bVarBindOIDs[i], this.getPEValue(i, bSnmpValues));
            }
            boolean isOnlineOrDetected = pNewState == 1;
            String bEventType = isOnlineOrDetected ? "TPC_NORMAL_DEVICE_EVENT" : "TPC_MISSING_DEVICE_EVENT";
            bSnmpValues.put("eventType", bEventType);
            bTecValues.put("eventType", bEventType);
            for (int i = 0; i < peTecSlotNames.length; ++i) {
                String value = (String)bTecValues.get(peTecSlotNames[i]);
                if (value == null) {
                    value = "";
                }
                mTecTable.put(peTecSlotNames[i], value);
            }
            String bSeverity = isOnlineOrDetected ? "HARMLESS" : "CRITICAL";
            PopulatorHelper.addCommonTecAttributes(mTecTable, bSeverity);
            if (isOnlineOrDetected) {
                mTrapType = 112;
                bAlertCondition = 64;
                mMsgId = "ALR1114W";
                mMsgParms = new Object[]{""};
            } else {
                mTrapType = 101;
                bAlertCondition = 65;
                mMsgId = "ALR0048W";
                mMsgParms = new Object[]{"N/A", EventDBAccessor.getDisplayNameForStorageSystemID(pID)};
            }
            mAlertDef.aldCondition = bAlertCondition;
            mAlertDef.aldProductID = (short)3;
            mAlertDef.aldDbmsType = 1;
            mAlertDef.aldType = (short)20;
            mAlertDef.aldAlertID = EventDBAccessor.getAlertIDByConditionForSubsystems(bAlertCondition, pID);
            if (mAlertDef.aldAlertID <= 0) {
                mLTH.traceInfo("No alertId found for deviceId=" + pID + " with condition=" + bAlertCondition);
                Alert alert = null;
                return alert;
            }
            int[] mAffectedResIDs = PopulatorHelper.getIntArrayFromListOfInteger(AffectedHostAnalyzer.getAffectedHostsForStorageSystem(pID));
            mResult = new FabricAlert(mComputerId, mResourceId, mResourceType, mAlertDef, mEnterprise, mTrapType, mSnmpTable, mTecClass, mTecTable, mMsgId, mMsgParms, mAffectedResIDs);
            mLTH.exit((Object)mResult);
        }
        catch (AlertCreationException pE) {
            throw pE;
        }
        catch (Exception pE) {
            mLTH.traceError("Exception during alert population for device: " + pID, (Throwable)pE);
            throw new AlertCreationException("Could not populate alert for device: " + pID);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    private String getPEValue(int pIndex, Hashtable pValues) {
        String peVarName = peVarNames[pIndex];
        if (peVarName.equals("description") || peVarName.equals("messageId")) {
            return peVarName;
        }
        String mValue = (String)pValues.get(peVarName);
        if (mValue != null) {
            return mValue;
        }
        return "";
    }
}

