/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.eventcorrelator.interfaces;

import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.aperi.monitor.eventcorrelator.EventXMLParser;
import org.eclipse.aperi.monitor.eventcorrelator.data.LogConstants;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.DataManager;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.ExtractEventFailedException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.InvalidParameterException;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartAction;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.SmartEvent;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.Source;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class InbandChangeEventExtractor {
    static ILogger msgLogger = LogConstants.msgLogger;
    static ILogger traceLogger = LogConstants.traceLogger;
    static final String className = InbandChangeEventExtractor.class.getName();

    public SmartEvent[] extractEvent(DataManager dataManager, String xmlEvent) throws ExtractEventFailedException {
        String methodName = "extractEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter= " + dataManager + " and " + xmlEvent));
        }
        Vector<SmartEvent> smartEvents = new Vector<SmartEvent>();
        XMLReader xmlReader = null;
        String[] xEventTypes = null;
        String[] xTimeStamps = null;
        String[] xSourceNames = null;
        String[] xSourceAddresses = null;
        try {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "In InbandChangeEventExtractor Parsing Data from xml");
            }
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setValidating(true);
            SAXParser saxParser = spfactory.newSAXParser();
            xmlReader = saxParser.getXMLReader();
            EventXMLParser ep = new EventXMLParser();
            xmlReader.setContentHandler(ep);
            xmlReader.setErrorHandler(ep);
            xmlReader.parse(new InputSource(new StringReader(xmlEvent)));
            xEventTypes = ep.getEventIds();
            xTimeStamps = ep.getTimeStamps();
            xSourceNames = ep.getSourceNames();
            xSourceAddresses = ep.getSourceAddresses();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "In SnmpSanEventExtractor.extractEvent Parsing Data from xml-done");
            }
        }
        catch (Exception e) {
            try {
                SmartEvent event = new SmartEvent("name", "address", "Specific Info", "ActionTarget", 0, "ActionDescription", 0, 0, "description", Calendar.getInstance());
                smartEvents.add(event);
                Object[] events = new SmartEvent[smartEvents.size()];
                smartEvents.copyInto(events);
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                return events;
            }
            catch (Exception ee) {
                throw new ExtractEventFailedException();
            }
        }
        for (int i = 0; i < xEventTypes.length; ++i) {
            SmartEvent smartEvent = null;
            try {
                smartEvent = this.createSmartEvent(xEventTypes[i], xTimeStamps[i], xSourceNames[i], xSourceAddresses[i], dataManager);
            }
            catch (ExtractEventFailedException eefe) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)eefe);
                }
                try {
                    smartEvent = new SmartEvent("name", "address", "Specific Info", "ActionTarget", 0, "ActionDescription", 0, 0, "description", Calendar.getInstance());
                }
                catch (Exception e) {
                    throw new ExtractEventFailedException();
                }
            }
            smartEvents.add(smartEvent);
        }
        Object[] events = new SmartEvent[smartEvents.size()];
        smartEvents.copyInto(events);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return events;
    }

    private SmartEvent createSmartEvent(String xEventType, String xTimeStamp, String xSourceName, String xSourceAddress, DataManager dataManager) throws ExtractEventFailedException {
        String methodName = "createSmartEvent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        SmartEvent smartEvent = null;
        try {
            String queryKeyTag = xEventType + "." + "Inband";
            String eventTypeStr = dataManager.getData(queryKeyTag + ".SmartEvent.EventType");
            int eventType = Integer.parseInt(eventTypeStr);
            String eventPriorityStr = dataManager.getData(queryKeyTag + ".SmartEvent.Priority");
            int eventPriority = Integer.parseInt(eventPriorityStr);
            String eventDescription = dataManager.getData(queryKeyTag + ".SmartEvent.Description");
            String eventActionTarget = dataManager.getData(queryKeyTag + ".SmartEvent.SmartAction.Target");
            String eventActionTypeStr = dataManager.getData(queryKeyTag + ".SmartEvent.SmartAction.ActionType");
            int eventActionType = Integer.parseInt(eventActionTypeStr);
            String eventActionDescription = dataManager.getData(queryKeyTag + ".SmartEvent.SmartAction.ActionDescription");
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "In InbandChangeEventExtractor.extractEvent Dot the descriptions");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss a zzz");
            Date date = new Date();
            try {
                date = sdf.parse(xTimeStamp);
            }
            catch (ParseException pe) {
                // empty catch block
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "In InbandChangeEventExtractor.extractEvent Created the calendar");
            }
            try {
                Source source = new Source(xSourceName, xSourceAddress, null);
                SmartAction smartAction = new SmartAction(eventActionTarget, eventActionType, eventActionDescription);
                smartEvent = new SmartEvent(source, smartAction, eventType, eventPriority, eventDescription, calendar);
            }
            catch (InvalidParameterException ipe) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ipe);
                }
                throw new ExtractEventFailedException();
            }
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, (Object)"In InbandChangeEventExtractor.extractEvent: Created SmartEvent");
            }
        }
        catch (RuntimeException re) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)re);
            }
            throw new ExtractEventFailedException();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return smartEvent;
    }
}

