/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.monitor.snmp;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.monitor.eventcorrelator.EventCorrelatorFactory;
import org.eclipse.aperi.monitor.snmp.SnmpMonitor;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpV2PDU;
import org.eclipse.aperi.snmp.SnmpV2Trap;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.V2TrapFilter;
import org.eclipse.aperi.snmp.V2TrapListener;
import org.eclipse.aperi.snmp.data.Counter64;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.TimeTicks;

public class SnmpV2Monitor
extends SnmpMonitor
implements V2TrapFilter,
V2TrapListener {
    private EventCorrelatorFactory eventMonitor = null;
    private SnmpTrap v1Trap = null;

    public SnmpV2Monitor(EventCorrelatorFactory eventMonitor) {
        super(eventMonitor);
        String methodName = "SnmpMonitor";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
    }

    public void handle(SnmpV2PDU trap) {
        String methodName = "handlev2";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        super.handle(this.v1Trap);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public boolean filter(SnmpV2PDU trap) {
        long start = System.currentTimeMillis();
        String methodName = "filterv2";
        this.v1Trap = this.mapToV1Trap((SnmpV2Trap)trap);
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger.isLogging()) {
            StringBuffer variables = new StringBuffer();
            Vector varList = trap.varBindList();
            for (SnmpVarBind varbind : varList) {
                variables.append("\t(" + varbind.get_printable_oid() + "=");
                if (varbind.get_value() instanceof OctetString) {
                    variables.append(((OctetString)varbind.get_value()).toDisplayString() + ")\n");
                    continue;
                }
                variables.append(varbind.get_printable_value() + ")\n");
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return super.filter(this.v1Trap);
    }

    private SnmpTrap mapToV1Trap(SnmpV2Trap v2Trap) {
        OID Snmp_StandardTraps = new OID("1.3.6.1.6.3.1.1.5");
        OID SnmpTrapEnterpriseOID = new OID("1.3.6.1.6.3.1.1.4.3.0");
        Object oid = null;
        Vector varList = v2Trap.varBindList();
        SnmpVarBind varbind_SysUpTime = (SnmpVarBind)varList.elementAt(0);
        SnmpVarBind varbind_TrapOID = (SnmpVarBind)varList.elementAt(1);
        SnmpVarBind varbind_Enterprise = null;
        SnmpTrap trap = new SnmpTrap();
        Iterator i = varList.iterator();
        i.next();
        i.next();
        while (i.hasNext()) {
            SnmpVarBind varbind = (SnmpVarBind)i.next();
            if (varbind.get_value() instanceof Counter64) continue;
            if (varbind.get_oid().equals((Object)SnmpTrapEnterpriseOID)) {
                varbind_Enterprise = varbind;
                continue;
            }
            trap.varBindList.addElement(varbind);
        }
        trap.agentAddr = new IPAddress(v2Trap.senderAddr);
        trap.communityString = new OctetString(v2Trap.communityString);
        trap.senderAddr = new IPAddress(v2Trap.senderAddr);
        trap.timeStamp = (TimeTicks)varbind_SysUpTime.get_value();
        OID trapOID = (OID)varbind_TrapOID.get_value();
        int OID_length = trapOID.value.length;
        if (OID_length == 10 && trapOID.value[9] <= 6L && trapOID.startsWith(Snmp_StandardTraps)) {
            trap.specificTrap = 0;
            trap.genericTrap = (int)trapOID.value[9] - 1;
            trap.enterprise = varbind_Enterprise != null ? varbind_Enterprise.get_oid() : Snmp_StandardTraps;
        } else {
            trap.genericTrap = 6;
            trap.specificTrap = (int)trapOID.value[OID_length - 1];
            trap.enterprise = trapOID.value[OID_length - 2] == 0L ? new OID(Snmp_StandardTraps.value, OID_length - 2) : new OID(Snmp_StandardTraps.value, OID_length - 1);
        }
        return trap;
    }
}

