/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.aperi.common.dbaccess.HostAgentPingDbAccess;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.Null;
import org.eclipse.aperi.infrastructure.database.objects.Agent;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.Scanner;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class AgentTableUpdater
extends AgentTableReader {
    static final String className = AgentTableUpdater.class.getName();

    AgentTableUpdater(DBConnection dbc, String tableName) throws InterruptedException, SQLException {
        super(dbc, tableName);
    }

    boolean createHost(TdmAgent h) throws SQLException {
        String methodName = "createHost";
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "createHost", (Object)h.getUniqueAgentName());
        }
        Timestamp ts = new Timestamp(h.status_lstchanged.getTime());
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "createHost", h.guid.toNoDotString() + " " + h.agentName + " " + h.ipAddress + " " + h.agentPort + " " + h.osname + " " + ts + " " + h.status + " " + h.version);
        }
        DeviceAgent da = new DeviceAgent();
        Host host = new Host();
        short s = AgentTableUpdater.osType(h.osname);
        int dot = h.agentName.indexOf(46);
        String hostName = "";
        String domainName = "";
        if (dot < 0) {
            hostName = h.agentName;
        } else {
            hostName = h.agentName.substring(0, dot);
            domainName = h.agentName.substring(dot + 1);
        }
        host.setNetworkName(hostName);
        host.setHostName(h.agentName);
        host.setDomainName(domainName);
        host.setHostUrl(h.agentName);
        host.setOsType(s);
        host.setIpAddress(h.ipAddress);
        int id = 0;
        Host oldEntry = this.getResHost(h.guid);
        if (oldEntry == null) {
            host.setGuid(h.guid.toNoDotString());
            id = AutoIdentifier.getIdentifier((int)1, (int)1);
            host.setComputerId(id);
            host.insert(this._dbc);
            this.updateScanner(h);
        } else {
            id = oldEntry.getComputerId();
            host.setComputerId(id);
            host.update(this._dbc);
            this.updateScanner(h);
        }
        da.setPort(h.agentPort);
        da.setStatusLastChanged(ts);
        da.setStatus(h.status);
        da.setVersion(h.version);
        da.setHostId(id);
        id = AutoIdentifier.getIdentifier((int)1, (int)1);
        da.setDeviceAgentId(id);
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "createHost", da.toString());
        }
        boolean b = da.insert(this._dbc);
        this._dbc.commit();
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "createHost", b);
        }
        return b;
    }

    int updateHost(TdmAgent h, boolean bUpdateStatus) throws SQLException {
        int r;
        String methodName = "updateHost";
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "updateHost", (Object)h.getUniqueAgentName());
        }
        int n = r = bUpdateStatus ? this.updateHostWithStatus(h) : this.updateHostNoStatus(h);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "updateHost", r);
        }
        return r;
    }

    private int updateHostWithStatus(TdmAgent h) throws SQLException {
        String methodName = "updateHostWithStatus";
        String name = h.getUniqueAgentName();
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "updateHostWithStatus", (Object)name);
        }
        Timestamp ts = new Timestamp(h.status_lstchanged.getTime());
        Host host = new Host();
        short s = AgentTableUpdater.osType(h.osname);
        int dot = h.agentName.indexOf(46);
        String hostName = "";
        String domainName = "";
        if (dot < 0) {
            hostName = h.agentName;
        } else {
            hostName = h.agentName.substring(0, dot);
            domainName = h.agentName.substring(dot + 1);
        }
        host.setNetworkName(hostName);
        host.setHostName(h.agentName);
        host.setDomainName(domainName);
        host.setHostUrl(h.agentName);
        host.setOsType(s);
        host.setIpAddress(h.ipAddress);
        host.setGuid(h.guid.toNoDotString());
        DeviceAgent da = new DeviceAgent();
        da.setDeviceAgentId(h.index);
        da.retrieve(this._dbc);
        host.setComputerId(da.getHostId());
        host.update(this._dbc);
        this.updateScanner(h);
        da = new DeviceAgent();
        da.setDeviceAgentId(h.index);
        da.setPort(h.agentPort);
        da.setStatusLastChanged(ts);
        da.setStatus(h.status);
        da.setVersion(h.version);
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "updateHostWithStatus", da.toString() + " " + h.index + " " + name);
        }
        int r = da.update(this._dbc);
        this._dbc.commit();
        HostAgentPingDbAccess.updateHostStatus((int)host.getComputerId(), (String)h.status);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "updateHostWithStatus", r);
        }
        return r;
    }

    private int updateHostNoStatus(TdmAgent h) throws SQLException {
        String methodName = "updateHostNoStatus";
        String name = h.getUniqueAgentName();
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "updateHostNoStatus", (Object)name);
        }
        Host host = new Host();
        short s = AgentTableUpdater.osType(h.osname);
        int dot = h.agentName.indexOf(46);
        String hostName = "";
        String domainName = "";
        if (dot < 0) {
            hostName = h.agentName;
        } else {
            hostName = h.agentName.substring(0, dot);
            domainName = h.agentName.substring(dot + 1);
        }
        host.setNetworkName(hostName);
        host.setHostName(h.agentName);
        host.setDomainName(domainName);
        host.setHostUrl(h.agentName);
        host.setOsType(s);
        host.setIpAddress(h.ipAddress);
        host.setGuid(h.guid.toNoDotString());
        DeviceAgent da = new DeviceAgent();
        da.setDeviceAgentId(h.index);
        da.retrieve(this._dbc);
        host.setComputerId(da.getHostId());
        host.update(this._dbc);
        this.updateScanner(h);
        da = new DeviceAgent();
        da.setDeviceAgentId(h.index);
        da.setPort(h.agentPort);
        da.setVersion(h.version);
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "updateHostNoStatus", da.toString() + " " + h.index + " " + name);
        }
        int r = da.update(this._dbc);
        this._dbc.commit();
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "updateHostNoStatus", r);
        }
        return r;
    }

    private void createScanner(TdmAgent h) throws SQLException {
        Scanner scanner = new Scanner();
        scanner.clear();
        scanner.setAgentName(h.guid.toNoDotString());
        scanner.setScannerId("PI1:" + h.ipAddress + ":" + h.agentPort);
        scanner.setType("PI1");
        scanner.setPort(h.agentPort);
        scanner.setVersion(h.version);
        if (!scanner.insert(this._dbc)) {
            System.out.println("Error inserting scanner " + h.ipAddress);
        }
        scanner.setScannerId("PI2:" + h.ipAddress + ":" + h.agentPort);
        scanner.setType("PI2");
        scanner.setPort(h.agentPort);
        scanner.setVersion(h.version);
        if (!scanner.insert(this._dbc)) {
            System.out.println("Error inserting scanner " + h.ipAddress);
        }
    }

    private void updateScanner(TdmAgent h) throws SQLException {
        String topology_scanner_id = "PI1:" + h.ipAddress + ":" + h.agentPort;
        Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
        htWhere.put(Scanner.getColumnInfo((String)"SCANNER_ID"), topology_scanner_id);
        Scanner scanner_query = Scanner.retrieve((DBConnection)this._dbc, htWhere);
        if (scanner_query == null) {
            this.createScanner(h);
        } else {
            Scanner scanner = new Scanner();
            scanner.clear();
            scanner.setAgentName(h.guid.toNoDotString());
            scanner.setScannerId(topology_scanner_id);
            scanner.setType("PI1");
            scanner.setPort(h.agentPort);
            scanner.setVersion(h.version);
            scanner.update(this._dbc);
            scanner.setScannerId("PI2:" + h.ipAddress + ":" + h.agentPort);
            scanner.setType("PI2");
            scanner.setPort(h.agentPort);
            scanner.setVersion(h.version);
            scanner.update(this._dbc);
        }
    }

    int updateStatus(GUID guid, int port, Timestamp ts, String status) throws SQLException {
        String methodName = "updateStatus";
        String name = guid + ":" + port;
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "updateStatus", (Object)name);
        }
        Host host = this.getResHost(guid);
        Hashtable<ColumnInfo, Object> htIn = new Hashtable<ColumnInfo, Object>();
        Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
        htIn.put(DeviceAgent.getColumnInfo((String)"STATUS_LAST_CHANGED"), ts);
        htIn.put(DeviceAgent.getColumnInfo((String)"STATUS"), status);
        htWhere.put(DeviceAgent.getColumnInfo((String)"HOST_ID"), "" + host.getComputerId());
        htWhere.put(DeviceAgent.getColumnInfo((String)"PORT"), "" + port);
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "updateStatus", htIn.toString() + htWhere.toString());
        }
        int r = DeviceAgent.update((DBConnection)this._dbc, htIn, htWhere);
        this._dbc.commit();
        HostAgentPingDbAccess.updateHostStatus((int)host.getComputerId(), (String)status);
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "updateStatus", r);
        }
        return r;
    }

    int deleteHost(int id) throws SQLException {
        String methodName = "deleteHost";
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "deleteHost", (Object)new Integer(id));
        }
        DeviceAgent da = new DeviceAgent();
        da.setDeviceAgentId(id);
        da.retrieve(this._dbc);
        Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
        htWhere.put(Agent.getColumnInfo((String)"COMPUTER_ID"), "" + da.getHostId());
        Agent.AgentCursor ac = Agent.getCursor((DBConnection)this._dbc, htWhere, null);
        int r = da.delete(this._dbc);
        if (!ac.next()) {
            Host host = new Host();
            host.setComputerId(da.getHostId());
            host.delete(this._dbc);
        }
        this._dbc.commit();
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "deleteHost", r);
        }
        return r;
    }

    int moveAgentToDomain(GUID guid, int port, int domainID) throws SQLException {
        String methodName = "moveAgent";
        String name = guid + ":" + port;
        if (this._trace.isLogging()) {
            this._trace.entry((Object)this, "moveAgent", (Object)name);
        }
        Hashtable<ColumnInfo, Object> htIn = new Hashtable<ColumnInfo, Object>();
        Hashtable<ColumnInfo, String> htWhere = new Hashtable<ColumnInfo, String>();
        if (domainID == 0) {
            htIn.put(DeviceAgent.getColumnInfo((String)"POLICY_DOMAIN_ID"), new Null());
        } else {
            htIn.put(DeviceAgent.getColumnInfo((String)"POLICY_DOMAIN_ID"), "" + domainID);
        }
        Host host = this.getResHost(guid);
        htWhere.put(DeviceAgent.getColumnInfo((String)"HOST_ID"), "" + host.getComputerId());
        htWhere.put(DeviceAgent.getColumnInfo((String)"PORT"), "" + port);
        if (this._trace.isLogging()) {
            this._trace.text(IRecordType.TYPE_MISC_DATA, (Object)this, "moveAgent", htIn.toString() + htWhere.toString());
        }
        int r = DeviceAgent.update((DBConnection)this._dbc, htIn, htWhere);
        this._dbc.commit();
        if (this._trace.isLogging()) {
            this._trace.exit((Object)this, "moveAgent", r);
        }
        return r;
    }
}

