/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Date;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableReader;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.AgentTableUpdater;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.SANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.data.TdmAgent;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.DatabaseConnectException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.PeerDataException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.RemoveActiveAgentException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.SqlException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.TdmException;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.UnknownAgentException;
import org.eclipse.aperi.sanmgmt.event.TESTopicExtensionMgr;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messagingimpl.TESTopicImpl;
import org.eclipse.aperi.sanmgmt.subagent.common.HostQueryInfo;

class HostManager {
    static final String className = HostManager.class.getName();

    HostManager() {
    }

    static TdmAgent bldTdmHostObject(HostQueryInfo hostinfo) throws PeerDataException {
        String methodName = "bldTdmHostObject";
        String errorMsg = "";
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "bldTdmHostObject");
        }
        TdmAgent h = new TdmAgent();
        h.version = hostinfo.hostVersion;
        h.agentName = hostinfo.hostName;
        h.guid = hostinfo.GUID;
        if (h.agentName == null || h.agentName.equals("")) {
            SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)className, "bldTdmHostObject", "Agent_nameError");
            errorMsg = "The Agent returns invalid host name.";
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "bldTdmHostObject", errorMsg);
            }
            throw new PeerDataException();
        }
        h.ipAddress = hostinfo.hostIP;
        h.agentPort = Integer.parseInt(hostinfo.hostPort);
        h.osname = hostinfo.osName;
        h.status_lstchanged = new Date();
        h.status = "AC";
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "bldTdmHostObject");
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String addTdmHost(AgentTableUpdater tableAccess, TdmAgent h) {
        String methodName = "addTdmHost";
        int id = -1;
        String evtstatus = null;
        Object tdmhost = null;
        boolean bInclude = true;
        DeviceAgent.DeviceAgentCursor dac = null;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "addTdmHost");
        }
        try {
            dac = tableAccess.queryHost(h.guid, h.agentPort);
            if (dac.next()) {
                DeviceAgent da = dac.getAttributes();
                String status = da.getStatus();
                h.index = da.getDeviceAgentId();
                id = HostManager.sqlUpdateTdmHost2HostTable(tableAccess, h, bInclude);
                evtstatus = "AC";
            } else if (tableAccess.createHost(h)) {
                evtstatus = "AC";
            }
        }
        catch (Exception e) {
            SANDiskMgrHostService.messages.exception((Object)className, "addTdmHost", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "addTdmHost", (Throwable)e);
            }
        }
        finally {
            if (dac != null) {
                try {
                    dac.close();
                }
                catch (SQLException ignore) {}
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "addTdmHost", evtstatus);
        }
        return evtstatus;
    }

    static int getHostIdByTdmHost(AgentTableReader tableAccess, GUID guid, int port) throws UnknownAgentException {
        String methodName = "getHostIdByTdmHost";
        String name = guid + ":" + port;
        int id = -1;
        DeviceAgent.DeviceAgentCursor dac = null;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getHostIdByTdmHost", (Object)name);
        }
        try {
            dac = tableAccess.queryHost(guid, port);
            if (!dac.next()) {
                SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)className, "getHostIdByTdmHost", "Agent_notExistDB", (Object)name);
                String msg = name + " is not a known Host.";
                if (SANDiskMgrHostService.trace.isLogging()) {
                    SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "getHostIdByTdmHost", msg);
                }
                throw new UnknownAgentException();
            }
            DeviceAgent da = dac.getAttributes();
            id = da.getDeviceAgentId();
        }
        catch (Exception e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getHostIdByTdmHost", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getHostIdByTdmHost", (Throwable)e);
            }
            throw new UnknownAgentException();
        }
        finally {
            try {
                if (dac != null) {
                    dac.close();
                }
            }
            catch (Exception e) {}
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getHostIdByTdmHost", id);
        }
        return id;
    }

    private static int sqlUpdateTdmHost2HostTable(AgentTableUpdater tableAccess, TdmAgent h, boolean bInclude) {
        String methodName = "sqlUpdateTdmHost2HostTable";
        int id = -1;
        String name = h.getUniqueAgentName();
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "sqlUpdateTdmHost2HostTable", (Object)name, (Object)new Boolean(bInclude));
        }
        try {
            id = tableAccess.updateHost(h, bInclude);
        }
        catch (Exception e) {
            SANDiskMgrHostService.messages.exception((Object)className, "sqlUpdateTdmHost2HostTable", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "sqlUpdateTdmHost2HostTable", (Throwable)e);
            }
            id = -1;
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "sqlUpdateTdmHost2HostTable", id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void fireDiskMgrHostEvent(GUID guid, int port, String evtstatus) {
        String methodName = "fireDiskMgrHostEvent";
        String name = guid + ":" + port;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "fireDiskMgrHostEvent", (Object)name, (Object)evtstatus);
        }
        TopicPublisher publisher = null;
        String testmsg = name;
        SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "fireDiskMgrHostEvent", testmsg);
        try {
            Factory factory = SANDiskMgrHostService.getFactory();
            TESTopicExtensionMgr extMgr = TESTopicExtensionMgr.getExtensionMgr();
            TESTopicImpl topicImpl = (TESTopicImpl)extMgr.getExtensionImpl("org.eclipse.aperi.monitor.eventcorrelator.data.DiskMgrAgentEvent");
            TESTopicImpl event = (TESTopicImpl)topicImpl.getClass().getConstructor(String.class, Integer.TYPE, String.class).newInstance(guid.toNoDotString(), port, evtstatus);
            ObjectMessage template = factory.createMessage(null);
            template.setStringProperty("publisherID", "org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.uniquename");
            publisher = factory.createPublisher(event.getClass().getName(), (Message)template);
            ObjectMessage publishedEvent = factory.createMessage((Serializable)event);
            publisher.publish((Message)publishedEvent);
        }
        catch (Exception e) {
            SANDiskMgrHostService.messages.exception((Object)className, "fireDiskMgrHostEvent", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "fireDiskMgrHostEvent", (Throwable)e);
            }
        }
        finally {
            block16: {
                try {
                    if (publisher != null) {
                        publisher.close();
                    }
                }
                catch (Exception e) {
                    SANDiskMgrHostService.messages.exception((Object)className, "fireDiskMgrHostEvent", (Throwable)e);
                    if (!SANDiskMgrHostService.trace.isLogging()) break block16;
                    SANDiskMgrHostService.trace.exception((Object)className, "fireDiskMgrHostEvent", (Throwable)e);
                }
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "fireDiskMgrHostEvent");
        }
    }

    static int isHostInactive(AgentTableReader tableAccess, GUID guid, int port) throws UnknownAgentException, RemoveActiveAgentException, SqlException {
        int id;
        String name;
        block17: {
            String methodName = "isHostInactive";
            name = guid + ":" + port;
            String sql = "";
            id = -1;
            DeviceAgent.DeviceAgentCursor dac = null;
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.entry((Object)className, "isHostInactive", (Object)name);
            }
            try {
                dac = tableAccess.queryHost(guid, port);
                if (dac.next()) {
                    DeviceAgent da = dac.getAttributes();
                    id = da.getDeviceAgentId();
                    String status = da.getStatus();
                    if (status.equals("AC")) {
                        SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)className, "isHostInactive", "Agent_removeActiveError", (Object)name);
                        String msg = "Agent " + name + " can not be removed because it is active.";
                        if (SANDiskMgrHostService.trace.isLogging()) {
                            SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "isHostInactive", msg);
                        }
                        throw new RemoveActiveAgentException();
                    }
                    break block17;
                }
                SANDiskMgrHostService.messages.message(IRecordType.TYPE_ERROR, (Object)className, "isHostInactive", "Agent_notExistDB", (Object)name);
                String msg = name + " is not a known Host.";
                if (SANDiskMgrHostService.trace.isLogging()) {
                    SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "isHostInactive", msg);
                }
                throw new UnknownAgentException();
            }
            catch (SQLException e1) {
                SANDiskMgrHostService.messages.exception((Object)className, "isHostInactive", (Throwable)e1);
                if (SANDiskMgrHostService.trace.isLogging()) {
                    SANDiskMgrHostService.trace.exception((Object)className, "isHostInactive", (Throwable)e1);
                }
                throw new SqlException(e1);
            }
            finally {
                try {
                    if (dac != null) {
                        dac.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "isHostInactive", name);
        }
        return id;
    }

    static void removeHost(AgentTableUpdater tableAccess, int id) throws SqlException {
        String methodName = "removeHost";
        String sql = "";
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "removeHost", (Object)new Integer(id));
        }
        try {
            tableAccess.deleteHost(id);
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "removeHost", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "removeHost", (Throwable)e);
            }
            throw new SqlException(e);
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "removeHost");
        }
    }

    static void removeInactiveHost(GUID guid, int port) throws TdmException {
        String methodName = "removeInactiveHost";
        String name = guid + ":" + port;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "removeInactiveHost", (Object)name);
        }
        AgentTableUpdater tableAccess = null;
        int id = -1;
        try {
            tableAccess = SANDiskMgrHostService.getHostTableUpdater();
            id = HostManager.isHostInactive(tableAccess, guid, port);
            HostManager.removeHost(tableAccess, id);
            HostManager.fireDiskMgrHostEvent(guid, port, "RM");
            SANDiskMgrHostService.messages.message(IRecordType.TYPE_INFO, (Object)className, "removeInactiveHost", "User_removeInactiveAgent", (Object)name);
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "removeInactiveHost", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "removeInactiveHost", (Throwable)e);
            }
            throw new SqlException(e);
        }
        catch (InterruptedException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "removeInactiveHost", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "removeInactiveHost", (Throwable)e);
            }
            throw new DatabaseConnectException(e);
        }
        finally {
            if (tableAccess != null) {
                tableAccess.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "removeInactiveHost");
        }
    }

    static int getPolicyDomainIDFromAgent(GUID guid, int port) throws TdmException {
        String methodName = "getPolicyDomainIDFromAgent";
        String name = guid + ":" + port;
        int rc = -1;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "getPolicyDomainIDFromAgent", (Object)name);
        }
        AgentTableReader tableAccess = null;
        try {
            tableAccess = SANDiskMgrHostService.getHostTableReader();
            rc = tableAccess.getPolicyDomainIDFromAgent(guid, port);
            if (rc == -1) {
                SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "getPolicyDomainIDFromAgent", "Agent not found");
                throw new UnknownAgentException();
            }
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getPolicyDomainIDFromAgent", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getPolicyDomainIDFromAgent", (Throwable)e);
            }
            throw new SqlException(e);
        }
        catch (InterruptedException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "getPolicyDomainIDFromAgent", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "getPolicyDomainIDFromAgent", (Throwable)e);
            }
            throw new DatabaseConnectException(e);
        }
        finally {
            if (tableAccess != null) {
                tableAccess.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "getPolicyDomainIDFromAgent", rc);
        }
        return rc;
    }

    static void moveAgentToDomain(GUID guid, int port, int id) throws TdmException {
        String methodName = "moveAgentToDomain";
        String name = guid + ":" + port;
        int rc = 0;
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.entry((Object)className, "moveAgentToDomain", (Object)name);
        }
        AgentTableUpdater tableAccess = null;
        try {
            tableAccess = SANDiskMgrHostService.getHostTableUpdater();
            rc = tableAccess.moveAgentToDomain(guid, port, id);
            if (rc == 0) {
                SANDiskMgrHostService.trace.text(IRecordType.TYPE_MISC_DATA, (Object)className, "moveAgentToDomain", "Agent not found");
                throw new UnknownAgentException();
            }
        }
        catch (SQLException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "moveAgentToDomain", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "moveAgentToDomain", (Throwable)e);
            }
            throw new SqlException(e);
        }
        catch (InterruptedException e) {
            SANDiskMgrHostService.messages.exception((Object)className, "moveAgentToDomain", (Throwable)e);
            if (SANDiskMgrHostService.trace.isLogging()) {
                SANDiskMgrHostService.trace.exception((Object)className, "moveAgentToDomain", (Throwable)e);
            }
            throw new DatabaseConnectException(e);
        }
        finally {
            if (tableAccess != null) {
                tableAccess.close();
            }
        }
        if (SANDiskMgrHostService.trace.isLogging()) {
            SANDiskMgrHostService.trace.exit((Object)className, "moveAgentToDomain", rc);
        }
    }
}

