/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control.fabric;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.control.Controller;
import org.eclipse.aperi.control.ThreadPool;
import org.eclipse.aperi.control.data.JobInfo;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.data.fabric.InbandZoneControlAgent;
import org.eclipse.aperi.control.data.fabric.ZoneControlAgent;
import org.eclipse.aperi.control.interfaces.InvalidTokenException;
import org.eclipse.aperi.control.interfaces.JobInProgressException;
import org.eclipse.aperi.control.interfaces.LockedException;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.control.interfaces.fabric.IZoneControl;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.fabric.FabricActivator;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Alias;
import org.eclipse.aperi.infrastructure.database.objects.Alias2member;
import org.eclipse.aperi.infrastructure.database.objects.Zone;
import org.eclipse.aperi.infrastructure.database.objects.Zone2alias;
import org.eclipse.aperi.infrastructure.database.objects.Zone2member;
import org.eclipse.aperi.infrastructure.database.objects.ZoneMember;
import org.eclipse.aperi.infrastructure.database.objects.Zset;
import org.eclipse.aperi.infrastructure.database.objects.Zset2zone;
import org.eclipse.aperi.infrastructure.database.tables.TResAlias2memberTable;
import org.eclipse.aperi.infrastructure.database.tables.TResAliasTable;
import org.eclipse.aperi.infrastructure.database.tables.TResZone2aliasTable;
import org.eclipse.aperi.infrastructure.database.tables.TResZone2memberTable;
import org.eclipse.aperi.infrastructure.database.tables.TResZoneMemberTable;
import org.eclipse.aperi.infrastructure.database.tables.TResZoneTable;
import org.eclipse.aperi.infrastructure.database.tables.TResZset2zoneTable;
import org.eclipse.aperi.infrastructure.database.tables.TResZsetTable;
import org.eclipse.aperi.monitor.eventcorrelator.interfaces.IEventMonitorService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone2ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone2ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias2ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneConstants;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet2Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.Command;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.IZoneControlAgent;

public class ZoneController
extends Controller
implements IZoneControl {
    ILogger msgLogger = ZoneConstants.msgLogger;
    ILogger traceLogger = ZoneConstants.traceLogger;
    ILogger auditLogger = ZoneConstants.auditLogger;
    static final String className = ZoneController.class.getName();
    private Hashtable agents = new Hashtable();
    private static final short ACTIVE = 1;
    private static final short INACTIVE = 0;
    private static final int ZONE_ERROR = -1414;
    private ArrayList activateOnCommit = new ArrayList();
    private static IEventMonitorService eventMonitor = null;

    public ZoneController() {
        String methodName = "ZoneController";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        this.controllerThreadPool = new ThreadPool(5, "Zone Controller");
        this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_ZoneControlStart");
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public ZoneController(ControlEngine ce) {
        this();
        this.ce = ce;
    }

    private ZoneController(ControlEngine ce, Token token, Hashtable agentsIn, ArrayList activateOnCommitIn, Method m, Object[] args) {
        String methodName = "ZoneController";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        this.ce = ce;
        this.token = token;
        this.m = m;
        this.args = args;
        this.agents = agentsIn;
        this.activateOnCommit = activateOnCommitIn;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public Controller createController(ControlEngine ce, Token token, Method m, Object[] args) {
        String methodName = "createController";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return new ZoneController(ce, token, this.agents, this.activateOnCommit, m, args);
    }

    public String[] getAsyncMethodNames() {
        String methodName = "getAsyncMethodNames";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return new String[]{"commitTransaction", "setZoneInfo", "ping"};
    }

    public String[] getNonPersistedTopLevelJobAPIMethodNames() {
        String methodName = "getNonPersistedTopLevelJobAPIMethodNames";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return new String[0];
    }

    public Token reserve(String resource, String resourceType, String clientId, int accessType) throws LockedException, NotAvailableException {
        ILogger jobLogger;
        String methodName = "reserve";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        Token token = null;
        token = this._internalreserve(resource, resourceType, clientId, accessType);
        if (!token.isValid()) {
            block12: {
                this.cleanupLastTransaction(token);
                try {
                    this._internalrelease(token);
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block12;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            token = this._internalreserve(resource, resourceType, clientId, accessType);
        }
        String target = "None";
        String result = Integer.toString(token.getTokenId());
        NotAvailableException na = null;
        ZoneControlAgent ourAgent = this.findZoneControlAgent(token);
        if (ourAgent == null) {
            block13: {
                try {
                    this._internalrelease(token);
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block13;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            na = new NotAvailableException();
            result = na.toString();
        } else {
            target = ourAgent.getTarget();
            this.agents.put(token, ourAgent);
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger != null) {
            jobLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_reserve", (Object[])new String[]{resource, target, clientId, result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_reserve", (Object[])new String[]{resource, target, clientId, result});
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        if (na != null) {
            throw na;
        }
        return token;
    }

    /*
     * Loose catch block
     */
    public int release(Token token) throws Exception {
        int rc;
        block21: {
            ILogger jobLogger;
            String methodName;
            block20: {
                ILogger jobLogger2;
                String SAN;
                String result;
                block18: {
                    methodName = "release";
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
                    }
                    rc = 0;
                    if (token == null) break block20;
                    result = "";
                    SAN = token.getResource();
                    this.activateOnCommit.remove(token);
                    IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                    rc = izc.release(SAN);
                    result = Integer.toString(rc);
                    Object var8_11 = null;
                    try {
                        this._internalrelease(token);
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block18;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
                this.agents.remove(token);
                String dsrId = token.getJobId();
                JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
                ILogger iLogger = jobLogger2 = jobInfo == null ? null : jobInfo.getJobLogger();
                if (jobLogger2 != null) {
                    jobLogger2.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_release", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
                } else {
                    this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_release", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
                }
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                break block21;
                {
                    catch (Throwable t) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                        }
                        result = t.toString();
                        throw new Exception(result);
                    }
                }
                catch (Throwable throwable) {
                    block19: {
                        Object var8_12 = null;
                        try {
                            this._internalrelease(token);
                        }
                        catch (Exception e) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                        }
                    }
                    this.agents.remove(token);
                    dsrId = token.getJobId();
                    jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
                    ILogger iLogger2 = jobLogger2 = jobInfo == null ? null : jobInfo.getJobLogger();
                    if (jobLogger2 != null) {
                        jobLogger2.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_release", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
                    } else {
                        this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_release", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
                    }
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                    }
                    throw throwable;
                }
            }
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger != null) {
                jobLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_release", (Object[])new String[]{"", "", "", ""});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_release", (Object[])new String[]{"", "", "", ""});
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
        return rc;
    }

    public Token _internalreserve(String resource, String resourceType, String client, int accessType) throws LockedException {
        String methodName = "reserve";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        String result = "";
        String target = "None";
        String tokenTimeout = ZoneConstants.TOKENTIMEOUTVALUE;
        Token token = null;
        if (accessType == 1 && (token = super.getDBToken(resource, resourceType, client, accessType)) != null) {
            try {
                super.checkToken(token);
            }
            catch (InvalidTokenException e) {
                result = e.toString();
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_reserve", (Object[])new String[]{resource, target, token.getClient(), result});
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                return token;
            }
            catch (JobInProgressException e) {
                // empty catch block
            }
            LockedException locked = new LockedException();
            result = locked.toString();
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_reserve", (Object[])new String[]{resource, target, token.getClient(), result});
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            throw locked;
        }
        token = super.createToken(resource, resourceType, client, accessType);
        if (token == null) {
            LockedException locked = new LockedException();
            result = locked.toString();
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_reserve", (Object[])new String[]{resource, target, client, result});
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            throw locked;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return token;
    }

    public int _internalrelease(Token token) throws Exception {
        String methodName = "release";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        String[] jobIds = this.ce.getJobIds(token);
        for (int i = 0; i < jobIds.length; ++i) {
            ServiceUtils.activeJobs.remove(jobIds[i]);
            ServiceUtils.completedJobResults.remove(jobIds[i]);
        }
        super.removeTokenFromJobs(token);
        if (token.getAccessType() == 1) {
            super.removeToken(token.getResource(), token.getResourceType());
        }
        super.removeTokenFromValidTokens(token);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int startTransaction(Token token) throws Exception {
        ILogger jobLogger2222;
        String methodName = "startTransaction";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.startTransaction(SAN);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var8_9 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_startTransaction", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_startTransaction", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_startTransaction", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_startTransaction", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult commitTransaction(Token token) throws Exception {
        ILogger jobLogger2222;
        String result;
        AsyncResult rc;
        String methodName;
        block26: {
            block24: {
                methodName = "commitTransaction";
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
                }
                rc = new AsyncResult(-1414);
                result = "";
                String SAN = token.getResource();
                try {
                    try {
                        ZoneControlAgent agent = (ZoneControlAgent)((Object)this.agents.get(token));
                        IZoneControlAgent izc = agent.getAgentProxy();
                        int irc = izc.commitTransaction(SAN);
                        rc.setRc(irc);
                        if (irc == 0) {
                            boolean apply_active = this.activateOnCommit.contains(token);
                            this.updateDatabase(SAN, agent, apply_active);
                            this.activateOnCommit.remove(token);
                            this.reDiscoverZoneConfig(SAN);
                        }
                        result = Integer.toString(rc.getRc());
                    }
                    catch (Throwable t) {
                        ILogger jobLogger2222;
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                        }
                        result = t.toString();
                        rc.setReturnException(new Exception(result));
                        Object var11_12 = null;
                        if (this.shutdown) {
                            result = "Cancelled.";
                            rc.setStatus(5);
                            rc.setRc(-14);
                        } else if (rc.getRc() != 0 || rc.getReturnException() != null) {
                            rc.setStatus(0);
                        } else {
                            rc.setStatus(1);
                        }
                        String dsrId = token.getJobId();
                        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
                        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
                        if (jobLogger2222 != null) {
                            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_commitTransaction", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
                        } else {
                            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_commitTransaction", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
                        }
                        if (this.traceLogger == null) return rc;
                        if (!this.traceLogger.isLogging()) return rc;
                        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                        return rc;
                    }
                    Object var11_11 = null;
                    if (!this.shutdown) break block24;
                    result = "Cancelled.";
                }
                catch (Throwable throwable) {
                    ILogger jobLogger2222;
                    Object var11_13 = null;
                    if (this.shutdown) {
                        result = "Cancelled.";
                        rc.setStatus(5);
                        rc.setRc(-14);
                    } else if (rc.getRc() != 0 || rc.getReturnException() != null) {
                        rc.setStatus(0);
                    } else {
                        rc.setStatus(1);
                    }
                    String dsrId = token.getJobId();
                    JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
                    ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
                    if (jobLogger2222 != null) {
                        jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_commitTransaction", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
                    } else {
                        this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_commitTransaction", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
                    }
                    if (this.traceLogger == null) throw throwable;
                    if (!this.traceLogger.isLogging()) throw throwable;
                    this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                    throw throwable;
                }
                rc.setStatus(5);
                rc.setRc(-14);
                break block26;
            }
            if (rc.getRc() != 0 || rc.getReturnException() != null) {
                rc.setStatus(0);
            } else {
                rc.setStatus(1);
            }
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_commitTransaction", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_commitTransaction", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int rollbackTransaction(Token token) throws Exception {
        ILogger jobLogger2222;
        String methodName = "rollbackTransaction";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.rollbackTransaction(SAN);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var8_9 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_rollbackTransaction", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_rollbackTransaction", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_rollbackTransaction", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_rollbackTransaction", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult setZoneInfo(Token token, ZoneDefinition definition, int flag) throws Exception {
        ILogger jobLogger2222;
        String result;
        AsyncResult rc;
        String methodName;
        block27: {
            block25: {
                methodName = "setZoneInfo";
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
                }
                rc = new AsyncResult(-1414);
                result = "";
                String SAN = token.getResource();
                try {
                    try {
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Zone Definition:\n " + definition.toString());
                        }
                        ZoneControlAgent agent = (ZoneControlAgent)((Object)this.agents.get(token));
                        IZoneControlAgent izc = agent.getAgentProxy();
                        int irc = izc.setZoneInfo(SAN, definition, flag);
                        rc.setRc(irc);
                        if (irc == 0) {
                            boolean apply_active = flag == 1 || flag == 2;
                            this.updateDatabase(SAN, agent, apply_active);
                            this.reDiscoverZoneConfig(SAN);
                        }
                        result = Integer.toString(rc.getRc());
                    }
                    catch (Throwable t) {
                        ILogger jobLogger2222;
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                        }
                        result = t.toString();
                        rc.setReturnException(new Exception(result));
                        Object var13_14 = null;
                        if (this.shutdown) {
                            result = "Cancelled.";
                            rc.setStatus(5);
                            rc.setRc(-14);
                        } else if (rc.getRc() != 0 || rc.getReturnException() != null) {
                            rc.setStatus(0);
                        } else {
                            rc.setStatus(1);
                        }
                        String dsrId = token.getJobId();
                        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
                        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
                        if (jobLogger2222 != null) {
                            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_setZoneInfo", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
                            jobLogger2222.text(IRecordType.TYPE_INFO, (Object)this, methodName, ZoneController.printableZoneDefinition(definition));
                        } else {
                            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_setZoneInfo", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
                            this.auditLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, ZoneController.printableZoneDefinition(definition));
                        }
                        if (this.traceLogger == null) return rc;
                        if (!this.traceLogger.isLogging()) return rc;
                        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                        return rc;
                    }
                    Object var13_13 = null;
                    if (!this.shutdown) break block25;
                    result = "Cancelled.";
                }
                catch (Throwable throwable) {
                    ILogger jobLogger2222;
                    Object var13_15 = null;
                    if (this.shutdown) {
                        result = "Cancelled.";
                        rc.setStatus(5);
                        rc.setRc(-14);
                    } else if (rc.getRc() != 0 || rc.getReturnException() != null) {
                        rc.setStatus(0);
                    } else {
                        rc.setStatus(1);
                    }
                    String dsrId = token.getJobId();
                    JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
                    ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
                    if (jobLogger2222 != null) {
                        jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_setZoneInfo", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
                        jobLogger2222.text(IRecordType.TYPE_INFO, (Object)this, methodName, ZoneController.printableZoneDefinition(definition));
                    } else {
                        this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_setZoneInfo", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
                        this.auditLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, ZoneController.printableZoneDefinition(definition));
                    }
                    if (this.traceLogger == null) throw throwable;
                    if (!this.traceLogger.isLogging()) throw throwable;
                    this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                    throw throwable;
                }
                rc.setStatus(5);
                rc.setRc(-14);
                break block27;
            }
            if (rc.getRc() != 0 || rc.getReturnException() != null) {
                rc.setStatus(0);
            } else {
                rc.setStatus(1);
            }
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_setZoneInfo", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
            jobLogger2222.text(IRecordType.TYPE_INFO, (Object)this, methodName, ZoneController.printableZoneDefinition(definition));
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_setZoneInfo", (Object[])new String[]{token.getResource(), token.getClient(), Integer.toString(token.getTokenId()), result});
            this.auditLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, ZoneController.printableZoneDefinition(definition));
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendCommandArray(Token token, Command[] commands) throws Exception {
        ILogger jobLogger2222;
        String methodName = "sendCommandArray";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.sendCommandArray(SAN, commands);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var9_10 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_sendCommandArray", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_sendCommandArray", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_sendCommandArray", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_sendCommandArray", (Object[])new String[]{SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupLastTransaction(Token token) {
        String methodName = "cleanupLastTransaction";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        try {
            IZoneControlAgent izc;
            String SAN = token.getResource();
            ZoneControlAgent agent = (ZoneControlAgent)((Object)this.agents.get(token));
            if (agent != null && (izc = agent.getAgentProxy()) != null) {
                izc.rollbackTransaction(SAN);
                izc.release(SAN);
            }
        }
        catch (Throwable t) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
            }
        }
        finally {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createZoneSet(Token token, String zoneSetName) throws Exception {
        ILogger jobLogger2222;
        String methodName = "createZoneSet";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.createZoneSet(SAN, zoneSetName);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var9_10 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createZone(Token token, String zoneName, short zoneType, short zoneSubType) throws Exception {
        ILogger jobLogger2222;
        String methodName = "createZone";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.createZone(SAN, zoneName, zoneType, zoneSubType);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var11_12 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZone", (Object[])new String[]{zoneName, Integer.toString(zoneType), Integer.toString(zoneSubType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZone", (Object[])new String[]{zoneName, Integer.toString(zoneType), Integer.toString(zoneSubType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZone", (Object[])new String[]{zoneName, Integer.toString(zoneType), Integer.toString(zoneSubType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZone", (Object[])new String[]{zoneName, Integer.toString(zoneType), Integer.toString(zoneSubType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createZoneAlias(Token token, String zoneAliasName) throws Exception {
        ILogger jobLogger2222;
        String methodName = "createZoneAlias";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.createZoneAlias(SAN, zoneAliasName);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var9_10 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneAlias", (Object[])new String[]{zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneAlias", (Object[])new String[]{zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneAlias", (Object[])new String[]{zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneAlias", (Object[])new String[]{zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createZoneMemberSettingData(Token token, short enumType, String id, short targType, String targName) throws Exception {
        ILogger jobLogger2222;
        String methodName = "createZoneMemberSettingData";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.createZoneMemberSettingData(SAN, enumType, id, targType, targName);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var12_13 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneMemberSettingData", (Object[])new String[]{id, Integer.toString(enumType), Integer.toString(targType), targName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneMemberSettingData", (Object[])new String[]{id, Integer.toString(enumType), Integer.toString(targType), targName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneMemberSettingData", (Object[])new String[]{id, Integer.toString(enumType), Integer.toString(targType), targName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_createZoneMemberSettingData", (Object[])new String[]{id, Integer.toString(enumType), Integer.toString(targType), targName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addZoneToZoneSet(Token token, String zoneSetName, String zoneName) throws Exception {
        ILogger jobLogger2222;
        String methodName = "addZoneToZoneSet";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.addZoneToZoneSet(SAN, zoneSetName, zoneName);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var10_11 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneToZoneSet", (Object[])new String[]{zoneSetName, zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneToZoneSet", (Object[])new String[]{zoneSetName, zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneToZoneSet", (Object[])new String[]{zoneSetName, zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneToZoneSet", (Object[])new String[]{zoneSetName, zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addZoneMemberToZone(Token token, String zoneName, String zoneMemberName, short zoneMemberType) throws Exception {
        ILogger jobLogger2222;
        String methodName = "addZoneMemberToZone";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.addZoneMemberToZone(SAN, zoneName, zoneMemberName, zoneMemberType);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var11_12 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneMemberToZone", (Object[])new String[]{zoneName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneMemberToZone", (Object[])new String[]{zoneName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneMemberToZone", (Object[])new String[]{zoneName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneMemberToZone", (Object[])new String[]{zoneName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addZoneAliasToZone(Token token, String zoneName, String zoneAliasName) throws Exception {
        ILogger jobLogger2222;
        String methodName = "addZoneAliasToZone";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.addZoneAliasToZone(SAN, zoneName, zoneAliasName);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var10_11 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneAliasToZone", (Object[])new String[]{zoneName, zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneAliasToZone", (Object[])new String[]{zoneName, zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneAliasToZone", (Object[])new String[]{zoneName, zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneAliasToZone", (Object[])new String[]{zoneName, zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addZoneMemberToZoneAlias(Token token, String zoneAliasName, String zoneMemberName, short zoneMemberType) throws Exception {
        ILogger jobLogger2222;
        String methodName = "addZoneMemberToZoneAlias";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.addZoneMemberToZoneAlias(SAN, zoneAliasName, zoneMemberName, zoneMemberType);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var11_12 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneMemberToZoneAlias", (Object[])new String[]{zoneAliasName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneMemberToZoneAlias", (Object[])new String[]{zoneAliasName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneMemberToZoneAlias", (Object[])new String[]{zoneAliasName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_addZoneMemberToZoneAlias", (Object[])new String[]{zoneAliasName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int removeZoneFromZoneSet(Token token, String zoneSetName, String zoneName) throws Exception {
        ILogger jobLogger2222;
        String methodName = "removeZoneFromZoneSet";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.removeZoneFromZoneSet(SAN, zoneSetName, zoneName);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var10_11 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneFromZoneSet", (Object[])new String[]{zoneSetName, zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneFromZoneSet", (Object[])new String[]{zoneSetName, zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneFromZoneSet", (Object[])new String[]{zoneSetName, zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneFromZoneSet", (Object[])new String[]{zoneSetName, zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int removeZoneAliasFromZone(Token token, String zoneName, String zoneAliasName) throws Exception {
        ILogger jobLogger2222;
        String methodName = "removeZoneAliasFromZone";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.removeZoneAliasFromZone(SAN, zoneName, zoneAliasName);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var10_11 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneAliasFromZone", (Object[])new String[]{zoneName, zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneAliasFromZone", (Object[])new String[]{zoneName, zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneAliasFromZone", (Object[])new String[]{zoneName, zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneAliasFromZone", (Object[])new String[]{zoneName, zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int removeZoneMemberFromZone(Token token, String zoneName, String zoneMemberName, short zoneMemberType) throws Exception {
        ILogger jobLogger2222;
        String methodName = "removeZoneMemberFromZone";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.removeZoneMemberFromZone(SAN, zoneName, zoneMemberName, zoneMemberType);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var11_12 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneMemberFromZone", (Object[])new String[]{zoneName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneMemberFromZone", (Object[])new String[]{zoneName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneMemberFromZone", (Object[])new String[]{zoneName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneMemberFromZone", (Object[])new String[]{zoneName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int removeZoneMemberFromZoneAlias(Token token, String zoneAliasName, String zoneMemberName, short zoneMemberType) throws Exception {
        ILogger jobLogger2222;
        String methodName = "removeZoneMemberFromZoneAlias";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.removeZoneMemberFromZoneAlias(SAN, zoneAliasName, zoneMemberName, zoneMemberType);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var11_12 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneMemberFromZoneAlias", (Object[])new String[]{zoneAliasName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneMemberFromZoneAlias", (Object[])new String[]{zoneAliasName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneMemberFromZoneAlias", (Object[])new String[]{zoneAliasName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_removeZoneMemberFromZoneAlias", (Object[])new String[]{zoneAliasName, zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteZoneMember(Token token, String zoneMemberName, short zoneMemberType) throws Exception {
        ILogger jobLogger2222;
        String methodName = "deleteZoneMember";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.deleteZoneMember(SAN, zoneMemberName, zoneMemberType);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var10_11 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneMember", (Object[])new String[]{zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneMember", (Object[])new String[]{zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneMember", (Object[])new String[]{zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneMember", (Object[])new String[]{zoneMemberName, Integer.toString(zoneMemberType), SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteZone(Token token, String zoneName) throws Exception {
        ILogger jobLogger2222;
        String methodName = "deleteZone";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.deleteZone(SAN, zoneName);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var9_10 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZone", (Object[])new String[]{zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZone", (Object[])new String[]{zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZone", (Object[])new String[]{zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZone", (Object[])new String[]{zoneName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteZoneSet(Token token, String zoneSetName) throws Exception {
        ILogger jobLogger2222;
        String methodName = "deleteZoneSet";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.deleteZoneSet(SAN, zoneSetName);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var9_10 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteZoneAlias(Token token, String zoneAliasName) throws Exception {
        ILogger jobLogger2222;
        String methodName = "deleteZoneAlias";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            try {
                IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                rc = izc.deleteZoneAlias(SAN, zoneAliasName);
                result = Integer.toString(rc);
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                result = t.toString();
                throw new Exception(result);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            ILogger jobLogger2222;
            Object var9_10 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger2222 != null) {
                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneAlias", (Object[])new String[]{zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneAlias", (Object[])new String[]{zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneAlias", (Object[])new String[]{zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deleteZoneAlias", (Object[])new String[]{zoneAliasName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int activateZoneSet(Token token, String zoneSetName) throws Exception {
        String methodName = "activateZoneSet";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            ILogger jobLogger222;
            block10: {
                try {
                    IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                    rc = izc.activateZoneSet(SAN, zoneSetName);
                    result = Integer.toString(rc);
                    if (rc != 0 || this.activateOnCommit.contains(token)) break block10;
                    this.activateOnCommit.add(token);
                }
                catch (Throwable t) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                    }
                    result = t.toString();
                    throw new Exception(result);
                }
            }
            Object var9_9 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger222 != null) {
                jobLogger222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_activateZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_activateZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) return rc;
            if (!this.traceLogger.isLogging()) return rc;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            return rc;
        }
        catch (Throwable throwable) {
            ILogger jobLogger222;
            Object var9_10 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger222 != null) {
                jobLogger222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_activateZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_activateZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deactivateZoneSet(Token token, String zoneSetName) throws Exception {
        String methodName = "deactivateZoneSet";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = -1414;
        String result = "";
        String SAN = token.getResource();
        try {
            ILogger jobLogger222;
            block10: {
                try {
                    IZoneControlAgent izc = ((ZoneControlAgent)((Object)this.agents.get(token))).getAgentProxy();
                    rc = izc.deactivateZoneSet(SAN, zoneSetName);
                    result = Integer.toString(rc);
                    if (rc != 0 || this.activateOnCommit.contains(token)) break block10;
                    this.activateOnCommit.add(token);
                }
                catch (Throwable t) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                    }
                    result = t.toString();
                    throw new Exception(result);
                }
            }
            Object var9_9 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger222 != null) {
                jobLogger222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deactivateZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deactivateZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) return rc;
            if (!this.traceLogger.isLogging()) return rc;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            return rc;
        }
        catch (Throwable throwable) {
            ILogger jobLogger222;
            Object var9_10 = null;
            String dsrId = token.getJobId();
            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
            ILogger iLogger = jobLogger222 = jobInfo == null ? null : jobInfo.getJobLogger();
            if (jobLogger222 != null) {
                jobLogger222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deactivateZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            } else {
                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_deactivateZoneSet", (Object[])new String[]{zoneSetName, SAN, token.getClient(), Integer.toString(token.getTokenId()), result});
            }
            if (this.traceLogger == null) throw throwable;
            if (!this.traceLogger.isLogging()) throw throwable;
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult ping(Token token) throws NotAvailableException, Exception {
        ILogger jobLogger2222;
        String SAN;
        String result;
        AsyncResult rc;
        String methodName;
        block34: {
            NotAvailableException na;
            ZoneCapabilities zc;
            block32: {
                methodName = "ping";
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
                }
                rc = new AsyncResult(-1414);
                result = "";
                SAN = token.getResource();
                zc = null;
                na = null;
                try {
                    block31: {
                        try {
                            ZoneControlAgent agent = (ZoneControlAgent)((Object)this.agents.get(token));
                            result = agent.getTarget();
                            IZoneControlAgent izc = agent.getAgentProxy();
                            if (izc.ping(SAN, agent.getLockParameters()) == 0) {
                                if (!this.shutdown && (zc = izc.getCapabilities(SAN)) != null) {
                                    zc.setAgentName(agent.getTarget());
                                    zc.setAgentScannerId(agent.getScannerId());
                                }
                                break block31;
                            }
                            na = new NotAvailableException();
                        }
                        catch (Throwable t) {
                            ILogger jobLogger2222;
                            result = t.toString();
                            rc.setReturnException(new Exception(result));
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                            }
                            Object var11_12 = null;
                            if (this.shutdown) {
                                result = "Cancelled.";
                                rc.setStatus(5);
                                rc.setRc(-14);
                            } else if (na != null) {
                                result = na.toString();
                                rc.setReturnException((Exception)na);
                                rc.setStatus(0);
                            } else if (zc == null || rc.getReturnException() != null) {
                                rc.setStatus(0);
                            } else {
                                rc.setRc(0);
                                rc.setStatus(1);
                                Object[] results = new Object[]{zc};
                                rc.setResults(results);
                            }
                            String dsrId = token.getJobId();
                            JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
                            ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
                            if (jobLogger2222 != null) {
                                jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_ping", (Object[])new String[]{SAN, result});
                            } else {
                                this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_ping", (Object[])new String[]{SAN, result});
                            }
                            if (this.traceLogger == null) return rc;
                            if (!this.traceLogger.isLogging()) return rc;
                            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                            return rc;
                        }
                    }
                    Object var11_11 = null;
                    if (!this.shutdown) break block32;
                    result = "Cancelled.";
                }
                catch (Throwable throwable) {
                    ILogger jobLogger2222;
                    Object var11_13 = null;
                    if (this.shutdown) {
                        result = "Cancelled.";
                        rc.setStatus(5);
                        rc.setRc(-14);
                    } else if (na != null) {
                        result = na.toString();
                        rc.setReturnException(na);
                        rc.setStatus(0);
                    } else if (zc == null || rc.getReturnException() != null) {
                        rc.setStatus(0);
                    } else {
                        rc.setRc(0);
                        rc.setStatus(1);
                        Object[] results = new Object[]{zc};
                        rc.setResults(results);
                    }
                    String dsrId = token.getJobId();
                    JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
                    ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
                    if (jobLogger2222 != null) {
                        jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_ping", (Object[])new String[]{SAN, result});
                    } else {
                        this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_ping", (Object[])new String[]{SAN, result});
                    }
                    if (this.traceLogger == null) throw throwable;
                    if (!this.traceLogger.isLogging()) throw throwable;
                    this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                    throw throwable;
                }
                rc.setStatus(5);
                rc.setRc(-14);
                break block34;
            }
            if (na != null) {
                result = na.toString();
                rc.setReturnException((Exception)na);
                rc.setStatus(0);
            } else if (zc == null || rc.getReturnException() != null) {
                rc.setStatus(0);
            } else {
                rc.setRc(0);
                rc.setStatus(1);
                Object[] results = new Object[]{zc};
                rc.setResults(results);
            }
        }
        String dsrId = token.getJobId();
        JobInfo jobInfo = (JobInfo)ServiceUtils.activeJobs.get(dsrId);
        ILogger iLogger = jobLogger2222 = jobInfo == null ? null : jobInfo.getJobLogger();
        if (jobLogger2222 != null) {
            jobLogger2222.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_ping", (Object[])new String[]{SAN, result});
        } else {
            this.auditLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "ZCAudit_ping", (Object[])new String[]{SAN, result});
        }
        if (this.traceLogger == null) return rc;
        if (!this.traceLogger.isLogging()) return rc;
        this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        return rc;
    }

    private ZoneControlAgent findZoneControlAgent(Token token) {
        String methodName = "findZoneControlAgent";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        String SAN = token.getResource();
        ZoneControlAgent ourAgent = null;
        ZoneControlAgent[] agents = null;
        agents = this.getZoneControllerInfo(SAN);
        for (int i = 0; i < agents.length; ++i) {
            try {
                IZoneControlAgent izc = agents[i].getAgentProxy();
                if (izc.lock(SAN, agents[i].getLockParameters()) != 0) continue;
                ourAgent = agents[i];
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found agent for zone control => " + ourAgent.getTarget());
                break;
            }
            catch (Throwable t) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return ourAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZoneControlAgent[] getZoneControllerInfo(String SAN) {
        String methodName = "getZoneControllerInfo";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        DBConnection connection = null;
        ArrayList<ZoneControlAgent> agents = new ArrayList<ZoneControlAgent>();
        try {
            connection = ServiceUtils.getConnection();
            String schema = connection.getSchema();
            String sql = "\tSelect \t\t'GS-3' as TYPE, scanner.scanner_id as SCANNERID, host.IP_ADDRESS as ADDRESS, agent.PORT as PORT, 'N/A' as userid, 'N/A' as password,  agent.VERSION as VERSION \tfrom \t\t" + schema + ".T_RES_SCANNER scanner, " + schema + ".T_RES_ELEMENT_PROBE_STATUS state, " + schema + ".T_RES_DEVICE_AGENT agent, " + schema + ".T_RES_FABRIC fabric, " + schema + ".T_RES_HOST host" + "\twhere " + "\t\tfabric.FABRIC_WWN = '" + SAN.trim() + "' and" + "\t\tfabric.DETECTABLE = 1 and" + "\t\tstate.ELEMENT_ID = fabric.FABRIC_ID and " + "\t\tstate.scanner_id = scanner.scanner_id and " + "\t\tscanner.enabled = 1 and " + "\t\tscanner.type = '" + "PI1" + "' and " + "\t\tagent.HOST_ID = host.computer_id and " + "\t\tagent.PORT = scanner.port and " + "\t\tagent.STATUS = 'AC'";
            DBResultSet dbr = null;
            try {
                dbr = ComplexQuery.sqlQuery((DBConnection)connection, (String)sql, new Hashtable());
                while (dbr.next()) {
                    String type = dbr.getString("TYPE").trim();
                    ZoneControlAgent agent = null;
                    if ("GS-3".equals(type)) {
                        String scannerId = dbr.getString("SCANNERID");
                        String address = dbr.getString("ADDRESS");
                        String port = dbr.getString("PORT");
                        String version = dbr.getString("VERSION");
                        agent = new InbandZoneControlAgent(scannerId, address, port, version);
                    }
                    agents.add(agent);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found potential agent for zone control =>" + agent.getTarget());
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            finally {
                block31: {
                    try {
                        if (dbr != null) {
                            dbr.close();
                        }
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block31;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block32: {
                if (connection != null) {
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block32;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        ZoneControlAgent[] agentArray = new ZoneControlAgent[agents.size()];
        agentArray = agents.toArray(new ZoneControlAgent[0]);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return agentArray;
    }

    private int updateDatabase(String resource, ZoneControlAgent agent, boolean applyToActiveZoneset) {
        String methodName = "updateDatabase";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = 0;
        boolean doDatabaseUpdate = false;
        ZoneDefinition oldZoneDef = null;
        ZoneDefinition newZoneDef = null;
        try {
            IZoneControlAgent izc = agent.getAgentProxy();
            oldZoneDef = new ZoneDefinition();
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Getting zone definition before zone control changes applied...");
            }
            oldZoneDef = izc.getOldZoneDefinition(resource);
            newZoneDef = new ZoneDefinition();
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Getting zone definition after zone control changes applied...");
            }
            newZoneDef = izc.getNewZoneDefinition(resource);
            doDatabaseUpdate = true;
        }
        catch (Throwable t) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, t.toString());
        }
        if (doDatabaseUpdate && oldZoneDef != null && newZoneDef != null) {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Doing direct update of the database...");
            }
            this.setZoneTypesToDefault(oldZoneDef);
            this.setZoneTypesToDefault(newZoneDef);
            this.makeZoneConfigDBChanges(oldZoneDef, newZoneDef, resource, applyToActiveZoneset);
        } else {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Could not directly update database so we are updating the database by doing a probe on " + agent.getTarget());
            }
            this.reDiscoverZoneConfig(agent);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int makeZoneConfigDBChanges(ZoneDefinition oldZoneDef, ZoneDefinition newZoneDef, String resource, boolean applyToActiveZoneset) {
        String methodName = "makeZoneConfigDBChanges";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int status = 0;
        ZoneMember[] oldDefMembers = oldZoneDef.getMembers();
        ZoneAlias[] oldDefAliases = oldZoneDef.getAliases();
        Zone[] oldDefZones = oldZoneDef.getZones();
        ZoneSet[] oldDefZoneSets = oldZoneDef.getZoneSets();
        ZoneMember[] newDefMembers = newZoneDef.getMembers();
        ZoneAlias[] newDefAliases = newZoneDef.getAliases();
        Zone[] newDefZones = newZoneDef.getZones();
        ZoneSet[] newDefZoneSets = newZoneDef.getZoneSets();
        ArrayList oldZDefZone2alias = this.getZone2alias(oldZoneDef, oldDefZones);
        Zone2ZoneAlias[] oldDefZone2ZoneAliases = new Zone2ZoneAlias[oldZDefZone2alias.size()];
        oldDefZone2ZoneAliases = oldZDefZone2alias.toArray(new Zone2ZoneAlias[0]);
        ArrayList oldZDefZone2member = this.getZone2member(oldZoneDef, oldDefZones);
        Zone2ZoneMember[] oldDefZone2ZoneMembers = new Zone2ZoneMember[oldZDefZone2member.size()];
        oldDefZone2ZoneMembers = oldZDefZone2member.toArray(new Zone2ZoneMember[0]);
        ArrayList oldZDefAlias2member = this.getAlias2member(oldZoneDef, oldDefAliases);
        ZoneAlias2ZoneMember[] oldDefAlias2ZoneMembers = new ZoneAlias2ZoneMember[oldZDefAlias2member.size()];
        oldDefAlias2ZoneMembers = oldZDefAlias2member.toArray(new ZoneAlias2ZoneMember[0]);
        ArrayList oldZDefZoneSet2zone = this.getZoneSet2zone(oldZoneDef, oldDefZoneSets);
        ZoneSet2Zone[] oldDefZoneSet2Zones = new ZoneSet2Zone[oldZDefZoneSet2zone.size()];
        oldDefZoneSet2Zones = oldZDefZoneSet2zone.toArray(new ZoneSet2Zone[0]);
        ArrayList newZDefZone2alias = this.getZone2alias(newZoneDef, newDefZones);
        Zone2ZoneAlias[] newDefZone2ZoneAliases = new Zone2ZoneAlias[newZDefZone2alias.size()];
        newDefZone2ZoneAliases = newZDefZone2alias.toArray(new Zone2ZoneAlias[0]);
        ArrayList newZDefZone2member = this.getZone2member(newZoneDef, newDefZones);
        Zone2ZoneMember[] newDefZone2ZoneMembers = new Zone2ZoneMember[newZDefZone2member.size()];
        newDefZone2ZoneMembers = newZDefZone2member.toArray(new Zone2ZoneMember[0]);
        ArrayList newZDefAlias2member = this.getAlias2member(newZoneDef, newDefAliases);
        ZoneAlias2ZoneMember[] newDefAlias2ZoneMembers = new ZoneAlias2ZoneMember[newZDefAlias2member.size()];
        newDefAlias2ZoneMembers = newZDefAlias2member.toArray(new ZoneAlias2ZoneMember[0]);
        ArrayList newZDefZoneSet2zone = this.getZoneSet2zone(newZoneDef, newDefZoneSets);
        ZoneSet2Zone[] newDefZoneSet2Zones = new ZoneSet2Zone[newZDefZoneSet2zone.size()];
        newDefZoneSet2Zones = newZDefZoneSet2zone.toArray(new ZoneSet2Zone[0]);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            int i;
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Old Zone definition: \n" + oldZoneDef.toString());
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "\nNew Zone definition: \n" + newZoneDef.toString());
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "\nOld definition:");
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of members  = " + oldDefMembers.length);
            for (i = 0; i < oldDefMembers.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefMembers[i].getName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of aliases  = " + oldDefAliases.length);
            for (i = 0; i < oldDefAliases.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefAliases[i].getName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zones    = " + oldDefZones.length);
            for (i = 0; i < oldDefZones.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefZones[i].getName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zoneSets = " + oldDefZoneSets.length);
            for (i = 0; i < oldDefZoneSets.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefZoneSets[i].getName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zone2aliases  = " + oldDefZone2ZoneAliases.length);
            for (i = 0; i < oldDefZone2ZoneAliases.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefZone2ZoneAliases[i].getZoneName() + " to " + oldDefZone2ZoneAliases[i].getZoneAliasName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zone2members  = " + oldDefZone2ZoneMembers.length);
            for (i = 0; i < oldDefZone2ZoneMembers.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefZone2ZoneMembers[i].getZoneName() + " to " + oldDefZone2ZoneMembers[i].getZoneMemberName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of alias2member  = " + oldDefAlias2ZoneMembers.length);
            for (i = 0; i < oldDefAlias2ZoneMembers.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefAlias2ZoneMembers[i].getZoneAliasName() + " to " + oldDefAlias2ZoneMembers[i].getZoneMemberName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zoneSet2zones  = " + oldDefZoneSet2Zones.length);
            for (i = 0; i < oldDefZoneSet2Zones.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefZoneSet2Zones[i].getZoneSetName() + " to " + oldDefZoneSet2Zones[i].getZoneName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "\nNew definition:");
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of members  = " + newDefMembers.length);
            for (i = 0; i < newDefMembers.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefMembers[i].getName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of aliases  = " + newDefAliases.length);
            for (i = 0; i < newDefAliases.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefAliases[i].getName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zones    = " + newDefZones.length);
            for (i = 0; i < newDefZones.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefZones[i].getName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zoneSets = " + newDefZoneSets.length);
            for (i = 0; i < newDefZoneSets.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefZoneSets[i].getName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zone2aliases  = " + newDefZone2ZoneAliases.length);
            for (i = 0; i < newDefZone2ZoneAliases.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefZone2ZoneAliases[i].getZoneName() + " to " + newDefZone2ZoneAliases[i].getZoneAliasName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zone2members  = " + newDefZone2ZoneMembers.length);
            for (i = 0; i < newDefZone2ZoneMembers.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefZone2ZoneMembers[i].getZoneName() + " to " + newDefZone2ZoneMembers[i].getZoneMemberName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of alias2member  = " + newDefAlias2ZoneMembers.length);
            for (i = 0; i < newDefAlias2ZoneMembers.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefAlias2ZoneMembers[i].getZoneAliasName() + " to " + newDefAlias2ZoneMembers[i].getZoneMemberName());
            }
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zoneSet2zones  = " + newDefZoneSet2Zones.length);
            for (i = 0; i < newDefZoneSet2Zones.length; ++i) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefZoneSet2Zones[i].getZoneSetName() + " to " + newDefZoneSet2Zones[i].getZoneName());
            }
        }
        DBConnection connection = null;
        try {
            connection = ServiceUtils.getConnection();
            int rc = this.removeDeletedZone2AliasAssociations(connection, oldDefZone2ZoneAliases, newZDefZone2alias, resource);
            rc = this.removeDeletedZone2MemberAssociations(connection, oldDefZone2ZoneMembers, newZDefZone2member, resource);
            rc = this.removeDeletedAlias2MemberAssociations(connection, oldDefAlias2ZoneMembers, newZDefAlias2member, resource);
            rc = this.removeDeletedZoneSet2ZoneAssociations(connection, oldDefZoneSet2Zones, newZDefZoneSet2zone, resource);
            rc = this.removeDeletedZoneMembers(connection, oldDefMembers, newZoneDef);
            rc = this.removeDeletedZoneAliases(connection, oldDefAliases, newZoneDef, resource);
            rc = this.removeDeletedZones(connection, oldDefZones, newZoneDef, resource, (short)0);
            rc = this.removeDeletedZoneSets(connection, oldDefZoneSets, newZoneDef, resource, (short)0);
            rc = this.addNewAndUpdateChangedZoneMembers(connection, newDefMembers, oldZoneDef);
            rc = this.addNewAndUpdateChangedZoneAliases(connection, newDefAliases, oldZoneDef, resource);
            rc = this.addNewAndUpdateChangedZones(connection, newDefZones, oldZoneDef, resource, (short)0);
            rc = this.addNewAndUpdateChangedZoneSets(connection, newDefZoneSets, oldZoneDef, resource, (short)0);
            rc = this.addNewZone2AliasAssociations(connection, newDefZone2ZoneAliases, oldZDefZone2alias, resource);
            rc = this.addNewZone2MemberAssociations(connection, newDefZone2ZoneMembers, oldZDefZone2member, resource);
            rc = this.addNewAlias2MemberAssociations(connection, newDefAlias2ZoneMembers, oldZDefAlias2member, resource);
            rc = this.addNewZoneSet2ZoneAssociations(connection, newDefZoneSet2Zones, oldZDefZoneSet2zone, resource);
            if (applyToActiveZoneset) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Applying zone configuration changes to the active zoneset");
                }
                rc = this.updateActiveZoneset(connection, newZoneDef, resource);
            }
            if (ZoneController.getEventMonitorProxy() != null) {
                ZoneController.getEventMonitorProxy().handleModelUpdate(this.token.getJobId());
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleModelUpdate invoked for " + this.token.getJobId());
                }
            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleModelUpdate not invoked for " + this.token.getJobId() + " due to null eventMonitorProxy");
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block39: {
                if (connection != null) {
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block39;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int removeDeletedZone2AliasAssociations(DBConnection connection, Zone2ZoneAlias[] oldDefZone2ZoneAliases, ArrayList newZDefZone2alias, String resource) {
        String methodName = "removeDeletedZone2AliasAssociations";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = 0;
        ArrayList<Zone2ZoneAlias> deletedZone2Alias = new ArrayList<Zone2ZoneAlias>();
        for (int i = 0; i < oldDefZone2ZoneAliases.length; ++i) {
            if (newZDefZone2alias.contains(oldDefZone2ZoneAliases[i])) continue;
            deletedZone2Alias.add(oldDefZone2ZoneAliases[i]);
        }
        if (deletedZone2Alias.size() > 0) {
            for (Zone2ZoneAlias z2a : deletedZone2Alias) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting zone2alias " + z2a.getZoneName() + " to " + z2a.getZoneAliasName());
                }
                org.eclipse.aperi.infrastructure.database.objects.Zone zone = this.getZoneFromDB(connection, z2a.getZoneName(), resource, (short)0);
                Alias alias = this.getZoneAliasFromDB(connection, z2a.getZoneAliasName(), resource);
                if (zone != null && alias != null && this.getZone2ZoneAliasFromDB(connection, zone.getZoneId(), alias.getAliasId()) != null) {
                    try {
                        Zone2alias zone2alias = this.getZone2ZoneAliasFromDB(connection, zone.getZoneId(), alias.getAliasId());
                        Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                        whereclause.put(Zone2alias.getColumnInfo((String)"ZONE_ID"), String.valueOf(zone.getZoneId()));
                        whereclause.put(Zone2alias.getColumnInfo((String)"ALIAS_ID"), String.valueOf(alias.getAliasId()));
                        Zone2alias.deletes((DBConnection)connection, whereclause);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zone2alias " + z2a.getZoneName() + " to " + z2a.getZoneAliasName() + " deleted.");
                        }
                        if (zone2alias != null) {
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZone2aliasTable.getTablename(), new Integer(zone2alias.getZone2aliasId()).toString(), 1, 0);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zone2alias.getZone2aliasId());
                                continue;
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zone2alias.getZone2aliasId() + " due to null eventMonitorProxy");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange could not be invoked for " + this.token.getJobId() + " due to null zone2alias");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    continue;
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Could not find zone " + z2a.getZoneName() + " or alias " + z2a.getZoneAliasName() + " in the database, or the association doesn't exist.");
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No zone2aliases to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeDeletedZone2MemberAssociations(DBConnection connection, Zone2ZoneMember[] oldDefZone2ZoneMembers, ArrayList newZDefZone2member, String resource) {
        String methodName = "removeDeletedZone2MemberAssociations";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = 0;
        ArrayList<Zone2ZoneMember> deletedZone2Member = new ArrayList<Zone2ZoneMember>();
        for (int i = 0; i < oldDefZone2ZoneMembers.length; ++i) {
            if (newZDefZone2member.contains(oldDefZone2ZoneMembers[i])) continue;
            deletedZone2Member.add(oldDefZone2ZoneMembers[i]);
        }
        if (deletedZone2Member.size() > 0) {
            for (Zone2ZoneMember z2m : deletedZone2Member) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting zone2member " + z2m.getZoneName() + " to " + z2m.getZoneMemberName());
                }
                org.eclipse.aperi.infrastructure.database.objects.Zone zone = this.getZoneFromDB(connection, z2m.getZoneName(), resource, (short)0);
                org.eclipse.aperi.infrastructure.database.objects.ZoneMember member = this.getZoneMemberFromDB(connection, z2m.getZoneMemberName(), z2m.getZoneMemberType());
                if (zone != null && member != null && this.getZone2ZoneMemberFromDB(connection, zone.getZoneId(), member.getZoneMemberId()) != null) {
                    try {
                        Zone2member zone2member = this.getZone2ZoneMemberFromDB(connection, zone.getZoneId(), member.getZoneMemberId());
                        Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                        whereclause.put(Zone2member.getColumnInfo((String)"ZONE_ID"), String.valueOf(zone.getZoneId()));
                        whereclause.put(Zone2member.getColumnInfo((String)"ZONE_MEMBER_ID"), String.valueOf(member.getZoneMemberId()));
                        Zone2member.deletes((DBConnection)connection, whereclause);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zone2member " + z2m.getZoneName() + " to " + z2m.getZoneMemberName() + " deleted.");
                        }
                        if (zone2member != null) {
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZone2memberTable.getTablename(), new Integer(zone2member.getZone2memberId()).toString(), 1, 0);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zone2member.getZone2memberId());
                                continue;
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zone2member.getZone2memberId() + " due to null eventMonitorProxy");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null zone2member");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    continue;
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Could not find zone " + z2m.getZoneName() + " or member " + z2m.getZoneMemberName() + " in the database, or the association doesn't exist.");
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No zone2members to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeDeletedAlias2MemberAssociations(DBConnection connection, ZoneAlias2ZoneMember[] oldDefAlias2ZoneMembers, ArrayList newZDefAlias2member, String resource) {
        String methodName = "removeDeletedAlias2MemberAssociations";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = 0;
        ArrayList<ZoneAlias2ZoneMember> deletedAlias2Member = new ArrayList<ZoneAlias2ZoneMember>();
        for (int i = 0; i < oldDefAlias2ZoneMembers.length; ++i) {
            if (newZDefAlias2member.contains(oldDefAlias2ZoneMembers[i])) continue;
            deletedAlias2Member.add(oldDefAlias2ZoneMembers[i]);
        }
        if (deletedAlias2Member.size() > 0) {
            for (ZoneAlias2ZoneMember a2m : deletedAlias2Member) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting alias2member " + a2m.getZoneAliasName() + " to " + a2m.getZoneMemberName());
                }
                Alias alias = this.getZoneAliasFromDB(connection, a2m.getZoneAliasName(), resource);
                org.eclipse.aperi.infrastructure.database.objects.ZoneMember member = this.getZoneMemberFromDB(connection, a2m.getZoneMemberName(), a2m.getZoneMemberType());
                if (alias != null && member != null && this.getZoneAlias2ZoneMemberFromDB(connection, alias.getAliasId(), member.getZoneMemberId()) != null) {
                    try {
                        Alias2member alias2member = this.getZoneAlias2ZoneMemberFromDB(connection, alias.getAliasId(), member.getZoneMemberId());
                        Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                        whereclause.put(Alias2member.getColumnInfo((String)"ALIAS_ID"), String.valueOf(alias.getAliasId()));
                        whereclause.put(Alias2member.getColumnInfo((String)"ZONE_MEMBER_ID"), String.valueOf(member.getZoneMemberId()));
                        Alias2member.deletes((DBConnection)connection, whereclause);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "alias2member " + a2m.getZoneAliasName() + " to " + a2m.getZoneMemberName() + " deleted.");
                        }
                        if (alias2member != null) {
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResAlias2memberTable.getTablename(), new Integer(alias2member.getAlias2memberId()).toString(), 1, 0);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + alias2member.getAlias2memberId());
                                continue;
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + alias2member.getAlias2memberId() + "due to null eventMonitorProxy");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null alias2member");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    continue;
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Could not find alias " + a2m.getZoneAliasName() + " or member " + a2m.getZoneMemberName() + " in the database, or the association doesn't exist.");
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No alias2members to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeDeletedZoneSet2ZoneAssociations(DBConnection connection, ZoneSet2Zone[] oldDefZoneSet2Zones, ArrayList newZDefZoneSet2zone, String resource) {
        String methodName = "removeDeletedZoneSet2ZoneAssociations";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = 0;
        ArrayList<ZoneSet2Zone> deletedZoneSet2Zone = new ArrayList<ZoneSet2Zone>();
        for (int i = 0; i < oldDefZoneSet2Zones.length; ++i) {
            if (newZDefZoneSet2zone.contains(oldDefZoneSet2Zones[i])) continue;
            deletedZoneSet2Zone.add(oldDefZoneSet2Zones[i]);
        }
        if (deletedZoneSet2Zone.size() > 0) {
            for (ZoneSet2Zone zs2z : deletedZoneSet2Zone) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting zoneset2zone " + zs2z.getZoneSetName() + " to " + zs2z.getZoneName());
                }
                Zset zoneSet = this.getZoneSetFromDB(connection, zs2z.getZoneSetName(), resource, (short)0);
                org.eclipse.aperi.infrastructure.database.objects.Zone zone = this.getZoneFromDB(connection, zs2z.getZoneName(), resource, (short)0);
                if (zoneSet != null && zone != null && this.getZoneSet2ZoneFromDB(connection, zoneSet.getZsetId(), zone.getZoneId()) != null) {
                    try {
                        Zset2zone zset2zone = this.getZoneSet2ZoneFromDB(connection, zoneSet.getZsetId(), zone.getZoneId());
                        Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                        whereclause.put(Zset2zone.getColumnInfo((String)"ZSET_ID"), String.valueOf(zoneSet.getZsetId()));
                        whereclause.put(Zset2zone.getColumnInfo((String)"ZONE_ID"), String.valueOf(zone.getZoneId()));
                        Zset2zone.deletes((DBConnection)connection, whereclause);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneset2zone " + zs2z.getZoneSetName() + " to " + zs2z.getZoneName() + " deleted.");
                        }
                        if (zset2zone != null) {
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZset2zoneTable.getTablename(), new Integer(zset2zone.getZset2zoneId()).toString(), 1, 0);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zset2zone.getZset2zoneId());
                                continue;
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zset2zone.getZset2zoneId() + " due to null eventMonitorProxy");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null zset2zone");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    continue;
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Could not find zoneSet " + zs2z.getZoneSetName() + " or zone " + zs2z.getZoneName() + " in the database, or the association doesn't exist.");
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No zoneSet2zones to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeDeletedZone2AliasAssociationsForActiveCopy(DBConnection connection, Zone2ZoneAlias[] oldDefZone2ZoneAliases, ArrayList newZDefZone2alias, String resource) {
        String methodName = "removeDeletedZone2AliasAssociationsForActiveCopy";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = 0;
        ArrayList<Zone2ZoneAlias> deletedZone2Alias = new ArrayList<Zone2ZoneAlias>();
        for (int i = 0; i < oldDefZone2ZoneAliases.length; ++i) {
            if (newZDefZone2alias.contains(oldDefZone2ZoneAliases[i])) continue;
            deletedZone2Alias.add(oldDefZone2ZoneAliases[i]);
        }
        if (deletedZone2Alias.size() > 0) {
            for (Zone2ZoneAlias z2a : deletedZone2Alias) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting active copy zone2alias " + z2a.getZoneName() + " to " + z2a.getZoneAliasName());
                }
                org.eclipse.aperi.infrastructure.database.objects.Zone zone = this.getZoneFromDB(connection, z2a.getZoneName(), resource, (short)1);
                Alias alias = this.getZoneAliasFromDB(connection, z2a.getZoneAliasName(), resource);
                if (zone != null && alias != null && this.getZone2ZoneAliasFromDB(connection, zone.getZoneId(), alias.getAliasId()) != null) {
                    try {
                        Zone2alias zone2alias = this.getZone2ZoneAliasFromDB(connection, zone.getZoneId(), alias.getAliasId());
                        Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                        whereclause.put(Zone2alias.getColumnInfo((String)"ZONE_ID"), String.valueOf(zone.getZoneId()));
                        whereclause.put(Zone2alias.getColumnInfo((String)"ALIAS_ID"), String.valueOf(alias.getAliasId()));
                        Zone2alias.deletes((DBConnection)connection, whereclause);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zone2alias " + z2a.getZoneName() + " to " + z2a.getZoneAliasName() + " deleted.");
                        }
                        if (zone2alias != null) {
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZone2aliasTable.getTablename(), new Integer(zone2alias.getZone2aliasId()).toString(), 1, 0);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zone2alias.getZone2aliasId());
                                continue;
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zone2alias.getZone2aliasId() + " due to null eventMonitorProxy");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange could not be invoked for " + this.token.getJobId() + " due to null zone2alias");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    continue;
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Could not find zone " + z2a.getZoneName() + " or alias " + z2a.getZoneAliasName() + " in the database, or the association doesn't exist.");
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No zone2aliases to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeDeletedZone2MemberAssociationsForActiveCopy(DBConnection connection, Zone2ZoneMember[] oldDefZone2ZoneMembers, ArrayList newZDefZone2member, String resource) {
        String methodName = "removeDeletedZone2MemberAssociationsForActiveCopy";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = 0;
        ArrayList<Zone2ZoneMember> deletedZone2Member = new ArrayList<Zone2ZoneMember>();
        for (int i = 0; i < oldDefZone2ZoneMembers.length; ++i) {
            if (newZDefZone2member.contains(oldDefZone2ZoneMembers[i])) continue;
            deletedZone2Member.add(oldDefZone2ZoneMembers[i]);
        }
        if (deletedZone2Member.size() > 0) {
            for (Zone2ZoneMember z2m : deletedZone2Member) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting active copy zone2member " + z2m.getZoneName() + " to " + z2m.getZoneMemberName());
                }
                org.eclipse.aperi.infrastructure.database.objects.Zone zone = this.getZoneFromDB(connection, z2m.getZoneName(), resource, (short)1);
                org.eclipse.aperi.infrastructure.database.objects.ZoneMember member = this.getZoneMemberFromDB(connection, z2m.getZoneMemberName(), z2m.getZoneMemberType());
                if (zone != null && member != null && this.getZone2ZoneMemberFromDB(connection, zone.getZoneId(), member.getZoneMemberId()) != null) {
                    try {
                        Zone2member zone2member = this.getZone2ZoneMemberFromDB(connection, zone.getZoneId(), member.getZoneMemberId());
                        Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                        whereclause.put(Zone2member.getColumnInfo((String)"ZONE_ID"), String.valueOf(zone.getZoneId()));
                        whereclause.put(Zone2member.getColumnInfo((String)"ZONE_MEMBER_ID"), String.valueOf(member.getZoneMemberId()));
                        Zone2member.deletes((DBConnection)connection, whereclause);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zone2member " + z2m.getZoneName() + " to " + z2m.getZoneMemberName() + " deleted.");
                        }
                        if (zone2member != null) {
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZone2memberTable.getTablename(), new Integer(zone2member.getZone2memberId()).toString(), 1, 0);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zone2member.getZone2memberId());
                                continue;
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zone2member.getZone2memberId() + " due to null eventMonitorProxy");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null zone2member");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    continue;
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Could not find zone " + z2m.getZoneName() + " or member " + z2m.getZoneMemberName() + " in the database, or the association doesn't exist.");
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No zone2members to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeDeletedZoneSet2ZoneAssociationsForActiveCopy(DBConnection connection, ZoneSet2Zone[] oldDefZoneSet2Zones, ArrayList newZDefZoneSet2zone, String resource) {
        String methodName = "removeDeletedZoneSet2ZoneAssociationsForActiveCopy";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        int rc = 0;
        ArrayList<ZoneSet2Zone> deletedZoneSet2Zone = new ArrayList<ZoneSet2Zone>();
        for (int i = 0; i < oldDefZoneSet2Zones.length; ++i) {
            if (newZDefZoneSet2zone.contains(oldDefZoneSet2Zones[i])) continue;
            deletedZoneSet2Zone.add(oldDefZoneSet2Zones[i]);
        }
        if (deletedZoneSet2Zone.size() > 0) {
            for (ZoneSet2Zone zs2z : deletedZoneSet2Zone) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting active copy zoneset2zone " + zs2z.getZoneSetName() + " to " + zs2z.getZoneName());
                }
                Zset zoneSet = this.getZoneSetFromDB(connection, zs2z.getZoneSetName(), resource, (short)1);
                org.eclipse.aperi.infrastructure.database.objects.Zone zone = this.getZoneFromDB(connection, zs2z.getZoneName(), resource, (short)1);
                if (zoneSet != null && zone != null && this.getZoneSet2ZoneFromDB(connection, zoneSet.getZsetId(), zone.getZoneId()) != null) {
                    try {
                        Zset2zone zset2zone = this.getZoneSet2ZoneFromDB(connection, zoneSet.getZsetId(), zone.getZoneId());
                        Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                        whereclause.put(Zset2zone.getColumnInfo((String)"ZSET_ID"), String.valueOf(zoneSet.getZsetId()));
                        whereclause.put(Zset2zone.getColumnInfo((String)"ZONE_ID"), String.valueOf(zone.getZoneId()));
                        Zset2zone.deletes((DBConnection)connection, whereclause);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneset2zone " + zs2z.getZoneSetName() + " to " + zs2z.getZoneName() + " deleted.");
                        }
                        if (zset2zone != null) {
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZset2zoneTable.getTablename(), new Integer(zset2zone.getZset2zoneId()).toString(), 1, 0);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zset2zone.getZset2zoneId());
                                continue;
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zset2zone.getZset2zoneId() + " due to null eventMonitorProxy");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null zset2zone");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    continue;
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Could not find zoneSet " + zs2z.getZoneSetName() + " or zone " + zs2z.getZoneName() + " in the database, or the association doesn't exist.");
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No zoneSet2zones to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeDeletedZoneMembers(DBConnection connection, ZoneMember[] oldDefMembers, ZoneDefinition newZoneDef) {
        String methodName = "removeDeletedZoneMembers";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Finding deleted members");
        }
        int rc = 0;
        ArrayList<ZoneMember> deletedMembers = new ArrayList<ZoneMember>();
        for (int i = 0; i < oldDefMembers.length; ++i) {
            if (newZoneDef.getZoneMember(oldDefMembers[i].getName(), oldDefMembers[i].getType()) != null) continue;
            deletedMembers.add(oldDefMembers[i]);
        }
        if (deletedMembers.size() > 0) {
            for (ZoneMember member : deletedMembers) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting member " + member.getName());
                }
                try {
                    org.eclipse.aperi.infrastructure.database.objects.ZoneMember zonemember = this.getZoneMemberFromDB(connection, member.getName(), member.getType());
                    Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                    whereclause.put(org.eclipse.aperi.infrastructure.database.objects.ZoneMember.getColumnInfo((String)"MEMBER_NAME"), member.getName());
                    whereclause.put(org.eclipse.aperi.infrastructure.database.objects.ZoneMember.getColumnInfo((String)"TYPE"), String.valueOf(member.getType()));
                    rc = org.eclipse.aperi.infrastructure.database.objects.ZoneMember.deletes((DBConnection)connection, whereclause);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "member " + member.getName() + " deleted.");
                    }
                    if (zonemember != null) {
                        if (ZoneController.getEventMonitorProxy() != null) {
                            ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZoneMemberTable.getTablename(), new Integer(zonemember.getZoneMemberId()).toString(), 1, 0);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zonemember.getZoneMemberId());
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zonemember.getZoneMemberId() + "due to null eventMonitorProxy");
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null zonemember");
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No members to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeDeletedZoneAliases(DBConnection connection, ZoneAlias[] oldDefAliases, ZoneDefinition newZoneDef, String resource) {
        String methodName = "removeDeletedZoneAliases";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Finding deleted aliases");
        }
        int rc = 0;
        ArrayList<ZoneAlias> deletedAliases = new ArrayList<ZoneAlias>();
        for (int i = 0; i < oldDefAliases.length; ++i) {
            if (newZoneDef.getZoneAlias(oldDefAliases[i].getName()) != null) continue;
            deletedAliases.add(oldDefAliases[i]);
        }
        if (deletedAliases.size() > 0) {
            for (ZoneAlias alias : deletedAliases) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting alias " + alias.getName());
                }
                try {
                    Alias aliasFromDB = this.getZoneAliasFromDB(connection, alias.getName(), resource);
                    Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                    whereclause.put(Alias.getColumnInfo((String)"ALIAS_NAME"), alias.getName());
                    whereclause.put(Alias.getColumnInfo((String)"FABRIC_WWN"), resource);
                    rc = Alias.deletes((DBConnection)connection, whereclause);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "alias " + alias.getName() + " deleted.");
                    }
                    if (aliasFromDB != null) {
                        if (ZoneController.getEventMonitorProxy() != null) {
                            ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResAliasTable.getTablename(), new Integer(aliasFromDB.getAliasId()).toString(), 1, 0);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + aliasFromDB.getAliasId());
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + aliasFromDB.getAliasId() + " due to null eventMonitorProxy");
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null aliasFromDB");
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No aliases to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeDeletedZones(DBConnection connection, Zone[] oldDefZones, ZoneDefinition newZoneDef, String resource, short activeFlag) {
        String methodName = "removeDeletedZones";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Finding deleted zones with active=" + activeFlag);
        }
        int rc = 0;
        ArrayList<Zone> deletedZones = new ArrayList<Zone>();
        for (int i = 0; i < oldDefZones.length; ++i) {
            if (newZoneDef.getZone(oldDefZones[i].getName(), oldDefZones[i].getVendorType()) != null) continue;
            deletedZones.add(oldDefZones[i]);
        }
        if (deletedZones.size() > 0) {
            for (Zone zone : deletedZones) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting zone " + zone.getName() + " with active=" + activeFlag);
                }
                try {
                    org.eclipse.aperi.infrastructure.database.objects.Zone zoneFromDB = this.getZoneFromDB(connection, zone.getName(), resource, activeFlag);
                    Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                    whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"ZONE_NAME"), zone.getName());
                    whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"FABRIC_WWN"), resource);
                    whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"ACTIVE"), String.valueOf(activeFlag));
                    rc = org.eclipse.aperi.infrastructure.database.objects.Zone.deletes((DBConnection)connection, whereclause);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zone " + zone.getName() + " with active=" + activeFlag + " deleted.");
                    }
                    if (zoneFromDB != null) {
                        if (ZoneController.getEventMonitorProxy() != null) {
                            ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZoneTable.getTablename(), new Integer(zoneFromDB.getZoneId()).toString(), 1, 0);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zoneFromDB.getZoneId());
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zoneFromDB.getZoneId() + " due to null eventMonitorProxy");
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null zoneFromDB");
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No zones to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeDeletedZoneSets(DBConnection connection, ZoneSet[] oldDefZoneSets, ZoneDefinition newZoneDef, String resource, short activeFlag) {
        String methodName = "removeDeletedZoneSets";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Finding deleted zonesets with active=" + activeFlag);
        }
        int rc = 0;
        ArrayList<ZoneSet> deletedZoneSets = new ArrayList<ZoneSet>();
        for (int i = 0; i < oldDefZoneSets.length; ++i) {
            if (newZoneDef.getZoneSet(oldDefZoneSets[i].getName()) != null) continue;
            deletedZoneSets.add(oldDefZoneSets[i]);
        }
        if (deletedZoneSets.size() > 0) {
            for (ZoneSet zoneSet : deletedZoneSets) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting zoneSet " + zoneSet.getName() + " with active=" + activeFlag);
                }
                try {
                    Zset zonesetFromDB = this.getZoneSetFromDB(connection, zoneSet.getName(), resource, activeFlag);
                    Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                    whereclause.put(Zset.getColumnInfo((String)"ZSET_NAME"), zoneSet.getName());
                    whereclause.put(Zset.getColumnInfo((String)"FABRIC_WWN"), resource);
                    whereclause.put(Zset.getColumnInfo((String)"ACTIVE"), String.valueOf(activeFlag));
                    rc = Zset.deletes((DBConnection)connection, whereclause);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneSet " + zoneSet.getName() + " with active=" + activeFlag + " deleted.");
                    }
                    if (zonesetFromDB != null) {
                        if (ZoneController.getEventMonitorProxy() != null) {
                            ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZsetTable.getTablename(), new Integer(zonesetFromDB.getZsetId()).toString(), 1, 0);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zonesetFromDB.getZsetId());
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zonesetFromDB.getZsetId() + "due to null eventMonitorProxy");
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null zonesetFromDB");
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No zoneSets to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeActiveCopyZonesForDeactivatedZoneSet(DBConnection connection, Zone[] zones, String resource) {
        String methodName = "removeActiveCopyZonesForDeactivatedZoneSet";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting active copy zones of deactivated zoneset");
        }
        short activeFlag = 1;
        int rc = 0;
        ArrayList<Zone> deletedZones = new ArrayList<Zone>();
        for (int i = 0; i < zones.length; ++i) {
            deletedZones.add(zones[i]);
        }
        if (deletedZones.size() > 0) {
            for (Zone zone : deletedZones) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting active copy of zone " + zone.getName());
                }
                try {
                    org.eclipse.aperi.infrastructure.database.objects.Zone zoneFromDB = this.getZoneFromDB(connection, zone.getName(), resource, activeFlag);
                    Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                    whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"ZONE_NAME"), zone.getName());
                    whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"FABRIC_WWN"), resource);
                    whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"ACTIVE"), String.valueOf(activeFlag));
                    rc = org.eclipse.aperi.infrastructure.database.objects.Zone.deletes((DBConnection)connection, whereclause);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zone " + zone.getName() + " deleted.");
                    }
                    if (zoneFromDB != null) {
                        if (ZoneController.getEventMonitorProxy() != null) {
                            ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZoneTable.getTablename(), new Integer(zoneFromDB.getZoneId()).toString(), 1, 0);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zoneFromDB.getZoneId());
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zoneFromDB.getZoneId() + " due to null eventMonitorProxy");
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null zoneFromDB");
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No zones to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    private int removeActiveCopyZoneSetForDeactivatedZoneSet(DBConnection connection, ZoneSet[] activeZoneSets, String resource) {
        String methodName = "removeActiveCopyZoneSetForDeactivatedZoneSet";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting active copy zonesets for active zoneset");
        }
        short activeFlag = 1;
        int rc = 0;
        ArrayList<ZoneSet> deletedZoneSets = new ArrayList<ZoneSet>();
        for (int i = 0; i < activeZoneSets.length; ++i) {
            deletedZoneSets.add(activeZoneSets[i]);
        }
        if (deletedZoneSets.size() > 0) {
            for (ZoneSet zoneSet : deletedZoneSets) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Deleting active copy of zoneSet " + zoneSet.getName());
                }
                try {
                    Zset zonesetFromDB = this.getZoneSetFromDB(connection, zoneSet.getName(), resource, activeFlag);
                    Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                    whereclause.put(Zset.getColumnInfo((String)"ZSET_NAME"), zoneSet.getName());
                    whereclause.put(Zset.getColumnInfo((String)"FABRIC_WWN"), resource);
                    whereclause.put(Zset.getColumnInfo((String)"ACTIVE"), String.valueOf(activeFlag));
                    rc = Zset.deletes((DBConnection)connection, whereclause);
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneSet " + zoneSet.getName() + " deleted.");
                    }
                    if (zonesetFromDB != null) {
                        if (ZoneController.getEventMonitorProxy() != null) {
                            ZoneController.getEventMonitorProxy().handleDeviceStateChange(this.token.getJobId(), TResZsetTable.getTablename(), new Integer(zonesetFromDB.getZsetId()).toString(), 1, 0);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "handleDeviceStateChange invoked for " + this.token.getJobId() + zonesetFromDB.getZsetId());
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + zonesetFromDB.getZsetId() + "due to null eventMonitorProxy");
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "handleDeviceStateChange not invoked for " + this.token.getJobId() + " due to null zonesetFromDB");
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No zoneSets to delete.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewAndUpdateChangedZoneMembers(DBConnection connection, ZoneMember[] newDefMembers, ZoneDefinition oldZoneDef) {
        methodName = "addNewAndUpdateChangedZoneMembers";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new and changed members");
        }
        rc = 0;
        newMembers = new ArrayList<ZoneMember>();
        changedMembers = new ArrayList<ZoneMember>();
        for (i = 0; i < newDefMembers.length; ++i) {
            oldZDefMem = oldZoneDef.getZoneMember(newDefMembers[i].getName(), newDefMembers[i].getType());
            if (oldZDefMem == null) {
                newMembers.add(newDefMembers[i]);
                continue;
            }
            if (oldZDefMem.isIdenticalTo((Object)newDefMembers[i])) continue;
            changedMembers.add(newDefMembers[i]);
        }
        if (newMembers.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newMembers.size());
                for (ZoneMember zm : newMembers) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new member " + zm.getName());
                    }
                    try {
                        if (this.getZoneMemberFromDB(connection, zm.getName(), zm.getType()) == null) {
                            member = new org.eclipse.aperi.infrastructure.database.objects.ZoneMember(autoIdRange++, zm.getName(), zm.getType(), 0, null);
                            member.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZoneMemberTable.getTablename(), new Integer(member.getZoneMemberId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + member.getZoneMemberId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + member.getZoneMemberId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "member " + zm.getName() + " added.");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "member " + zm.getName() + " already exists.");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl55
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new members to add.");
        }
lbl55:
        // 8 sources

        for (ZoneMember zm : changedMembers) {
            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Zone Member " + zm.getName() + " changed, but not processed.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewAndUpdateChangedZoneAliases(DBConnection connection, ZoneAlias[] newDefAliases, ZoneDefinition oldZoneDef, String resource) {
        methodName = "addNewAndUpdateChangedZoneAliases";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new and changed aliases");
        }
        rc = 0;
        newAliases = new ArrayList<ZoneAlias>();
        changedAliases = new ArrayList<ZoneAlias>();
        for (i = 0; i < newDefAliases.length; ++i) {
            oldZDefAlias = oldZoneDef.getZoneAlias(newDefAliases[i].getName());
            if (oldZDefAlias == null) {
                newAliases.add(newDefAliases[i]);
                continue;
            }
            if (oldZDefAlias.isIdenticalTo((Object)newDefAliases[i])) continue;
            changedAliases.add(newDefAliases[i]);
        }
        if (newAliases.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newAliases.size());
                for (ZoneAlias za : newAliases) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new alias " + za.getName());
                    }
                    try {
                        if (this.getZoneAliasFromDB(connection, za.getName(), resource) == null) {
                            alias = new Alias(autoIdRange++, resource, za.getName(), null);
                            alias.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResAliasTable.getTablename(), new Integer(alias.getAliasId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + alias.getAliasId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + alias.getAliasId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "alias " + za.getName() + " added.");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "alias " + za.getName() + " already exists.");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl55
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new aliases to add.");
        }
lbl55:
        // 8 sources

        for (ZoneAlias za : changedAliases) {
            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Zone Alias " + za.getName() + " changed, but not processed.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewAndUpdateChangedZones(DBConnection connection, Zone[] newDefZones, ZoneDefinition oldZoneDef, String resource, short activeFlag) {
        methodName = "addNewAndUpdateChangedZones";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new and changed zones with active=" + activeFlag);
        }
        rc = 0;
        newZones = new ArrayList<Zone>();
        changedZones = new ArrayList<Zone>();
        for (i = 0; i < newDefZones.length; ++i) {
            oldZDefZone = oldZoneDef.getZone(newDefZones[i].getName(), newDefZones[i].getVendorType());
            if (oldZDefZone == null) {
                newZones.add(newDefZones[i]);
                continue;
            }
            if (oldZDefZone.isIdenticalTo((Object)newDefZones[i])) continue;
            changedZones.add(newDefZones[i]);
        }
        if (newZones.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newZones.size());
                for (Zone z : newZones) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new zone " + z.getName() + " with active=" + activeFlag);
                    }
                    try {
                        if (this.getZoneFromDB(connection, z.getName(), resource, activeFlag) == null) {
                            zone = new org.eclipse.aperi.infrastructure.database.objects.Zone(autoIdRange++, resource, z.getType(), activeFlag, z.getName(), z.getSubType(), z.getVendorType(), 0, z.getDescription());
                            zone.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZoneTable.getTablename(), new Integer(zone.getZoneId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + zone.getZoneId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + zone.getZoneId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zone " + z.getName() + " with active=" + activeFlag + " added.");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zone " + z.getName() + " with active=" + activeFlag + " already exists.");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl55
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new zones to add.");
        }
lbl55:
        // 8 sources

        for (Zone z : changedZones) {
            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Zone =" + z.getName() + " with active=" + activeFlag + " changed, but not processed.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewAndUpdateChangedZoneSets(DBConnection connection, ZoneSet[] newDefZoneSets, ZoneDefinition oldZoneDef, String resource, short activeFlag) {
        methodName = "addNewAndUpdateChangedZoneSets";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new and changed zonesets with active=" + activeFlag);
        }
        rc = 0;
        newZoneSets = new ArrayList<ZoneSet>();
        changedZoneSets = new ArrayList<ZoneSet>();
        for (i = 0; i < newDefZoneSets.length; ++i) {
            oldZDefZoneSet = oldZoneDef.getZoneSet(newDefZoneSets[i].getName());
            if (oldZDefZoneSet == null) {
                newZoneSets.add(newDefZoneSets[i]);
                continue;
            }
            if (oldZDefZoneSet.isIdenticalTo((Object)newDefZoneSets[i])) continue;
            changedZoneSets.add(newDefZoneSets[i]);
        }
        if (newZoneSets.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newZoneSets.size());
                for (ZoneSet zs : newZoneSets) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new zoneSet " + zs.getName() + " with active=" + activeFlag);
                    }
                    try {
                        if (this.getZoneSetFromDB(connection, zs.getName(), resource, activeFlag) == null) {
                            zoneSet = new Zset(autoIdRange++, resource, activeFlag, zs.getDescription(), zs.getName());
                            zoneSet.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZsetTable.getTablename(), new Integer(zoneSet.getZsetId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + zoneSet.getZsetId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + zoneSet.getZsetId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zoneSet " + zs.getName() + " with active=" + activeFlag + " added.");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zoneSet " + zs.getName() + " with active=" + activeFlag + " already exists.");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl55
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new zoneSets to add.");
        }
lbl55:
        // 8 sources

        for (ZoneSet zs : changedZoneSets) {
            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "ZoneSet =" + zs.getName() + " with active=" + activeFlag + " changed, but not processed.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addActiveCopyZonesForActivatedZoneSet(DBConnection connection, Zone[] zones, String resource) {
        methodName = "addActiveCopyZonesForActivatedZoneSet";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding active copy zones for newly activated zoneset");
        }
        activeFlag = 1;
        rc = 0;
        newZones = new ArrayList<Zone>();
        for (i = 0; i < zones.length; ++i) {
            newZones.add(zones[i]);
        }
        if (newZones.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newZones.size());
                for (Zone z : newZones) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding active copy of zone " + z.getName());
                    }
                    try {
                        if (this.getZoneFromDB(connection, z.getName(), resource, activeFlag) == null) {
                            zone = new org.eclipse.aperi.infrastructure.database.objects.Zone(autoIdRange++, resource, z.getType(), activeFlag, z.getName(), z.getSubType(), z.getVendorType(), 0, z.getDescription());
                            zone.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZoneTable.getTablename(), new Integer(zone.getZoneId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + zone.getZoneId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + zone.getZoneId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zone " + z.getName() + " added.");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zone " + z.getName() + " already exists.");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl49
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new zones to add.");
        }
lbl49:
        // 6 sources

        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addActiveCopyZoneSetForActivatedZoneSet(DBConnection connection, ZoneSet activeZoneSet, String resource) {
        methodName = "addActiveCopyZoneSetForActivatedZoneSet";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "adding active copy zoneset for active zoneset ");
        }
        activeFlag = 1;
        rc = 0;
        newZoneSets = new ArrayList<ZoneSet>();
        newZoneSets.add(activeZoneSet);
        if (newZoneSets.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newZoneSets.size());
                for (ZoneSet zs : newZoneSets) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding active copy of zoneSet " + zs.getName());
                    }
                    try {
                        if (this.getZoneSetFromDB(connection, zs.getName(), resource, activeFlag) == null) {
                            zoneSet = new Zset(autoIdRange++, resource, activeFlag, zs.getDescription(), zs.getName());
                            zoneSet.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZsetTable.getTablename(), new Integer(zoneSet.getZsetId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + zoneSet.getZsetId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + zoneSet.getZsetId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zoneSet " + zs.getName() + " added.");
                            continue;
                        }
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zoneSet " + zs.getName() + " already exists.");
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl47
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new zoneSets to add.");
        }
lbl47:
        // 6 sources

        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewZone2AliasAssociations(DBConnection connection, Zone2ZoneAlias[] newDefZone2ZoneAliases, ArrayList oldZDefZone2alias, String resource) {
        methodName = "addNewZone2AliasAssociations";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new zone2alias associations");
        }
        rc = 0;
        newZone2Alias = new ArrayList<Zone2ZoneAlias>();
        for (i = 0; i < newDefZone2ZoneAliases.length; ++i) {
            if (oldZDefZone2alias.contains(newDefZone2ZoneAliases[i])) continue;
            newZone2Alias.add(newDefZone2ZoneAliases[i]);
        }
        if (newZone2Alias.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newZone2Alias.size());
                for (Zone2ZoneAlias z2a : newZone2Alias) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new zone2alias " + z2a.getZoneName() + " to " + z2a.getZoneAliasName());
                    }
                    zone = this.getZoneFromDB(connection, z2a.getZoneName(), resource, (short)0);
                    alias = this.getZoneAliasFromDB(connection, z2a.getZoneAliasName(), resource);
                    if (zone != null && alias != null && this.getZone2ZoneAliasFromDB(connection, zone.getZoneId(), alias.getAliasId()) == null) {
                        try {
                            zone2alias = new Zone2alias(autoIdRange++, zone.getZoneId(), alias.getAliasId());
                            zone2alias.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZone2aliasTable.getTablename(), new Integer(zone2alias.getZone2aliasId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + zone2alias.getZone2aliasId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + zone2alias.getZone2aliasId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zone2alias " + z2a.getZoneName() + " to " + z2a.getZoneAliasName() + " added.");
                        }
                        catch (Exception e) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                        }
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Could not find zone " + z2a.getZoneName() + " or member " + z2a.getZoneAliasName() + " in the database, or that association already exists.");
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl51
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new zone2alias to add.");
        }
lbl51:
        // 6 sources

        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewZone2MemberAssociations(DBConnection connection, Zone2ZoneMember[] newDefZone2ZoneMembers, ArrayList oldZDefZone2member, String resource) {
        methodName = "addNewZone2MemberAssociations";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new zone2member associations");
        }
        rc = 0;
        newZone2Member = new ArrayList<Zone2ZoneMember>();
        for (i = 0; i < newDefZone2ZoneMembers.length; ++i) {
            if (oldZDefZone2member.contains(newDefZone2ZoneMembers[i])) continue;
            newZone2Member.add(newDefZone2ZoneMembers[i]);
        }
        if (newZone2Member.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newZone2Member.size());
                for (Zone2ZoneMember z2m : newZone2Member) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new zone2member " + z2m.getZoneName() + " to " + z2m.getZoneMemberName());
                    }
                    zone = this.getZoneFromDB(connection, z2m.getZoneName(), resource, (short)0);
                    member = this.getZoneMemberFromDB(connection, z2m.getZoneMemberName(), z2m.getZoneMemberType());
                    if (zone != null && member != null && this.getZone2ZoneMemberFromDB(connection, zone.getZoneId(), member.getZoneMemberId()) == null) {
                        try {
                            zone2member = new Zone2member(autoIdRange++, member.getZoneMemberId(), zone.getZoneId());
                            zone2member.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZone2memberTable.getTablename(), new Integer(zone2member.getZone2memberId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + zone2member.getZone2memberId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + zone2member.getZone2memberId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zone2member " + z2m.getZoneName() + " to " + z2m.getZoneMemberName() + " added.");
                        }
                        catch (Exception e) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                        }
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Could not find zone " + z2m.getZoneName() + " or member " + z2m.getZoneMemberName() + " in the database, or that association already exists.");
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl51
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new zone2member to add.");
        }
lbl51:
        // 6 sources

        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewZone2AliasAssociationsForActiveZS(DBConnection connection, Zone2ZoneAlias[] newDefZone2ZoneAliases, ArrayList oldZDefZone2alias, String resource) {
        methodName = "addNewZone2AliasAssociationsForActiveZS";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new zone2alias associations");
        }
        rc = 0;
        newZone2Alias = new ArrayList<Zone2ZoneAlias>();
        for (i = 0; i < newDefZone2ZoneAliases.length; ++i) {
            if (oldZDefZone2alias.contains(newDefZone2ZoneAliases[i])) continue;
            newZone2Alias.add(newDefZone2ZoneAliases[i]);
        }
        if (newZone2Alias.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newZone2Alias.size());
                for (Zone2ZoneAlias z2a : newZone2Alias) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new zone2alias " + z2a.getZoneName() + " to " + z2a.getZoneAliasName());
                    }
                    zone = this.getZoneFromDB(connection, z2a.getZoneName(), resource, (short)1);
                    alias = this.getZoneAliasFromDB(connection, z2a.getZoneAliasName(), resource);
                    if (zone != null && alias != null && this.getZone2ZoneAliasFromDB(connection, zone.getZoneId(), alias.getAliasId()) == null) {
                        try {
                            zone2alias = new Zone2alias(autoIdRange++, zone.getZoneId(), alias.getAliasId());
                            zone2alias.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZone2aliasTable.getTablename(), new Integer(zone2alias.getZone2aliasId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + zone2alias.getZone2aliasId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + zone2alias.getZone2aliasId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zone2alias " + z2a.getZoneName() + " to " + z2a.getZoneAliasName() + " added.");
                        }
                        catch (Exception e) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                        }
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Could not find zone " + z2a.getZoneName() + " or member " + z2a.getZoneAliasName() + " in the database, or that association already exists.");
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl51
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new zone2alias to add.");
        }
lbl51:
        // 6 sources

        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewZone2MemberAssociationsForActiveZS(DBConnection connection, Zone2ZoneMember[] newDefZone2ZoneMembers, ArrayList oldZDefZone2member, String resource) {
        methodName = "addNewZone2MemberAssociationsForActiveZS";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new zone2member associations");
        }
        rc = 0;
        newZone2Member = new ArrayList<Zone2ZoneMember>();
        for (i = 0; i < newDefZone2ZoneMembers.length; ++i) {
            if (oldZDefZone2member.contains(newDefZone2ZoneMembers[i])) continue;
            newZone2Member.add(newDefZone2ZoneMembers[i]);
        }
        if (newZone2Member.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newZone2Member.size());
                for (Zone2ZoneMember z2m : newZone2Member) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new zone2member " + z2m.getZoneName() + " to " + z2m.getZoneMemberName());
                    }
                    zone = this.getZoneFromDB(connection, z2m.getZoneName(), resource, (short)1);
                    member = this.getZoneMemberFromDB(connection, z2m.getZoneMemberName(), z2m.getZoneMemberType());
                    if (zone != null && member != null && this.getZone2ZoneMemberFromDB(connection, zone.getZoneId(), member.getZoneMemberId()) == null) {
                        try {
                            zone2member = new Zone2member(autoIdRange++, member.getZoneMemberId(), zone.getZoneId());
                            zone2member.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZone2memberTable.getTablename(), new Integer(zone2member.getZone2memberId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + zone2member.getZone2memberId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + zone2member.getZone2memberId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zone2member " + z2m.getZoneName() + " to " + z2m.getZoneMemberName() + " added.");
                        }
                        catch (Exception e) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                        }
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Could not find zone " + z2m.getZoneName() + " or member " + z2m.getZoneMemberName() + " in the database, or that association already exists.");
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl51
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new zone2member to add.");
        }
lbl51:
        // 6 sources

        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewAlias2MemberAssociations(DBConnection connection, ZoneAlias2ZoneMember[] newDefAlias2ZoneMembers, ArrayList oldZDefAlias2member, String resource) {
        methodName = "addNewAlias2MemberAssociations";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new alias2member associations");
        }
        rc = 0;
        newAlias2Member = new ArrayList<ZoneAlias2ZoneMember>();
        for (i = 0; i < newDefAlias2ZoneMembers.length; ++i) {
            if (oldZDefAlias2member.contains(newDefAlias2ZoneMembers[i])) continue;
            newAlias2Member.add(newDefAlias2ZoneMembers[i]);
        }
        if (newAlias2Member.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newAlias2Member.size());
                for (ZoneAlias2ZoneMember a2m : newAlias2Member) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new alias2member " + a2m.getZoneAliasName() + " to " + a2m.getZoneMemberName());
                    }
                    alias = this.getZoneAliasFromDB(connection, a2m.getZoneAliasName(), resource);
                    member = this.getZoneMemberFromDB(connection, a2m.getZoneMemberName(), a2m.getZoneMemberType());
                    if (alias != null && member != null && this.getZoneAlias2ZoneMemberFromDB(connection, alias.getAliasId(), member.getZoneMemberId()) == null) {
                        try {
                            alias2member = new Alias2member(autoIdRange++, alias.getAliasId(), member.getZoneMemberId());
                            alias2member.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResAlias2memberTable.getTablename(), new Integer(alias2member.getAlias2memberId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + alias2member.getAlias2memberId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + alias2member.getAlias2memberId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "alias2member " + a2m.getZoneAliasName() + " to " + a2m.getZoneMemberName() + " added.");
                        }
                        catch (Exception e) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                        }
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Could not find alias " + a2m.getZoneAliasName() + " or member " + a2m.getZoneMemberName() + " in the database, or that association already exists.");
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl51
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new alias2member to add.");
        }
lbl51:
        // 6 sources

        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewZoneSet2ZoneAssociations(DBConnection connection, ZoneSet2Zone[] newDefZoneSet2Zones, ArrayList oldZDefZoneSet2zone, String resource) {
        methodName = "addNewZoneSet2ZoneAssociations";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new zoneset2zone associations");
        }
        rc = 0;
        newZoneSet2Zone = new ArrayList<ZoneSet2Zone>();
        for (i = 0; i < newDefZoneSet2Zones.length; ++i) {
            if (oldZDefZoneSet2zone.contains(newDefZoneSet2Zones[i])) continue;
            newZoneSet2Zone.add(newDefZoneSet2Zones[i]);
        }
        if (newZoneSet2Zone.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newZoneSet2Zone.size());
                for (ZoneSet2Zone zs2z : newZoneSet2Zone) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new zoneset2zone " + zs2z.getZoneSetName() + " to " + zs2z.getZoneName());
                    }
                    zoneSet = this.getZoneSetFromDB(connection, zs2z.getZoneSetName(), resource, (short)0);
                    zone = this.getZoneFromDB(connection, zs2z.getZoneName(), resource, (short)0);
                    if (zoneSet != null && zone != null && this.getZoneSet2ZoneFromDB(connection, zoneSet.getZsetId(), zone.getZoneId()) == null) {
                        try {
                            zoneSet2zone = new Zset2zone(autoIdRange++, zone.getZoneId(), zoneSet.getZsetId());
                            zoneSet2zone.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZset2zoneTable.getTablename(), new Integer(zoneSet2zone.getZset2zoneId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + zoneSet2zone.getZset2zoneId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + zoneSet2zone.getZset2zoneId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zoneset2zone " + zs2z.getZoneSetName() + " to " + zs2z.getZoneName() + " added.");
                        }
                        catch (Exception e) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                        }
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Could not find zoneset " + zs2z.getZoneSetName() + " or zone " + zs2z.getZoneName() + " in the database, or that association already exists.");
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl51
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new zoneset2zones to add.");
        }
lbl51:
        // 6 sources

        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int addNewZoneSet2ZoneAssociationsForActiveZS(DBConnection connection, ZoneSet2Zone[] newDefZoneSet2Zones, ArrayList oldZDefZoneSet2zone, String resource) {
        methodName = "addNewZoneSet2ZoneAssociationsForActiveZS";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)ZoneController.className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Finding new zoneset2zone associations");
        }
        rc = 0;
        newZoneSet2Zone = new ArrayList<ZoneSet2Zone>();
        for (i = 0; i < newDefZoneSet2Zones.length; ++i) {
            if (oldZDefZoneSet2zone.contains(newDefZoneSet2Zones[i])) continue;
            newZoneSet2Zone.add(newDefZoneSet2Zones[i]);
        }
        if (newZoneSet2Zone.size() > 0) {
            try {
                autoIdRange = AutoIdentifier.getIdentifier((int)1, (int)newZoneSet2Zone.size());
                for (ZoneSet2Zone zs2z : newZoneSet2Zone) {
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Adding new zoneset2zone " + zs2z.getZoneSetName() + " to " + zs2z.getZoneName());
                    }
                    zoneSet = this.getZoneSetFromDB(connection, zs2z.getZoneSetName(), resource, (short)1);
                    zone = this.getZoneFromDB(connection, zs2z.getZoneName(), resource, (short)1);
                    if (zoneSet != null && zone != null && this.getZoneSet2ZoneFromDB(connection, zoneSet.getZsetId(), zone.getZoneId()) == null) {
                        try {
                            zoneSet2zone = new Zset2zone(autoIdRange++, zone.getZoneId(), zoneSet.getZsetId());
                            zoneSet2zone.insert(connection);
                            if (ZoneController.getEventMonitorProxy() != null) {
                                ZoneController.getEventMonitorProxy().handleNewDevice(this.token.getJobId(), TResZset2zoneTable.getTablename(), new Integer(zoneSet2zone.getZset2zoneId()).toString());
                                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "handleNewDevice invoked for " + this.token.getJobId() + zoneSet2zone.getZset2zoneId());
                                }
                            } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, "handleNewDevice not invoked for " + this.token.getJobId() + zoneSet2zone.getZset2zoneId() + " due to null eventMonitorProxy");
                            }
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "zoneset2zone " + zs2z.getZoneSetName() + " to " + zs2z.getZoneName() + " added.");
                        }
                        catch (Exception e) {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
                        }
                        continue;
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) continue;
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "Could not find zoneset " + zs2z.getZoneSetName() + " or zone " + zs2z.getZoneName() + " in the database, or that association already exists.");
                }
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) ** GOTO lbl51
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ZoneController.className, methodName, (Throwable)e);
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ZoneController.className, methodName, "No new zoneset2zones to add.");
        }
lbl51:
        // 6 sources

        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)ZoneController.className, methodName);
        }
        return rc;
    }

    private int updateActiveZoneset(DBConnection connection, ZoneDefinition newZoneDef, String resource) {
        int rc;
        String methodName;
        block16: {
            methodName = "updateActiveZoneset";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            }
            rc = 0;
            ZoneDefinition activeZDefDB = this.getActiveZoneDefFromDB(connection, resource);
            ZoneDefinition activeZDefZDef = this.getActiveZoneDefFromZoneDef(connection, newZoneDef);
            ZoneSet oldDefActiveZoneset = activeZDefDB.getActiveZoneSet();
            ZoneSet newDefActiveZoneset = activeZDefZDef.getActiveZoneSet();
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                if (oldDefActiveZoneset != null) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Old active zoneset = " + oldDefActiveZoneset.getName());
                } else {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "NO Old active zoneset");
                }
                if (newDefActiveZoneset != null) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "New active zoneset = " + newDefActiveZoneset.getName());
                } else {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "NO New active zoneset");
                }
            }
            Zone[] oldDefZones = activeZDefDB.getZones();
            ZoneSet[] oldDefZoneSets = activeZDefDB.getZoneSets();
            ZoneAlias[] oldDefAliases = activeZDefDB.getAliases();
            ZoneMember[] oldDefMembers = activeZDefDB.getMembers();
            Zone[] newDefZones = activeZDefZDef.getZones();
            ZoneSet[] newDefZoneSets = activeZDefZDef.getZoneSets();
            ZoneAlias[] newDefAliases = activeZDefZDef.getAliases();
            ZoneMember[] newDefMembers = activeZDefZDef.getMembers();
            ArrayList oldZDefZoneSet2zone = this.getZoneSet2zone(activeZDefDB, oldDefZoneSets);
            ZoneSet2Zone[] oldDefZoneSet2Zones = new ZoneSet2Zone[oldZDefZoneSet2zone.size()];
            oldDefZoneSet2Zones = oldZDefZoneSet2zone.toArray(new ZoneSet2Zone[0]);
            ArrayList newZDefZoneSet2zone = this.getZoneSet2zone(activeZDefZDef, newDefZoneSets);
            ZoneSet2Zone[] newDefZoneSet2Zones = new ZoneSet2Zone[newZDefZoneSet2zone.size()];
            newDefZoneSet2Zones = newZDefZoneSet2zone.toArray(new ZoneSet2Zone[0]);
            ArrayList oldZDefZone2member = this.getZone2member(activeZDefDB, oldDefZones);
            Zone2ZoneMember[] oldDefZone2ZoneMembers = new Zone2ZoneMember[oldZDefZone2member.size()];
            oldDefZone2ZoneMembers = oldZDefZone2member.toArray(new Zone2ZoneMember[0]);
            ArrayList oldZDefZone2alias = this.getZone2alias(activeZDefDB, oldDefZones);
            Zone2ZoneAlias[] oldDefZone2ZoneAliases = new Zone2ZoneAlias[oldZDefZone2alias.size()];
            oldDefZone2ZoneAliases = oldZDefZone2alias.toArray(new Zone2ZoneAlias[0]);
            ArrayList newZDefZone2member = this.getZone2member(newZoneDef, newDefZones);
            Zone2ZoneMember[] newDefZone2ZoneMembers = new Zone2ZoneMember[newZDefZone2member.size()];
            newDefZone2ZoneMembers = newZDefZone2member.toArray(new Zone2ZoneMember[0]);
            ArrayList newZDefZone2alias = this.getZone2alias(newZoneDef, newDefZones);
            Zone2ZoneAlias[] newDefZone2ZoneAliases = new Zone2ZoneAlias[newZDefZone2alias.size()];
            newDefZone2ZoneAliases = newZDefZone2alias.toArray(new Zone2ZoneAlias[0]);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                int i;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Old Active Zone definition: \n" + activeZDefDB.toString());
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "\nNew Active Zone definition: \n" + activeZDefZDef.toString());
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "\nOld active definition:");
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zones    = " + oldDefZones.length);
                for (i = 0; i < oldDefZones.length; ++i) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefZones[i].getName());
                }
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zoneSets = " + oldDefZoneSets.length);
                for (i = 0; i < oldDefZoneSets.length; ++i) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefZoneSets[i].getName());
                }
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zoneSet2zones  = " + oldDefZoneSet2Zones.length);
                for (i = 0; i < oldDefZoneSet2Zones.length; ++i) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + oldDefZoneSet2Zones[i].getZoneSetName() + " to " + oldDefZoneSet2Zones[i].getZoneName());
                }
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "\nNew active definition:");
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zones    = " + newDefZones.length);
                for (i = 0; i < newDefZones.length; ++i) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefZones[i].getName());
                }
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zoneSets = " + newDefZoneSets.length);
                for (i = 0; i < newDefZoneSets.length; ++i) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefZoneSets[i].getName());
                }
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "  Number of zoneSet2zones  = " + newDefZoneSet2Zones.length);
                for (i = 0; i < newDefZoneSet2Zones.length; ++i) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "    " + newDefZoneSet2Zones[i].getZoneSetName() + " to " + newDefZoneSet2Zones[i].getZoneName());
                }
            }
            try {
                rc = this.removeDeletedZone2AliasAssociationsForActiveCopy(connection, oldDefZone2ZoneAliases, newZDefZone2alias, resource);
                rc = this.removeDeletedZone2MemberAssociationsForActiveCopy(connection, oldDefZone2ZoneMembers, newZDefZone2member, resource);
                rc = this.removeDeletedZoneSet2ZoneAssociationsForActiveCopy(connection, oldDefZoneSet2Zones, newZDefZoneSet2zone, resource);
                rc = this.removeDeletedZones(connection, oldDefZones, activeZDefZDef, resource, (short)1);
                rc = this.removeDeletedZoneSets(connection, oldDefZoneSets, activeZDefZDef, resource, (short)1);
                rc = this.addNewAndUpdateChangedZones(connection, newDefZones, activeZDefDB, resource, (short)1);
                rc = this.addNewAndUpdateChangedZoneSets(connection, newDefZoneSets, activeZDefDB, resource, (short)1);
                rc = this.addNewZoneSet2ZoneAssociationsForActiveZS(connection, newDefZoneSet2Zones, oldZDefZoneSet2zone, resource);
                rc = this.addNewZone2MemberAssociationsForActiveZS(connection, newDefZone2ZoneMembers, oldZDefZone2member, resource);
                rc = this.addNewZone2AliasAssociationsForActiveZS(connection, newDefZone2ZoneAliases, oldZDefZone2alias, resource);
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block16;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ZoneDefinition getActiveZoneDefFromDB(DBConnection connection, String resource) {
        ZoneDefinition activeZdef;
        String methodName;
        block40: {
            block42: {
                Zone.ZoneCursor zc;
                block38: {
                    methodName = "getActiveZoneDefFromDB";
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
                    }
                    activeZdef = new ZoneDefinition();
                    ZoneSet zSet = null;
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Finding the active zoneSet in the database...");
                    }
                    Zset zoneSet = null;
                    Zset.ZsetCursor zsc = null;
                    try {
                        Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                        whereclause.put(Zset.getColumnInfo((String)"FABRIC_WWN"), resource);
                        whereclause.put(Zset.getColumnInfo((String)"ACTIVE"), String.valueOf(1));
                        zsc = Zset.getCursor((DBConnection)connection, whereclause, null);
                        if (zsc.next()) {
                            zoneSet = zsc.getObject();
                            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found active zoneSet " + zoneSet.getZsetName() + " in the database");
                            }
                            zSet = new ZoneSet(zoneSet.getZsetName(), zoneSet.getDescription());
                            activeZdef.addZoneSet(zSet);
                            activeZdef.activateZoneSet(zSet);
                        }
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                        }
                    }
                    finally {
                        block37: {
                            if (zsc != null) {
                                try {
                                    zsc.close();
                                }
                                catch (Exception e) {
                                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block37;
                                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                                }
                            }
                        }
                    }
                    if (zoneSet == null || zSet == null) break block42;
                    if (this.traceLogger != null && this.traceLogger.isLogging()) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Finding the active zones in the database...");
                    }
                    org.eclipse.aperi.infrastructure.database.objects.Zone zone = null;
                    zc = null;
                    Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
                    whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"FABRIC_WWN"), resource);
                    whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"ACTIVE"), String.valueOf(1));
                    zc = org.eclipse.aperi.infrastructure.database.objects.Zone.getCursor((DBConnection)connection, whereclause, null);
                    while (zc.next()) {
                        zone = zc.getObject();
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found active zone " + zone.getZoneName() + " in the database.");
                        }
                        Zone z = new Zone(zone.getZoneName(), zone.getVendorType(), zone.getDescription(), zone.getZoneType(), zone.getZoneSubtype());
                        activeZdef.addZone(zSet, z);
                    }
                    Object var13_18 = null;
                    if (zc == null) break block38;
                    try {
                        zc.close();
                    }
                    catch (Exception e2) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e2);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block38;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                    }
                }
                if (this.traceLogger != null && this.traceLogger.isLogging() && activeZdef.getZones().length == 0) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find any active zones in the database.");
                }
                break block40;
                {
                    catch (Exception e) {
                        block39: {
                            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                            }
                            Object var13_19 = null;
                            if (zc != null) {
                                try {
                                    zc.close();
                                }
                                catch (Exception e2) {
                                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e2);
                                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block39;
                                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                                }
                            }
                        }
                        if (this.traceLogger != null && this.traceLogger.isLogging() && activeZdef.getZones().length == 0) {
                            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find any active zones in the database.");
                        }
                        break block40;
                    }
                }
                catch (Throwable throwable) {
                    block41: {
                        Object var13_20 = null;
                        if (zc != null) {
                            try {
                                zc.close();
                            }
                            catch (Exception e2) {
                                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e2);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block41;
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                            }
                        }
                    }
                    if (this.traceLogger != null && this.traceLogger.isLogging() && activeZdef.getZones().length == 0) {
                        this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find any active zones in the database.");
                    }
                    throw throwable;
                }
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No active zoneSet found in the database.");
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return activeZdef;
    }

    private ZoneDefinition getActiveZoneDefFromZoneDef(DBConnection connection, ZoneDefinition newZoneDef) {
        ZoneSet zSet;
        String methodName = "getActiveZoneDefFromZoneDef";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        ZoneDefinition activeZdef = new ZoneDefinition();
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Finding the active zoneSet in the newZoneDef...");
        }
        if ((zSet = newZoneDef.getActiveZoneSet()) != null) {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found active zoneSet " + zSet.getName() + " in the newZoneDef");
            }
            activeZdef.addZoneSet(zSet);
            activeZdef.activateZoneSet(zSet);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Finding the active zones in the newZoneDef...");
            }
            Zone[] zones = newZoneDef.getZones(zSet);
            for (int z = 0; z < zones.length; ++z) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found active zone " + zones[z].getName() + " in the newZoneDef.");
                }
                activeZdef.addZone(zSet, zones[z]);
            }
            if (this.traceLogger != null && this.traceLogger.isLogging() && activeZdef.getZones().length == 0) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find any active zones in the newZoneDef.");
            }
        } else if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "No active zoneSet found in the newZoneDef.");
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return activeZdef;
    }

    private ArrayList getZone2alias(ZoneDefinition zoneDef, Zone[] zones) {
        String methodName = "getZone2alias";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        ArrayList<Zone2ZoneAlias> zone2alias = new ArrayList<Zone2ZoneAlias>();
        for (int i = 0; i < zones.length; ++i) {
            ZoneAlias[] aliases = zoneDef.getAliases(zones[i]);
            for (int a = 0; a < aliases.length; ++a) {
                Zone2ZoneAlias z2za = new Zone2ZoneAlias(zones[i].getName(), zones[i].getVendorType(), aliases[a].getName());
                zone2alias.add(z2za);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return zone2alias;
    }

    private ArrayList getZone2member(ZoneDefinition zoneDef, Zone[] zones) {
        String methodName = "getZone2member";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        ArrayList<Zone2ZoneMember> zone2member = new ArrayList<Zone2ZoneMember>();
        for (int i = 0; i < zones.length; ++i) {
            ZoneMember[] members = zoneDef.getMembers(zones[i]);
            for (int m = 0; m < members.length; ++m) {
                Zone2ZoneMember z2zm = new Zone2ZoneMember(zones[i].getName(), zones[i].getVendorType(), members[m].getName(), members[m].getType());
                zone2member.add(z2zm);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return zone2member;
    }

    private ArrayList getAlias2member(ZoneDefinition zoneDef, ZoneAlias[] aliases) {
        String methodName = "getAlias2member";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        ArrayList<ZoneAlias2ZoneMember> alias2member = new ArrayList<ZoneAlias2ZoneMember>();
        for (int i = 0; i < aliases.length; ++i) {
            ZoneMember[] members = zoneDef.getMembers(aliases[i]);
            for (int m = 0; m < members.length; ++m) {
                ZoneAlias2ZoneMember za2zm = new ZoneAlias2ZoneMember(aliases[i].getName(), members[m].getName(), members[m].getType());
                alias2member.add(za2zm);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alias2member;
    }

    private ArrayList getZoneSet2zone(ZoneDefinition zoneDef, ZoneSet[] zoneSets) {
        String methodName = "getZoneSet2zone";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        ArrayList<ZoneSet2Zone> zoneSet2zone = new ArrayList<ZoneSet2Zone>();
        for (int i = 0; i < zoneSets.length; ++i) {
            Zone[] zones = zoneDef.getZones(zoneSets[i]);
            for (int z = 0; z < zones.length; ++z) {
                ZoneSet2Zone zs2z = new ZoneSet2Zone(zoneSets[i].getName(), zones[z].getName(), zones[z].getVendorType());
                zoneSet2zone.add(zs2z);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return zoneSet2zone;
    }

    private void setZoneTypesToDefault(ZoneDefinition zdef) {
        String methodName = "setZoneTypesToDefault";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        Zone[] zones = zdef.getZones();
        for (int i = 0; i < zones.length; ++i) {
            zones[i].setSubType(new Integer(0).shortValue());
            zones[i].setType(new Integer(0).shortValue());
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alias getZoneAliasFromDB(DBConnection connection, String name, String resource) {
        String methodName = "getZoneAliasFromDB";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Getting zone alias " + name + " from the database.");
        }
        Alias alias = null;
        Alias.AliasCursor ac = null;
        try {
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(Alias.getColumnInfo((String)"FABRIC_WWN"), resource);
            whereclause.put(Alias.getColumnInfo((String)"ALIAS_NAME"), name);
            ac = Alias.getCursor((DBConnection)connection, whereclause, null);
            if (ac.next()) {
                alias = ac.getObject();
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block19: {
                if (ac != null) {
                    try {
                        ac.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            if (alias != null) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found alias " + name);
            } else {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find alias " + name);
            }
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.eclipse.aperi.infrastructure.database.objects.ZoneMember getZoneMemberFromDB(DBConnection connection, String name, short type) {
        String methodName = "getZoneMemberFromDB";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Getting zone member " + name + " from the database.");
        }
        org.eclipse.aperi.infrastructure.database.objects.ZoneMember member = null;
        ZoneMember.ZoneMemberCursor zmc = null;
        try {
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.ZoneMember.getColumnInfo((String)"MEMBER_NAME"), name);
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.ZoneMember.getColumnInfo((String)"TYPE"), String.valueOf(type));
            zmc = org.eclipse.aperi.infrastructure.database.objects.ZoneMember.getCursor((DBConnection)connection, whereclause, null);
            if (zmc.next()) {
                member = zmc.getObject();
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block19: {
                if (zmc != null) {
                    try {
                        zmc.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            if (member != null) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found member " + name);
            } else {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find member " + name);
            }
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.eclipse.aperi.infrastructure.database.objects.Zone getZoneFromDB(DBConnection connection, String name, String resource, short activeFlag) {
        String methodName = "getZoneFromDB";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Getting zone " + name + " active=" + activeFlag + " from the database.");
        }
        org.eclipse.aperi.infrastructure.database.objects.Zone zone = null;
        Zone.ZoneCursor zc = null;
        try {
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"FABRIC_WWN"), resource);
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"ZONE_NAME"), name);
            whereclause.put(org.eclipse.aperi.infrastructure.database.objects.Zone.getColumnInfo((String)"ACTIVE"), String.valueOf(activeFlag));
            zc = org.eclipse.aperi.infrastructure.database.objects.Zone.getCursor((DBConnection)connection, whereclause, null);
            if (zc.next()) {
                zone = zc.getObject();
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block19: {
                if (zc != null) {
                    try {
                        zc.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            if (zone != null) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found zone " + name + " active=" + activeFlag);
            } else {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find zone " + name + " active=" + activeFlag);
            }
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Zset getZoneSetFromDB(DBConnection connection, String name, String resource, short activeFlag) {
        String methodName = "getZoneSetFromDB";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Getting zoneset " + name + " active=" + activeFlag + " from the database.");
        }
        Zset zoneSet = null;
        Zset.ZsetCursor zsc = null;
        try {
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(Zset.getColumnInfo((String)"FABRIC_WWN"), resource);
            whereclause.put(Zset.getColumnInfo((String)"ZSET_NAME"), name);
            whereclause.put(Zset.getColumnInfo((String)"ACTIVE"), String.valueOf(activeFlag));
            zsc = Zset.getCursor((DBConnection)connection, whereclause, null);
            if (zsc.next()) {
                zoneSet = zsc.getObject();
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block19: {
                if (zsc != null) {
                    try {
                        zsc.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            if (zoneSet != null) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found zoneSet " + name + " active=" + activeFlag);
            } else {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find zoneSet " + name + " active=" + activeFlag);
            }
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return zoneSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Zone2alias getZone2ZoneAliasFromDB(DBConnection connection, int zoneId, int aliasId) {
        String methodName = "getZone2ZoneAliasFromDB";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Getting zone2alias from the database " + zoneId + " " + aliasId);
        }
        Zone2alias zone2alias = null;
        Zone2alias.Zone2aliasCursor z2ac = null;
        try {
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(Zone2alias.getColumnInfo((String)"ZONE_ID"), String.valueOf(zoneId));
            whereclause.put(Zone2alias.getColumnInfo((String)"ALIAS_ID"), String.valueOf(aliasId));
            z2ac = Zone2alias.getCursor((DBConnection)connection, whereclause, null);
            if (z2ac.next()) {
                zone2alias = z2ac.getObject();
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block19: {
                if (z2ac != null) {
                    try {
                        z2ac.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            if (zone2alias != null) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found zone2alias " + zoneId + " " + aliasId);
            } else {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find zone2alias " + zoneId + " " + aliasId);
            }
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return zone2alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Zone2member getZone2ZoneMemberFromDB(DBConnection connection, int zoneId, int memberId) {
        String methodName = "getZone2ZoneMemberFromDB";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Getting zone2member from the database " + zoneId + " " + memberId);
        }
        Zone2member zone2member = null;
        Zone2member.Zone2memberCursor z2mc = null;
        try {
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(Zone2member.getColumnInfo((String)"ZONE_ID"), String.valueOf(zoneId));
            whereclause.put(Zone2member.getColumnInfo((String)"ZONE_MEMBER_ID"), String.valueOf(memberId));
            z2mc = Zone2member.getCursor((DBConnection)connection, whereclause, null);
            if (z2mc.next()) {
                zone2member = z2mc.getObject();
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block19: {
                if (z2mc != null) {
                    try {
                        z2mc.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            if (zone2member != null) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found zone2member " + zoneId + " " + memberId);
            } else {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find zone2member " + zoneId + " " + memberId);
            }
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return zone2member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alias2member getZoneAlias2ZoneMemberFromDB(DBConnection connection, int aliasId, int memberId) {
        String methodName = "getZoneAlias2ZoneMemberFromDB";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Getting alias2member from the database " + aliasId + " " + memberId);
        }
        Alias2member alias2member = null;
        Alias2member.Alias2memberCursor a2mc = null;
        try {
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(Alias2member.getColumnInfo((String)"ALIAS_ID"), String.valueOf(aliasId));
            whereclause.put(Alias2member.getColumnInfo((String)"ZONE_MEMBER_ID"), String.valueOf(memberId));
            a2mc = Alias2member.getCursor((DBConnection)connection, whereclause, null);
            if (a2mc.next()) {
                alias2member = a2mc.getObject();
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block19: {
                if (a2mc != null) {
                    try {
                        a2mc.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            if (alias2member != null) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found alias2member " + aliasId + " " + memberId);
            } else {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find alias2member " + aliasId + " " + memberId);
            }
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return alias2member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Zset2zone getZoneSet2ZoneFromDB(DBConnection connection, int zoneSetId, int zoneId) {
        String methodName = "getZoneSet2ZoneFromDB";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Getting zoneset2zone from the database " + zoneSetId + " " + zoneId);
        }
        Zset2zone zoneSet2zone = null;
        Zset2zone.Zset2zoneCursor zs2zc = null;
        try {
            Hashtable<ColumnInfo, String> whereclause = new Hashtable<ColumnInfo, String>();
            whereclause.put(Zset2zone.getColumnInfo((String)"ZSET_ID"), String.valueOf(zoneSetId));
            whereclause.put(Zset2zone.getColumnInfo((String)"ZONE_ID"), String.valueOf(zoneId));
            zs2zc = Zset2zone.getCursor((DBConnection)connection, whereclause, null);
            if (zs2zc.next()) {
                zoneSet2zone = zs2zc.getObject();
            }
        }
        catch (Exception e) {
            this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        finally {
            block19: {
                if (zs2zc != null) {
                    try {
                        zs2zc.close();
                    }
                    catch (Exception e) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block19;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            if (zoneSet2zone != null) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Found zoneSet2zone " + zoneSetId + " " + zoneId);
            } else {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Did not find zoneSet2zone " + zoneSetId + " " + zoneId);
            }
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return zoneSet2zone;
    }

    private void reDiscoverZoneConfig(String resource) {
        ZoneControlAgent[] agents;
        String methodName = "reDiscoverZoneConfig(resource)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "reDiscover Zone Config for SAN " + resource);
        }
        if ((agents = this.getZoneControllerInfo(resource)).length > 0) {
            for (int i = 0; i < agents.length; ++i) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Invoking zone control scan for SAN resource " + resource + " on target " + agents[i].getTarget());
                }
                agents[i].invokeZoneControlScan();
            }
        } else {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Could not determine zone control agents for SAN " + resource + " so perform probe on the Fabric.");
            }
            Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
            properties.put("FABRICS", new String[0]);
            ServiceUtils.getDiscoveryServiceProxy().discover(Discover.probeFabric, properties);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void reDiscoverZoneConfig(ZoneControlAgent agent) {
        String methodName = "reDiscoverZoneConfig(agent)";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "reDiscover Zone Config for " + agent.getTarget());
        }
        String jobId = agent.invokeZoneControlScan();
        DiscoverUtils.waitForJobToComplete((String)jobId);
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public static IEventMonitorService getEventMonitorProxy() {
        if (eventMonitor == null) {
            eventMonitor = (IEventMonitorService)FabricActivator._serviceHelper.bindLocal("SANEventCorrelatorFactory");
        }
        return eventMonitor;
    }

    public static String printableZoneDefinition(ZoneDefinition definition) {
        StringBuffer output = new StringBuffer();
        output.append("===========================================================");
        ZoneSet[] zsArray = definition.getZoneSets();
        String activeZoneSet = definition.getActiveZoneSet().getName();
        HashSet<String> referencedZones = new HashSet<String>();
        HashSet<String> referencedAliases = new HashSet<String>();
        for (int i = 0; i < zsArray.length; ++i) {
            String zs = zsArray[i].getName();
            if (activeZoneSet != null && zs.equals(activeZoneSet)) {
                output.append("\n\tActive ZoneSet: " + zs + "\n");
            } else {
                output.append("\n\tZoneSet: " + zs + "\n");
            }
            Zone[] zs2zArray = definition.getZones(zsArray[i]);
            for (int j = 0; j < zs2zArray.length; ++j) {
                output.append("\t\tZone: " + zs2zArray[j].getName() + "; " + zs2zArray[j].getVendorType() + "\n");
                referencedZones.add(zs2zArray[j].getName());
                ZoneAlias[] z2zaArray = definition.getAliases(zs2zArray[j]);
                for (int k = 0; k < z2zaArray.length; ++k) {
                    output.append("\t\t\tZoneAlias: " + z2zaArray[k].getName() + "\n");
                    referencedAliases.add(z2zaArray[k].getName());
                    ZoneMember[] za2zmArray = definition.getMembers(z2zaArray[k]);
                    for (int l = 0; l < za2zmArray.length; ++l) {
                        output.append("\t\t\t\tZoneMember: " + za2zmArray[l].getName() + "; " + za2zmArray[l].getType() + "\n");
                    }
                }
                ZoneMember[] z2zmArray = definition.getMembers(zs2zArray[j]);
                for (int k = 0; k < z2zmArray.length; ++k) {
                    output.append("\t\t\tZoneMember: " + z2zmArray[k].getName() + "; " + z2zmArray[k].getType() + "\n");
                }
            }
        }
        Zone[] zArray = definition.getZones();
        for (int i = 0; i < zArray.length; ++i) {
            if (referencedZones.contains(zArray[i])) continue;
            output.append("\n\tZone: " + zArray[i].getName() + "; " + zArray[i].getVendorType() + "\n");
            ZoneAlias[] z2zaArray = definition.getAliases(zArray[i]);
            for (int k = 0; k < z2zaArray.length; ++k) {
                output.append("\t\tZoneAlias: " + z2zaArray[k].getName() + "\n");
                referencedAliases.add(z2zaArray[k].getName());
                ZoneMember[] za2zmArray = definition.getMembers(z2zaArray[k]);
                for (int l = 0; l < za2zmArray.length; ++l) {
                    output.append("\t\t\tZoneMember: " + za2zmArray[l].getName() + "; " + za2zmArray[l].getType() + "\n");
                }
            }
            ZoneMember[] z2zmArray = definition.getMembers(zArray[i]);
            for (int k = 0; k < z2zmArray.length; ++k) {
                output.append("\t\tZoneMember: " + z2zmArray[k].getName() + "; " + z2zmArray[k].getType() + "\n");
            }
        }
        ZoneAlias[] zaArray = definition.getAliases();
        for (int i = 0; i < zaArray.length; ++i) {
            if (referencedAliases.contains(zaArray[i])) continue;
            output.append("\n\tZoneAlias: " + zaArray[i].getName() + "\n");
            ZoneMember[] za2zmArray = definition.getMembers(zaArray[i]);
            for (int l = 0; l < za2zmArray.length; ++l) {
                output.append("\t\tZoneMember: " + za2zmArray[l].getName() + "; " + za2zmArray[l].getType() + "\n");
            }
        }
        output.append("===========================================================\n\n");
        return output.toString();
    }

    protected Class getProxyInterfaceClass() {
        return IZoneControl.class;
    }
}

