/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPScanner;
import org.eclipse.aperi.discovery.snmp.scanner.data.Entity;
import org.eclipse.aperi.discovery.snmp.scanner.data.Parameter;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.MissingUniqueIdException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response;
import org.eclipse.aperi.snmp.SnmpSocketException;

public class CiscoMDSScanner
extends SNMPScanner {
    static ILogger msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.SNMPScanner");
    static ILogger traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.SNMPScanner");
    private static final String className = CiscoMDSScanner.class.getName();
    private static final String SCANNERNAME = "CiscoMDS";
    private int WWNSIZE = 16;
    private static final String OUTBAND_TOPOLOGY_SCANNER = "OutbandCiscoScanner:";
    private String result = new String();
    private Vector sanList = new Vector();
    private Vector portListWwn = new Vector();
    private Vector physicalSwitchList = new Vector();
    private Vector portMembershipList = new Vector();
    private Vector localIeList = new Vector();
    private Vector vsanList = new Vector();
    private Vector ieList = new Vector();
    private Vector portList = new Vector();
    private Vector atpList = new Vector();
    private Vector nodeList = new Vector();
    private Vector attachedNodeList = new Vector();
    private Vector bladeOperStat = new Vector();
    private Vector bladeList = new Vector();
    private Vector avantiNodeList = new Vector();
    private Vector avantiPortList = new Vector();
    private Vector avantiInterfaceList = new Vector();
    private Vector avantiClusterList = new Vector();
    private Hashtable vSanAtpHash = new Hashtable();
    private Hashtable attachedPortHash = new Hashtable();
    private String ipAddress;
    private Vector portTrunkList = new Vector();
    private Vector vsanVector = new Vector();
    private Vector avantiClusterNodeList = new Vector();

    private void setPortTypeValue(Vector plist) {
        String methodName = "setPortTypeValue";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < plist.size(); ++i) {
            Entity pentity = (Entity)plist.elementAt(i);
            for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                int ifIndex;
                Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                if (param.getName().equals("Type")) {
                    String value = param.getValue();
                    if (value.equals("1")) {
                        param.setValue("auto");
                        continue;
                    }
                    if (value.equals("2")) {
                        param.setValue("F_Port");
                        continue;
                    }
                    if (value.equals("3")) {
                        param.setValue("FL_PORT");
                        continue;
                    }
                    if (value.equals("4")) {
                        param.setValue("E_PORT");
                        continue;
                    }
                    if (value.equals("5")) {
                        param.setValue("B_PORT");
                        continue;
                    }
                    if (value.equals("6")) {
                        param.setValue("FX_PORT");
                        continue;
                    }
                    if (value.equals("7")) {
                        param.setValue("SD_PORT");
                        continue;
                    }
                    if (value.equals("8")) {
                        param.setValue("TL_PORT");
                        continue;
                    }
                    if (value.equals("9")) {
                        param.setValue("N_PORT");
                        continue;
                    }
                    if (value.equals("10")) {
                        param.setValue("NL_PORT");
                        continue;
                    }
                    if (value.equals("11")) {
                        param.setValue("NX_PORT");
                        continue;
                    }
                    if (value.equals("12")) {
                        param.setValue("TE_PORT");
                        continue;
                    }
                    if (!value.equals("13")) continue;
                    param.setValue("FV_PORT");
                    continue;
                }
                if (param.getName().equals("State")) {
                    if (param.getValue().equals("1")) {
                        param.setValue("Unknown");
                        continue;
                    }
                    if (param.getValue().equals("2")) {
                        param.setValue("Online");
                        continue;
                    }
                    if (param.getValue().equals("3")) {
                        param.setValue("Offline");
                        continue;
                    }
                    if (param.getValue().equals("4")) {
                        param.setValue("Testing");
                        continue;
                    }
                    if (!param.getValue().equals("5")) continue;
                    param.setValue("Failed");
                    continue;
                }
                if (!param.getName().equals("Physical Port Number") || (ifIndex = Integer.parseInt(param.getValue())) >> 24 != 1) continue;
                int card = (ifIndex >> 19 & 0x1F) + 1;
                int port = (ifIndex >> 12 & 0x7F) + 1;
                if (port < 10) {
                    param.setValue(card + "0" + port);
                    continue;
                }
                param.setValue(new String(card + "" + port));
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setAttachedPortType(Vector plist) {
        String methodName = "setAttachedPortType";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < plist.size(); ++i) {
            Entity pentity = (Entity)plist.elementAt(i);
            for (int k = 0; k < pentity.getParameterList().size(); ++k) {
                Parameter param = (Parameter)pentity.getParameterList().elementAt(k);
                if (!param.getName().equals("Type")) continue;
                String value = param.getValue();
                if (value.equals("0")) {
                    param.setValue("unknown");
                    continue;
                }
                if (value.equals("01")) {
                    param.setValue("N_Port");
                    continue;
                }
                if (value.equals("02")) {
                    param.setValue("NL_PORT");
                    continue;
                }
                if (value.equals("03")) {
                    param.setValue("F/NL_Port");
                    continue;
                }
                if (value.equals("7F")) {
                    param.setValue("Nx_PORT");
                    continue;
                }
                if (value.equals("81")) {
                    param.setValue("F_Port");
                    continue;
                }
                if (value.equals("82")) {
                    param.setValue("FL_PORT");
                    continue;
                }
                if (value.equals("84")) {
                    param.setValue("E_Port");
                    continue;
                }
                if (value.equals("85")) {
                    param.setValue("B_PORT");
                    continue;
                }
                if (value.equals("FF")) {
                    param.setValue("TL_PORT");
                    continue;
                }
                if (value.equals("FE")) {
                    param.setValue("TE_Port");
                    continue;
                }
                if (value.equals("FD")) {
                    param.setValue("SD_PORT");
                    continue;
                }
                if (value.equals("FC")) {
                    param.setValue("FV_Port");
                    continue;
                }
                if (value.equals("FB")) {
                    param.setValue("NV_PORT");
                    continue;
                }
                if (!value.equals("31")) continue;
                param.setValue("Unavailable");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setConnUnitAttributes(Vector ielist) {
        String value = null;
        String str = null;
        int index = 0;
        String[] arrayStr = new String[3];
        String methodName = "setConnUnitAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < ielist.size(); ++i) {
            Entity ieEntity = (Entity)ielist.elementAt(i);
            for (int j = 0; j < ieEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)ieEntity.getParameterList().elementAt(j);
                if (param.getName().equals("Type")) {
                    value = param.getValue();
                    if (value.equals("1")) {
                        param.setValue("Unknown");
                        continue;
                    }
                    if (value.equals("2")) {
                        param.setValue("Other");
                        continue;
                    }
                    if (value.equals("3")) {
                        param.setValue("Switch");
                        continue;
                    }
                    if (value.equals("4")) {
                        param.setValue("Hub");
                        continue;
                    }
                    if (!value.equals("5")) continue;
                    param.setValue("Bridge");
                    continue;
                }
                if (!param.getName().equals("Vendor ID")) continue;
                value = param.getValue().substring(8);
                for (int k = 0; k < 3; ++k) {
                    index = value.indexOf("00");
                    str = value.substring(0, index);
                    arrayStr[k] = CiscoMDSScanner.convertHexStringToAscii(str);
                    str = value.substring(index + 2);
                    value = str.toString();
                }
                if (arrayStr[0] != null) {
                    param.setValue(arrayStr[0]);
                }
                if (arrayStr[1] != null) {
                    ieEntity.addParameter("Model", arrayStr[1]);
                }
                if (arrayStr[2] == null) continue;
                ieEntity.addParameter("Release Code", arrayStr[2]);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public String getMgmtServerHeader(String address, String name, String uniqueId) {
        String methodName = "getMgmtServerHeader";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        String str = new String();
        Entity IEntity = new Entity();
        this.scanId = OUTBAND_TOPOLOGY_SCANNER + uniqueId;
        str = str.concat(IEntity.setDocType(SCANNERNAME));
        str = str.concat(IEntity.setXmlHeader(address, name, this.scanId, "5.0.0"));
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return str;
    }

    private void convertVector2TreeMap(Vector vec, TreeMap hasht, String key) {
        String methodName = "convertVector2TreeMap";
        boolean doNotAdd = false;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < vec.size(); ++i) {
            Entity ieEntity = (Entity)vec.elementAt(i);
            for (int j = 0; j < ieEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)ieEntity.getParameterList().elementAt(j);
                if (!param.getName().equals(key)) continue;
                String value = param.getValue();
                Entity en = (Entity)hasht.get(value);
                if (en != null) {
                    for (int k = 0; k < en.getParameterList().size(); ++k) {
                        String State;
                        Parameter duplicateEn = (Parameter)en.getParameterList().elementAt(k);
                        if (!duplicateEn.getName().equals("State") || !(State = duplicateEn.getValue()).equals("2")) continue;
                        doNotAdd = true;
                        break;
                    }
                }
                if (!doNotAdd) {
                    hasht.put(param.getValue(), ieEntity);
                    continue;
                }
                doNotAdd = false;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private Vector getPortList(Vector Other, Vector Wwn) {
        String methodName = "getPortList";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Vector<Entity> vPort = new Vector<Entity>();
        TreeMap tOther = new TreeMap();
        TreeMap tWwn = new TreeMap();
        this.convertVector2TreeMap(Other, tOther, "WWN");
        this.convertVector2TreeMap(Wwn, tWwn, "WWN");
        for (Object obj : tWwn.keySet()) {
            Entity wwnEntity = (Entity)tWwn.get(obj);
            if (wwnEntity != null) {
                Entity otherEntity = (Entity)tOther.get(obj);
                if (otherEntity == null) {
                    vPort.add(wwnEntity);
                    continue;
                }
                for (int j = 0; j < otherEntity.getParameterList().size(); ++j) {
                    Parameter param = (Parameter)otherEntity.getParameterList().elementAt(j);
                    if (param.getName().equals("WWN")) continue;
                    wwnEntity.addParameter(param.getName(), param.getValue());
                }
                vPort.add(wwnEntity);
                continue;
            }
            if (traceLogger == null || !traceLogger.isLogging()) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Received empty wwnEntity" + Wwn);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return vPort;
    }

    public Response invoke(String scannerName, String[] target) throws SnmpSocketException, UnknownHostException, Exception, MissingUniqueIdException {
        Vector portListOther = new Vector();
        String methodName = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "CiscoInvoke: " + scannerName + " on target = " + target[0] + ", @ " + Calendar.getInstance().getTime());
        }
        this.switchIpAddress = target[0];
        String[] sanParam = new String[]{this.CISCODMPRINCIPALSWITCHWWN};
        String[] vSanParam = new String[]{this.CISCOVSANNAME, this.CISCOVSANOPERSTATE, this.CISCOVSANADMINSTATE};
        String[] mgmtID = new String[]{this.CISCOFCSMGMTADDR, this.CISCOFCSMGMTADDRLISTINDEX};
        String[] physicalSwitchParam = new String[]{this.CISCOFCFEELEMENTNAME, this.SYSNAME, this.SYSLOCATION, this.SYSDESCR, this.SYSCONTACT, this.SYSOBJECTID};
        String[] localSwitchParam = new String[]{this.CISCODMLOCALSWITCHWWN, this.CISCODMDOMAINID, this.CISCODMSTATE};
        String[] vSwitchParm = new String[]{this.CISCOFCSDOMAINID, this.CISCOFCSIETYPE, this.CISCOFCSIELOGICALNAME, this.CISCOFCSIEINFOLIST, this.CISCOFCSMGMTID};
        String[] portParmOther = new String[]{this.CISCOFCSPORTTYPE, this.CISCOFCSPORTSTATE, this.CISCOFCSPHYSICALPORTNUMBER, this.CISCOFCSPORTATTACHPORTNAMEINDEX};
        String[] portParmWwn = new String[]{this.CISCOFCIFWWN};
        String[] attachedPortParm = new String[]{this.CISCOFCSATTACHPORTNAME};
        String[] portMembership = new String[]{this.CISCOVSANIFENTRY};
        String[] trunkOperStatus = new String[]{this.CISCOFCIFTRUNKOPERSTATUS};
        String[] attachedNodeParam = new String[]{this.CISCOFCNSNODENAME, this.CISCOFCNSFABRICPORTNAME, this.CISCOFCNSPORTNAME};
        String[] bladeOperStatusParam = new String[]{this.CEFCMODULEOPERSTATUS};
        String[] bladeParam = new String[]{this.ENTPHYSICALNAME, this.ENTPHYSICALPARENTRELPOS, this.ENTPHYSICALMODELNAME, this.ENTPHYSICALSERIALNUM, this.ENTPHYSICALFIRMWAREREV, this.ENTPHYSICALMFGNAME};
        String[] avantiNodeParam = new String[]{this.CAINTERFACENWWN};
        String[] avantiInterfaceParam = new String[]{this.IFOPERSTATUS, this.IFDESCR};
        String[] avantiPortParam = new String[]{this.CANPORTPWWN, this.CANPORTSTATE};
        String[] avantiClusterParam = new String[]{this.FCNAMESERVERSYMBOLICNODENAME};
        String[] avantiClusterNodeParam = new String[]{this.FCNAMESERVERSYMBOLICNODENAME, this.CISCOFCNSNODENAME};
        Response r = null;
        InetAddress ia = InetAddress.getByName(target[0]);
        String ipaddress = ia.getHostAddress();
        this.setIpAddress(ipaddress);
        this.result = this.getMgmtServerHeader(target[0], scannerName, ipaddress);
        this.setScanType(6);
        if (this.isCiscoMdsSwitch(ipaddress) == 1) {
            this.physicalSwitchList = this.runProcess(target[0], physicalSwitchParam);
            this.sanList = this.runProcess(target[0], sanParam);
            this.vsanList = this.runProcess(target[0], vSanParam);
            this.setVSanId(this.vsanList);
            this.refreshCiscoFcsMib(ipaddress, this.getVsanId(this.vsanList));
            this.localIeList = this.runProcess(target[0], localSwitchParam);
            this.ieList = this.runProcess(target[0], vSwitchParm);
            this.portMembershipList = this.runProcess(target[0], portMembership);
            this.portTrunkList = this.runProcess(target[0], trunkOperStatus);
            portListOther = this.runProcess(target[0], portParmOther);
            this.portListWwn = this.runProcess(target[0], portParmWwn);
            this.atpList = this.runProcess(target[0], attachedPortParm);
            this.attachedNodeList = this.runProcess(target[0], attachedNodeParam);
            this.bladeOperStat = this.runProcess(target[0], bladeOperStatusParam);
            this.bladeList = this.runProcess(target[0], bladeParam);
            this.avantiNodeList = this.runProcess(target[0], avantiNodeParam);
            this.avantiInterfaceList = this.runProcess(target[0], avantiInterfaceParam);
            this.avantiPortList = this.runProcess(target[0], avantiPortParam);
            this.avantiClusterList = this.runProcess(target[0], avantiClusterParam);
            this.avantiClusterNodeList = this.runProcess(target[0], avantiClusterNodeParam);
            this.ProcessPortListOther(portListOther);
            this.createAttachPortIndexMap(portListOther);
            this.portList = this.getPortList(portListOther, this.portListWwn);
            this.removeSuspendedVswitch(this.localIeList);
            String url = "http://" + ipaddress;
            String snmp = "snmp://" + ipaddress;
            this.hardcodeValue(this.vsanList, "PhysicalInfrastructure", "False");
            this.hardcodeValue(this.physicalSwitchList, "Management URL Address", url);
            this.hardcodeValue(this.physicalSwitchList, "Management SNMP Address", snmp);
            this.hardcodeValue(this.physicalSwitchList, "IP Address", ipaddress);
            this.hardcodeValue(this.ieList, "Management URL Address", url);
            this.hardcodeValue(this.ieList, "Management SNMP Address", snmp);
            this.hardcodeValue(this.physicalSwitchList, "Type", "Switch");
            if (this.sanList.isEmpty()) {
                throw new MissingUniqueIdException();
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Physical switch list = " + this.physicalSwitchList + "San List = " + this.sanList + " vsan list = " + this.vsanList + " localIeList = " + this.localIeList + " ie List = " + this.ieList + " port membership list = " + this.portMembershipList + " port list other = " + portListOther + " port list WWN = " + this.portListWwn + " port list = " + this.portList + " Attached port list = " + this.atpList + " Attached node list = " + this.attachedNodeList);
            }
        } else {
            r = new Response(Response.RETURN_CODE_ERROR, "");
            return r;
        }
        this.result.concat(this.topologyXmlGenerator());
        r = this.processXMLDeltaScan(this.scanId, this.result, 0, "MibQueryEngine");
        if (r.getHeader() == null) {
            Header hdr = new Header();
            r.setHeader(hdr);
        }
        r.getHeader().setScannerId(this.scanId);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Cisco MDS XML = " + r);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "CiscoComplete: " + scannerName + " on target = " + target[0] + ", @ " + Calendar.getInstance().getTime());
        }
        return r;
    }

    private void removeSuspendedVswitch(Vector localIeList) {
        String methodName = "removeSuspendedVswitch";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        block0: for (int i = 0; i < localIeList.size(); ++i) {
            Entity en = (Entity)localIeList.elementAt(i);
            for (int j = 0; j < en.getParameterList().size(); ++j) {
                String value;
                Parameter param = (Parameter)en.getParameterList().elementAt(j);
                if (!param.getName().startsWith("State") || !(value = param.getValue()).equals("12")) continue;
                localIeList.remove(i);
                --i;
                continue block0;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private Vector getVsanId(Vector vsanList) {
        Vector<String> vec = new Vector<String>();
        String methodName = "getVsanId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < vsanList.size(); ++i) {
            Entity en = (Entity)vsanList.elementAt(i);
            for (int j = 0; j < en.getParameterList().size(); ++j) {
                Parameter param = (Parameter)en.getParameterList().elementAt(j);
                if (!param.getName().startsWith("VSAN ID")) continue;
                String value = param.getValue();
                vec.addElement(value);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return vec;
    }

    private void ProcessPortListOther(Vector portListOther) {
        String value = null;
        String key = null;
        String methodName = "ProcessPortListOther";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int len = this.CISCOFCSPORTATTACHPORTNAMEINDEX.length();
        for (int i = 0; i < portListOther.size(); ++i) {
            Entity en = (Entity)portListOther.elementAt(i);
            for (int j = 0; j < en.getParameterList().size(); ++j) {
                Parameter param = (Parameter)en.getParameterList().elementAt(j);
                if (!param.getName().startsWith(this.CISCOFCSPORTATTACHPORTNAMEINDEX)) continue;
                value = param.getValue();
                String name = param.getName();
                String subString = name.substring(len + 1);
                int endIndex = subString.indexOf(".");
                key = subString.substring(endIndex + 1);
                en.addParameter("WWN", this.convertDecimalWWNToHexWWN(key));
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setIpAddress(String targetIp) {
        this.ipAddress = targetIp;
    }

    private String getIpAddress() {
        return this.ipAddress;
    }

    private void createAttachPortIndexMap(Vector portListOther) {
        String value = null;
        String key = null;
        String methodName = "createAttachPortIndexMap";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int len = this.CISCOFCSPORTATTACHPORTNAMEINDEX.length();
        for (int i = 0; i < portListOther.size(); ++i) {
            Entity en = (Entity)portListOther.elementAt(i);
            for (int j = 0; j < en.getParameterList().size(); ++j) {
                Parameter param = (Parameter)en.getParameterList().elementAt(j);
                if (!param.getName().startsWith(this.CISCOFCSPORTATTACHPORTNAMEINDEX)) continue;
                value = param.getValue();
                if (!value.equals("0")) {
                    String subString = param.getName().substring(len + 1);
                    int endIndex = subString.indexOf(".");
                    key = subString.substring(0, endIndex);
                    this.vSanAtpHash.put(value, key);
                }
                param.setName("Index");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private String convertport2WWN(String port, Vector portListWwn) {
        boolean found = false;
        String portWwn = null;
        String methodName = "convertport2WWN";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < portListWwn.size(); ++i) {
            Entity en = (Entity)portListWwn.elementAt(i);
            for (int j = 0; j < en.getParameterList().size(); ++j) {
                Parameter param = (Parameter)en.getParameterList().elementAt(j);
                if (param.getName().equals("Physical Port Number")) {
                    if (!param.getValue().equals(port)) continue;
                    found = true;
                    continue;
                }
                if (!param.getName().equals("WWN")) continue;
                portWwn = param.getValue();
            }
            if (!found) continue;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return portWwn;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return null;
    }

    private void hardcodeValue(Vector sanList, String name, String value) {
        String methodName = "hardcodeValue";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < sanList.size(); ++i) {
            ((Entity)sanList.elementAt(i)).addParameter(name, value);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private String getSubstring(String wwn) {
        String methodName = "getSubString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter= " + wwn));
        }
        if (wwn.length() >= this.WWNSIZE && this.isZeroSubstring(wwn)) {
            String newid = wwn.substring(0, 16);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return newid;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return wwn;
    }

    private boolean isZeroSubstring(String wwn) {
        String methodName = "isZeroSubstring";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter= " + wwn));
        }
        String sub = wwn.substring(16, wwn.length());
        boolean flag = true;
        for (int i = 0; i < sub.length(); ++i) {
            if (sub.charAt(i) != '0') {
                flag = false;
                break;
            }
            flag = true;
        }
        if (flag) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return true;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return false;
    }

    private void resetUniqueId(Vector alist) {
        String methodName = "resetUniqueId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < alist.size(); ++i) {
            Entity entity = (Entity)alist.elementAt(i);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Entity's Unique ID Value = " + entity.getUniqueId());
            }
            String newID = this.getSubstring(entity.getUniqueId());
            entity.setUniqueId(newID);
            Vector plist = entity.getParameterList();
            for (int j = 0; j < plist.size(); ++j) {
                String newvalue;
                Parameter param = (Parameter)plist.elementAt(j);
                String value = param.getValue();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Parameter Value = " + value);
                }
                if ((newvalue = this.getSubstring(value)) == null) continue;
                param.setValue(newvalue);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private boolean removedUnidentifiedPorts(Vector sanport) {
        boolean portRemoved = false;
        String methodName = "removedUnidentifiedPorts";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = sanport.size() - 1; i >= 0; --i) {
            Entity ientity = (Entity)sanport.elementAt(i);
            String WWN = ientity.getUniqueId();
            if (!WWN.equals("0000000000000000") && !WWN.equals("                ") && !WWN.equals("")) continue;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Removing unidentified port entity from scan data for target " + this.switchIpAddress + "\n" + ientity.toString());
            }
            sanport.removeElementAt(i);
            portRemoved = true;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return portRemoved;
    }

    private void setPortContainsPortXrefs(Vector portlist, Vector atplist, Hashtable vSanAtpHash) throws Exception {
        int j;
        Entity pEntity;
        int i;
        int value = 0;
        String methodName = "setPortContainsPortXrefs";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (i = 0; i < portlist.size(); ++i) {
            pEntity = (Entity)portlist.elementAt(i);
            for (j = 0; j < pEntity.getParameterList().size(); ++j) {
                if (!pEntity.getParamNameAt(j).equals("Index")) continue;
                value = Integer.parseInt(pEntity.getParamValueAt(j));
                pEntity.getParameterList().remove(j);
                break;
            }
            if (value == 0) continue;
            String newOID = new String(this.CISCOFCSATTACHPORTNAME + "." + value + ".");
            Vector wwn = this.createTrunkConnection(newOID, atplist, vSanAtpHash, this.attachedPortHash);
            Enumeration e = wwn.elements();
            while (e.hasMoreElements()) {
                pEntity.addXrefs(pEntity.getUniqueId(), (String)e.nextElement());
            }
        }
        for (i = 0; i < atplist.size(); ++i) {
            pEntity = (Entity)atplist.elementAt(i);
            j = pEntity.getParameterList().size();
            if (j >= 2) continue;
            atplist.removeElementAt(i);
            --i;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private String topologyXmlGenerator() {
        String methodName;
        block8: {
            methodName = "topologyXmlGenerator: targetIP=" + this.switchIpAddress;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            try {
                int i;
                this.resetUniqueId(this.sanList);
                this.resetUniqueId(this.vsanList);
                this.resetUniqueId(this.ieList);
                this.resetUniqueId(this.portList);
                this.resetUniqueId(this.atpList);
                this.resetUniqueId(this.localIeList);
                this.resetUniqueId(this.portMembershipList);
                this.resetUniqueId(this.physicalSwitchList);
                this.resetUniqueId(this.attachedNodeList);
                this.setAvantiUniqueId(this.bladeOperStat, this.CEFCMODULEOPERSTATUS);
                this.setAvantiUniqueId(this.bladeList, this.ENTPHYSICALNAME);
                this.mergeLists(this.bladeOperStat, this.bladeList);
                this.setAvantiIds(this.bladeOperStat, "Blade");
                this.setAvantiUniqueId(this.avantiNodeList, this.CAINTERFACENWWN);
                this.setAvantiUniqueId(this.avantiInterfaceList, this.IFOPERSTATUS);
                this.mergeLists(this.avantiNodeList, this.avantiInterfaceList);
                this.addNode2PortXref(this.avantiNodeList, this.avantiPortList);
                this.addBlade2NodeXref(this.bladeOperStat, this.avantiNodeList);
                this.setAvantiIds(this.avantiNodeList, "WWN", "FcNode");
                this.addVportToVsan(this.avantiPortList, this.attachedPortHash);
                this.parseAvantiPortParams(this.avantiPortList, this.CANPORTPWWN);
                this.parseAvantiClusterParams(this.avantiClusterList, this.FCNAMESERVERSYMBOLICNODENAME);
                this.addCluster2NodeXref(this.avantiClusterList, this.avantiClusterNodeList);
                this.setAvantiPortStateAndMode(this.avantiPortList);
                this.setAvantiNodeStatus(this.avantiNodeList);
                this.setBladeStatus(this.bladeOperStat);
                boolean portListPortsRemoved = this.removedUnidentifiedPorts(this.portList);
                boolean atpListPortsRemoved = this.removedUnidentifiedPorts(this.atpList);
                if (atpListPortsRemoved || portListPortsRemoved) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "AdvancedTopologyScanner_unidentifiedPortRemoved");
                }
                this.setVSanId(this.localIeList);
                this.setVSanId(this.sanList);
                this.setVsanFabricAttributes(this.sanList, this.vsanList);
                this.generateFabricName(this.sanList);
                this.portMembershipList.addAll(this.portTrunkList);
                this.addVswitch2PortXref(this.localIeList, this.portMembershipList);
                this.replaceDomainIdWithWWN(this.ieList);
                this.removeNonlocalSwitches(this.localIeList, this.ieList);
                this.addXrefVsan2Vswitch(this.vsanList, this.localIeList);
                this.setPortContainsPortXrefs(this.portList, this.atpList, this.vSanAtpHash);
                this.createTrunkConnection(this.CISCOFCSATTACHPORTNAME, this.atpList, this.vSanAtpHash, this.attachedPortHash);
                Vector endDevicePorts = this.FilterSwitchPorts(this.atpList);
                this.hardcodeValue(this.sanList, "Type", "Fabric");
                this.hardcodeValue(this.sanList, "PhysicalInfrastructure", "True");
                this.setConnUnitAttributes(this.ieList);
                this.setPortTypeValue(this.portList);
                this.setAttachedPortType(this.atpList);
                this.setNodeXml(this.attachedNodeList, this.portListWwn);
                Vector mergedNodeList = this.mergeMultiPortNodes(this.attachedNodeList);
                this.removeSuspendedVsans(this.vsanList);
                for (i = 0; i < this.sanList.size(); ++i) {
                    this.iEntity = (Entity)this.sanList.elementAt(i);
                    this.result = this.result.concat(this.iEntity.toXml());
                    this.result = this.result.concat(this.iEntity.toIdXml(new Vector[]{this.vsanList, this.physicalSwitchList, endDevicePorts}));
                }
                this.printVsanXml(this.vsanList, this.attachedPortHash);
                for (i = 0; i < this.physicalSwitchList.size(); ++i) {
                    this.iEntity = (Entity)this.physicalSwitchList.elementAt(i);
                    this.result = this.result.concat(this.iEntity.toXml());
                    this.result = this.result.concat(this.iEntity.toIdXml(new Vector[]{this.ieList, this.bladeOperStat}));
                }
                Vector attachPortList = this.removeDuplicateAttachportEntry(this.atpList);
                this.result = this.result.concat(this.iEntity.composeXml(new Vector[]{this.ieList, this.portList, attachPortList}));
                this.result = this.result.concat(this.iEntity.composeXml(new Vector[]{this.bladeOperStat, this.avantiNodeList, this.avantiPortList, this.avantiClusterList}));
                this.result = this.result.concat(this.iEntity.composeXml(new Vector[]{mergedNodeList}));
                this.result = this.result.concat(this.iEntity.endResultXml(SCANNERNAME));
            }
            catch (Exception e) {
                if (msgLogger != null && msgLogger.isLogging()) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "AdvancedTopologyScanner_TopolgoyXmlGeneratorError");
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.result;
    }

    private void replaceDomainIdWithWWN(Vector ieList) {
        String methodName = "replaceDomainIdWithWWN";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        block0: for (int i = 0; i < ieList.size(); ++i) {
            Entity localEntity = (Entity)ieList.elementAt(i);
            for (int j = 0; j < localEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)localEntity.getParameterList().elementAt(j);
                String name = param.getName();
                if (!name.startsWith(this.CISCOFCSDOMAINID)) continue;
                int len = this.CISCOFCSDOMAINID.length();
                String substr = name.substring(len + 1);
                len = substr.indexOf(".");
                String decWWN = substr.substring(len + 1);
                String hexWWN = this.convertDecimalWWNToHexWWN(decWWN);
                param.setName("Domain");
                localEntity.addParameter("WWN", hexWWN);
                localEntity.setUniqueId(hexWWN);
                continue block0;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private String convertDecimalWWNToHexWWN(String decWWN) {
        StringBuffer hexString = new StringBuffer();
        String methodName = "convertDecimalWWNToHexWWN";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int endIndex = 0;
        int startIndex = 0;
        String searchString = decWWN + ".";
        endIndex = searchString.indexOf(".");
        String substr = searchString.substring(startIndex, endIndex);
        while (endIndex != -1) {
            int integer = Integer.parseInt(substr);
            String str = Integer.toHexString(integer);
            if (str.length() < 2) {
                str = "0" + str;
            }
            hexString.append(str.toUpperCase());
            startIndex = endIndex + 1;
            endIndex = searchString.indexOf(".", startIndex);
            if (endIndex != -1) {
                substr = searchString.substring(startIndex, endIndex);
                continue;
            }
            substr = searchString.substring(startIndex);
        }
        String finalString = hexString.toString();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return finalString;
    }

    private Vector FilterSwitchPorts(Vector atpList) {
        String methodName = "FilterSwitchPorts";
        Vector filteredList = new Vector();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        block0: for (int x = 0; x < atpList.size(); ++x) {
            Entity atpEntity = (Entity)atpList.elementAt(x);
            for (int y = 0; y < atpEntity.getParameterList().size(); ++y) {
                String name = atpEntity.getParamNameAt(y);
                if (!name.equals("Type")) continue;
                String prop = atpEntity.getParamValueAt(y);
                if (prop.equals("84") || prop.equals("FE")) continue block0;
                filteredList.add(atpList.elementAt(x));
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return filteredList;
    }

    private void removeSuspendedVsans(Vector vsanList) {
        String methodName = "removeSuspendedVsans";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        block0: for (int x = 0; x < vsanList.size(); ++x) {
            Entity atpEntity = (Entity)vsanList.elementAt(x);
            for (int y = 0; y < atpEntity.getParameterList().size(); ++y) {
                String prop;
                String name = atpEntity.getParamNameAt(y);
                if (!name.equals("Active") || !(prop = atpEntity.getParamValueAt(y)).equals("False")) continue;
                vsanList.remove(x);
                --x;
                continue block0;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private Vector removeDuplicateAttachportEntry(Vector atpList) {
        Vector<Entity> newList = new Vector<Entity>();
        String methodName = "removeDuplicateAttachportEntry";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int x = 0; x < atpList.size(); ++x) {
            Entity atpEntity = (Entity)atpList.elementAt(x);
            if (newList.contains(atpEntity)) continue;
            newList.addElement(atpEntity);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return newList;
    }

    private Vector createTrunkConnection(String newOID, Vector atplist, Hashtable vSanAtpHash, Hashtable attachedPortHash) {
        Vector<String> wwnList = new Vector<String>();
        String wwn = null;
        String methodName = "createTrunkConnection";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int x = 0; x < atplist.size(); ++x) {
            Entity atpEntity = (Entity)atplist.elementAt(x);
            int esize = atpEntity.getParameterList().size();
            for (int y = 0; y < esize; ++y) {
                int endIndex;
                String subStr;
                String keyIndex;
                String vSanId;
                String name = atpEntity.getParamNameAt(y);
                if (!name.startsWith(newOID)) continue;
                String prop = atpEntity.getParamValueAt(y);
                wwn = prop.substring(0, 16);
                String portType = prop.substring(22);
                atpEntity.addParameter("WWN", wwn);
                atpEntity.addParameter("Type", portType);
                atpEntity.setUniqueId(wwn);
                wwnList.add(wwn);
                if (!portType.equals("84") && !portType.equals("FE") && (vSanId = (String)vSanAtpHash.get(keyIndex = (subStr = name.substring(this.CISCOFCSATTACHPORTNAME.length() + 1)).substring(0, endIndex = subStr.indexOf(".")))) != null) {
                    Vector<String> atpVector = (Vector<String>)attachedPortHash.get(vSanId);
                    if (atpVector == null) {
                        atpVector = new Vector<String>();
                        atpVector.add(wwn);
                    } else if (!atpVector.contains(wwn)) {
                        atpVector.add(wwn);
                    }
                    attachedPortHash.put(vSanId, atpVector);
                }
                atpEntity.getParameterList().remove(0);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return wwnList;
    }

    private void printVsanXml(Vector vsanList, Hashtable vsanHash) {
        String methodName = "printVsanXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < vsanList.size(); ++i) {
            Entity localEntity = (Entity)vsanList.elementAt(i);
            for (int j = 0; j < localEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)localEntity.getParameterList().elementAt(j);
                String name = param.getName();
                if (!name.equals("VSAN ID")) continue;
                Vector attport = (Vector)vsanHash.get(param.getValue());
                this.result = this.result.concat(localEntity.toXml());
                this.result = this.result.concat(localEntity.toIdXml(localEntity));
                this.result = attport != null ? this.result.concat(localEntity.toIdXml(attport, "FcPort")) : this.result.concat(localEntity.endEntityXml());
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private Vector mergeMultiPortNodes(Vector nodelist) throws Exception {
        String methodName = "mergeMultiPortNodes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Vector<Entity> newlist = new Vector<Entity>();
        block0: for (int i = 0; i < nodelist.size(); ++i) {
            Entity ientity = (Entity)nodelist.elementAt(i);
            if (newlist.contains(ientity)) {
                for (int j = 0; j < newlist.size(); ++j) {
                    Entity jentity = (Entity)newlist.elementAt(j);
                    if (!ientity.equals(jentity)) continue;
                    Hashtable iXrefs = ientity.getXrefs();
                    Vector atpList = (Vector)iXrefs.get(ientity.getUniqueId());
                    for (int p = 0; p < atpList.size(); ++p) {
                        jentity.addXrefs(jentity.getUniqueId(), (String)atpList.elementAt(p));
                    }
                    continue block0;
                }
                continue;
            }
            newlist.addElement(ientity);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return newlist;
    }

    private void setNodeXml(Vector attachedNodeList, Vector portListWwn) throws Exception {
        boolean addref = false;
        String portName = null;
        String methodName = "setNodeXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        TreeMap treeWwn = new TreeMap();
        this.convertVector2TreeMap(portListWwn, treeWwn, "WWN");
        for (int i = 0; i < attachedNodeList.size(); ++i) {
            Entity localEntity = (Entity)attachedNodeList.elementAt(i);
            for (int j = 0; j < localEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)localEntity.getParameterList().elementAt(j);
                String name = param.getName();
                if (name.startsWith(this.CISCOFCNSFABRICPORTNAME)) {
                    String fabricPort = param.getValue();
                    if (treeWwn.get(fabricPort) != null) {
                        addref = true;
                        localEntity.getParameterList().remove(j);
                        --j;
                        continue;
                    }
                    attachedNodeList.remove(i);
                    --i;
                    continue;
                }
                if (!name.startsWith(this.CISCOFCNSPORTNAME)) continue;
                portName = param.getValue();
                localEntity.getParameterList().remove(j);
                --j;
            }
            if (!addref) continue;
            localEntity.addXrefs(localEntity.getUniqueId(), portName);
            addref = false;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void addVswitch2PortXref(Vector ieList, Vector portMembershipList) throws Exception {
        Parameter param;
        int j;
        Entity localEntity;
        int i;
        Hashtable hasht = new Hashtable();
        Vector vec = null;
        boolean addEntry = false;
        String vsanId = null;
        String portWWN = null;
        String methodName = "addVswitch2PortXref";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (i = 0; i < portMembershipList.size(); ++i) {
            localEntity = (Entity)portMembershipList.elementAt(i);
            for (j = 0; j < localEntity.getParameterList().size(); ++j) {
                String value;
                int len;
                param = (Parameter)localEntity.getParameterList().elementAt(j);
                String name = param.getName();
                if (name.startsWith(this.CISCOVSANIFENTRY)) {
                    len = this.CISCOVSANIFENTRY.length();
                    value = name.substring(len + 1);
                    portWWN = this.convertport2WWN(value, this.portListWwn);
                    vsanId = param.getValue();
                    addEntry = true;
                } else if (name.startsWith(this.CISCOFCIFTRUNKOPERSTATUS) && param.getValue().equals("1")) {
                    len = this.CISCOFCIFTRUNKOPERSTATUS.length();
                    value = name.substring(len + 1);
                    int index = value.indexOf(".");
                    vsanId = value.substring(index + 1);
                    portWWN = this.convertport2WWN(value.substring(0, index), this.portListWwn);
                    addEntry = true;
                }
                if (!addEntry) continue;
                addEntry = false;
                vec = (Vector)hasht.get(vsanId);
                if (vec == null) {
                    vec = new Vector();
                } else if (vec.contains(portWWN)) continue;
                vec.add(portWWN);
                hasht.put(vsanId, vec);
            }
        }
        for (i = 0; i < ieList.size(); ++i) {
            localEntity = (Entity)ieList.elementAt(i);
            for (j = 0; j < localEntity.getParameterList().size(); ++j) {
                String value;
                param = (Parameter)localEntity.getParameterList().elementAt(j);
                if (!param.getName().equals("VSAN ID") || (vec = (Vector)hasht.get(value = param.getValue())) == null) continue;
                localEntity.addXrefs(localEntity.getUniqueId(), vec);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void addXrefVsan2Vswitch(Vector vsanList, Vector localIeList) throws Exception {
        Parameter param;
        int j;
        Entity localEntity;
        int i;
        Hashtable<String, String> hasht = new Hashtable<String, String>();
        String vsanId = null;
        String Wwn = null;
        String methodName = "addXrefVsan2Vswitch";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (i = 0; i < localIeList.size(); ++i) {
            localEntity = (Entity)localIeList.elementAt(i);
            for (j = 0; j < localEntity.getParameterList().size(); ++j) {
                param = (Parameter)localEntity.getParameterList().elementAt(j);
                if (param.getName().equals("VSAN ID")) {
                    vsanId = param.getValue();
                    continue;
                }
                if (!param.getName().equals("WWN")) continue;
                Wwn = param.getValue();
            }
            hasht.put(vsanId, Wwn);
        }
        block2: for (i = 0; i < vsanList.size(); ++i) {
            localEntity = (Entity)vsanList.elementAt(i);
            for (j = 0; j < localEntity.getParameterList().size(); ++j) {
                param = (Parameter)localEntity.getParameterList().elementAt(j);
                if (!param.getName().equals("VSAN ID")) continue;
                vsanId = param.getValue();
                Wwn = (String)hasht.get(vsanId);
                if (Wwn == null) continue block2;
                localEntity.addXrefs(localEntity.getUniqueId(), Wwn);
                continue block2;
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void removeNonlocalSwitches(Vector localIeList, Vector ieList) throws Exception {
        Object value;
        Entity localEntity;
        int i;
        Hashtable portsRef = new Hashtable();
        Object Wwn = null;
        String methodName = "removeNonlocalSwitches";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (i = 0; i < localIeList.size(); ++i) {
            localEntity = (Entity)localIeList.elementAt(i);
            String key = localEntity.getUniqueId();
            Hashtable hasht = localEntity.getXrefs();
            if (hasht == null) continue;
            value = hasht.get(key);
            if (value != null) {
                portsRef.put(key, value);
                continue;
            }
            portsRef.put(key, new Vector());
        }
        block1: for (i = 0; i < ieList.size(); ++i) {
            localEntity = (Entity)ieList.elementAt(i);
            for (int j = 0; j < localEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)localEntity.getParameterList().elementAt(j);
                if (!param.getName().equals("WWN")) continue;
                value = param.getValue();
                Vector localIeData = (Vector)portsRef.get(value);
                if (localIeData == null) {
                    ieList.remove(i);
                    --i;
                    continue block1;
                }
                if (localIeData.isEmpty()) continue;
                for (int k = 0; k < ((Vector)localIeData.elementAt(0)).size(); ++k) {
                    if ((String)((Vector)localIeData.elementAt(0)).elementAt(k) == null) continue;
                    localEntity.addXrefs(Integer.toString(k), (String)((Vector)localIeData.elementAt(0)).elementAt(k));
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setVSanId(Vector list) {
        int len = 0;
        String methodName = "setVSanId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity localIeEntity = (Entity)list.elementAt(i);
            for (int j = 0; j < localIeEntity.getParameterList().size(); ++j) {
                String substr;
                Parameter param = (Parameter)localIeEntity.getParameterList().elementAt(j);
                String name = param.getName();
                if (name.startsWith(this.CISCODMLOCALSWITCHWWN) || name.startsWith(this.CISCODMPRINCIPALSWITCHWWN)) {
                    len = name.startsWith(this.CISCODMLOCALSWITCHWWN) ? this.CISCODMLOCALSWITCHWWN.length() : this.CISCODMPRINCIPALSWITCHWWN.length();
                    substr = name.substring(len + 1);
                    localIeEntity.addParameter("VSAN ID", substr);
                    param.setName("WWN");
                    continue;
                }
                if (!name.startsWith(this.CISCOVSANNAME)) continue;
                len = this.CISCOVSANNAME.length();
                substr = name.substring(len + 1);
                localIeEntity.addParameter("VSAN ID", substr);
                param.setName("Name");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setVsanFabricAttributes(Vector localIeList, Vector vsanList) {
        String wwn = null;
        String vsanId = null;
        String vsan1WWN = null;
        Hashtable<String, String> hasht = new Hashtable<String, String>();
        String methodName = "setVsanFabricAttributes";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < localIeList.size(); ++i) {
            Entity localIeEntity = (Entity)localIeList.elementAt(i);
            for (int j = 0; j < localIeEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)localIeEntity.getParameterList().elementAt(j);
                String name = param.getName();
                if (name.equals("WWN")) {
                    wwn = param.getValue();
                    continue;
                }
                if (!name.equals("VSAN ID")) continue;
                vsanId = param.getValue();
            }
            if (vsanId.equals("1")) {
                vsan1WWN = wwn;
            }
            hasht.put(vsanId, wwn);
        }
        for (int x = 0; x < vsanList.size(); ++x) {
            Entity vsanEntity = (Entity)vsanList.elementAt(x);
            for (int y = 0; y < vsanEntity.getParameterList().size(); ++y) {
                String value;
                Parameter vsanParam = (Parameter)vsanEntity.getParameterList().elementAt(y);
                if (vsanParam.getName().equals("VSAN ID")) {
                    vsanId = vsanParam.getValue();
                    if (vsanId.equals("4094")) {
                        String wwn4094 = "7000000000000000";
                        vsanEntity.setUniqueId(wwn4094);
                        vsanEntity.addParameter("WWN", wwn4094);
                        continue;
                    }
                    wwn = (String)hasht.get(vsanId);
                    if (wwn == null) continue;
                    vsanEntity.addParameter("WWN", wwn);
                    vsanEntity.setUniqueId(wwn);
                    continue;
                }
                if (vsanParam.getName().equals("State")) {
                    value = vsanParam.getValue();
                    if (value.equals("1")) {
                        vsanParam.setValue("Up");
                        continue;
                    }
                    if (!value.equals("2")) continue;
                    vsanParam.setValue("Down");
                    continue;
                }
                if (!vsanParam.getName().equals("Active")) continue;
                value = vsanParam.getValue();
                if (value.equals("1")) {
                    vsanParam.setValue("True");
                    continue;
                }
                if (!value.equals("2")) continue;
                vsanParam.setValue("False");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void generateFabricName(Vector sanList) {
        String methodName = "generateFabricName";
        Vector<String> addressList = new Vector<String>();
        Vector addrListIndex = new Vector();
        Vector mgmtAddrList = new Vector();
        Vector switchWWN = new Vector();
        Vector switchWWNList = new Vector();
        TreeMap switchWWNMap = new TreeMap();
        boolean found = false;
        String swAddress = this.getIpAddress();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "ENTERED: Enter generateFabricName for switch " + swAddress + ", @ " + Calendar.getInstance().getTime());
        }
        addressList.add(swAddress);
        this.queryRetryCount = 0;
        for (int i = 0; i < addressList.size(); ++i) {
            String address;
            block29: {
                block28: {
                    block27: {
                        address = (String)addressList.get(i);
                        try {
                            SNMPConfig.setRetries(address, 1);
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "START: Getting Management Address list index for " + address + ", @ " + Calendar.getInstance().getTime());
                            }
                            addrListIndex = this.runProcess(address, new String[]{this.CISCOFCSMGMTADDRLISTINDEX});
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "COMPLETED: Getting Management Address list index for " + address + ", @ " + Calendar.getInstance().getTime());
                            }
                        }
                        catch (Exception e) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block27;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Warning: " + e.getMessage());
                        }
                    }
                    if (addrListIndex.isEmpty()) {
                        if (traceLogger == null || !traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Failed to get management address list index of switch " + address);
                        continue;
                    }
                    try {
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "START: Getting Management Addresses of attached devices to switch " + address + ", @ " + Calendar.getInstance().getTime());
                        }
                        mgmtAddrList = this.runProcess(address, new String[]{this.CISCOFCSMGMTADDR});
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "COMPLETED: Getting Management Addresses of attached devices to switch " + address + ", @ " + Calendar.getInstance().getTime());
                        }
                    }
                    catch (Exception e) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block28;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Warning: " + e.getMessage());
                    }
                }
                if (mgmtAddrList.isEmpty()) {
                    if (traceLogger == null || !traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Failed to get management addresses of devices connected to switch " + address);
                    continue;
                }
                try {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "START: Getting Physical Switch WWN for switch connected to " + address + ", @ " + Calendar.getInstance().getTime());
                    }
                    switchWWN = this.runProcess(address, new String[]{this.CISCOFCFEELEMENTNAME});
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "COMPLETED: Getting Physical Switch WWN for switch connected to " + address + ", @ " + Calendar.getInstance().getTime());
                    }
                }
                catch (Exception e) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block29;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Warning: " + e.getMessage());
                }
            }
            if (switchWWN.isEmpty()) {
                if (traceLogger == null || !traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Failed to get physical switch WWN of switch " + address);
                continue;
            }
            switchWWNList.addElement(switchWWN.elementAt(0));
            block7: for (int j = 0; j < addrListIndex.size(); ++j) {
                Entity indexEntity = (Entity)addrListIndex.get(j);
                String index = indexEntity.getParamValueAt(0);
                if (index == null) continue;
                String newOID = this.CISCOFCSMGMTADDR + "." + index + ".1";
                for (int k = 0; k < mgmtAddrList.size(); ++k) {
                    Entity mgmtEntity = (Entity)mgmtAddrList.elementAt(k);
                    for (int l = 0; l < mgmtEntity.getParameterList().size(); ++l) {
                        Parameter param = (Parameter)mgmtEntity.getParameterList().elementAt(l);
                        if (!param.getName().equals(newOID)) continue;
                        String mgmtString = param.getValue();
                        int startIndex = mgmtString.indexOf("//");
                        if (startIndex == -1) {
                            if (traceLogger == null || !traceLogger.isLogging()) continue;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Bad management address : + " + mgmtString);
                            continue;
                        }
                        int endIndex = mgmtString.indexOf("/", startIndex += 2);
                        if (endIndex == -1) {
                            if (traceLogger == null || !traceLogger.isLogging()) continue;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Bad management address : + " + mgmtString);
                            continue;
                        }
                        String substr = mgmtString.substring(startIndex, endIndex);
                        if (substr != null && !addressList.contains(substr)) {
                            addressList.add(substr);
                        }
                        mgmtAddrList.remove(k);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    found = false;
                    continue block7;
                }
            }
        }
        this.convertVector2TreeMap(switchWWNList, switchWWNMap, "WWN");
        String fabricName = "3" + ((String)switchWWNMap.firstKey()).substring(1);
        sanList.removeAllElements();
        if (fabricName != null) {
            Entity sanEntity = new Entity();
            sanEntity.addParameter("Name", fabricName);
            sanEntity.setUniqueId(fabricName);
            sanEntity.setName("San");
            sanList.add(sanEntity);
        } else if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Could not find VSAN 1.");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "EXIT: Exited generateFabricName for switch " + swAddress + ", @ " + Calendar.getInstance().getTime());
        }
        this.queryRetryCount = 2;
    }

    public String getScannerHeader(String scannerName, String targetIp) {
        String ipaddress = null;
        String result = null;
        String methodName = "getScannerHeader";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        try {
            InetAddress ia = InetAddress.getByName(targetIp);
            ipaddress = ia.getHostAddress();
            result = this.getMgmtServerHeader(targetIp, scannerName, ipaddress);
            result = result.concat("</CiscoMDSXml>");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public Response getScannerHeaderResponse(int errorCode, String scannerName, String targetIp) {
        String ipaddress = null;
        String result = null;
        String methodName = "getScannerHeaderResponse";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        try {
            InetAddress ia = InetAddress.getByName(targetIp);
            ipaddress = ia.getHostAddress();
            result = this.getMgmtServerHeader(targetIp, scannerName, ipaddress);
            result = result.concat("</CiscoMDSXml>");
        }
        catch (Exception e) {
            // empty catch block
        }
        Response r = this.processXMLDeltaScan(this.scanId, result, errorCode, "MibQueryEngine");
        if (r.getHeader() == null) {
            Header hdr = new Header();
            r.setHeader(hdr);
        }
        r.getHeader().setScannerId(this.scanId);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return r;
    }

    private Vector runProcess(String ipaddress, String[] alist) throws SnmpSocketException, UnknownHostException, Exception {
        String methodName = "runProcess";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        Vector result = new Vector();
        boolean isContacted = false;
        int attempts = this.queryRetryCount + 1;
        for (int i = 0; i < attempts; ++i) {
            result = this.runSnmpQuery(ipaddress, alist);
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "--------> AdvTop:: runProcess: " + ipaddress + " counter =" + i);
            }
            if (this.ERROR_FLAG) continue;
            isContacted = true;
            break;
        }
        if (!isContacted) {
            throw new Exception("Unable to contact the host " + ipaddress + " after " + attempts + " attempts!");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    private String parseOIDInstance(String instance, String oid) {
        String result = null;
        String methodName = "parseOIDString";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (instance != null && oid != null) {
            int oidlen = oid.length();
            int instancelen = instance.length();
            if (instance.startsWith(oid) && instancelen > oidlen) {
                int endIndex = instance.indexOf(".", oidlen + 1);
                result = endIndex != -1 ? instance.substring(oidlen + 1, endIndex) : instance.substring(oidlen + 1);
            }
        } else if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " One or more input parameters to this method may be null");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    private void setAvantiUniqueId(Vector list, String oid) {
        String uniqueId = null;
        String methodName = "setAvantiUniqueId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity localEntity = (Entity)list.elementAt(i);
            String name = localEntity.getName();
            if (name != null) {
                uniqueId = this.parseOIDInstance(name, oid);
                if (uniqueId != null) {
                    localEntity.setUniqueId(uniqueId);
                    continue;
                }
                localEntity.setUniqueId("");
                continue;
            }
            if (traceLogger == null || !traceLogger.isLogging()) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Entity name is null");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setAvantiIds(Vector list, String param, String name) {
        String uniqueId = null;
        String methodName = "setAvantiIds";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity localEntity = (Entity)list.elementAt(i);
            if (localEntity != null) {
                for (int j = 0; j < localEntity.getParameterList().size(); ++j) {
                    String paramName = localEntity.getParamNameAt(j);
                    if (paramName == null || !paramName.startsWith(param)) continue;
                    uniqueId = localEntity.getParamValueAt(j);
                    if (uniqueId != null) {
                        localEntity.setUniqueId(uniqueId);
                        break;
                    }
                    if (traceLogger == null || !traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " param value is null");
                }
                localEntity.setName(name);
                continue;
            }
            if (traceLogger == null || !traceLogger.isLogging()) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Entity object is null");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void mergeLists(Vector toList, Vector fromList) {
        TreeMap fromTree;
        String methodName = "mergeLists";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((fromTree = this.convertVector2TreeMap(fromList)) != null) {
            for (int x = 0; x < toList.size(); ++x) {
                Entity toEntity = (Entity)toList.elementAt(x);
                String key = toEntity.getUniqueId();
                Entity fromEntity = (Entity)fromTree.get(key);
                if (fromEntity != null) {
                    for (int i = 0; i < fromEntity.getParameterList().size(); ++i) {
                        String name = fromEntity.getParamNameAt(i);
                        if (name.startsWith("Name")) {
                            toEntity.addParameter("Type", fromEntity.getParamValueAt(i));
                            continue;
                        }
                        toEntity.addParameter(name, fromEntity.getParamValueAt(i));
                    }
                    continue;
                }
                if (traceLogger == null || !traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Entity list is null");
            }
        } else if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Entity tree is null");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void getAvantiOIDNames(Vector list) {
        String methodName = "getAvantiOIDNames";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
    }

    private TreeMap convertVector2TreeMap(Vector vec) {
        String methodName = "convertVector2TreeMap";
        TreeMap<String, Entity> hasht = new TreeMap<String, Entity>();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < vec.size(); ++i) {
            Entity ieEntity = (Entity)vec.elementAt(i);
            String key = ieEntity.getUniqueId();
            hasht.put(key, ieEntity);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return hasht;
    }

    private void setAvantiIds(Vector list, String name) {
        String methodName = "setAvantiIds";
        String serialNumber = null;
        String vendor = null;
        String paramName = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity ent = (Entity)list.elementAt(i);
            if (ent != null) {
                for (int j = 0; j < ent.getParameterList().size(); ++j) {
                    paramName = ent.getParamNameAt(j);
                    if (paramName != null && paramName.equals("Vendor")) {
                        vendor = ent.getParamValueAt(j);
                    } else if (paramName != null && paramName.equals("Serial Number")) {
                        serialNumber = ent.getParamValueAt(j);
                    }
                    if (serialNumber != null && vendor != null) break;
                }
                if (serialNumber == null || vendor == null || serialNumber.length() == 0 || vendor.length() == 0) {
                    list.remove(i);
                    --i;
                } else {
                    ent.setName(name);
                    String uniqueId = vendor + ":" + serialNumber;
                    ent.setUniqueId(uniqueId);
                }
            } else if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Entity object is null");
            }
            paramName = null;
            vendor = null;
            serialNumber = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void addBlade2NodeXref(Vector bladeOperStat, Vector avantiNodeList) {
        String methodName = "addBlade2NodeXref";
        TreeMap bladeMap = new TreeMap();
        TreeMap<String, Vector<String>> nodeMap = new TreeMap<String, Vector<String>>();
        Vector<String> vec = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.convertVector2TreeMap(bladeOperStat, bladeMap, "Slot");
        this.getSlotFromIfIndex(avantiNodeList);
        for (int i = 0; i < avantiNodeList.size(); ++i) {
            Entity nodeEntity = (Entity)avantiNodeList.elementAt(i);
            if (nodeEntity != null) {
                String key = nodeEntity.getUniqueId();
                if (key != null) {
                    for (int j = 0; j < nodeEntity.getParameterList().size(); ++j) {
                        String name = nodeEntity.getParamNameAt(j);
                        if (name == null || !name.equals("WWN")) continue;
                        String value = nodeEntity.getParamValueAt(j);
                        if (nodeMap.containsKey(key) && value != null) {
                            vec = (Vector<String>)nodeMap.get(key);
                            nodeMap.remove(key);
                        } else if (!nodeMap.containsKey(key) && value != null) {
                            vec = new Vector<String>();
                        }
                        if (vec != null) {
                            vec.add(value);
                            nodeMap.put(key, vec);
                            continue;
                        }
                        if (traceLogger == null || !traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Map value is null");
                    }
                    continue;
                }
                if (traceLogger == null || !traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Key is null");
                continue;
            }
            if (traceLogger == null || !traceLogger.isLogging()) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Entity is null");
        }
        while (!nodeMap.isEmpty()) {
            String nodeKey = (String)nodeMap.firstKey();
            if (nodeKey != null) {
                Entity bladeEntity = (Entity)bladeMap.get(nodeKey);
                if (bladeEntity != null) {
                    Vector nodeValue = (Vector)nodeMap.get(nodeKey);
                    if (nodeValue != null) {
                        try {
                            bladeEntity.addXrefs(nodeKey, nodeValue);
                        }
                        catch (Exception e) {
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Failed to add blade to node Cross reference for " + nodeKey + " --> " + nodeValue);
                            }
                        }
                    } else if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " nodeValue is null");
                    }
                } else if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " bladeEntity is null");
                }
                nodeMap.remove(nodeKey);
                continue;
            }
            if (traceLogger == null || !traceLogger.isLogging()) break;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " nodeKey is null");
            break;
        }
        this.convertMap2List(bladeMap, bladeOperStat);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void convertMap2List(TreeMap bladeMap, Vector bladeOperStat) {
        String methodName = "convertMap2List";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        bladeOperStat.removeAllElements();
        while (!bladeMap.isEmpty()) {
            String key = (String)bladeMap.firstKey();
            if (key != null) {
                Entity ent = (Entity)bladeMap.get(key);
                if (ent != null) {
                    bladeOperStat.add(ent);
                } else if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " entity is null");
                }
                bladeMap.remove(key);
                continue;
            }
            if (traceLogger == null || !traceLogger.isLogging()) break;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Key is null");
            break;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void getSlotFromIfIndex(Vector avantiNodeList) {
        String methodName = "getSlotFromIfIndex";
        int card = 0;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < avantiNodeList.size(); ++i) {
            Entity localEntity = (Entity)avantiNodeList.elementAt(i);
            String name = localEntity.getUniqueId();
            if (name != null) {
                int ifIndex = Integer.parseInt(name);
                if (ifIndex >> 24 == 12) {
                    card = (ifIndex >> 19 & 0x1F) + 1;
                    int n = (ifIndex >> 12 & 0x7F) + 1;
                }
                localEntity.setUniqueId(Integer.toString(card));
                continue;
            }
            if (traceLogger == null || !traceLogger.isLogging()) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Entity name is null");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void parseAvantiPortParams(Vector avantiPortList, String oid) {
        String methodName = "parseAvantiPortParams";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < avantiPortList.size(); ++i) {
            int endIndex;
            int startIndex;
            String mode_vsanid;
            String subString;
            Entity ent = (Entity)avantiPortList.elementAt(i);
            if (ent == null) continue;
            String name = ent.getName();
            if (name != null && name.startsWith(oid) && (subString = name.substring(oid.length() + 1)) != null && (mode_vsanid = subString.substring(startIndex = subString.indexOf(".") + 1)) != null && (endIndex = mode_vsanid.indexOf(".") + 1) > 1) {
                String mode = mode_vsanid.substring(0, endIndex - 1);
                String vsan_id = mode_vsanid.substring(endIndex);
                if (mode != null) {
                    ent.addParameter("Mode", mode);
                }
                if (vsan_id != null && !this.vsanVector.contains(vsan_id) && mode.startsWith("3")) {
                    this.vsanVector.add(vsan_id);
                }
            }
            ent.setName("FcPort");
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void parseAvantiClusterParams(Vector avantiClusterList, String oid) {
        String methodName = "parseAvantiClusterParams";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < avantiClusterList.size(); ++i) {
            String vsanID;
            int endIndex;
            String vsanIdPlus;
            String name;
            Entity ent = (Entity)avantiClusterList.elementAt(i);
            if (ent != null && (name = ent.getName()) != null && name.startsWith(oid) && (vsanIdPlus = name.substring(oid.length() + 1)) != null && (endIndex = vsanIdPlus.indexOf(".")) >= 0 && (vsanID = vsanIdPlus.substring(0, endIndex)) != null && this.vsanVector.contains(vsanID)) {
                int index;
                String param;
                this.vsanVector.remove(vsanID);
                String paramHex = ent.getParamValueAt(0);
                ent.getParameterList().remove(0);
                if (paramHex != null && paramHex.length() > 0 && (param = CiscoMDSScanner.convertHexStringToAscii(paramHex)) != null && (index = param.indexOf(":")) >= 0) {
                    String clusterID = param.substring(0, index);
                    String clusterNamePlus = param.substring(index + 1);
                    String clusterName = null;
                    if (clusterID != null && clusterNamePlus != null) {
                        index = clusterNamePlus.indexOf(":");
                        clusterName = index < 1 ? clusterNamePlus : clusterNamePlus.substring(0, index - 1);
                        ent.addParameter("ID", clusterID);
                        if (clusterName != null) {
                            ent.addParameter("Name", clusterName);
                        }
                        ent.setName("Cluster");
                        ent.setUniqueId(clusterID);
                        continue;
                    }
                }
            }
            avantiClusterList.remove(i);
            --i;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void addNode2PortXref(Vector avantiNodeList, Vector avantiPortList) {
        String methodName = "addNode2PortXref";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < avantiNodeList.size(); ++i) {
            String ifIndex;
            Entity nodeEntity = (Entity)avantiNodeList.elementAt(i);
            if (nodeEntity == null || (ifIndex = nodeEntity.getUniqueId()) == null) continue;
            for (int j = 0; j < avantiPortList.size(); ++j) {
                String portWwn;
                String name;
                Entity portEntity = (Entity)avantiPortList.elementAt(j);
                if (portEntity == null || (name = portEntity.getName()) == null || name.indexOf(ifIndex) == -1 || (portWwn = portEntity.getUniqueId()) == null) continue;
                try {
                    nodeEntity.addXrefs(ifIndex, portWwn);
                    continue;
                }
                catch (Exception e) {
                    if (traceLogger == null || !traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Failed to create node to port relationship.");
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void addCluster2NodeXref(Vector avantiClusterList, Vector avantiClusterNodeList) {
        String methodName = "addCluster2NodeXref";
        String clusterAsciiId = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < avantiClusterList.size(); ++i) {
            String clusterUniqueId;
            Entity clusterEntity = (Entity)avantiClusterList.elementAt(i);
            if (clusterEntity == null || (clusterUniqueId = clusterEntity.getUniqueId()) == null) continue;
            block3: for (int j = 0; j < avantiClusterNodeList.size(); ++j) {
                int clusterNameIndex;
                int clusterIdIndex;
                String asciiNodeUniqueId;
                String nodeUniqueId;
                Entity nodeEntity = (Entity)avantiClusterNodeList.elementAt(j);
                if (nodeEntity == null || (nodeUniqueId = nodeEntity.getUniqueId()) == null || nodeUniqueId.length() <= 1 || (asciiNodeUniqueId = CiscoMDSScanner.convertHexStringToAscii(nodeUniqueId)) == null || (clusterIdIndex = asciiNodeUniqueId.indexOf(":")) == -1 || (clusterAsciiId = (clusterNameIndex = asciiNodeUniqueId.indexOf(":", clusterIdIndex + 1)) != -1 ? asciiNodeUniqueId.substring(0, clusterNameIndex) : asciiNodeUniqueId) == null || !clusterAsciiId.startsWith(clusterUniqueId)) continue;
                for (int k = 0; k < nodeEntity.getParameterList().size(); ++k) {
                    block7: {
                        String wwn = nodeEntity.getParamNameAt(k);
                        if (wwn == null || !wwn.startsWith("WWN") || (wwn = nodeEntity.getParamValueAt(k)) == null) continue;
                        try {
                            clusterEntity.addXrefs(clusterUniqueId, wwn);
                        }
                        catch (Exception e) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block7;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " Failed to create node to port relationship.");
                        }
                    }
                    avantiClusterNodeList.remove(j);
                    --j;
                    continue block3;
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setAvantiPortStateAndMode(Vector list) {
        String methodName = "setAvantiPortStateAndMode";
        String value = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity ieEntity = (Entity)list.elementAt(i);
            if (ieEntity == null) continue;
            for (int j = 0; j < ieEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)ieEntity.getParameterList().elementAt(j);
                if (param == null) continue;
                if (param.getName().equals("Mode")) {
                    value = param.getValue();
                    if (value == null) continue;
                    if (value.equals("1")) {
                        param.setValue("Initiator");
                        continue;
                    }
                    if (value.equals("2")) {
                        param.setValue("Target");
                        continue;
                    }
                    if (!value.equals("3")) continue;
                    param.setValue("Mgmt");
                    continue;
                }
                if (!param.getName().equals("State") || (value = param.getValue()) == null) continue;
                if (value.equals("1")) {
                    param.setValue("Up");
                    continue;
                }
                if (!value.equals("2")) continue;
                param.setValue("Down");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setAvantiNodeStatus(Vector list) {
        String methodName = "setAvantiNodeStatus";
        String value = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity ieEntity = (Entity)list.elementAt(i);
            if (ieEntity == null) continue;
            for (int j = 0; j < ieEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)ieEntity.getParameterList().elementAt(j);
                if (param == null || !param.getName().equals("Interface Status") || (value = param.getValue()) == null) continue;
                if (value.equals("1")) {
                    param.setValue("Up");
                    continue;
                }
                if (value.equals("2")) {
                    param.setValue("Down");
                    continue;
                }
                if (value.equals("3")) {
                    param.setValue("Testing");
                    continue;
                }
                if (value.equals("4")) {
                    param.setValue("Unknown");
                    continue;
                }
                if (value.equals("5")) {
                    param.setValue("Dormant");
                    continue;
                }
                if (value.equals("6")) {
                    param.setValue("NotPresent");
                    continue;
                }
                if (!value.equals("7")) continue;
                param.setValue("LowerLayerDown");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void setBladeStatus(Vector list) {
        String methodName = "setBladeStatus";
        String value = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity ieEntity = (Entity)list.elementAt(i);
            if (ieEntity == null) continue;
            for (int j = 0; j < ieEntity.getParameterList().size(); ++j) {
                Parameter param = (Parameter)ieEntity.getParameterList().elementAt(j);
                if (param == null || !param.getName().equals("Status") || (value = param.getValue()) == null) continue;
                if (value.equals("1")) {
                    param.setValue("Unknown");
                    continue;
                }
                if (value.equals("2")) {
                    param.setValue("OK");
                    continue;
                }
                if (value.equals("3")) {
                    param.setValue("Disabled");
                    continue;
                }
                if (value.equals("4")) {
                    param.setValue("OkButDiagFailed");
                    continue;
                }
                if (value.equals("5")) {
                    param.setValue("Boot");
                    continue;
                }
                if (value.equals("6")) {
                    param.setValue("SelfTest");
                    continue;
                }
                if (value.equals("7")) {
                    param.setValue("Failed");
                    continue;
                }
                if (value.equals("8")) {
                    param.setValue("Missing");
                    continue;
                }
                if (value.equals("9")) {
                    param.setValue("MismatchWithParent");
                    continue;
                }
                if (value.equals("10")) {
                    param.setValue("MismatchConfig");
                    continue;
                }
                if (value.equals("11")) {
                    param.setValue("DiagFailed");
                    continue;
                }
                if (value.equals("12")) {
                    param.setValue("Dormant");
                    continue;
                }
                if (value.equals("13")) {
                    param.setValue("OutOfServiceAdmin");
                    continue;
                }
                if (value.equals("14")) {
                    param.setValue("OutOfServiceEnvTemp");
                    continue;
                }
                if (value.equals("15")) {
                    param.setValue("PoweredDown");
                    continue;
                }
                if (value.equals("16")) {
                    param.setValue("PoweredUp");
                    continue;
                }
                if (value.equals("17")) {
                    param.setValue("PowerDenied");
                    continue;
                }
                if (!value.equals("18")) continue;
                param.setValue("PowerCycled");
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void addVportToVsan(Vector list, Hashtable hash) {
        String methodName = "addVportsToVsan";
        Vector<String> obj = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < list.size(); ++i) {
            String vsan;
            int index;
            Entity ieEntity = (Entity)list.elementAt(i);
            if (ieEntity == null) continue;
            String wwn = ieEntity.getUniqueId();
            String name = ieEntity.getName();
            if (name == null || wwn == null || (index = name.lastIndexOf(".")) == -1 || (vsan = name.substring(index + 1)) == null) continue;
            obj = (Vector<String>)hash.get(vsan);
            if (obj == null) {
                obj = new Vector<String>();
            }
            obj.add(wwn);
            hash.put(vsan, obj);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }
}

