/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPScanner;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class ProcessStdOutThread
extends Thread {
    private static ILogger msgLogger = SNMPScanner.msgLogger;
    private static ILogger traceLogger = SNMPScanner.traceLogger;
    private final String className = ProcessStdOutThread.class.getName();
    boolean printIt = false;
    Process p = null;
    String os = "";
    String cmd = "";
    boolean bOutputDone = false;

    public ProcessStdOutThread(Process pexec, String OpSys, String command, boolean print) {
        this.printIt = print;
        this.p = pexec;
        this.os = OpSys;
        this.cmd = command;
    }

    public void run() {
        String methodName = "run";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)(this.className + "::" + this.cmd), methodName);
        }
        String aLine = null;
        BufferedReader p_stdout = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        try {
            aLine = p_stdout.readLine();
        }
        catch (IOException ex) {
            aLine = null;
        }
        while (!this.bOutputDone && aLine != null) {
            if (this.printIt && traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, this.className + "::" + this.cmd, aLine);
            }
            try {
                aLine = p_stdout.readLine();
                if (aLine == null || aLine.length() != 0 || !this.os.startsWith("win")) continue;
                aLine = p_stdout.readLine();
            }
            catch (IOException ex) {
                aLine = null;
            }
        }
        try {
            p_stdout.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.bOutputDone = true;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)(this.className + "::" + this.cmd), methodName);
        }
    }

    public void shutdown() {
        String methodName = "shutdown";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)(this.className + "::" + this.cmd), methodName);
        }
        this.bOutputDone = true;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)(this.className + "::" + this.cmd), methodName);
        }
    }

    public boolean isDone() {
        String methodName = "isDone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)(this.className + "::" + this.cmd), methodName);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)(this.className + "::" + this.cmd), methodName);
        }
        return this.bOutputDone;
    }
}

