/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import org.eclipse.aperi.sanmgmt.Variables;

public class SNMPTraceLogger
extends PrintStream {
    private String fileName = null;
    private PrintStream log = null;
    private int offset = 0;
    private long bytesOut = 0L;
    private boolean logTimeStamp = false;
    private boolean logThreadName = true;
    private static final int maxLogs = 10;
    private static final long maxLogSize = 20480000L;

    public SNMPTraceLogger() throws FileNotFoundException {
        this(Variables.getBaseDirectory() + File.separator + "log" + File.separator + "SnmpTrace.log", false, true);
    }

    public SNMPTraceLogger(String fileName) throws FileNotFoundException {
        this(fileName, false, true);
    }

    public SNMPTraceLogger(String fileName, boolean logTimeStamp) throws FileNotFoundException {
        this(fileName, logTimeStamp, true);
    }

    public SNMPTraceLogger(boolean logTimeStamp) throws FileNotFoundException {
        this(Variables.getBaseDirectory() + File.separator + "log" + File.separator + "SnmpTrace.log", logTimeStamp, true);
    }

    public SNMPTraceLogger(boolean logTimeStamp, boolean logThreadName) throws FileNotFoundException {
        this(Variables.getBaseDirectory() + File.separator + "log" + File.separator + "SnmpTrace.log", logTimeStamp, logThreadName);
    }

    public SNMPTraceLogger(String fileName, boolean logTimeStamp, boolean logThreadName) throws FileNotFoundException {
        super(new BufferedOutputStream(new FileOutputStream(fileName, true)), true);
        this.fileName = fileName;
        this.logTimeStamp = logTimeStamp;
        this.logThreadName = logThreadName;
        this.log = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileName, true)), true);
        File f = new File(fileName);
        this.bytesOut = f.length();
    }

    public void flush() {
        if (this.log != null) {
            this.log.flush();
        }
    }

    public void close() {
        if (this.log != null) {
            this.log.close();
        }
        super.close();
    }

    public boolean checkError() {
        if (this.log != null) {
            return this.log.checkError();
        }
        return true;
    }

    public void write(int b) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.write(b);
            this.log.flush();
            ++this.offset;
        }
    }

    public void write(byte[] buf, int off, int len) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.write(buf, off, len);
            this.log.flush();
            this.offset += len;
            this.bytesOut += (long)len;
        }
    }

    public void write(byte[] buf) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            try {
                this.log.write(buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.log.flush();
            this.offset += buf.length;
            this.bytesOut += (long)buf.length;
        }
    }

    public void print(boolean b) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(b);
            this.log.flush();
            this.offset += b ? 4 : 5;
            this.bytesOut += (long)(b ? 4 : 5);
        }
    }

    public void print(char c) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(c);
            this.log.flush();
            this.offset += String.valueOf(c).length();
            this.bytesOut += (long)String.valueOf(c).length();
        }
    }

    public void print(int i) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(i);
            this.log.flush();
            this.offset += String.valueOf(i).length();
            this.bytesOut += (long)String.valueOf(i).length();
        }
    }

    public void print(long l) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(l);
            this.log.flush();
            this.offset += String.valueOf(l).length();
            this.bytesOut += (long)String.valueOf(l).length();
        }
    }

    public void print(float f) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(f);
            this.log.flush();
            this.offset += String.valueOf(f).length();
            this.bytesOut += (long)String.valueOf(f).length();
        }
    }

    public void print(double d) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(d);
            this.log.flush();
            this.offset += String.valueOf(d).length();
            this.bytesOut += (long)String.valueOf(d).length();
        }
    }

    public void print(char[] s) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(s);
            this.log.flush();
            this.offset += s.length;
            this.bytesOut += (long)s.length;
        }
    }

    public void print(Object obj) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(obj);
            this.log.flush();
            this.offset += String.valueOf(obj).length();
            this.bytesOut += (long)String.valueOf(obj).length();
        }
    }

    public void print(String s) {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.log.print(s);
            this.log.flush();
            this.offset += s.length();
            this.bytesOut += (long)s.length();
        }
    }

    public void println(boolean x) {
        this.print(x);
        this.newLine();
    }

    public void println(char x) {
        this.print(x);
        this.newLine();
    }

    public void println(int x) {
        this.print(x);
        this.newLine();
    }

    public void println(long x) {
        this.print(x);
        this.newLine();
    }

    public void println(float x) {
        this.print(x);
        this.newLine();
    }

    public void println(double x) {
        this.print(x);
        this.newLine();
    }

    public void println(char[] x) {
        this.print(x);
        this.newLine();
    }

    public void println(String x) {
        this.print(x);
        this.newLine();
    }

    public void println(Object x) {
        this.print(x);
        this.newLine();
    }

    public void println() {
        if (this.log != null) {
            this.wrapLog();
            this.logDateAndTime();
            this.newLine();
        }
    }

    private void newLine() {
        if (this.log != null) {
            this.logThreadName();
            this.log.println();
            this.log.flush();
            this.offset = 0;
        }
    }

    private String getNewFileName(String name, int number) {
        File f = new File(name);
        String partName = f.getName();
        String path = f.getPath().substring(0, f.getPath().indexOf(partName));
        Vector fileParts = new Vector();
        String newFileName = path;
        int firstDot = partName.indexOf(".");
        newFileName = firstDot != -1 ? newFileName.concat(partName.substring(0, firstDot) + number + partName.substring(firstDot)) : newFileName.concat(partName + number);
        return newFileName;
    }

    private synchronized void wrapLog() {
        boolean wrapFile = false;
        File logFile = new File(this.fileName);
        try {
            long len = logFile.length();
            if (logFile.length() >= 20480000L || this.bytesOut >= 20480000L) {
                wrapFile = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (wrapFile) {
            for (int i = 9; i > 0; --i) {
                File filex = new File(this.getNewFileName(this.fileName, i));
                if (!filex.exists()) continue;
                filex.renameTo(new File(this.getNewFileName(this.fileName, i + 1)));
            }
            File filex = new File(this.getNewFileName(this.fileName, 10));
            if (filex.exists()) {
                filex.delete();
            }
            this.close();
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
            this.bytesOut = 0L;
            this.offset = 0;
            logFile.renameTo(new File(this.getNewFileName(this.fileName, 1)));
            this.log = null;
            try {
                this.log = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.fileName, true)), true);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
    }

    private synchronized void logDateAndTime() {
        if (this.logTimeStamp && this.offset == 0 && this.log != null) {
            TimeZone tz = TimeZone.getDefault();
            Date now = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            df.setTimeZone(tz);
            String currentTime = df.format(now) + "  ";
            this.log.print(currentTime);
            this.offset += currentTime.length();
            this.bytesOut += (long)currentTime.length();
        }
    }

    private synchronized void logThreadName() {
        if (this.logThreadName && this.log != null) {
            String threadName = "  [" + Thread.currentThread().getName() + "]";
            this.log.print(threadName);
            this.offset += threadName.length();
            this.bytesOut += (long)threadName.length();
        }
    }
}

