/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner.data;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.aperi.discovery.snmp.scanner.data.Parameter;
import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class Entity {
    static ILogger msgLogger = OutbandScanner.msgLogger;
    static ILogger traceLogger = OutbandScanner.traceLogger;
    static final String className = Entity.class.getName();
    private String TOPOLOGY = "Topology";
    private String STATISTICS = "StatisticsScanner";
    private String CISCOMDS = "CiscoMDS";
    private String name = null;
    private String type = null;
    private String uniqueId = null;
    private Vector paramList = new Vector();
    private String str = new String();
    private Hashtable xrefs = new Hashtable();
    private Parameter iParameter;

    public Entity() {
    }

    public Entity(String aType, String aID) {
        this.name = aType;
        this.uniqueId = aID;
        this.type = "UNAVAILABLE";
        Vector paramList = new Vector();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String newid) {
        this.uniqueId = newid;
    }

    public void addParameter(String name, String value) {
        boolean parmSet = false;
        StringBuffer tempString = new StringBuffer();
        String newValue = value.trim();
        char[] strChar = newValue.toCharArray();
        for (int i = 0; i < strChar.length; ++i) {
            char int_val = strChar[i];
            if (int_val < ' ' && int_val > '~') continue;
            tempString.append(strChar[i]);
        }
        String parserValue = tempString.toString();
        for (int i = 0; i < this.paramList.size(); ++i) {
            if (!this.getParamNameAt(i).equals(name) || !this.getParamActualValueAt(i).equals("")) continue;
            this.setParamValueAt(i, parserValue);
            parmSet = true;
        }
        if (!parmSet) {
            this.paramList.add(new Parameter(name, parserValue));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String entityName) {
        this.name = entityName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String entityType) {
        this.type = entityType;
    }

    public Vector getParameterList() {
        return this.paramList;
    }

    public String getParamNameAt(int i) {
        this.iParameter = (Parameter)this.paramList.elementAt(i);
        return this.iParameter.getName();
    }

    public String getParamValueAt(int i) {
        if (this.paramList.size() > i) {
            this.iParameter = (Parameter)this.paramList.elementAt(i);
            return this.iParameter.getValue();
        }
        return null;
    }

    public String getParamActualValueAt(int i) {
        if (this.paramList.size() > i) {
            this.iParameter = (Parameter)this.paramList.elementAt(i);
            return this.iParameter.getActualValue();
        }
        return null;
    }

    public void setParamValueAt(int num, String value) {
        for (int i = 0; i < this.paramList.size(); ++i) {
            if (i != num) continue;
            ((Parameter)this.paramList.elementAt(i)).setValue(value);
        }
    }

    public void addXrefs(String aType, Vector id) throws Exception {
        String methodName = "addXrefs";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter=" + aType + " and " + id));
        }
        if (aType.length() == 0 || id == null) {
            throw new Exception("Error: Entity.addXRefs - missing input parameter");
        }
        Vector<Vector> idlist = (Vector<Vector>)this.xrefs.get(aType);
        if (idlist == null) {
            idlist = new Vector<Vector>();
            idlist.add(id);
            this.xrefs.put(aType, idlist);
        } else if (traceLogger != null && traceLogger.isLogging()) {
            String msg = "A Xref for " + aType + " already exists.";
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, msg);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void addXrefs(String aType, String id) throws Exception {
        String methodName = "addXrefs";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter=" + aType + " and " + id));
        }
        if (aType.length() == 0 || id.length() == 0) {
            throw new Exception("Error: Entity.addXRefs - missing input parameter");
        }
        Vector<String> idlist = (Vector<String>)this.xrefs.get(aType);
        if (idlist == null) {
            idlist = new Vector<String>();
            idlist.add(id);
            this.xrefs.put(aType, idlist);
        } else if (!this.isUniqueId(aType, id)) {
            idlist.add(id);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public Hashtable getXrefs() {
        return this.xrefs;
    }

    private boolean isUniqueId(String aType, String id) {
        Vector v = (Vector)this.xrefs.get(aType);
        for (int i = 0; i < v.size(); ++i) {
            if (!((String)v.elementAt(i)).equals(id)) continue;
            return true;
        }
        return false;
    }

    public String toXml() {
        String methodName = "toXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        String str = "  <" + this.name + "Xml>\n";
        String tmp = "    <UniqueIdXml>" + this.name + "Xml:" + this.uniqueId + "</UniqueIdXml>\n";
        str = str.concat(tmp);
        for (int i = 0; i < this.paramList.size(); ++i) {
            String param = ((Parameter)this.paramList.get(i)).toXML();
            str = str.concat(param);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return str;
    }

    public String toIdXml(Vector v, String name) throws NoSuchElementException {
        String methodName = "toIdXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter=" + v));
        }
        String tmp = new String();
        String str = new String();
        for (int i = 0; i < v.size(); ++i) {
            tmp = "  <" + name + "IdXml>" + name + "Xml:" + v.elementAt(i) + "</" + name + "IdXml>\n";
            str = str.concat(tmp);
        }
        str = str.concat(this.endEntityXml());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return str;
    }

    public String toIdXml(Vector[] v) throws NoSuchElementException {
        String methodName = "toIdXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter=" + v));
        }
        String tmp = new String();
        String str = new String();
        for (int f = 0; f < v.length; ++f) {
            for (int i = 0; i < v[f].size(); ++i) {
                tmp = "  <" + ((Entity)v[f].elementAt(i)).getName() + "IdXml>" + ((Entity)v[f].elementAt(i)).getName() + "Xml:" + ((Entity)v[f].elementAt(i)).getUniqueId() + "</" + ((Entity)v[f].elementAt(i)).getName() + "IdXml>\n";
                str = str.concat(tmp);
            }
        }
        str = str.concat(this.endEntityXml());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return str;
    }

    public String toIdXml(Entity en) throws NoSuchElementException {
        String methodName = "toIdXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter=" + en));
        }
        String str = new String();
        String entype = new String();
        String tmp = null;
        String enName = en.getName();
        entype = enName.equals("San") ? "InterconnectElement" : (enName.equals("FcPort") ? "AttachedFcPort" : (enName.equals("Blade") || enName.equals("Cluster") ? "FcNode" : (enName.equals("FcNode") ? "FcPort" : "FcPort")));
        Enumeration e = this.xrefs.keys();
        while (e.hasMoreElements()) {
            String atype = (String)e.nextElement();
            Vector vec = (Vector)this.xrefs.get(atype);
            for (int i = 0; i < vec.size(); ++i) {
                if (entype.equals("AttachedFcPort")) {
                    tmp = "  <" + entype + "IdXml>" + "FcPortXml:" + vec.elementAt(i) + "</" + entype + "IdXml>\n";
                    str = str.concat(tmp);
                    continue;
                }
                if (entype.equals("FcNode") && enName.equals("Blade")) {
                    for (int j = 0; j < ((Vector)vec.elementAt(i)).size(); ++j) {
                        tmp = "  <" + entype + "IdXml>" + entype + "Xml:" + ((Vector)vec.elementAt(i)).elementAt(j) + "</" + entype + "IdXml>\n";
                        str = str.concat(tmp);
                    }
                    continue;
                }
                tmp = "  <" + entype + "IdXml>" + entype + "Xml:" + vec.elementAt(i) + "</" + entype + "IdXml>\n";
                str = str.concat(tmp);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return str;
    }

    public String composeXml(Vector[] componentList) {
        String methodName = "composeXml";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Input Parameter=" + componentList));
        }
        String result = new String();
        for (int c = 0; c < componentList.length; ++c) {
            Vector entityList = componentList[c];
            for (int i = 0; i < entityList.size(); ++i) {
                Entity iEntity = (Entity)entityList.elementAt(i);
                result = result.concat(iEntity.toXml());
                result = result.concat(iEntity.toIdXml((Entity)entityList.elementAt(i)));
                result = result.concat(iEntity.endEntityXml());
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public String endEntityXml() {
        String str = new String();
        str = "  </" + this.name + "Xml>\n";
        return str;
    }

    public String endResultXml(String dtdType) {
        String s = "</" + dtdType + "Xml>";
        return s;
    }

    public String setDocType(String dtdType) {
        String str = new String();
        str = str.concat("<?xml version=\"1.0\"?>\n");
        str = dtdType.equals(this.TOPOLOGY) ? str.concat("<!DOCTYPE " + dtdType + "Xml " + this.getTopologyDtd()) : (dtdType.equals(this.CISCOMDS) ? str.concat("<!DOCTYPE " + dtdType + "Xml " + this.getCiscoMDSDtd()) : (dtdType.equals(this.STATISTICS) ? str.concat("<!DOCTYPE " + dtdType + "Xml " + this.getStatisticsDtd()) : str.concat("<!DOCTYPE " + dtdType + "Xml " + this.getSimpleTopologyDtd())));
        str = str.concat("<" + dtdType + "Xml>\n");
        return str;
    }

    public String setXmlHeader(String address, String name, String uniqueId, String version) {
        String str = new String();
        str = str.concat("  <HeaderXml>\n");
        str = str.concat("    <ParameterXml>\n");
        str = str.concat("      <NameXml>Version</NameXml>\n");
        str = str.concat("      <ValueXml>" + version + "</ValueXml>\n");
        str = str.concat("    </ParameterXml>\n");
        str = str.concat("    <ParameterXml>\n");
        str = str.concat("      <NameXml>Agent Address</NameXml>\n");
        str = str.concat("      <ValueXml>" + address + "</ValueXml>\n");
        str = str.concat("    </ParameterXml>\n");
        str = str.concat("    <ParameterXml>\n");
        str = str.concat("      <NameXml>Scanner Name</NameXml>\n");
        str = str.concat("      <ValueXml>" + name + "</ValueXml>\n");
        str = str.concat("    </ParameterXml>\n");
        str = str.concat("    <ParameterXml>\n");
        str = str.concat("      <NameXml>Scan ID</NameXml>\n");
        str = str.concat("      <ValueXml>" + uniqueId + "</ValueXml>\n");
        str = str.concat("    </ParameterXml>\n");
        str = str.concat("  </HeaderXml>\n");
        return str;
    }

    private String getStatisticsDtd() {
        String dtdfile = new String();
        dtdfile = dtdfile.concat("[<!-- Statistics Scanner DTD -->\n");
        dtdfile = dtdfile.concat("<!ELEMENT StatisticsScannerXml (HeaderXml, SwitchParamXml*, PortParamXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT HeaderXml (ParameterXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT SwitchParamXml (UniqueIdXml, ParameterXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT PortParamXml (UniqueIdXml, ParameterXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT UniqueIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ParameterXml (NameXml, ValueXml)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT NameXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ValueXml (#PCDATA)>]> <!-- END Statistics Scanner DTD -->\n");
        return dtdfile;
    }

    private String getSimpleTopologyDtd() {
        String dtdfile = new String();
        dtdfile = dtdfile.concat("[<!-- Simple Topology Discover DTD -->\n");
        dtdfile = dtdfile.concat("<!ELEMENT SimpleTopologyXml (HeaderXml, SanXml*, InterconnectElementXml*, FcPortXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT HeaderXml (ParameterXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT SanXml (UniqueIdXml, ParameterXml*, InterconnectElementIdXml*, FcPortIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT InterconnectElementXml (UniqueIdXml, ParameterXml*, FcPortIdXml*)>");
        dtdfile = dtdfile.concat("<!ELEMENT FcPortXml (UniqueIdXml, ParameterXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT UniqueIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ParameterXml (NameXml, ValueXml)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT InterconnectElementIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT FcPortIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT NameXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ValueXml (#PCDATA)>]> <!-- END Simple Topology Discover DTD -->\n");
        return dtdfile;
    }

    private String getCiscoMDSDtd() {
        String dtdfile = new String();
        dtdfile = dtdfile.concat("[<!-- Topology Discover DTD -->\n");
        dtdfile = dtdfile.concat("<!ELEMENT TopologyXml (HeaderXml, SanXml*, InterconnectElementXml*, ZoneXml*, PlatformXml*, SystemXml*, ControllerXml*, FcPortXml*, FcNodeXml*, ZoneSetXml*, ZoneMemberXml*, BladeXml*, ClusterXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT HeaderXml (ParameterXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT SanXml (UniqueIdXml, ParameterXml*, InterconnectElementIdXml*, FcPortIdXml*, ZoneSetIdXml*, SanIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT InterconnectElementXml (UniqueIdXml, ParameterXml*, FcPortIdXml*, InterconnectElementIdXml*, BladeIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ZoneSetXml (UniqueIdXml, ParameterXml*, ZoneIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ZoneXml (UniqueIdXml, ParameterXml*, FcPortIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ZoneMemberXml (UniqueIdXml, ParameterXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT PlatformXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT SystemXml (UniqueIdXml, ParameterXml*, ControllerIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ControllerXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT FcPortXml (UniqueIdXml, ParameterXml*, AttachedFcPortIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT FcNodeXml (UniqueIdXml, ParameterXml*, FcPortIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT BladeXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ClusterXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ParameterXml (NameXml, ValueXml)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT UniqueIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT FcPortIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT InterconnectElementIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ZoneSetIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ZoneIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT FcNodeIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT AttachedFcPortIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ControllerIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT BladeIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ClusterIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT SanIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT NameXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ValueXml (#PCDATA)>]> <!-- END Topology Discover DTD -->\n");
        return dtdfile;
    }

    private String getTopologyDtd() {
        String dtdfile = new String();
        dtdfile = dtdfile.concat("[<!-- Topology Discover DTD -->\n");
        dtdfile = dtdfile.concat("<!ELEMENT TopologyXml (HeaderXml, SanXml*, InterconnectElementXml*, ZoneXml*, PlatformXml*, SystemXml*, ControllerXml*, FcPortXml*, FcNodeXml*, ZoneSetXml*, ZoneMemberXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT HeaderXml (ParameterXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT SanXml (UniqueIdXml, ParameterXml*, SanIdXml*, InterconnectElementIdXml*, FcPortIdXml*, ZoneSetIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT InterconnectElementXml (UniqueIdXml, ParameterXml*, FcPortIdXml*, InterconnectElementIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ZoneSetXml (UniqueIdXml, ParameterXml*, ZoneIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ZoneXml (UniqueIdXml, ParameterXml*, FcPortIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ZoneMemberXml (UniqueIdXml, ParameterXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT PlatformXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT SystemXml (UniqueIdXml, ParameterXml*, ControllerIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ControllerXml (UniqueIdXml, ParameterXml*, FcNodeIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT FcPortXml (UniqueIdXml, ParameterXml*, AttachedFcPortIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT FcNodeXml (UniqueIdXml, ParameterXml*, FcPortIdXml*)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ParameterXml (NameXml, ValueXml)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT UniqueIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT FcPortIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT InterconnectElementIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ZoneSetIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ZoneIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT FcNodeIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT AttachedFcPortIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ControllerIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT SanIdXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT NameXml (#PCDATA)>\n");
        dtdfile = dtdfile.concat("<!ELEMENT ValueXml (#PCDATA)>]> <!-- END Topology Discover DTD -->\n");
        return dtdfile;
    }

    public String toString() {
        String str = new String();
        str = str.concat("\nEntity\n");
        str = str.concat("  Type     = " + this.getType() + "\n");
        str = str.concat("  UniqueId = " + this.getUniqueId() + "\n");
        str = str.concat("  Parameters\n");
        for (int i = 0; i < this.getParameterList().size(); ++i) {
            Parameter param = (Parameter)this.getParameterList().elementAt(i);
            str = str.concat("    " + param.getName() + " = " + param.getActualValue() + "\n");
        }
        return str;
    }

    public void initTopologyParms() {
    }

    public void initSwitchStatsParms() {
        this.addParameter("State", "");
        this.addParameter("Status", "");
    }

    public void initPortStatsParms() {
        this.addParameter("WWN", "");
        this.addParameter("State", "");
        this.addParameter("Class3Discards", "");
        this.addParameter("RxLinkResets", "");
        this.addParameter("TxLinkResets", "");
        this.addParameter("RxOfflineSequences", "");
        this.addParameter("TxOfflineSequences", "");
        this.addParameter("LinkFailures", "");
        this.addParameter("InvalidCRC", "");
        this.addParameter("InvalidTxWords", "");
        this.addParameter("PrimitiveSequenceProtocolErrors", "");
        this.addParameter("LossOfSignal", "");
        this.addParameter("LossOfSynchronization", "");
        this.addParameter("InvalidOrderedSets", "");
        this.addParameter("FramesTooLong", "");
        this.addParameter("FramesTruncated", "");
        this.addParameter("AddressErrors", "");
        this.addParameter("DelimiterErrors", "");
        this.addParameter("EncodingDisparityErrors", "");
    }

    public void initSensorStatsParms() {
        this.addParameter("ConnUnitWWN", "");
        this.addParameter("Index", "");
        this.addParameter("Name", "");
        this.addParameter("Status", "");
        this.addParameter("Info", "");
        this.addParameter("Message", "");
        this.addParameter("Type", "");
        this.addParameter("Characteristic", "");
    }

    public void initEventStatsParms() {
        this.addParameter("ConnUnitWWN", "");
        this.addParameter("Index", "");
        this.addParameter("RealTime", "");
        this.addParameter("Uptime", "");
        this.addParameter("Severity", "");
        this.addParameter("Type", "");
        this.addParameter("ObjectID", "");
        this.addParameter("Description", "");
    }

    public void initCiscoParms() {
    }

    public boolean equals(Object o) {
        return o instanceof Entity && ((Entity)o).getUniqueId().equals(this.getUniqueId());
    }
}

