/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.tsanm;

import java.util.Hashtable;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.snmp.scanner.CiscoMDSScanner;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig;
import org.eclipse.aperi.discovery.snmp.scanner.TopologyScanner;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.IScanner;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Header;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.KeyedJobQueue;
import org.eclipse.aperi.util.queue.QueueController;

public class OutbandScanner
extends Thread {
    private boolean shutdown = false;
    private static SNMPConfig config;
    private Thread thread = null;
    public static String queueName;
    public static final String MESSAGE_NAME = "aperi.logger.message.SNMPScanner";
    public static final String TRACE_NAME = "aperi.logger.trace.SNMPScanner";
    public static String MSG_FILE;
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    static final String className;
    public static final String TopologyScanner;
    public static final String CiscoMDSScanner;

    public OutbandScanner() {
        this.setName(queueName + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new KeyedJobQueue(true));
        this.start();
    }

    public void run() {
        boolean trace = false;
        String methodName = "run";
        this.thread = Thread.currentThread();
        while (!this.shutdown) {
            if (traceLogger != null && traceLogger.isLogging()) {
                trace = true;
            }
            if (trace) {
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, queueName + ": waiting for a job.");
            }
            JobInfo job = QueueController.getInstance().getNextJob(queueName);
            if (this.shutdown) continue;
            if (job == null) {
                if (!trace) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, queueName + ":Error - got a NULL job from the queue");
                continue;
            }
            try {
                ILogger jobLogger = null;
                Request request = Router.getRouter().getRequest(job.getDiscoverRequest());
                if (request != null) {
                    jobLogger = request.getJobLogger();
                }
                Hashtable outbandParams = null;
                String scannerName = null;
                String snmpCommunity = null;
                String snmpWriteCommunity = null;
                String ipTarget = job.getResourceId();
                if (job.getRequest().getData() instanceof Hashtable) {
                    outbandParams = (Hashtable)job.getRequest().getData();
                    scannerName = (String)outbandParams.get("SCANNER");
                    snmpCommunity = (String)outbandParams.get("SNMP Community");
                    snmpWriteCommunity = (String)outbandParams.get("SNMP Write Community");
                } else if (job.getRequest().getData() instanceof String) {
                    scannerName = (String)job.getRequest().getData();
                } else {
                    if (jobLogger != null) {
                        jobLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "OutbandScanner_Failed", new Object[]{scannerName, job.getTarget()[0], new Integer(999)});
                    }
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "OutbandScanner_Failed", new Object[]{scannerName, job.getTarget()[0], new Integer(999)});
                    if (trace) {
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)className, methodName, "The job request data format is unknown for Job " + job.toString() + ".");
                    }
                }
                String scannerShortName = scannerName;
                int position = scannerName.lastIndexOf(".");
                if (position > -1) {
                    scannerShortName = scannerName.substring(position + 1);
                }
                IScanner scanner = null;
                try {
                    Class<?> classDefinition = Class.forName(scannerName);
                    scanner = (IScanner)classDefinition.newInstance();
                }
                catch (Throwable e) {
                    if (jobLogger != null) {
                        jobLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, e);
                    }
                    if (trace) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, e);
                    }
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, e);
                    if (trace) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, e);
                    }
                    job.setReturnCode(101);
                    job.complete(false);
                    continue;
                }
                if (jobLogger != null) {
                    jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "OutbandScanner_invoke", (Object[])new String[]{scannerShortName, job.getTarget()[0]});
                }
                if (trace) {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, queueName + ": invoking " + scannerName + " on " + job.getTarget()[0]);
                }
                if (scanner == null) {
                    if (jobLogger != null) {
                        jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "OutbandScanner_invokeErrNullScanner", (Object[])new String[]{scannerShortName});
                    }
                    if (trace) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Scanner " + scannerName + " not valid.");
                    }
                    job.setReturnCode(101);
                    job.complete(false);
                } else {
                    try {
                        org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response response;
                        if (scannerName.equals(TopologyScanner) || CiscoMDSScanner.equals(scannerName)) {
                            config = (SNMPConfig)SnmpV1API.getConfig();
                            config.setSnmpCommunityName(ipTarget, snmpCommunity);
                            config.setSnmpWriteCommunityName(ipTarget, snmpWriteCommunity);
                        }
                        if ((response = scanner.invoke(scannerName, job.getTarget())).getHeader() == null) {
                            Header hdr = new Header();
                            response.setHeader(hdr);
                        }
                        response.getHeader().setScannerName(scannerName);
                        response.getHeader().setAgentAddress(job.getTarget()[0]);
                        response.getHeader().setScannerId(job.getRequestId());
                        response.getHeader().setType("");
                        if (response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK) {
                            job.setResponse((Response)new ObjectResponse((Object)response, job));
                        }
                        job.setReturnCode(response.getReturnCode());
                        if (jobLogger != null) {
                            if (response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK) {
                                jobLogger.message(IRecordType.TYPE_INFO, (Object)this, methodName, "OutbandScanner_Successful", (Object)scannerShortName, (Object)job.getTarget()[0]);
                            } else {
                                jobLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "OutbandScanner_Failed", (Object[])new String[]{scannerShortName, job.getTarget()[0], new Integer(response.getReturnCode()).toString()});
                            }
                        }
                        job.complete(response.getReturnCode() == org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response.RETURN_CODE_OK);
                    }
                    catch (Exception e) {
                        if (jobLogger != null) {
                            jobLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "OutbandScanHandler_UnknownHostException", (Object)scannerShortName, (Object)job.getTarget()[0]);
                            jobLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (trace) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                            }
                        }
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "OutbandScanHandler_UnknownHostException", (Object)scannerShortName, (Object)job.getTarget()[0]);
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (trace) {
                            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                        }
                        job.setReturnCode(100);
                        job.complete(false);
                    }
                }
            }
            catch (Throwable t) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, t);
                if (trace) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, t);
                }
                job.setReturnCode(99);
                job.complete(false);
            }
            if (!trace) continue;
            traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, queueName + ": finishing job.");
        }
    }

    public void shutdown() {
        String methodName;
        block5: {
            methodName = "shutdown";
            this.shutdown = true;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread.join(30000L);
                    this.thread = null;
                }
                catch (Exception e) {
                    msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (traceLogger == null || !traceLogger.isLogging()) break block5;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    static {
        queueName = "SNMP Scanner";
        MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.MibQueryEngineTMS";
        msgLogger = null;
        traceLogger = null;
        className = OutbandScanner.class.getName();
        String methodName = "Initialization";
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        TopologyScanner = TopologyScanner.class.getName();
        CiscoMDSScanner = CiscoMDSScanner.class.getName();
    }
}

