/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.fabric.FabricMsgConsts;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;

class DiscoverFabricViaSMIS
extends DiscoverProcess {
    private static String MSG_FILE;
    private final String className = "ProbeFabric";
    public static final String MESSAGE_NAME = "aperi.logger.message.FabricManager";
    public static final String TRACE_NAME = "aperi.logger.trace.FabricManager";
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    public static final long MIN_RETRY_INTERVAL = 100L;
    public static final long MULT_RETRY_INTERVAL = 500L;
    public static final int ALLOWED_RETRIES = 3;
    boolean trace = false;

    public DiscoverFabricViaSMIS() {
        super("Discover Fabric Via SMIS.  Collects switch and port info.", false, new String[]{"CIMOM"}, new String[]{String[].class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        String methodName = "process";
        String[] cimom = (String[])DiscoverFabricViaSMIS.getParameter((Map)parameters, (String)"CIMOM", (String)String[].class.getName());
        ArrayList switches = this.getSwitchesForCIMOM(cimom);
        CIMProcessor processor = new CIMProcessor();
        try {
            DiscoverStep discoverPortsForComputerSystem = new DiscoverStep("arhDiscoverPortsForComputerSystem", "PORT", processor);
            ILogger jobLogger = discoverRequest.getJobLogger();
            for (String[] switchParms : switches) {
                CIMObjectPath switchCIMOP = new CIMObjectPath(switchParms[1], cimom[1]);
                CIMProperty name = new CIMProperty("Name", new CIMValue((Object)switchParms[0], CIMDataType.getPredefinedType((int)8)));
                switchCIMOP.addKey(name);
                CIMProperty ccName = new CIMProperty("CreationClassName", new CIMValue((Object)switchParms[1], CIMDataType.getPredefinedType((int)8)));
                switchCIMOP.addKey(ccName);
                CIMInstance bInstance = new CIMInstance(switchCIMOP);
                CIMProperty dedicated = new CIMProperty("Dedicated", new CIMValue((Object)"5", CIMDataType.getPredefinedType((int)8)));
                bInstance.addProperty(dedicated);
                CIMProperty nameFormat = new CIMProperty("NameFormat", new CIMValue((Object)switchParms[2], CIMDataType.getPredefinedType((int)8)));
                bInstance.addProperty(nameFormat);
                parameters.put("SYSTEM", bInstance);
                if (jobLogger != null && jobLogger.isLogging()) {
                    jobLogger.message(IRecordType.TYPE_INFO, (Object)"ProbeFabric", "process", FabricMsgConsts.PROBING_SWITCH, (Object[])new String[]{switchParms[0]});
                }
                if (msgLogger != null && msgLogger.isLogging()) {
                    msgLogger.message(IRecordType.TYPE_INFO, (Object)"ProbeFabric", "process", FabricMsgConsts.PROBING_SWITCH, (Object[])new String[]{switchParms[0]});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)"ProbeFabric", "process", "Discovering ports for switch " + switchParms[0] + " using CIMOM " + cimom[0] + " with namespace " + cimom[1] + " and userId " + cimom[2] + ".");
                }
                try {
                    processor.start(discoverRequest.getId());
                    try {
                        boolean status = discoverPortsForComputerSystem.process(new Integer(discoverRequest.getId()).toString(), parameters);
                        if (status) {
                            if (jobLogger == null) continue;
                            jobLogger.message(IRecordType.TYPE_INFO, (Object)"ProbeFabric", "process", FabricMsgConsts.OPERATION_SUCCESSFUL, (Object[])new String[]{"Query.associators." + switchParms[0]});
                            continue;
                        }
                        if (jobLogger != null && jobLogger.isLogging()) {
                            jobLogger.message(IRecordType.TYPE_ERROR, (Object)"ProbeFabric", "process", FabricMsgConsts.CIM_METHOD_FAILED, (Object[])new String[]{"Query.associators." + switchParms[0], cimom[0], ""});
                        }
                        if (msgLogger != null && msgLogger.isLogging()) {
                            msgLogger.message(IRecordType.TYPE_ERROR, (Object)"ProbeFabric", "process", FabricMsgConsts.CIM_METHOD_FAILED, (Object[])new String[]{"Query.associators." + switchParms[0], cimom[0], ""});
                        }
                        if (traceLogger == null || !traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)"ProbeFabric", "process", "Failed to discover ports for switch " + switchParms[0] + " using CIMOM " + cimom[0] + " with namespace " + cimom[1] + " and userId " + cimom[2] + ".  The process method of the DiscoverStep, discoverPortsForComputerSystem, returned false.");
                    }
                    catch (Exception e) {
                        if (jobLogger != null && jobLogger.isLogging()) {
                            jobLogger.message(IRecordType.TYPE_ERROR, (Object)"ProbeFabric", "process", FabricMsgConsts.CIM_METHOD_EXCEPTION, (Object[])new String[]{"Query.associators." + switchParms[0], cimom[0], e.getLocalizedMessage()});
                        }
                        if (msgLogger != null && msgLogger.isLogging()) {
                            msgLogger.message(IRecordType.TYPE_ERROR, (Object)"ProbeFabric", "process", FabricMsgConsts.CIM_METHOD_EXCEPTION, (Object[])new String[]{"Query.associators." + switchParms[0], cimom[0], e.getLocalizedMessage()});
                            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)"ProbeFabric", "process", (Throwable)e);
                        }
                        if (traceLogger == null || !traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)"ProbeFabric", "process", "Failed to discover ports for switch " + switchParms[0] + " using CIMOM " + cimom[0] + " with namespace " + cimom[1] + " and userId " + cimom[2] + ".  The process method of the DiscoverStep, discoverPortsForComputerSystem, threw an exception, " + e.getLocalizedMessage() + ".");
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)"ProbeFabric", "process", (Throwable)e);
                    }
                }
                finally {
                    if (processor == null) continue;
                    processor.end(discoverRequest.getId());
                }
            }
        }
        finally {
            if (processor != null) {
                processor.shutdown();
                processor = null;
            }
        }
        return new Result(0);
    }

    public String getScannerId(Map parameters) throws ParameterException {
        String[] cimom = (String[])DiscoverFabricViaSMIS.getParameter((Map)parameters, (String)"CIMOM", (String)String[].class.getName());
        String scannerId = null;
        scannerId = "DF1:" + cimom[0];
        return scannerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ArrayList getSwitchesForCIMOM(String[] mCimom) throws ServerException {
        Random randomGenerator = new Random();
        String methodName = "getSwitchesForCIMOM";
        ArrayList<String[]> values = new ArrayList<String[]>();
        String sql = " Select switchkey.SWITCH_WWN as WWN, ccName.NAME as CCNAME, switchkey.NAME_FORMAT as FORMAT from T_RES_REGISTERED_CIMOM cimom, T_RES_CIMOM2NAMESPACE namespace, T_RES_CIMKEY_SWITCH switchkey, T_RES_CREATION_CLASS_NAME as ccName where cimom.SERVICE_URL = '" + mCimom[0] + "' AND " + "namespace.NAMESPACE = '" + mCimom[1] + "' AND " + "namespace.CIMOM_ID = cimom.REG_CIMOM_ID AND " + "switchkey.CIM_NAMESPACE_ID = namespace.CIM_NAMESPACE_ID AND " + "switchkey.CREATION_CLASS_NAME_ID = ccName.ID";
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFO, (Object)"ProbeFabric", "getSwitchesForCIMOM", "getSwitchesForCIMOM SQL is: " + sql);
        }
        DBResultSet dbr = null;
        int numRetries = 0;
        boolean retry = true;
        DBConnection connection = ServiceUtils.getConnection();
        do {
            Exception e32222;
            values.clear();
            dbr = ComplexQuery.sqlQuery((DBConnection)connection, (String)sql, null);
            while (dbr.next()) {
                String nameFormat = Short.toString(dbr.getShort("FORMAT"));
                String convertedNameFormat = DBConstants.getKeyFromValue((String)"SMISName_Format", (String)nameFormat);
                if (convertedNameFormat != null) {
                    nameFormat = convertedNameFormat;
                }
                values.add(new String[]{dbr.getString("WWN"), dbr.getString("CCNAME"), nameFormat});
                if (!traceLogger.isLogging()) continue;
                String msg = "Found Switch, WWN = " + dbr.getString("WWN") + ", Creation Class = " + dbr.getString("CCNAME") + ", Name Format = " + nameFormat + ", CIMOM URL = " + mCimom[0] + ", CIMOM NAMESPACE = " + mCimom[1];
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)"ProbeFabric", "getSwitchesForCIMOM", msg);
            }
            retry = false;
            connection.commit();
            Object var15_18 = null;
            try {
                if (dbr != null) {
                    dbr.getStatement().close();
                }
            }
            catch (Exception ignoer) {
                // empty catch block
            }
            try {
                if (dbr != null) {
                    dbr.close();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                if (connection != null) {
                    connection.commit();
                }
            }
            catch (Exception e2) {
                try {
                    if (connection != null) {
                        connection.rollback();
                    }
                }
                catch (Exception e32222) {
                    // empty catch block
                }
            }
            try {
                if (connection == null) continue;
                connection.close();
            }
            catch (Exception e4) {}
            continue;
            {
                catch (SQLException e) {
                    block63: {
                        block62: {
                            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)"ProbeFabric", "getSwitchesForCIMOM", (Throwable)e);
                            if (traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)"ProbeFabric", "getSwitchesForCIMOM", (Throwable)e);
                            }
                            if (!SQLExceptionHelper.isDeadlock((DBConnection)connection, (SQLException)e)) break block62;
                            try {
                                connection.rollback();
                            }
                            catch (SQLException sowhat) {
                                // empty catch block
                            }
                            if (++numRetries > 3) break block63;
                            retry = true;
                            long msWaitPeriod = (long)(500.0 * randomGenerator.nextDouble() * (double)numRetries);
                            if (msWaitPeriod < 100L) {
                                msWaitPeriod = 100L;
                            }
                            try {
                                Thread.sleep(msWaitPeriod);
                            }
                            catch (InterruptedException intex) {
                            }
                            var15_18 = null;
                            try {
                                if (dbr != null) {
                                    dbr.getStatement().close();
                                }
                            }
                            catch (Exception ignoer) {
                                // empty catch block
                            }
                            try {
                                if (dbr != null) {
                                    dbr.close();
                                }
                            }
                            catch (Exception e1) {
                                // empty catch block
                            }
                            try {
                                if (connection != null) {
                                    connection.commit();
                                }
                            }
                            catch (Exception e2) {
                                try {
                                    if (connection != null) {
                                        connection.rollback();
                                    }
                                }
                                catch (Exception e32222) {
                                    // empty catch block
                                }
                            }
                            try {
                                if (connection == null) continue;
                                connection.close();
                            }
                            catch (Exception e4) {}
                            continue;
                        }
                        try {
                            retry = false;
                        }
                        catch (SQLException e1) {
                        }
                    }
                    var15_18 = null;
                    try {
                        if (dbr != null) {
                            dbr.getStatement().close();
                        }
                    }
                    catch (Exception ignoer) {
                        // empty catch block
                    }
                    try {
                        if (dbr != null) {
                            dbr.close();
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    try {
                        if (connection != null) {
                            connection.commit();
                        }
                    }
                    catch (Exception e2) {
                        try {
                            if (connection != null) {
                                connection.rollback();
                            }
                        }
                        catch (Exception e32222) {
                            // empty catch block
                        }
                    }
                    try {
                        if (connection == null) continue;
                        connection.close();
                    }
                    catch (Exception e4) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var15_18 = null;
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                    }
                }
                catch (Exception ignoer) {
                    // empty catch block
                }
                try {
                    if (dbr != null) {
                        dbr.close();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                try {
                    if (connection != null) {
                        connection.commit();
                    }
                }
                catch (Exception e2) {
                    try {
                        if (connection != null) {
                            connection.rollback();
                        }
                    }
                    catch (Exception e32222) {
                        // empty catch block
                    }
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e4) {
                    // empty catch block
                }
                throw throwable;
            }
        } while (retry);
        return values;
    }

    static {
        Router.getRouter().addProcess("arhDiscoverPortsForComputerSystem", (IDiscoverProcess)new AssociatorCIMQuery("Discover Ports for Computer System", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_FCPort", (String)"GroupComponent", (String)"PartComponent"), "SYSTEM", CIMInstance.class.getName(), false));
        MSG_FILE = FabricManagerConstants.MSG_FILE;
        msgLogger = null;
        traceLogger = null;
        String methodName = "Initialization";
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

