/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.SimpleCIMDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.sblim.wbem.cim.CIMInstance;

class FabricDiscoverWithConcurrentStreams
extends DiscoverProcess {
    private static String MSG_FILE = FabricManagerConstants.MSG_FILE;
    private final String className = "FabricDiscoverWithConcurrentStreams";
    public static final String MESSAGE_NAME = "aperi.logger.message.FabricManager";
    public static final String TRACE_NAME = "aperi.logger.trace.FabricManager";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;

    public FabricDiscoverWithConcurrentStreams() {
        super("Discover Fabric with Concurrent Streams", true, new String[]{"CIMOM"}, new String[]{String[].class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        String methodName = "process";
        CIMProcessor processor = null;
        CIMProcessor realProcessor = new CIMProcessor();
        DiscoverStep discoverAdminDomains = new DiscoverStep("DIMdiscoverAdminDomains", "ADMINDOMAIN", processor);
        DiscoverStep discoverAdminDomainsForAdminDomain = new DiscoverStep("DIMdiscoverAdminDomainsForAdminDomain", null, processor);
        DiscoverStep discoverComputerSystemsForAdminDomain = new DiscoverStep("DIMdiscoverComputerSystemsForAdminDomain", "SYSTEM", processor);
        DiscoverStep discoverPortsForComputerSystem = new DiscoverStep("DIMdiscoverPortsForComputerSystem", "PORT", processor);
        DiscoverStep discoverProtocolsForPort = new DiscoverStep("DIMdiscoverProtocolsForPort", "PROTOCOL", processor);
        DiscoverStep discoverConnectionsForProtocol = new DiscoverStep("DIMdiscoverConnectionsForProtocol", null, processor);
        discoverAdminDomains.addNextStep((IStep)discoverAdminDomainsForAdminDomain);
        discoverAdminDomains.addNextStep((IStep)discoverComputerSystemsForAdminDomain);
        discoverComputerSystemsForAdminDomain.addNextStep((IStep)discoverPortsForComputerSystem);
        discoverPortsForComputerSystem.addNextStep((IStep)discoverProtocolsForPort);
        discoverProtocolsForPort.addNextStep((IStep)discoverConnectionsForProtocol);
        boolean status = false;
        try {
            realProcessor.start(discoverRequest.getId());
            try {
                status = discoverAdminDomains.process(new Integer(discoverRequest.getId()).toString(), parameters);
            }
            catch (Exception e) {
                status = false;
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)"FabricDiscoverWithConcurrentStreams", "process", (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)"FabricDiscoverWithConcurrentStreams", "process", (Throwable)e);
                }
            }
        }
        finally {
            if (realProcessor != null) {
                realProcessor.end(discoverRequest.getId());
                realProcessor.shutdown();
                realProcessor = null;
            }
        }
        return new Result(status ? 0 : 99);
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        Router.getRouter().addProcess("DIMdiscoverAdminDomains", (IDiscoverProcess)new SimpleCIMDiscoverProcess("Discover Admin Domains", false, new Query[]{Query.enumerateInstancesQuery((String)"CIM_AdminDomain")}, false));
        Router.getRouter().addProcess("DIMdiscoverAdminDomainsForAdminDomain", (IDiscoverProcess)new AssociatorCIMQuery("Discover Admin Domains for Admin Domain", Query.associatorNames((String)"CIM_AdminDomain", (String)"CIM_ContainedDomain", (String)"CIM_AdminDomain", (String)"GroupComponent", (String)"PartComponent"), "ADMINDOMAIN", CIMInstance.class.getName(), false));
        Router.getRouter().addProcess("DIMdiscoverComputerSystemsForAdminDomain", (IDiscoverProcess)new AssociatorCIMQuery("Discover Computer Systems for Admin Domain", Query.associators((String)"CIM_AdminDomain", (String)"CIM_Component", (String)"CIM_ComputerSystem", (String)"GroupComponent", (String)"PartComponent"), "ADMINDOMAIN", CIMInstance.class.getName(), false));
        Router.getRouter().addProcess("DIMdiscoverPortsForComputerSystem", (IDiscoverProcess)new AssociatorCIMQuery("Discover Ports for Computer System", Query.associators((String)"CIM_ComputerSystem", (String)"CIM_SystemDevice", (String)"CIM_FCPort", (String)"GroupComponent", (String)"PartComponent"), "SYSTEM", CIMInstance.class.getName(), false));
        Router.getRouter().addProcess("DIMdiscoverProtocolsForPort", (IDiscoverProcess)new AssociatorCIMQuery("Discover Protocols for Port", Query.associators((String)"CIM_FCPort", (String)"CIM_DeviceSAPImplementation", (String)"CIM_ProtocolEndpoint", (String)"Antecedent", (String)"Dependent"), "PORT", CIMInstance.class.getName(), false));
        Router.getRouter().addProcess("DIMdiscoverConnectionsForProtocol", (IDiscoverProcess)new AssociatorCIMQuery("Discover Connections for Protocol", Query.associators((String)"CIM_ProtocolEndpoint", (String)"CIM_ActiveConnection", (String)"CIM_ProtocolEndpoint", (String)"Antecedent", (String)"Dependent"), "PROTOCOL", CIMInstance.class.getName(), false));
    }
}

