/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.fabric.FabricMsgConsts;
import org.eclipse.aperi.fabric.api.DeviceAgent;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.fabric.api.FabricScanner;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.SRMCrypto;

class ProbeFabricAgents
extends DiscoverProcess {
    static final String className = ProbeFabricAgents.class.getName();
    private static ILogger msgLogger = null;
    private static ILogger traceLogger = null;

    public ProbeFabricAgents() {
        super("Probe Fabric Agents", false, new String[]{"AGENTS", "AGENT_TYPES"}, new String[]{ArrayList.class.getName(), ArrayList.class.getName()});
    }

    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        FabricScanner[] tempScanners;
        block28: {
            String methodName = "process";
            Object[] msgInserts = new String[2];
            ArrayList agentList = (ArrayList)ProbeFabricAgents.getParameter((Map)parameters, (String)"AGENTS", (String)ArrayList.class.getName());
            ArrayList agent_types = (ArrayList)ProbeFabricAgents.getParameter((Map)parameters, (String)"AGENT_TYPES", (String)ArrayList.class.getName());
            if (agent_types.isEmpty()) {
                agent_types.add(new Integer(FabricManagerConstants.SNMPType));
                agent_types.add(new Integer(FabricManagerConstants.deviceServerType));
                agent_types.add(new Integer(FabricManagerConstants.CIMType));
            }
            Iterator i = agent_types.iterator();
            while (i.hasNext()) {
                Hashtable<String, Object> parms;
                FabricScanner[] tempScanners2;
                int agentType = (Integer)i.next();
                if (agentType == FabricManagerConstants.SNMPType) {
                    SNMPAgent[] snmpagents = this.getSNMPAgents();
                    if (snmpagents == null) continue;
                    for (int j = 0; j < snmpagents.length; ++j) {
                        block26: {
                            if (!agentList.isEmpty() && !agentList.contains(snmpagents[j].getIpAddress())) continue;
                            tempScanners2 = null;
                            try {
                                tempScanners2 = this.getScannersForAgent(snmpagents[j].getIpAddress());
                            }
                            catch (Exception exp) {
                                msgInserts[0] = "SNMP scanner";
                                msgInserts[1] = snmpagents[j].getIpAddress();
                                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.SCANNER_NOT_FOUND, msgInserts);
                                if (!traceLogger.isLogging()) break block26;
                                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error during discover Fabrics getting the Scanners for outband agent with ID = " + snmpagents[j].getIpAddress() + ".");
                                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exp);
                            }
                        }
                        for (int z = 0; z < tempScanners2.length; ++z) {
                            if (tempScanners2[z].getEnabled() != 0) {
                                if (!tempScanners2[z].getType().equals("PO2") && !tempScanners2[z].getType().equals("PO4")) continue;
                                parms = new Hashtable();
                                parms.put("IPADDRESS", new String[]{snmpagents[j].getIpAddress(), snmpagents[j].getUserName(), snmpagents[j].getPassword()});
                                parms.put("SCANNER", tempScanners2[z].getType());
                                Router.getRouter().perform(Discover.discoverViaSNMP, parms, new Integer(discoverRequest.getId()).toString());
                                continue;
                            }
                            if (tempScanners2[z].getInactiveProcessed() != 0) continue;
                            parms = new Hashtable();
                            parms.put("IPADDRESS", new String[]{snmpagents[j].getIpAddress()});
                            parms.put("SCANNER", tempScanners2[z].getType());
                            Router.getRouter().perform(Discover.ProcessMissingSNMPAgent, parms, new Integer(discoverRequest.getId()).toString());
                        }
                    }
                    continue;
                }
                if (agentType == FabricManagerConstants.deviceServerType) {
                    try {
                        DeviceAgent[] inbandAgents = this.getDeviceServerAgents();
                        if (inbandAgents == null) continue;
                        for (int m = 0; m < inbandAgents.length; ++m) {
                            block27: {
                                if (!agentList.isEmpty() && !agentList.contains(inbandAgents[m].getUrl()) && !agentList.contains(inbandAgents[m].getIpAddress()) && !agentList.contains(inbandAgents[m].getGuid())) continue;
                                tempScanners2 = null;
                                try {
                                    tempScanners2 = this.getScannersForAgent(inbandAgents[m].getGuid());
                                }
                                catch (Exception exp) {
                                    msgInserts[0] = "Inband Scanner";
                                    msgInserts[1] = inbandAgents[m].getGuid();
                                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.SCANNER_NOT_FOUND, msgInserts);
                                    if (!traceLogger.isLogging()) break block27;
                                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error during discover Fabrics getting the Scanners for inband agent with ID = " + inbandAgents[m].getGuid() + ".");
                                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exp);
                                }
                            }
                            for (int z = 0; z < tempScanners2.length; ++z) {
                                parms = new Hashtable<String, Object>();
                                parms.put("AGENT", new String[]{inbandAgents[m].getIpAddress() + ":" + inbandAgents[m].getPort(), inbandAgents[m].getVersion(), inbandAgents[m].getHostId()});
                                if (tempScanners2[z].getType().equals("PI1")) {
                                    parms.put("SCANNER", "Topology");
                                } else if (tempScanners2[z].getType().equals("PI2")) {
                                    parms.put("SCANNER", "AttributePEOnly");
                                }
                                if (tempScanners2[z].getEnabled() != 0 && inbandAgents[m].getStatus().trim().equals("AC")) {
                                    Router.getRouter().perform(Discover.discoverViaInband, parms, new Integer(discoverRequest.getId()).toString());
                                    continue;
                                }
                                if (tempScanners2[z].getInactiveProcessed() != 0) continue;
                                Router.getRouter().perform(Discover.ProcessMissingInbandAgent, parms, new Integer(discoverRequest.getId()).toString());
                            }
                        }
                        continue;
                    }
                    catch (Exception exc) {
                        msgInserts[0] = "DiscoverFabrics";
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
                        if (!traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error during discover Fabrics getting the Device Agents.");
                        traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
                        continue;
                    }
                }
                if (agentType != FabricManagerConstants.CIMType) continue;
                try {
                    ArrayList cimomList = this.getSwitchCIMOMs();
                    if (cimomList == null) continue;
                    for (String[] cimomParms : cimomList) {
                        Hashtable<String, String[]> parms2 = new Hashtable<String, String[]>();
                        if (!agentList.isEmpty() && !agentList.contains(cimomParms[0])) continue;
                        parms2.put("CIMOM", cimomParms);
                        String[] requestIds = Router.getRouter().perform(Discover.discoverCimomMetadata, parms2, new Integer(discoverRequest.getId()).toString());
                        Router.getRouter().waitTilComplete(requestIds);
                        Router.getRouter().perform(Discover.discoverFabricViaSMIS, parms2, new Integer(discoverRequest.getId()).toString());
                    }
                }
                catch (Exception exc) {
                    msgInserts[0] = "DiscoverFabrics";
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error during discover Fabrics getting the CIMOMs.");
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
                }
            }
            tempScanners = null;
            try {
                tempScanners = this.getScannersWithoutAgent();
            }
            catch (Exception exp) {
                msgInserts[0] = "null agent";
                msgInserts[1] = "";
                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.SCANNER_NOT_FOUND, msgInserts);
                if (!traceLogger.isLogging()) break block28;
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error during probe Fabric Agents getting the Scanners without an outband agent");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exp);
            }
        }
        if (tempScanners != null) {
            for (int z = 0; z < tempScanners.length; ++z) {
                if (tempScanners[z].getInactiveProcessed() != 0) continue;
                Hashtable<String, Object> parms = new Hashtable<String, Object>();
                parms.put("IPADDRESS", new String[]{tempScanners[z].getAgentName()});
                parms.put("SCANNER", tempScanners[z].getType());
                Router.getRouter().perform(Discover.ProcessMissingSNMPAgent, parms, new Integer(discoverRequest.getId()).toString());
            }
        }
        return new Result(0);
    }

    /*
     * Loose catch block
     */
    public SNMPAgent[] getSNMPAgents() throws ServerException {
        ArrayList<SNMPAgent> agents;
        block19: {
            Exception e22;
            IpTarget.IpTargetCursor cursor;
            DBConnection connection;
            String methodName;
            block16: {
                methodName = "getSNMPAgents";
                agents = new ArrayList<SNMPAgent>();
                connection = ServiceUtils.getConnection();
                cursor = null;
                cursor = IpTarget.getCursor((DBConnection)connection, null, null);
                while (cursor.next()) {
                    IpTarget target = cursor.getObject();
                    agents.add(new SNMPAgent(target.getIpAddress(), target.getHostName(), target.getReadCommunityName(), target.getUserId(), target.getPassword()));
                }
                connection.commit();
                Object var8_7 = null;
                if (cursor == null) break block16;
                try {
                    cursor.close();
                }
                catch (Exception e22) {
                    if (!traceLogger.isLogging()) break block16;
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e22);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e22) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e22);
                    }
                }
            }
            break block19;
            {
                catch (Exception e3) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e3);
                    }
                    String[] params = new String[]{methodName};
                    throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, params));
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Exception e22;
                    block17: {
                        Object var8_8 = null;
                        if (cursor != null) {
                            try {
                                cursor.close();
                            }
                            catch (Exception e22) {
                                if (!traceLogger.isLogging()) break block17;
                                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e22);
                            }
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception e22) {
                            if (!traceLogger.isLogging()) break block18;
                            traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)e22);
                        }
                    }
                }
                throw throwable;
            }
        }
        return agents.toArray(new SNMPAgent[0]);
    }

    public DeviceAgent[] getDeviceServerAgents() throws ServerException {
        String methodName = "getDeviceServerAgents";
        Object[] msgInserts = new String[2];
        DeviceAgent[] result = null;
        try {
            result = FabricDbAccess.getDeviceAgents();
            if (result == null) {
                result = new DeviceAgent[]{};
            }
        }
        catch (Exception exc) {
            msgInserts[0] = "dbAccessor.getDeviceAgents";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error getting Device Server agents.");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        return result;
    }

    public FabricScanner[] getScannersForAgent(String aAgentId) throws ServerException {
        String methodName = "getScannersForAgent";
        Object[] msgInserts = new String[2];
        FabricScanner[] result = null;
        try {
            result = FabricDbAccess.getScannersForAgent((String)aAgentId);
            if (result == null) {
                result = new FabricScanner[]{};
            }
        }
        catch (Exception exc) {
            msgInserts[0] = "getScannersForAgent";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error getting Scanners for Agent with id = " + aAgentId + ".");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        return result;
    }

    public FabricScanner[] getScannersWithoutAgent() throws ServerException {
        String methodName = "getScannersWithoutAgent";
        Object[] msgInserts = new String[2];
        FabricScanner[] result = null;
        try {
            result = FabricDbAccess.getScannersWithoutAgent();
            if (result == null) {
                result = new FabricScanner[]{};
            }
        }
        catch (Exception exc) {
            msgInserts[0] = "getScannersForAgent";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, methodName, FabricMsgConsts.OPERATION_FAILED, msgInserts);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error getting Scanners without Agent.");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, methodName, (Throwable)exc);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])msgInserts));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getSwitchCIMOMs() throws ServerException {
        methodName = "getCIMOMs";
        values = new ArrayList<String[]>();
        connection = ServiceUtils.getConnection();
        try {
            sql = " Select distinct cimom.SERVICE_URL as SERVICE_URL, cimom.USER_ID as USER_ID, cimom.PASSWORD as PASSWORD, namespace.NAMESPACE as NAMESPACE from T_RES_REGISTERED_CIMOM cimom, T_RES_CIMOM2NAMESPACE namespace, T_RES_CIMKEY_SWITCH cimkeyswitch where namespace.CIMOM_ID = cimom.REG_CIMOM_ID AND namespace.CIM_NAMESPACE_ID = cimkeyswitch.CIM_NAMESPACE_ID";
            if (ProbeFabricAgents.traceLogger.isLogging()) {
                ProbeFabricAgents.traceLogger.text(IRecordType.TYPE_INFO, (Object)ProbeFabricAgents.className, "getCIMOMs", "getCIMOMs SQL is: " + sql);
            }
            dbr = null;
            try {
                dbr = ComplexQuery.sqlQuery((DBConnection)connection, (String)sql, null);
                while (dbr.next()) {
                    block34: {
                        password = dbr.getString("PASSWORD");
                        if (password != null) {
                            try {
                                password = SRMCrypto.decrypt((String)password);
                            }
                            catch (Exception pEx) {
                                if (!ProbeFabricAgents.traceLogger.isLogging()) break block34;
                                ProbeFabricAgents.traceLogger.text(IRecordType.TYPE_ERROR, (Object)ProbeFabricAgents.className, "getCIMOMs", "Failed to decrypt password " + (String)password + " for CIMOM " + dbr.getString("SERVICE_URL") + "due to " + pEx.getMessage());
                                ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)pEx);
                            }
                        }
                    }
                    values.add(new String[]{dbr.getString("SERVICE_URL"), dbr.getString("NAMESPACE"), dbr.getString("USER_ID"), password});
                    if (!ProbeFabricAgents.traceLogger.isLogging()) continue;
                    msg = "Found CIMOM, URL = " + dbr.getString("SERVICE_URL") + ", NAMESPACE = " + dbr.getString("NAMESPACE") + ", USER_ID = " + dbr.getString("USER_ID");
                    ProbeFabricAgents.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)ProbeFabricAgents.className, "getCIMOMs", msg);
                }
                password = values;
                var11_13 = null;
                if (connection == null) return password;
                ** GOTO lbl93
            }
            catch (Exception e) {
                ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                if (!ProbeFabricAgents.traceLogger.isLogging()) ** GOTO lbl109
                ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                ** GOTO lbl109
            }
            finally {
                block35: {
                    try {
                        if (dbr != null) {
                            dbr.getStatement().close();
                        }
                    }
                    catch (Exception e) {
                        ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                        if (!ProbeFabricAgents.traceLogger.isLogging()) break block35;
                        ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            block36: {
                ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                if (ProbeFabricAgents.traceLogger.isLogging()) {
                    ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                }
                var11_15 = null;
                if (connection == null) return values;
                try {
                    connection.commit();
                }
                catch (Exception e) {
                    ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                    if (!ProbeFabricAgents.traceLogger.isLogging()) break block36;
                    ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                }
            }
            try {
                connection.close();
                return values;
            }
            catch (Exception e) {
                ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                if (ProbeFabricAgents.traceLogger.isLogging() == false) return values;
                ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                return values;
            }
        }
        {
            block39: {
                block38: {
                    catch (Throwable var10_23) {
                        block37: {
                            var11_16 = null;
                            if (connection == null) throw var10_23;
                            ** try [egrp 8[TRYBLOCK] [14 : 674->681)] { 
lbl78:
                            // 1 sources

                            connection.commit();
                            break block37;
lbl80:
                            // 1 sources

                            catch (Exception e) {
                                ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                                if (!ProbeFabricAgents.traceLogger.isLogging()) break block37;
                                ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                            }
                        }
                        ** try [egrp 9[TRYBLOCK] [15 : 730->737)] { 
lbl86:
                        // 1 sources

                        connection.close();
                        throw var10_23;
lbl88:
                        // 1 sources

                        catch (Exception e) {
                            ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                            if (ProbeFabricAgents.traceLogger.isLogging() == false) throw var10_23;
                            ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                        }
                        throw var10_23;
                    }
lbl93:
                    // 1 sources

                    ** try [egrp 8[TRYBLOCK] [14 : 674->681)] { 
lbl94:
                    // 1 sources

                    connection.commit();
                    break block38;
lbl96:
                    // 1 sources

                    catch (Exception e) {
                        ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                        if (!ProbeFabricAgents.traceLogger.isLogging()) break block38;
                        ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                    }
                }
                try {}
                catch (Exception e) {
                    ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                    if (ProbeFabricAgents.traceLogger.isLogging() == false) return password;
                    ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                    return password;
                }
                connection.close();
                return password;
lbl109:
                // 2 sources

                var11_14 = null;
                if (connection == null) return values;
                ** try [egrp 8[TRYBLOCK] [14 : 674->681)] { 
lbl112:
                // 1 sources

                connection.commit();
                break block39;
lbl114:
                // 1 sources

                catch (Exception e) {
                    ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                    if (!ProbeFabricAgents.traceLogger.isLogging()) break block39;
                    ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
                }
            }
            try {}
            catch (Exception e) {}
            ProbeFabricAgents.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
            if (ProbeFabricAgents.traceLogger.isLogging() == false) return values;
            ProbeFabricAgents.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)ProbeFabricAgents.className, "getCIMOMs", (Throwable)e);
            return values;
            connection.close();
            return values;
        }
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.FabricManager");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.FabricManager");
        msgLogger.setMessageFile(FabricManagerConstants.MSG_FILE);
    }
}

