/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.event.data.NoSnmpDestinationException;
import org.eclipse.aperi.sanmgmt.event.data.SnmpAddress;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

class DestinationFactory {
    private ILogger msgLogger = null;
    private ILogger traceLogger = null;
    private IConfigService dbParms = null;
    private static final String TEC_SERVER_LOCATION_KEY = "TECServerLocation";
    private static final String TEC_SERVER_PORT_KEY = "TECServerPort";
    private static final String TEC_DEBUG_MODE_KEY = "TECDebugMode";
    public static final int DEFAULT_TEC_PORTNUM = 0;
    private ArrayList snmpAddrList = null;
    private String tecServerLocation = null;
    private int tecServerPort = 0;
    private String tecDebugMode = "NO";
    private String callBackURL = null;
    private static final String className = DestinationFactory.class.getName();

    DestinationFactory(ILogger msgLogger, ILogger traceLogger, IConfigService dbParms) {
        String methodName = "DestinationFactory";
        this.msgLogger = msgLogger;
        this.traceLogger = traceLogger;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, "DestinationFactory");
        }
        this.dbParms = dbParms;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "DestinationFactory");
        }
    }

    synchronized boolean init() {
        boolean successCode;
        block4: {
            String methodName = "init";
            successCode = false;
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "init");
            }
            try {
                this.snmpAddrList = this.retrieveAllSnmpAddr();
                this.tecServerLocation = this.retrieveTECServerLocation();
                this.tecServerPort = this.retrieveTECServerPort();
                this.tecDebugMode = this.retrieveTECDebugMode();
                String managerLoc = this.dbParms.getProperty("manager.loc", "setup");
                String managerPort = this.dbParms.getProperty("manager.port", "setup");
                this.callBackURL = managerLoc + ":" + managerPort;
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "init", "callBackURL=" + this.callBackURL);
                this.dbParms.register(TEC_SERVER_LOCATION_KEY, "user", this.callBackURL, "SANEvent");
                this.dbParms.register(TEC_SERVER_PORT_KEY, "user", this.callBackURL, "SANEvent");
                successCode = true;
            }
            catch (Exception e) {
                this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "init", "SANEventMessage_ErrorReadingSnmpTECAddresses", (Object)"user");
                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "init", (Throwable)e);
                if (!this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "init", (Throwable)e);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "init");
        }
        return successCode;
    }

    synchronized void close() {
        String methodName = "close";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "close");
        }
        this.dbParms.deRegister(TEC_SERVER_LOCATION_KEY, "user", this.callBackURL, "SANEvent");
        this.dbParms.deRegister(TEC_SERVER_PORT_KEY, "user", this.callBackURL, "SANEvent");
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "close");
        }
    }

    public synchronized void propCallback(String name, String group, String value) {
        block8: {
            String methodName = "propCallback";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "propCallback", (Object)("name=" + name + ", group=" + group + ", value=" + value));
            }
            if (group.equals("user")) {
                if (name.equals(TEC_SERVER_LOCATION_KEY)) {
                    this.tecServerLocation = value;
                } else if (name.equals(TEC_SERVER_PORT_KEY)) {
                    try {
                        this.tecServerPort = value == null || value.equals("") ? 0 : Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block8;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "propCallback", (Throwable)e);
                    }
                }
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "propCallback", (Object)("tecServerLocation = " + this.tecServerLocation + ", tecServerPort = " + this.tecServerPort));
        }
    }

    synchronized ArrayList getAllSnmpAddr() {
        return this.snmpAddrList;
    }

    synchronized String getTECServerLocation() {
        return this.tecServerLocation;
    }

    synchronized int getTECServerPort() {
        return this.tecServerPort;
    }

    synchronized String getTECDebugMode() {
        return this.tecDebugMode;
    }

    ArrayList retrieveAllSnmpAddr() {
        String methodName = "retrieveAllSnmpAddr";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "retrieveAllSnmpAddr");
        }
        ArrayList<SnmpAddress> snmpList = new ArrayList<SnmpAddress>();
        ArrayList keys = this.dbParms.getKeys("user");
        if (!keys.isEmpty()) {
            String key = null;
            for (int i = 0; i < keys.size(); ++i) {
                SnmpAddress temp;
                key = (String)keys.get(i);
                if (!this.dbParms.getProperty(key, "user").equals("SnmpAddress") || (temp = this.stringToSnmpAddr(key)) == null) continue;
                snmpList.add(temp);
                if (!this.traceLogger.isLogging()) continue;
                try {
                    this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, "retrieveAllSnmpAddr", "Snmp Destination = " + temp.getSnmpDestination() + ", port = " + temp.getSnmpPort() + ", community = " + temp.getCommunityName());
                    continue;
                }
                catch (NoSnmpDestinationException e) {
                    // empty catch block
                }
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "retrieveAllSnmpAddr");
        }
        return snmpList;
    }

    String retrieveTECServerLocation() {
        String methodName = "retrieveTECServerLocation";
        if (this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "retrieveTECServerLocation");
        }
        String location = null;
        location = this.dbParms.getProperty(TEC_SERVER_LOCATION_KEY, "user");
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "retrieveTECServerLocation", (Object)("TEC Server location = " + location));
        }
        return location;
    }

    int retrieveTECServerPort() {
        int port;
        block6: {
            String methodName = "getTECServerPort";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "getTECServerPort");
            }
            port = 0;
            String serverPort = null;
            try {
                serverPort = this.dbParms.getProperty(TEC_SERVER_PORT_KEY, "user");
                if (serverPort != null && !serverPort.equals("")) {
                    port = Integer.parseInt(serverPort);
                }
            }
            catch (Exception e) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getTECServerPort", (Throwable)e);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "getTECServerPort", (Throwable)e);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "getTECServerPort", (Object)("TEC Server port = " + port));
        }
        return port;
    }

    String retrieveTECDebugMode() {
        String debugMode;
        block6: {
            String methodName = "retrieveTECDebugMode";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "retrieveTECDebugMode");
            }
            debugMode = null;
            try {
                debugMode = this.dbParms.getProperty(TEC_DEBUG_MODE_KEY, "user");
                if (debugMode == null || debugMode.equals("")) {
                    debugMode = "NO";
                }
            }
            catch (Exception e) {
                if (this.msgLogger != null) {
                    this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "retrieveTECDebugMode", (Throwable)e);
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "retrieveTECDebugMode", (Throwable)e);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "retrieveTECDebugMode", (Object)("TEC Debug Mode = " + debugMode));
        }
        return debugMode;
    }

    public synchronized boolean setSnmpAddr(SnmpAddress snmpAddr) {
        boolean result;
        block11: {
            String methodName = "setSnmpAddr";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "setSnmpAddr");
            }
            result = false;
            String key = this.snmpAddrToString(snmpAddr);
            if (key != null) {
                try {
                    int rc = this.dbParms.setProperty(key, "user", "SnmpAddress");
                    if (rc != 0) {
                        if (this.msgLogger != null) {
                            this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "setSnmpAddr", "SANEventMessage_snmpAddrNotSaved", (Object)"user.properties");
                        }
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, "setSnmpAddr", "Unable to save SnmpAddr entry to USER Properties table.");
                        }
                    } else {
                        int index = this.snmpAddrList.indexOf(snmpAddr);
                        if (index == -1) {
                            this.snmpAddrList.add(snmpAddr);
                        }
                    }
                }
                catch (Exception e) {
                    if (this.msgLogger != null) {
                        this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setSnmpAddr", (Throwable)e);
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block11;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "setSnmpAddr", (Throwable)e);
                }
            }
        }
        result = true;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "setSnmpAddr");
        }
        return result;
    }

    public synchronized boolean deleteSnmpAddr(SnmpAddress snmpAddr) {
        boolean result;
        block11: {
            String methodName = "deleteSnmpAddr";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "deleteSnmpAddr");
            }
            result = false;
            String key = this.snmpAddrToString(snmpAddr);
            if (key != null) {
                try {
                    int rc = this.dbParms.remove(key, "user");
                    if (rc != 0) {
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, "deleteSnmpAddr", "Unable to delete SnmpAddr entry from the USER Properties table.");
                        }
                        if (this.msgLogger != null) {
                            this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "deleteSnmpAddr", "SANEventMessage_snmpAddrNotRemoved", (Object)"user.properties");
                        }
                    } else {
                        int index = this.snmpAddrList.indexOf(snmpAddr);
                        if (index != -1) {
                            this.snmpAddrList.remove(index);
                        }
                    }
                }
                catch (Exception e) {
                    if (this.msgLogger != null) {
                        this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "deleteSnmpAddr", (Throwable)e);
                    }
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block11;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "deleteSnmpAddr", (Throwable)e);
                }
            }
        }
        result = true;
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "deleteSnmpAddr");
        }
        return result;
    }

    private String snmpAddrToString(SnmpAddress snmpAddr) {
        String communityName;
        String port;
        String destination;
        block10: {
            String methodName = "snmpAddrToString";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "snmpAddrToString");
            }
            destination = null;
            port = null;
            communityName = null;
            try {
                destination = snmpAddr.getSnmpDestination();
            }
            catch (NoSnmpDestinationException ex) {
                if (this.msgLogger != null) {
                    this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "snmpAddrToString", "SANEventMessage_NoSnmpDestinationException");
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block10;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "snmpAddrToString", (Throwable)ex);
            }
        }
        if (destination == null) {
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "snmpAddrToString");
            }
            return null;
        }
        try {
            port = Integer.toString(snmpAddr.getSnmpPort());
        }
        catch (Exception ex) {
            port = "-1";
        }
        communityName = snmpAddr.getCommunityName();
        if (communityName == null) {
            communityName = "";
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "snmpAddrToString");
        }
        return destination + "?" + port + "?" + communityName;
    }

    private SnmpAddress stringToSnmpAddr(String key) {
        SnmpAddress snmpAddr;
        block7: {
            String methodName = "stringToSnmpAddr";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "stringToSnmpAddr");
            }
            String destination = null;
            int port = -1;
            String communityName = null;
            StringTokenizer st = new StringTokenizer(key, "?");
            if (!st.hasMoreTokens()) {
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "stringToSnmpAddr");
                }
                return null;
            }
            destination = st.nextToken();
            port = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : -1;
            communityName = st.hasMoreTokens() ? st.nextToken() : "";
            snmpAddr = null;
            try {
                snmpAddr = new SnmpAddress(destination, port, communityName);
            }
            catch (NoSnmpDestinationException ex) {
                if (this.msgLogger != null) {
                    this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "stringToSnmpAddr", "SANEventMessage_NoSnmpDestinationException");
                }
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block7;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "stringToSnmpAddr", (Throwable)ex);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "stringToSnmpAddr");
        }
        return snmpAddr;
    }
}

