/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import java.util.Vector;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpTrapSession;

public class SnmpTrapProcessor
implements Runnable {
    public static ILogger msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.event");
    public static ILogger traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.event");
    static final String className;
    private Vector eventQueue = new Vector();
    private Thread workerThread = null;
    private static SnmpTrapProcessor myThread;
    private static long MAXNUMBEROFTRAP;
    private SnmpTrapSession session = null;

    public SnmpTrapProcessor(SnmpTrapSession session) {
        this.session = session;
    }

    public void start() {
        String methodName = "start";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (this.workerThread == null) {
            this.workerThread = new Thread(this);
            this.workerThread.start();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.workerThread = null;
        SnmpTrapProcessor snmpTrapProcessor = this;
        synchronized (snmpTrapProcessor) {
            this.notifyAll();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String methodName;
        block15: {
            methodName = "run";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            try {
                Thread curThread = Thread.currentThread();
                while (this.workerThread == curThread) {
                    String messageInfo;
                    try {
                        while (this.eventQueue.isEmpty()) {
                            SnmpTrapProcessor snmpTrapProcessor = this;
                            synchronized (snmpTrapProcessor) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                if (this.workerThread == null) {
                                    this.session.close();
                                    if (traceLogger.isLogging()) {
                                        messageInfo = "SnmpTrapProcessor was shutdown";
                                        traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, messageInfo);
                                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                                    }
                                    return;
                                }
                            }
                        }
                        SnmpTrap trap = (SnmpTrap)this.eventQueue.firstElement();
                        this.eventQueue.remove(0);
                        this.sendSnmpTrap(trap);
                    }
                    catch (Exception e) {
                        messageInfo = "Failed to send snmp trap";
                        if (!traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, messageInfo);
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
            catch (Exception pe) {
                String messageInfo = "Failed to start SnmpTrapProcessor.";
                if (!traceLogger.isLogging()) break block15;
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, messageInfo);
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)pe);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSnmpTrap(SnmpTrap trap) {
        String methodName = "addSnmpTrap";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)new String("SnmpTrap"));
        }
        if ((long)this.eventQueue.size() < MAXNUMBEROFTRAP) {
            this.eventQueue.addElement(trap);
        } else {
            if (!this.eventQueue.isEmpty()) {
                this.eventQueue.remove(0);
            }
            this.eventQueue.addElement(trap);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "Trap queue is full, so delete the oldest and add the new one.");
        }
        SnmpTrapProcessor snmpTrapProcessor = this;
        synchronized (snmpTrapProcessor) {
            this.notifyAll();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void sendSnmpTrap(SnmpTrap trap) {
        String methodName;
        block6: {
            methodName = "sendSnmpTrap";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)new String("SnmpTrap"));
            }
            try {
                if (this.session != null) {
                    this.session.send(trap);
                }
                if (traceLogger.isLogging()) {
                    String messageInfo = "Snmp trap was sent successfully";
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this, methodName, messageInfo);
                }
            }
            catch (Exception e) {
                String messageInfo = "Failed to send snmp trap";
                if (!traceLogger.isLogging()) break block6;
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, messageInfo);
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    static {
        msgLogger.setMessageFile("org.eclipse.aperi.sanmgmt.event.resources.SANEventService");
        className = SnmpTrapProcessor.class.getName();
        myThread = null;
        MAXNUMBEROFTRAP = 1000L;
    }
}

