/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.scanner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.aperi.agent.scanner.InbandZoneControl;
import org.eclipse.aperi.agent.scanner.ScannerProcess;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogFileHandler;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response;
import org.eclipse.aperi.sanmgmt.subagent.scanner.interfaces.IScanner;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.Command;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.IZoneControlAgent;
import org.eclipse.aperi.sanmgmt.util.InterpResolver;

public class Scanner
implements IScanner,
IService,
IZoneControlAgent {
    private static final long serialVersionUID = 20001130L;
    static final String MESSAGE_NAME = "aperi.logger.message.SanAgent_Scanner";
    static final String TRACE_NAME = "aperi.logger.trace.SanAgent_Scanner";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    static final String className = Scanner.class.getName();
    private String executableLocation = null;
    private StringBuffer nativeBinDirectory = null;
    private StringBuffer subagentHomeDirectory = null;
    private StringBuffer valuePath = null;
    private StringBuffer valueSystemroot = null;
    private StringBuffer valueLdlibrarypath = null;
    public static final String w32ix86 = "w32-ix86";
    public static final String winnt = "Windows NT";
    public static final String win2k = "Windows 2000";
    private static String MSG_FILE = "org.eclipse.aperi.sanmgmt.sanmgr.resources.ScannerTMS";
    private Status status = new Status(5, 9);
    private String description = "Collects data on agents";
    private String guid = null;
    private Vector<ScannerProcess> procs = new Vector();
    private Object procsVectorLock = new Object();
    private boolean shutdownInvoked = false;
    private static final String FULL_SCAN_OPT = "";
    private static final String FS_SCAN_OPT = "FS";
    private static final String VG_SCAN_OPT = "VG";
    private static final String PE_SCAN_OPT = "PE";
    private InbandZoneControl izc = null;

    public Scanner() {
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        if (msgLogger != null) {
            msgLogger.setMessageFile(MSG_FILE);
        }
    }

    public Response invoke(String scanner, String target) {
        String methodName = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(" with scanner = " + scanner + "target = " + target));
        }
        if (scanner.equalsIgnoreCase("AttributePEOnly")) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Invoking Attribute scanner with PE option...");
            }
            return this.invoke("Attribute", target, 3, null);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Invoking " + scanner + " scanner with FULL option...");
        }
        return this.invoke(scanner, target, 0, null);
    }

    public Response invoke(String scanner, String target, int option) {
        String methodName = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(" with scanner = " + scanner + "target = " + target + " option = " + option));
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Invoking " + scanner + " scanner with specified option...");
        }
        return this.invoke(scanner, target, option, null);
    }

    public Response invoke(String scanner, String target, String benchmarkLabel) {
        String methodName = "invoke";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)(" with scanner = " + scanner + "target = " + target + " benchmarkLabel = " + benchmarkLabel));
        }
        if (scanner.equalsIgnoreCase("AttributePEOnly")) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Invoking Attribute scanner with PE option and benchmark comparison...");
            }
            return this.invoke("Attribute", target, 3, benchmarkLabel);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Invoking " + scanner + " scanner with FULL option and benchmark comparison...");
        }
        return this.invoke(scanner, target, 0, benchmarkLabel);
    }

    /*
     * Exception decompiling
     */
    public Response invoke(String scanner, String target, int option, String benchmarkLabel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return "SANAgentScanner";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("Scanner_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("Scanner_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        String methodName = "shutdown";
        Process proc = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.shutdownInvoked = true;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Set shutdownInvoked to true");
        }
        Object object = this.procsVectorLock;
        synchronized (object) {
            for (ScannerProcess scannerProcess : this.procs) {
                if (scannerProcess != null) {
                    proc = scannerProcess.getProc();
                }
                if (proc == null) continue;
                proc.destroy();
                if (traceLogger == null || !traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Killed a unterminated scanner");
            }
            this.procsVectorLock.notifyAll();
        }
        this.status.setRunStatus(10);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    public boolean startup() {
        boolean success;
        String methodName;
        block42: {
            File rnidFile;
            block41: {
                methodName = "startup";
                success = false;
                rnidFile = null;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
                }
                this.status.setRunStatus(9);
                this.executableLocation = this.getExecutableLocation();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "executableLocation = " + this.executableLocation);
                }
                if (this.executableLocation.equals(FULL_SCAN_OPT) && traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Unable to get executable location...Default to current directory...");
                }
                try {
                    if (this.executableLocation == null) {
                        this.executableLocation = new String(FULL_SCAN_OPT);
                    }
                    this.nativeBinDirectory = new StringBuffer(Variables.getNativeLibDirectory());
                    if (this.nativeBinDirectory == null) {
                        this.nativeBinDirectory = new StringBuffer(FULL_SCAN_OPT);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "nativeBinDirectory is " + this.nativeBinDirectory);
                    }
                    this.subagentHomeDirectory = new StringBuffer(Variables.getBaseDirectory());
                    if (this.subagentHomeDirectory == null) {
                        this.subagentHomeDirectory = new StringBuffer(FULL_SCAN_OPT);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "subAgentHomeDirectory is " + this.subagentHomeDirectory);
                    }
                }
                catch (Exception e) {
                    if (msgLogger != null) {
                        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "Got Exception: Unable to nativeBinDirectory or subAgentHomeDirectory");
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    this.nativeBinDirectory = new StringBuffer(FULL_SCAN_OPT);
                    this.subagentHomeDirectory = new StringBuffer(FULL_SCAN_OPT);
                }
                try {
                    String interpValue;
                    String envValue = Variables.getEnvironmentValue((String)"PATH");
                    this.valuePath = envValue != null ? new StringBuffer(envValue) : new StringBuffer(FULL_SCAN_OPT);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "getEnvValue for PATH returned " + this.valuePath);
                    }
                    if ((interpValue = this.getInterp()) != null && interpValue.equals(w32ix86)) {
                        envValue = Variables.getEnvironmentValue((String)"SYSTEMROOT");
                        this.valueSystemroot = envValue != null ? new StringBuffer(envValue) : new StringBuffer(FULL_SCAN_OPT);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "getEnvValue for SYSTEMROOT returned " + this.valueSystemroot);
                        }
                    } else {
                        this.valueSystemroot = new StringBuffer(FULL_SCAN_OPT);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "getEnvValue for SYSTEMROOT returned " + this.valueSystemroot);
                        }
                    }
                    if (interpValue != null && interpValue.equals(w32ix86)) {
                        this.valueLdlibrarypath = new StringBuffer(FULL_SCAN_OPT);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "getEnvValue for LD_LIBRARY_PATH returned " + this.valueLdlibrarypath);
                        }
                    } else {
                        envValue = Variables.getEnvironmentValue((String)"LD_LIBRARY_PATH");
                        this.valueLdlibrarypath = envValue != null ? new StringBuffer(envValue) : new StringBuffer(FULL_SCAN_OPT);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "getEnvValue for LD_LIBRARY_PATH returned " + this.valueLdlibrarypath);
                        }
                    }
                }
                catch (Exception e) {
                    if (msgLogger != null) {
                        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                    if (traceLogger == null || !traceLogger.isLogging()) break block41;
                    traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "Got Exception: getEnvValue");
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            try {
                rnidFile = new File(this.executableLocation + "RNID");
                if (rnidFile.exists()) {
                    rnidFile.delete();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, this.executableLocation + "RNID" + " File exists, deleting");
                    }
                } else if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, this.executableLocation + "RNID" + " File does not exist");
                }
            }
            catch (Exception e) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block42;
                traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "Got Exception: Unable to getEnvValue");
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        this.guid = GUID.readGUID().toString();
        if (this.guid == null || this.guid.equals(FULL_SCAN_OPT)) {
            if (msgLogger != null) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "Scanner_getGuidError");
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, "Failed to get GUID");
            }
        } else {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "GUID = " + this.guid);
            }
            success = true;
        }
        if (this.izc == null) {
            this.izc = new InbandZoneControl();
        }
        if (success) {
            this.status.setRunStatus(8);
            if (msgLogger != null) {
                msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "Scanner_serviceReady");
            }
        } else {
            this.status.setRunStatus(2);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return success;
    }

    public boolean isAlive() {
        return true;
    }

    private boolean compare(String[] data, String[] oldData) {
        String methodName = "compare";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName + " with benchmark");
        }
        StringBuffer fullData = new StringBuffer(FULL_SCAN_OPT);
        for (int i = 0; i < data.length; ++i) {
            fullData.append(data[i]);
        }
        StringBuffer fullOldData = new StringBuffer(FULL_SCAN_OPT);
        for (int i = 0; i < oldData.length; ++i) {
            fullOldData.append(oldData[i]);
        }
        boolean same = fullData.toString().equals(fullOldData.toString());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)(same ? "Match with benchmark" : "Mismatch with benchmark"));
        }
        return same;
    }

    private String getExecutableLocation() {
        String methodName = "getExecutableLocation";
        String exeLoc = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        exeLoc = Variables.getExecutableDirectory();
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return exeLoc;
    }

    private String getInterp() {
        String methodName = "getInterp";
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Calling InterpResolver.getInterp with osName: " + osName + ", osVersion: " + osVersion + ", osArch: " + osArch);
        }
        String interp = InterpResolver.getInterp((String)osName, (String)osVersion, (String)osArch);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)("interp = " + interp));
        }
        return interp;
    }

    private synchronized Response performBMCompare(int returnCode, String[] sData, String scanner, String benchmarkLabel) {
        String methodName = "performBMCompare";
        int oldLevel = -1;
        String[] oldData = new String[]{};
        boolean same = false;
        String bmFile = null;
        File BMfile = null;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        try {
            bmFile = this.executableLocation + scanner + ".BM_" + benchmarkLabel;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "bmFile = " + bmFile);
            }
            if ((BMfile = new File(bmFile)).exists()) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Reading benchmark file...");
                }
                FileInputStream in = new FileInputStream(bmFile);
                ObjectInputStream inStream = new ObjectInputStream(in);
                oldLevel = (Integer)inStream.readObject();
                oldData = (String[])inStream.readObject();
                in.close();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Comparing data to benchmark with oldLevel = " + oldLevel);
                }
                same = this.compare(sData, oldData);
            }
        }
        catch (Exception e) {
            if (msgLogger != null) {
                BMfile.delete();
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "Scanner_readBenchmarkError", (Object)bmFile);
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            same = false;
            oldLevel = -1;
        }
        if (same) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Data for scanner " + scanner + " benchmark label " + benchmarkLabel + " is same as current benchmark");
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, returnCode);
            }
            return new Response(returnCode, sData, oldLevel, oldLevel, benchmarkLabel, same);
        }
        try {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Saving benchmark file...");
            }
            FileOutputStream out = new FileOutputStream(bmFile);
            ObjectOutputStream outStream = new ObjectOutputStream(out);
            Integer newLevel = new Integer(oldLevel < 1000 ? oldLevel + 1 : 0);
            outStream.writeObject(newLevel);
            outStream.writeObject(sData);
            out.close();
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Saved data as benchmark with newLevel = " + newLevel);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, returnCode);
            }
            return new Response(returnCode, sData, newLevel.intValue(), oldLevel, benchmarkLabel, same);
        }
        catch (Exception e) {
            if (msgLogger != null) {
                BMfile.delete();
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "Scanner_saveBenchmarkError");
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, returnCode);
            }
            return new Response(returnCode, sData);
        }
    }

    public String[] readString(InputStream in) {
        Vector<String> dataVector;
        String methodName;
        block10: {
            methodName = "readString";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            dataVector = new Vector<String>();
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader bufReader = new BufferedReader(isr);
            int pos = 0;
            String errorOutput = "TOS error";
            String xmlStart = "<";
            boolean xmlCharRead = false;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "readString with filter for error messages embedded in xml\n");
            }
            try {
                String data;
                while ((data = bufReader.readLine()) != null) {
                    pos = data.indexOf(errorOutput);
                    if (pos == -1) {
                        if (!xmlCharRead) {
                            pos = data.indexOf(xmlStart);
                            if (pos == -1) {
                                if (traceLogger == null || !traceLogger.isLogging()) continue;
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "scanner output filtered is " + data + "\n");
                                continue;
                            }
                            xmlCharRead = true;
                            dataVector.add(data.substring(pos));
                            continue;
                        }
                        dataVector.add(data);
                        continue;
                    }
                    if (traceLogger == null || !traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "scanner output filtered is " + data + "\n");
                }
            }
            catch (IOException e) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "Scanner_retrieveDataError");
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block10;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        String[] result = new String[dataVector.size()];
        dataVector.toArray(result);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public int lock(String resource, String[] parameters) {
        return this.izc.lock(resource, parameters);
    }

    public int startTransaction(String SAN) {
        return this.izc.startTransaction(SAN);
    }

    public int commitTransaction(String SAN) {
        return this.izc.commitTransaction(SAN);
    }

    public int rollbackTransaction(String SAN) {
        return this.izc.rollbackTransaction(SAN);
    }

    public int release(String resource) {
        return this.izc.release(resource);
    }

    public int sendCommandArray(String SAN, Command[] commands) {
        return this.izc.sendCommandArray(SAN, commands);
    }

    public int setZoneInfo(String SAN, ZoneDefinition definition, int zone_db_code) {
        return this.izc.setZoneInfo(SAN, definition, zone_db_code);
    }

    public int createZoneSet(String SAN, String zoneSetName) {
        return this.izc.createZoneSet(SAN, zoneSetName);
    }

    public int createZone(String SAN, String zoneName, short zoneType, short zoneSubType) {
        return this.izc.createZone(SAN, zoneName, zoneType, zoneSubType);
    }

    public int createZoneAlias(String SAN, String zoneAliasName) {
        return this.izc.createZoneAlias(SAN, zoneAliasName);
    }

    public int createZoneMemberSettingData(String SAN, short enumType, String id, short targType, String targName) {
        return this.izc.createZoneMemberSettingData(SAN, enumType, id, targType, targName);
    }

    public int addZoneToZoneSet(String SAN, String zoneSetName, String zoneName) {
        return this.izc.addZoneToZoneSet(SAN, zoneSetName, zoneName);
    }

    public int addZoneMemberToZone(String SAN, String zoneName, String zoneMemberName, short zoneMemberType) {
        return this.izc.addZoneMemberToZone(SAN, zoneName, zoneMemberName, zoneMemberType);
    }

    public int addZoneAliasToZone(String SAN, String zoneName, String zoneAliasName) {
        return this.izc.addZoneAliasToZone(SAN, zoneName, zoneAliasName);
    }

    public int addZoneMemberToZoneAlias(String SAN, String zoneAliasName, String zoneMemberName, short zoneMemberType) {
        return this.izc.addZoneMemberToZoneAlias(SAN, zoneAliasName, zoneMemberName, zoneMemberType);
    }

    public int removeZoneFromZoneSet(String SAN, String zoneSetName, String zoneName) {
        return this.izc.removeZoneFromZoneSet(SAN, zoneSetName, zoneName);
    }

    public int removeZoneAliasFromZone(String SAN, String zoneName, String zoneAliasName) {
        return this.izc.removeZoneAliasFromZone(SAN, zoneName, zoneAliasName);
    }

    public int removeZoneMemberFromZone(String SAN, String zoneName, String zoneMemberName, short zoneMemberType) {
        return this.izc.removeZoneMemberFromZone(SAN, zoneName, zoneMemberName, zoneMemberType);
    }

    public int removeZoneMemberFromZoneAlias(String SAN, String zoneAliasName, String zoneMemberName, short zoneMemberType) {
        return this.izc.removeZoneMemberFromZoneAlias(SAN, zoneAliasName, zoneMemberName, zoneMemberType);
    }

    public int deleteZoneMember(String SAN, String zoneMemberName, short zoneMemberType) {
        return this.izc.deleteZoneMember(SAN, zoneMemberName, zoneMemberType);
    }

    public int deleteZone(String SAN, String zoneName) {
        return this.izc.deleteZone(SAN, zoneName);
    }

    public int deleteZoneSet(String SAN, String zoneSetName) {
        return this.izc.deleteZoneSet(SAN, zoneSetName);
    }

    public int deleteZoneAlias(String SAN, String zoneAliasName) {
        return this.izc.deleteZoneAlias(SAN, zoneAliasName);
    }

    public int activateZoneSet(String SAN, String zoneSetName) {
        return this.izc.activateZoneSet(SAN, zoneSetName);
    }

    public int deactivateZoneSet(String SAN, String zoneSetName) {
        return this.izc.deactivateZoneSet(SAN, zoneSetName);
    }

    public int ping(String san, String[] parameters) {
        return this.izc.ping(san, parameters);
    }

    public ZoneCapabilities getCapabilities(String san) {
        return this.izc.getCapabilities(san);
    }

    public ZoneDefinition getOldZoneDefinition(String SAN) {
        return this.izc.getOldZoneDefinition(SAN);
    }

    public ZoneDefinition getNewZoneDefinition(String SAN) {
        return this.izc.getNewZoneDefinition(SAN);
    }

    public int readCurrentZoneDefinition(String SAN, ZoneDefinition currentZDef) throws Exception {
        return this.izc.readCurrentZoneDefinition(SAN, currentZDef);
    }

    public Hashtable getRoleMap() {
        Hashtable roleMap = new Hashtable();
        return roleMap;
    }

    public ReadLogResponse getLog(String name, byte direction, LogFilePos position, int linesDesired) throws Exception {
        ReadLogResponse rlr = new ReadLogResponse();
        rlr = LogFileHandler.getLog((String)name, (byte)direction, (LogFilePos)position, (int)linesDesired);
        return rlr;
    }

    public ReadLogResponse getLog(String name, byte direction, LogFilePos position, String search, int linesDesired) throws Exception {
        ReadLogResponse rlr = new ReadLogResponse();
        rlr = LogFileHandler.getLog((String)name, (byte)direction, (LogFilePos)position, (String)search, (int)linesDesired);
        return rlr;
    }
}

