/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.extensions;

import java.util.Hashtable;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

public abstract class AbstractExtensionMgr
implements IRegistryChangeListener,
IDisposable {
    private static final String EXTENSION_IMPL = "impl";
    protected Hashtable<String, Object> cache = new Hashtable();

    public AbstractExtensionMgr() {
        this(true);
    }

    public AbstractExtensionMgr(boolean autoInit) {
        if (autoInit) {
            this.initialize();
        }
    }

    public abstract String getExtensionPointId();

    public void initialize() {
        this.cache = new Hashtable();
        RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public Object getExtensionImpl(String extensionId) throws ExtensionException {
        return this.getExtensionImpl(extensionId, true);
    }

    public Object getExtensionImpl(String extensionId, boolean useCache) throws ExtensionException {
        Object impl = null;
        if (useCache) {
            impl = this.cache.get(extensionId);
        }
        if (impl == null) {
            try {
                IExtensionRegistry xReg = RegistryFactory.getRegistry();
                IExtensionPoint extensionPoint = xReg.getExtensionPoint(this.getExtensionPointId());
                IExtension extension = extensionPoint.getExtension(extensionId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                impl = configElements[0].createExecutableExtension(EXTENSION_IMPL);
                if (useCache) {
                    this.cache.put(extensionId, impl);
                }
            }
            catch (Exception e) {
                throw new ExtensionException(e);
            }
        }
        return impl;
    }

    public String[] getAllExtensionIds() {
        String[] idArray = null;
        try {
            IExtensionRegistry xReg = RegistryFactory.getRegistry();
            IExtensionPoint extensionPoint = xReg.getExtensionPoint(this.getExtensionPointId());
            IExtension[] exts = extensionPoint.getExtensions();
            String[] tmpIdArray = new String[exts.length];
            for (int i = 0; i < tmpIdArray.length; ++i) {
                tmpIdArray[i] = exts[i].getUniqueIdentifier();
            }
            idArray = tmpIdArray;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return idArray;
    }

    public boolean isExtensionDefined(String extensionId) {
        IExtension extension = null;
        try {
            IExtensionRegistry xReg = RegistryFactory.getRegistry();
            IExtensionPoint extensionPoint = xReg.getExtensionPoint(this.getExtensionPointId());
            extension = extensionPoint.getExtension(extensionId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return extension != null;
    }

    protected IExtension getExtension(String extensionId) {
        IExtension extension = null;
        try {
            IExtensionRegistry xReg = RegistryFactory.getRegistry();
            IExtensionPoint extensionPoint = xReg.getExtensionPoint(this.getExtensionPointId());
            extension = extensionPoint.getExtension(extensionId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return extension;
    }

    public String getExtensionAttribute(String extensionId, String attribute) {
        String attributeValue = null;
        try {
            IConfigurationElement[] elements = this.getExtension(extensionId).getConfigurationElements();
            attributeValue = elements[0].getAttribute(attribute);
        }
        catch (Exception e) {
            // empty catch block
        }
        return attributeValue;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        for (int i = 0; i < deltas.length; ++i) {
            String affectedPoint = deltas[i].getExtensionPoint().getUniqueIdentifier();
            if (!affectedPoint.equals(this.getExtensionPointId())) continue;
            String ext = deltas[i].getExtension().getUniqueIdentifier();
            if (deltas[i].getKind() == 2) {
                this.cache.remove(ext);
                this.extensionRemoved(ext);
                continue;
            }
            if (deltas[i].getKind() != 1) continue;
            this.extensionAdded(ext);
        }
    }

    protected void extensionAdded(String extensionId) {
    }

    protected void extensionRemoved(String extensionId) {
    }

    public void dispose() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            registry.removeRegistryChangeListener((IRegistryChangeListener)this);
        }
        if (this.cache != null) {
            this.cache.clear();
            this.cache = null;
        }
    }
}

