/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ColumnTypeConversionException;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.Decimal;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.FloatingPoint;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlException;

public abstract class Cursor {
    protected Agent agent_;
    public static final int STRING = 0;
    public static final int VARIABLE_STRING = 2;
    public static final int VARIABLE_SHORT_STRING = 1;
    public static final int NULL_TERMINATED_STRING = 3;
    public static final int BYTES = 4;
    public static final int VARIABLE_BYTES = 5;
    public static final int VARIABLE_SHORT_BYTES = 6;
    public static final int NULL_TERMINATED_BYTES = 7;
    public static final int SBCS_CLOB = 8;
    public static final int MBCS_CLOB = 9;
    public static final int DBCS_CLOB = 10;
    public byte[] dataBuffer_;
    public ByteArrayOutputStream dataBufferStream_;
    public int position_;
    public int lastValidBytePosition_;
    public boolean hasLobs_;
    protected int currentRowPosition_;
    private int nextRowPosition_;
    protected int[] columnDataPosition_;
    protected int[] columnDataComputedLength_;
    public boolean allRowsReceivedFromServer_;
    int rowsRead_;
    int maxFieldSize_ = 0;
    protected ArrayList columnDataPositionCache_ = new ArrayList();
    protected ArrayList columnDataLengthCache_ = new ArrayList();
    protected ArrayList columnDataIsNullCache_ = new ArrayList();
    public ArrayList isUpdateDeleteHoleCache_ = new ArrayList();
    public boolean isUpdateDeleteHole_;
    public static final Boolean ROW_IS_NULL = new Boolean(true);
    public static final Boolean ROW_IS_NOT_NULL = new Boolean(false);
    Date recyclableDate_ = null;
    Time recyclableTime_ = null;
    Timestamp recyclableTimestamp_ = null;
    public int[] jdbcTypes_;
    public int columns_;
    public boolean[] nullable_;
    public String[] charsetName_;
    public boolean[] isNull_;
    public int[] fdocaLength_;
    public int[] ccsid_;
    char[] charBuffer_;

    public Cursor(Agent agent) {
        this.agent_ = agent;
        this.dataBufferStream_ = new ByteArrayOutputStream();
    }

    public Cursor(Agent agent, byte[] byArray) {
        this(agent);
        this.dataBuffer_ = byArray;
        this.allRowsReceivedFromServer_ = false;
    }

    public void setNumberOfColumns(int n) {
        this.columnDataPosition_ = new int[n];
        this.columnDataComputedLength_ = new int[n];
        this.columns_ = n;
        this.nullable_ = new boolean[n];
        this.charsetName_ = new String[n];
        this.ccsid_ = new int[n];
        this.isNull_ = new boolean[n];
        this.jdbcTypes_ = new int[n];
    }

    public boolean next() throws SqlException {
        boolean bl = true;
        this.clearLobData_();
        this.makeNextRowPositionCurrent();
        while (!this.dataBufferHasUnprocessedData()) {
            if (this.allRowsReceivedFromServer_) {
                return false;
            }
            this.getMoreData_();
        }
        bl = this.calculateColumnOffsetsForRow_(0);
        this.markNextRowPosition();
        return bl;
    }

    public final void setAllRowsReceivedFromServer(boolean bl) {
        this.allRowsReceivedFromServer_ = bl;
    }

    public final boolean currentRowPositionIsEqualToNextRowPosition() {
        return this.currentRowPosition_ == this.nextRowPosition_;
    }

    public final void resetDataBuffer() {
        this.position_ = 0;
        this.lastValidBytePosition_ = 0;
        this.currentRowPosition_ = 0;
        this.nextRowPosition_ = 0;
        this.allRowsReceivedFromServer_ = false;
        this.dataBufferStream_.reset();
    }

    public final boolean dataBufferHasUnprocessedData() {
        return this.lastValidBytePosition_ - this.position_ > 0;
    }

    protected abstract boolean calculateColumnOffsetsForRow_(int var1) throws SqlException, DisconnectException;

    protected abstract void clearLobData_();

    protected abstract void getMoreData_() throws SqlException;

    public final void setBuffer(byte[] byArray) {
        this.dataBuffer_ = byArray;
    }

    public final void setIsUpdataDeleteHole(int n, boolean bl) {
        Boolean bl2;
        this.isUpdateDeleteHole_ = bl;
        Boolean bl3 = bl2 = this.isUpdateDeleteHole_ ? ROW_IS_NULL : ROW_IS_NOT_NULL;
        if (this.isUpdateDeleteHoleCache_.size() == n) {
            this.isUpdateDeleteHoleCache_.add(bl2);
        } else {
            this.isUpdateDeleteHoleCache_.set(n, bl2);
        }
    }

    final int getPosition() {
        return this.position_;
    }

    final void setPosition(int n) {
        this.position_ = n;
    }

    public final void markCurrentRowPosition() {
        this.currentRowPosition_ = this.position_;
    }

    public final void markNextRowPosition() {
        this.nextRowPosition_ = this.position_;
    }

    public final void makeNextRowPositionCurrent() {
        this.currentRowPosition_ = this.nextRowPosition_;
    }

    final void repositionCursorToCurrentRow() {
        this.position_ = this.currentRowPosition_;
    }

    final void repositionCursorToNextRow() {
        this.position_ = this.nextRowPosition_;
    }

    public final byte[] getDataBuffer() {
        return this.dataBuffer_;
    }

    public final int getDataBufferLength() {
        return this.dataBuffer_.length;
    }

    public final int getLastValidBytePosition() {
        return this.lastValidBytePosition_;
    }

    public final void incrementRowsReadEvent() {
        ++this.rowsRead_;
    }

    private final short get_SMALLINT(int n) {
        return SignedBinary.getShort(this.dataBuffer_, this.columnDataPosition_[n - 1]);
    }

    private final int get_INTEGER(int n) {
        return SignedBinary.getInt(this.dataBuffer_, this.columnDataPosition_[n - 1]);
    }

    private final long get_BIGINT(int n) {
        return SignedBinary.getLong(this.dataBuffer_, this.columnDataPosition_[n - 1]);
    }

    private final float get_FLOAT(int n) {
        return FloatingPoint.getFloat(this.dataBuffer_, this.columnDataPosition_[n - 1]);
    }

    private final double get_DOUBLE(int n) {
        return FloatingPoint.getDouble(this.dataBuffer_, this.columnDataPosition_[n - 1]);
    }

    private final BigDecimal get_DECIMAL(int n) throws SqlException {
        try {
            return Decimal.getBigDecimal(this.dataBuffer_, this.columnDataPosition_[n - 1], this.getColumnPrecision(n - 1), this.getColumnScale(n - 1));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "Encoding is unsupported for conversion to BigDecimal");
        }
    }

    private final double getDoubleFromDECIMAL(int n) throws SqlException {
        try {
            return Decimal.getDouble(this.dataBuffer_, this.columnDataPosition_[n - 1], this.getColumnPrecision(n - 1), this.getColumnScale(n - 1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, illegalArgumentException, "Decimal value is out of range for conversion to double");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "Encoding is unsupported for conversion to BigDecimal");
        }
    }

    private final long getLongFromDECIMAL(int n) throws SqlException {
        try {
            return Decimal.getLong(this.dataBuffer_, this.columnDataPosition_[n - 1], this.getColumnPrecision(n - 1), this.getColumnScale(n - 1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SqlException(this.agent_.logWriter_, illegalArgumentException, "Decimal value is out of range for conversion to long");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "Encoding is unsupported for conversion to BigDecimal");
        }
    }

    private final String getVARCHAR(int n) throws SqlException {
        String string = null;
        try {
            if (this.ccsid_[n - 1] == 1200) {
                return this.getStringWithoutConvert(this.columnDataPosition_[n - 1] + 2, this.columnDataComputedLength_[n - 1] - 2);
            }
            if (this.charsetName_[n - 1] == null) {
                throw new SqlException(this.agent_.logWriter_, "Required character converter not available for data type.");
            }
            string = new String(this.dataBuffer_, this.columnDataPosition_[n - 1] + 2, this.columnDataComputedLength_[n - 1] - 2, this.charsetName_[n - 1]);
            return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "unsupported encoding for result set column " + n);
        }
    }

    private final String getCHAR(int n) throws SqlException {
        String string = null;
        if (this.ccsid_[n - 1] == 1200) {
            return this.getStringWithoutConvert(this.columnDataPosition_[n - 1], this.columnDataComputedLength_[n - 1]);
        }
        try {
            if (this.charsetName_[n - 1] == null) {
                throw new SqlException(this.agent_.logWriter_, "Required character converter not available for data type.");
            }
            string = new String(this.dataBuffer_, this.columnDataPosition_[n - 1], this.columnDataComputedLength_[n - 1], this.charsetName_[n - 1]);
            return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "unsupported encoding for result set column " + n);
        }
    }

    private final Date getDATE(int n) throws SqlException {
        try {
            return DateTime.dateBytesToDate(this.dataBuffer_, this.columnDataPosition_[n - 1], this.recyclableDate_, this.charsetName_[n - 1]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "Encoding is unsupported for conversion to DATE");
        }
    }

    private final Time getTIME(int n) throws SqlException {
        try {
            return DateTime.timeBytesToTime(this.dataBuffer_, this.columnDataPosition_[n - 1], this.recyclableTime_, this.charsetName_[n - 1]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "Encoding is unsupported for conversion to TIME");
        }
    }

    private final Timestamp getTIMESTAMP(int n) throws SqlException {
        try {
            return DateTime.timestampBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[n - 1], this.recyclableTimestamp_, this.charsetName_[n - 1]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "Encoding is unsupported for conversion to TIMESTAMP");
        }
    }

    private final Timestamp getTimestampFromDATE(int n) throws SqlException {
        try {
            return DateTime.dateBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[n - 1], this.recyclableTimestamp_, this.charsetName_[n - 1]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "Encoding is unsupported for conversion to TIMESTAMP");
        }
    }

    private final Timestamp getTimestampFromTIME(int n) throws SqlException {
        try {
            return DateTime.timeBytesToTimestamp(this.dataBuffer_, this.columnDataPosition_[n - 1], this.recyclableTimestamp_, this.charsetName_[n - 1]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "Encoding is unsupported for conversion to TIMESTAMP");
        }
    }

    private final Date getDateFromTIMESTAMP(int n) throws SqlException {
        try {
            return DateTime.timestampBytesToDate(this.dataBuffer_, this.columnDataPosition_[n - 1], this.recyclableDate_, this.charsetName_[n - 1]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "Encoding is unsupported for conversion to DATE");
        }
    }

    private final Time getTimeFromTIMESTAMP(int n) throws SqlException {
        try {
            return DateTime.timestampBytesToTime(this.dataBuffer_, this.columnDataPosition_[n - 1], this.recyclableTime_, this.charsetName_[n - 1]);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException, "Encoding is unsupported for conversion to TIME");
        }
    }

    private final String getStringFromDATE(int n) throws SqlException {
        return this.getDATE(n).toString();
    }

    private final String getStringFromTIME(int n) throws SqlException {
        return this.getTIME(n).toString();
    }

    private final String getStringFromTIMESTAMP(int n) throws SqlException {
        return this.getTIMESTAMP(n).toString();
    }

    private final byte[] get_CHAR_FOR_BIT_DATA(int n) throws SqlException {
        int n2 = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[n - 1] : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[n - 1]);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[n - 1], byArray, 0, n2);
        return byArray;
    }

    private final byte[] get_VARCHAR_FOR_BIT_DATA(int n) throws SqlException {
        int n2 = 0;
        n2 = this.maxFieldSize_ == 0 ? this.columnDataComputedLength_[n - 1] - 2 : Math.min(this.maxFieldSize_, this.columnDataComputedLength_[n - 1] - 2);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[n - 1] + 2, byArray, 0, byArray.length);
        return byArray;
    }

    public abstract Blob getBlobColumn_(int var1, Agent var2) throws SqlException;

    public abstract Clob getClobColumn_(int var1, Agent var2) throws SqlException;

    public abstract byte[] getClobBytes_(int var1, int[] var2) throws SqlException;

    final boolean getBoolean(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 5: {
                return this.agent_.crossConverters_.getBooleanFromShort(this.get_SMALLINT(n));
            }
            case 4: {
                return this.agent_.crossConverters_.getBooleanFromInt(this.get_INTEGER(n));
            }
            case -5: {
                return this.agent_.crossConverters_.getBooleanFromLong(this.get_BIGINT(n));
            }
            case 7: {
                return this.agent_.crossConverters_.getBooleanFromFloat(this.get_FLOAT(n));
            }
            case 8: {
                return this.agent_.crossConverters_.getBooleanFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.agent_.crossConverters_.getBooleanFromLong(this.getLongFromDECIMAL(n));
            }
            case 1: {
                return this.agent_.crossConverters_.getBooleanFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getBooleanFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final byte getByte(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 5: {
                return this.agent_.crossConverters_.getByteFromShort(this.get_SMALLINT(n));
            }
            case 4: {
                return this.agent_.crossConverters_.getByteFromInt(this.get_INTEGER(n));
            }
            case -5: {
                return this.agent_.crossConverters_.getByteFromLong(this.get_BIGINT(n));
            }
            case 7: {
                return this.agent_.crossConverters_.getByteFromFloat(this.get_FLOAT(n));
            }
            case 8: {
                return this.agent_.crossConverters_.getByteFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.agent_.crossConverters_.getByteFromLong(this.getLongFromDECIMAL(n));
            }
            case 1: {
                return this.agent_.crossConverters_.getByteFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getByteFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final short getShort(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 5: {
                return this.get_SMALLINT(n);
            }
            case 4: {
                return this.agent_.crossConverters_.getShortFromInt(this.get_INTEGER(n));
            }
            case -5: {
                return this.agent_.crossConverters_.getShortFromLong(this.get_BIGINT(n));
            }
            case 7: {
                return this.agent_.crossConverters_.getShortFromFloat(this.get_FLOAT(n));
            }
            case 8: {
                return this.agent_.crossConverters_.getShortFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.agent_.crossConverters_.getShortFromLong(this.getLongFromDECIMAL(n));
            }
            case 1: {
                return this.agent_.crossConverters_.getShortFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getShortFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final int getInt(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 5: {
                return this.get_SMALLINT(n);
            }
            case 4: {
                return this.get_INTEGER(n);
            }
            case -5: {
                return this.agent_.crossConverters_.getIntFromLong(this.get_BIGINT(n));
            }
            case 7: {
                return this.agent_.crossConverters_.getIntFromFloat(this.get_FLOAT(n));
            }
            case 8: {
                return this.agent_.crossConverters_.getIntFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.agent_.crossConverters_.getIntFromLong(this.getLongFromDECIMAL(n));
            }
            case 1: {
                return this.agent_.crossConverters_.getIntFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getIntFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final long getLong(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 5: {
                return this.get_SMALLINT(n);
            }
            case 4: {
                return this.get_INTEGER(n);
            }
            case -5: {
                return this.get_BIGINT(n);
            }
            case 7: {
                return this.agent_.crossConverters_.getLongFromFloat(this.get_FLOAT(n));
            }
            case 8: {
                return this.agent_.crossConverters_.getLongFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.getLongFromDECIMAL(n);
            }
            case 1: {
                return this.agent_.crossConverters_.getLongFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getLongFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final float getFloat(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 7: {
                return this.get_FLOAT(n);
            }
            case 8: {
                return this.agent_.crossConverters_.getFloatFromDouble(this.get_DOUBLE(n));
            }
            case 3: {
                return this.agent_.crossConverters_.getFloatFromDouble(this.getDoubleFromDECIMAL(n));
            }
            case 5: {
                return this.get_SMALLINT(n);
            }
            case 4: {
                return this.get_INTEGER(n);
            }
            case -5: {
                return this.get_BIGINT(n);
            }
            case 1: {
                return this.agent_.crossConverters_.getFloatFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getFloatFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final double getDouble(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 7: {
                double d = this.get_FLOAT(n);
                return d;
            }
            case 8: {
                return this.get_DOUBLE(n);
            }
            case 3: {
                return this.getDoubleFromDECIMAL(n);
            }
            case 5: {
                return this.get_SMALLINT(n);
            }
            case 4: {
                return this.get_INTEGER(n);
            }
            case -5: {
                return this.get_BIGINT(n);
            }
            case 1: {
                return this.agent_.crossConverters_.getDoubleFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getDoubleFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final BigDecimal getBigDecimal(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 3: {
                return this.get_DECIMAL(n);
            }
            case 7: {
                float f = this.get_FLOAT(n);
                return new BigDecimal(String.valueOf(f));
            }
            case 8: {
                return new BigDecimal(String.valueOf(this.get_DOUBLE(n)));
            }
            case 5: {
                return BigDecimal.valueOf(this.get_SMALLINT(n));
            }
            case 4: {
                return BigDecimal.valueOf(this.get_INTEGER(n));
            }
            case -5: {
                return BigDecimal.valueOf(this.get_BIGINT(n));
            }
            case 1: {
                return this.agent_.crossConverters_.getBigDecimalFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getBigDecimalFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final Date getDate(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 91: {
                return this.getDATE(n);
            }
            case 93: {
                return this.getDateFromTIMESTAMP(n);
            }
            case 1: {
                return this.agent_.crossConverters_.getDateFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getDateFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final Time getTime(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 92: {
                return this.getTIME(n);
            }
            case 93: {
                return this.getTimeFromTIMESTAMP(n);
            }
            case 1: {
                return this.agent_.crossConverters_.getTimeFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getTimeFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final Timestamp getTimestamp(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 93: {
                return this.getTIMESTAMP(n);
            }
            case 91: {
                return this.getTimestampFromDATE(n);
            }
            case 92: {
                return this.getTimestampFromTIME(n);
            }
            case 1: {
                return this.agent_.crossConverters_.getTimestampFromString(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return this.agent_.crossConverters_.getTimestampFromString(this.getVARCHAR(n));
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final String getString(int n) throws SqlException {
        String string = null;
        switch (this.jdbcTypes_[n - 1]) {
            case 1: {
                return this.getCHAR(n);
            }
            case -1: 
            case 12: {
                return this.getVARCHAR(n);
            }
            case 5: {
                return String.valueOf(this.get_SMALLINT(n));
            }
            case 4: {
                return String.valueOf(this.get_INTEGER(n));
            }
            case -5: {
                return String.valueOf(this.get_BIGINT(n));
            }
            case 7: {
                return String.valueOf(this.get_FLOAT(n));
            }
            case 8: {
                return String.valueOf(this.get_DOUBLE(n));
            }
            case 3: {
                return String.valueOf(this.get_DECIMAL(n));
            }
            case 91: {
                return this.getStringFromDATE(n);
            }
            case 92: {
                return this.getStringFromTIME(n);
            }
            case 93: {
                return this.getStringFromTIMESTAMP(n);
            }
            case -2: {
                string = this.agent_.crossConverters_.getStringFromBytes(this.get_CHAR_FOR_BIT_DATA(n));
                return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
            }
            case -4: 
            case -3: {
                string = this.agent_.crossConverters_.getStringFromBytes(this.get_VARCHAR_FOR_BIT_DATA(n));
                return this.maxFieldSize_ == 0 ? string : string.substring(0, Math.min(this.maxFieldSize_, string.length()));
            }
            case 2004: {
                Blob blob = this.getBlobColumn_(n, this.agent_);
                return this.agent_.crossConverters_.getStringFromBytes(blob.getBytes(1L, (int)blob.length()));
            }
            case 2005: {
                Clob clob = this.getClobColumn_(n, this.agent_);
                return clob.getSubString(1L, (int)clob.length());
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    final byte[] getBytes(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case -2: {
                return this.get_CHAR_FOR_BIT_DATA(n);
            }
            case -4: 
            case -3: {
                return this.get_VARCHAR_FOR_BIT_DATA(n);
            }
            case 2004: {
                Blob blob = this.getBlobColumn_(n, this.agent_);
                return blob.getBytes(1L, (int)blob.length());
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    public final InputStream getBinaryStream(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(n));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(n));
            }
            case 2004: {
                Blob blob = this.getBlobColumn_(n, this.agent_);
                return blob.getBinaryStream();
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    public final InputStream getAsciiStream(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 2005: {
                Clob clob = this.getClobColumn_(n, this.agent_);
                return clob.getAsciiStream();
            }
            case 1: {
                try {
                    return new ByteArrayInputStream(this.getCHAR(n).getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException.getMessage());
                }
            }
            case -1: 
            case 12: {
                try {
                    return new ByteArrayInputStream(this.getVARCHAR(n).getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException.getMessage());
                }
            }
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(n));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(n));
            }
            case 2004: {
                Blob blob = this.getBlobColumn_(n, this.agent_);
                return blob.getBinaryStream();
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    public final InputStream getUnicodeStream(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 2005: {
                Clob clob = this.getClobColumn_(n, this.agent_);
                String string = clob.getSubString(1L, (int)clob.length());
                try {
                    return new ByteArrayInputStream(string.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException.getMessage());
                }
            }
            case 1: {
                try {
                    return new ByteArrayInputStream(this.getCHAR(n).getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException.getMessage());
                }
            }
            case -1: 
            case 12: {
                try {
                    return new ByteArrayInputStream(this.getVARCHAR(n).getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SqlException(this.agent_.logWriter_, unsupportedEncodingException.getMessage());
                }
            }
            case -2: {
                return new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(n));
            }
            case -4: 
            case -3: {
                return new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(n));
            }
            case 2004: {
                Blob blob = this.getBlobColumn_(n, this.agent_);
                return blob.getBinaryStream();
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    public final Reader getCharacterStream(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 2005: {
                Clob clob = this.getClobColumn_(n, this.agent_);
                return clob.getCharacterStream();
            }
            case 1: {
                return new StringReader(this.getCHAR(n));
            }
            case -1: 
            case 12: {
                return new StringReader(this.getVARCHAR(n));
            }
            case -2: {
                try {
                    return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_CHAR_FOR_BIT_DATA(n)), "UTF-16BE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SqlException(this.agent_.logWriter_, "UnsupportedEncodingException: " + unsupportedEncodingException.getMessage());
                }
            }
            case -4: 
            case -3: {
                try {
                    return new InputStreamReader((InputStream)new ByteArrayInputStream(this.get_VARCHAR_FOR_BIT_DATA(n)), "UTF-16BE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SqlException(this.agent_.logWriter_, "UnsupportedEncodingException: " + unsupportedEncodingException.getMessage());
                }
            }
            case 2004: {
                try {
                    Blob blob = this.getBlobColumn_(n, this.agent_);
                    return new InputStreamReader(blob.getBinaryStream(), "UTF-16BE");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SqlException(this.agent_.logWriter_, "UnsupportedEncodingException: " + unsupportedEncodingException.getMessage());
                }
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    public final java.sql.Blob getBlob(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 2004: {
                return this.getBlobColumn_(n, this.agent_);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    public final java.sql.Clob getClob(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 2005: {
                return this.getClobColumn_(n, this.agent_);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    public final Array getArray(int n) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "not yet implemented");
    }

    public final Ref getRef(int n) throws SqlException {
        throw new SqlException(this.agent_.logWriter_, "not yet implemented");
    }

    public final Object getObject(int n) throws SqlException {
        switch (this.jdbcTypes_[n - 1]) {
            case 5: {
                return new Integer(this.get_SMALLINT(n));
            }
            case 4: {
                return new Integer(this.get_INTEGER(n));
            }
            case -5: {
                return new Long(this.get_BIGINT(n));
            }
            case 7: {
                return new Float(this.get_FLOAT(n));
            }
            case 8: {
                return new Double(this.get_DOUBLE(n));
            }
            case 3: {
                return this.get_DECIMAL(n);
            }
            case 91: {
                return this.getDATE(n);
            }
            case 92: {
                return this.getTIME(n);
            }
            case 93: {
                return this.getTIMESTAMP(n);
            }
            case 1: {
                return this.getCHAR(n);
            }
            case -1: 
            case 12: {
                return this.getVARCHAR(n);
            }
            case -2: {
                return this.get_CHAR_FOR_BIT_DATA(n);
            }
            case -4: 
            case -3: {
                return this.get_VARCHAR_FOR_BIT_DATA(n);
            }
            case 2004: {
                return this.getBlobColumn_(n, this.agent_);
            }
            case 2005: {
                return this.getClobColumn_(n, this.agent_);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_);
    }

    public final void allocateCharBuffer() {
        int n = 0;
        block3: for (int i = 0; i < this.columns_; ++i) {
            switch (this.jdbcTypes_[i]) {
                case -1: 
                case 1: 
                case 12: {
                    if (this.fdocaLength_[i] <= n) continue block3;
                    n = this.fdocaLength_[i];
                }
            }
        }
        this.charBuffer_ = new char[n];
    }

    private final String getStringWithoutConvert(int n, int n2) throws SqlException {
        int n3 = n + n2;
        int n4 = 0;
        for (int i = n; i < n3; i += 2) {
            this.charBuffer_[n4++] = (char)((this.dataBuffer_[i] & 0xFF) << 8 | this.dataBuffer_[i + 1] & 0xFF);
        }
        return new String(this.charBuffer_, 0, n4);
    }

    public void nullDataForGC() {
        this.dataBuffer_ = null;
        this.dataBufferStream_ = null;
        this.columnDataPosition_ = null;
        this.columnDataComputedLength_ = null;
        this.columnDataPositionCache_ = null;
        this.columnDataLengthCache_ = null;
        this.columnDataIsNullCache_ = null;
        this.jdbcTypes_ = null;
        this.nullable_ = null;
        this.charsetName_ = null;
        this.ccsid_ = null;
        this.isUpdateDeleteHoleCache_ = null;
        this.isNull_ = null;
        this.fdocaLength_ = null;
        this.charBuffer_ = null;
    }

    private final int getColumnPrecision(int n) {
        return this.fdocaLength_[n] >> 8 & 0xFF;
    }

    private final int getColumnScale(int n) {
        return this.fdocaLength_[n] & 0xFF;
    }

    final byte[] getBytesFromVARCHAR(int n) throws SqlException {
        byte[] byArray = new byte[this.columnDataComputedLength_[n - 1] - 2];
        System.arraycopy(this.dataBuffer_, this.columnDataPosition_[n - 1] + 2, byArray, 0, byArray.length);
        return byArray;
    }
}

