/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.discovery.snmp.scanner.interfaces.IScanner;
import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.sanmgr.queryengine.data.Response;

public abstract class Scanner
implements IScanner {
    static ILogger msgLogger = OutbandScanner.msgLogger;
    static ILogger traceLogger = OutbandScanner.traceLogger;
    static final String className = Scanner.class.getName();
    public String scanId = null;

    public Response processXMLDeltaScan(String scanId, String sData, int returnCode, String benchmarkLabel) {
        String methodName = "processXMLDeltaScan with String";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Object[] saData = null;
        StringTokenizer st = new StringTokenizer(sData, "\r\n");
        Vector<String> outV = new Vector<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken() + "\n";
            outV.add(s);
        }
        saData = new String[outV.size()];
        outV.copyInto(saData);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.processXMLDeltaScan(scanId, (String[])saData, returnCode, benchmarkLabel);
    }

    public Response processXMLDeltaScan(String scanId, String[] sData, int returnCode, String benchmarkLabel) {
        File BMfile;
        boolean same;
        int oldLevel;
        FileOutputStream out;
        String methodName;
        block21: {
            methodName = "processDeltaScan with String[]";
            FileInputStream in = null;
            out = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            oldLevel = -1;
            String[] oldData = new String[]{};
            same = false;
            String fileName = this.benchmarkFileNameFromScanId(scanId);
            BMfile = new File(Variables.getExecutableDirectory() + File.separator + fileName + ".BM_" + benchmarkLabel);
            try {
                if (BMfile.exists()) {
                    in = new FileInputStream(BMfile);
                    ObjectInputStream inStream = new ObjectInputStream(in);
                    oldLevel = (Integer)inStream.readObject();
                    oldData = (String[])inStream.readObject();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Comparing data to " + benchmarkLabel + " version " + oldLevel);
                    }
                    same = this.compare(sData, oldData);
                }
            }
            catch (Exception e) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "Scanner_readBenchmarkError", (Object)BMfile.getAbsolutePath());
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                same = false;
                oldLevel = -1;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "Scanner_readBenchmarkError", (Object)BMfile.getAbsolutePath());
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block21;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
            }
        }
        Hashtable<String, Object> parameters = new Hashtable<String, Object>();
        parameters.put("ScannerID", scanId);
        parameters.put("BENCHMARK", new Integer(oldLevel));
        parameters.put("BENCHMARK LABEL", benchmarkLabel);
        parameters.put("SAME AS BENCHMARK", new Boolean(same));
        if (same) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, returnCode);
            }
            parameters.put("LEVEL", new Integer(oldLevel));
            return new Response(returnCode, sData, oldLevel, oldLevel, benchmarkLabel, same);
        }
        try {
            out = new FileOutputStream(BMfile.getAbsolutePath());
            ObjectOutputStream outStream = new ObjectOutputStream(out);
            Integer newLevel = new Integer(oldLevel < 1000 ? oldLevel + 1 : 0);
            outStream.writeObject(newLevel);
            outStream.writeObject(sData);
            outStream.flush();
            out.close();
            out = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, returnCode);
            }
            parameters.put("LEVEL", new Integer(newLevel));
            return new Response(returnCode, sData, newLevel.intValue(), oldLevel, benchmarkLabel, same);
        }
        catch (Exception e) {
            if (msgLogger != null) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "Scanner_saveBenchmarkError");
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, returnCode);
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e2) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "Scanner_saveBenchmarkError");
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                }
            }
            return new Response(returnCode, sData);
        }
    }

    private String benchmarkFileNameFromScanId(String scanId) {
        String methodName = "benchmarkFileNameFromScanId";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        StringTokenizer st = new StringTokenizer(scanId, ":.");
        Vector<String> outV = new Vector<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            outV.add(s);
        }
        Object[] fileNameParts = null;
        fileNameParts = new String[outV.size()];
        outV.copyInto(fileNameParts);
        String fileName = new String("");
        if (fileNameParts.length > 0) {
            for (int i = 0; i < fileNameParts.length - 1; ++i) {
                fileName = fileName + (String)fileNameParts[i] + "_";
            }
            fileName = fileName + (String)fileNameParts[fileNameParts.length - 1];
        } else {
            fileName = scanId;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return fileName;
    }

    public String[] readString(InputStream in) {
        Vector<String> dataVector;
        String methodName;
        block8: {
            methodName = "readString";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            dataVector = new Vector<String>();
            InputStreamReader isr = new InputStreamReader(in);
            BufferedReader bufReader = new BufferedReader(isr);
            int pos = 0;
            String errorOutput = "TOS error";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "readString with filter for error messages embedded in xml\n");
            }
            try {
                String data;
                while ((data = bufReader.readLine()) != null) {
                    pos = data.indexOf(errorOutput);
                    if (pos == -1) {
                        dataVector.add(data);
                        continue;
                    }
                    if (traceLogger == null || !traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "scanner output filtered is " + data + "\n");
                }
            }
            catch (IOException e) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "Scanner_retrieveDataError");
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        String[] result = new String[dataVector.size()];
        dataVector.toArray(result);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return result;
    }

    public boolean compare(String[] data, String[] oldData) {
        String methodName = "compare";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName, (Object)"Comparing to benchmark ");
        }
        StringBuffer fullData = new StringBuffer("");
        for (int i = 0; i < data.length; ++i) {
            fullData.append(data[i]);
        }
        StringBuffer fullOldData = new StringBuffer("");
        for (int i = 0; i < oldData.length; ++i) {
            fullOldData.append(oldData[i]);
        }
        boolean same = fullData.toString().equals(fullOldData.toString());
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)(same ? "Match with benchmark" : "Mismatch with benchmark"));
        }
        return same;
    }
}

