/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner.interfaces;

import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.fabric.FabricActivator;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class OutbandScannerProperty {
    static final String className = OutbandScannerProperty.class.getName();
    static ILogger msgLogger = null;
    static ILogger traceLogger = null;
    private static IConfigService configServiceProxy = null;
    static String COMMUNITYNAME = "public";
    String MONITORINTERVAL = "60000";
    static String WRITECOMMUNITYNAME = "private";
    String SNMPTIMEOUTTRACING = "OFF";
    String SNMPTRACE = "OFF";
    String SNMPRETRY = "3";
    String SNMPTIMEOUT = "1000";
    String SWITCHPING = "NO";
    String CAPABILITYSCANRETRY = "1";
    String QUERYRETRY = "2";
    String RETRYDELAY = "100";

    public OutbandScannerProperty() {
        IConfigService dbp;
        String methodName = "OutbandScannerProperty";
        msgLogger = OutbandScanner.msgLogger;
        traceLogger = OutbandScanner.traceLogger;
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        if ((dbp = this.getConfigServiceProxy()).getProperty("SnmpCommunityName", "user") == null) {
            dbp.setProperty("SnmpCommunityName", "user", COMMUNITYNAME);
        }
        if (dbp.getProperty("OutbandAgentMonitorInterval", "user") == null) {
            dbp.setProperty("OutbandAgentMonitorInterval", "user", this.MONITORINTERVAL);
        }
        if (dbp.getProperty("SnmpWriteCommunityName", "user") == null) {
            dbp.setProperty("SnmpWriteCommunityName", "user", WRITECOMMUNITYNAME);
        }
        if (dbp.getProperty("SnmpTimeoutTracing", "user") == null) {
            dbp.setProperty("SnmpTimeoutTracing", "user", this.SNMPTRACE);
        }
        if (dbp.getProperty("SnmpTrace", "user") == null) {
            dbp.setProperty("SnmpTrace", "user", this.SNMPTRACE);
        }
        if (dbp.getProperty("SnmpRetryCount", "user") == null) {
            dbp.setProperty("SnmpRetryCount", "user", this.SNMPRETRY);
        }
        if (dbp.getProperty("SnmpInitialTimeout", "user") == null) {
            dbp.setProperty("SnmpInitialTimeout", "user", this.SNMPTIMEOUT);
        }
        if (dbp.getProperty("PerformSwitchPing", "user") == null) {
            dbp.setProperty("PerformSwitchPing", "user", this.SWITCHPING);
        }
        if (dbp.getProperty("ITSANMCapabilityScanRetryCount", "user") == null) {
            dbp.setProperty("ITSANMCapabilityScanRetryCount", "user", this.CAPABILITYSCANRETRY);
        }
        if (dbp.getProperty("ITSANMQueryRetryCount", "user") == null) {
            dbp.setProperty("ITSANMQueryRetryCount", "user", this.QUERYRETRY);
        }
        if (dbp.getProperty("ITSANMRetryDelay", "user") == null) {
            dbp.setProperty("ITSANMRetryDelay", "user", this.RETRYDELAY);
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void setSnmpCommunityName(String community) {
        String methodName = "setSnmpCommunityName";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (community != null && !community.trim().equals("")) {
            COMMUNITYNAME = community;
        }
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        dbp.setProperty("SnmpCommunityName", "user", COMMUNITYNAME);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The SNMP community name was set to " + community);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public static String getSnmpCommunityName() {
        IConfigService dbp;
        String community;
        String methodName = "getSnmpCommunityName";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((community = (dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService")).getProperty("SnmpCommunityName", "user")) == null || community.trim().equals("")) {
            community = COMMUNITYNAME;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Returning the SNMP community name = " + community);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return community;
    }

    public void setSnmpWriteCommunityName(String writeCommunity) {
        String methodName = "setSnmpWriteCommunityName";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (writeCommunity != null && !writeCommunity.trim().equals("")) {
            WRITECOMMUNITYNAME = writeCommunity;
        }
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        dbp.setProperty("SnmpWriteCommunityName", "user", WRITECOMMUNITYNAME);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The SNMP Write Community name was set to " + writeCommunity);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public static String getSnmpWriteCommunityName() {
        IConfigService dbp;
        String writeCommunity;
        String methodName = "getSnmpWriteCommunityName";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((writeCommunity = (dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService")).getProperty("SnmpWriteCommunityName", "user")) == null || writeCommunity.trim().equals("")) {
            writeCommunity = WRITECOMMUNITYNAME;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Returning the SNMP Write community name = " + writeCommunity);
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return writeCommunity;
    }

    public void setOutbandAgentMonitorInterval(int interval) {
        String methodName = "setOutbandAgentMonitorInterval";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.MONITORINTERVAL = Integer.toString(interval);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        dbp.setProperty("OutbandAgentMonitorInterval", "user", this.MONITORINTERVAL);
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The Outband agent monitor interval was set to " + this.MONITORINTERVAL + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public int getOutbandAgentMonitorInterval() {
        String methodName = "getOutbandAgentMonitorInterval";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int interval = Integer.valueOf(this.MONITORINTERVAL);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String monitorInterval = dbp.getProperty("OutbandAgentMonitorInterval", "user");
        if (monitorInterval != null) {
            interval = Integer.valueOf(monitorInterval);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Returning Outband agent monitor interval = " + interval + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return interval;
    }

    public void setSnmpRetryCount(int interval) {
        String methodName = "setSnmpRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.SNMPRETRY = Integer.toString(interval);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        dbp.setProperty("SnmpRetryCount", "user", this.SNMPRETRY);
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The SNMP retry count was set to " + this.SNMPRETRY + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public int getSnmpRetryCount() {
        String methodName = "getSnmpRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int interval = Integer.valueOf(this.SNMPRETRY);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String SnmpRetry = dbp.getProperty("SnmpRetryCount", "user");
        if (SnmpRetry != null) {
            interval = Integer.valueOf(SnmpRetry);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Returning SNMP retry count = " + interval + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return interval;
    }

    public void setSnmpInitialTimeout(int interval) {
        String methodName = "setSnmpInitialTimeout";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.SNMPTIMEOUT = Integer.toString(interval);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        dbp.setProperty("SnmpInitialTimeout", "user", this.SNMPTIMEOUT);
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The SNMP timeout was set to " + this.SNMPTIMEOUT + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public int getSnmpInitialTimeout() {
        String methodName = "getSnmpInitialTimeout";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int interval = Integer.valueOf(this.SNMPTIMEOUT);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String SnmpTimeout = dbp.getProperty("SnmpInitialTimeout", "user");
        if (SnmpTimeout != null) {
            interval = Integer.valueOf(SnmpTimeout);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Returning SNMP timeout = " + interval + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return interval;
    }

    public boolean performSwitchPing() {
        IConfigService dbp;
        String switchPing;
        String methodName = "performSwitchPing";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((switchPing = (dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService")).getProperty("PerformSwitchPing", "user")) == null) {
            switchPing = this.SWITCHPING;
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Switch Ping = " + switchPing + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return switchPing.equalsIgnoreCase("Y") || switchPing.equalsIgnoreCase("YES");
    }

    public boolean performSnmpTimeoutTracing() {
        IConfigService dbp;
        String trace;
        String methodName = "performSnmpTimeoutTracing";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((trace = (dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService")).getProperty("SnmpTimeoutTracing", "user")) == null) {
            trace = this.SNMPTIMEOUTTRACING;
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Switch timeout trace = " + trace + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return trace.equalsIgnoreCase("ON");
    }

    public boolean performSnmpTrace() {
        IConfigService dbp;
        String trace;
        String methodName = "performSnmpTrace";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((trace = (dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService")).getProperty("SnmpTrace", "user")) == null) {
            trace = this.SNMPTRACE;
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Switch trace = " + trace + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return trace.equalsIgnoreCase("ON");
    }

    public void setITSANMCapabilityScanRetryCount(int interval) {
        String methodName = "setITSANMCapabilityScanRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.CAPABILITYSCANRETRY = Integer.toString(interval);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        dbp.setProperty("ITSANMCapabilityScanRetryCount", "user", this.CAPABILITYSCANRETRY);
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The ITSANM Capability scan retry count was set to " + this.CAPABILITYSCANRETRY + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public int getITSANMCapabilityScanRetryCount() {
        String methodName = "getITSANMCapabilityScanRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int interval = Integer.valueOf(this.CAPABILITYSCANRETRY);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String CapabilityScanRetry = dbp.getProperty("ITSANMCapabilityScanRetryCount", "user");
        if (CapabilityScanRetry != null) {
            interval = Integer.valueOf(CapabilityScanRetry);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Returning ITSANM Capabilty scan retry count = " + interval + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return interval;
    }

    public void setITSANMQueryRetryCount(int interval) {
        String methodName = "setITSANMQueryRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.QUERYRETRY = Integer.toString(interval);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        dbp.setProperty("ITSANMQueryRetryCount", "user", this.QUERYRETRY);
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The ITSANM Query retry count was set to " + this.QUERYRETRY + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public int getITSANMQueryRetryCount() {
        String methodName = "getITSANMQueryRetryCount";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int interval = Integer.valueOf(this.QUERYRETRY);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String QueryRetry = dbp.getProperty("ITSANMQueryRetryCount", "user");
        if (QueryRetry != null) {
            interval = Integer.valueOf(QueryRetry);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Returning ITSANM Query retry count = " + interval + ".");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return interval;
    }

    public void setITSANMRetryDelay(int interval) {
        String methodName = "setITSANMRetryDelay";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.RETRYDELAY = Integer.toString(interval);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        dbp.setProperty("ITSANMRetryDelay", "user", this.RETRYDELAY);
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "The ITSANM Query retry delay was set to " + this.RETRYDELAY + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public int getITSANMRetryDelay() {
        String methodName = "getITSANMRetryDelay";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int interval = Integer.valueOf(this.RETRYDELAY);
        IConfigService dbp = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        String RetryDelay = dbp.getProperty("ITSANMRetryDelay", "user");
        if (RetryDelay != null) {
            interval = Integer.valueOf(RetryDelay);
        }
        if (traceLogger.isLogging()) {
            traceLogger.message(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Returning ITSANM Query retry delay = " + interval + " milliseconds.");
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return interval;
    }

    public IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)FabricActivator._serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }
}

