/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.MessageListener;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.discovery.tsanm.InbandScanner;
import org.eclipse.aperi.discovery.tsanm.OutbandScanner;
import org.eclipse.aperi.fabric.FabricManagerService;
import org.eclipse.aperi.fabric.api.IAgentMgmtService;
import org.eclipse.aperi.fabric.api.IFabricCollectionService;
import org.eclipse.aperi.fabric.api.IFabricConfigurationService;
import org.eclipse.aperi.fabric.api.IFabricManagerService;
import org.eclipse.aperi.fabric.api.IFabricReportingService;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.snmpagent.manager.SNMPAgentManager;
import org.eclipse.aperi.snmpagent.manager.interfaces.ISNMPAgentManager;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class FabricActivator
implements BundleActivator {
    protected ServiceRegistration cFabricServiceRegistration;
    protected FabricManagerService cFabricService = null;
    protected ServiceRegistration cSNMPAgentManagerServiceRegistration;
    protected SNMPAgentManager cSNMPAgentManager = null;
    public static final String PROPERTY_NUM_OUTBAND_SCANNERS = "NumOutbandScanners";
    public static final String PROPERTY_NUM_INBAND_SCANNERS = "NumInbandScanners";
    public static final String PROPERTY_NUM_LEGACY_FABRIC_PARSERS = "NumLegacyFabricParsers";
    public static final String PROPERTY_GROUP = "DiscoverService";
    public static final int DEFAULT_NUM_RESOURCES = 5;
    HashSet<OutbandScanner> outbandScanners = null;
    HashSet<InbandScanner> inbandScanners = null;
    HashSet<TSANMLegacyParser> tsanmParsers = null;
    private BundleContext _bundleContext = null;
    public static ServiceHelper _serviceHelper;
    private static IConfigService configServiceProxy;

    public void start(BundleContext context) throws Exception {
        try {
            this._bundleContext = context;
            _serviceHelper = new ServiceHelper(this._bundleContext);
            this.startSNMPAgentManagerService(context);
            Properties properties = this.getConfigServiceProxy().getProperties(PROPERTY_GROUP);
            this.startOutbandScanner(properties);
            this.startInbandScanner(properties);
            this.startTSANMParser(properties);
            String[] mFabricServices = new String[]{IFabricManagerService.class.getName(), IFabricReportingService.class.getName(), IFabricCollectionService.class.getName(), IFabricConfigurationService.class.getName(), IAgentMgmtService.class.getName(), IJobMgmtService.class.getName(), MessageListener.class.getName()};
            Hashtable<String, String> mFabricProperties = new Hashtable<String, String>();
            ((Dictionary)mFabricProperties).put("org.eclipse.aperi.webservice.name", "FabricManagerService");
            this.cFabricService = new FabricManagerService();
            this.cFabricService.startup();
            this.cFabricServiceRegistration = context.registerService(mFabricServices, (Object)this.cFabricService, mFabricProperties);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String value = Discover.discoverAll;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.cFabricServiceRegistration != null) {
            this.cFabricServiceRegistration.unregister();
        }
        if (this.cFabricService != null) {
            this.cFabricService.shutdown();
            this.cFabricService = null;
        }
        this.stopTSANMParser();
        this.stopOutbandScanner();
        this.stopInbandScanner();
        _serviceHelper.dispose();
        _serviceHelper = null;
        this._bundleContext = null;
    }

    protected void startSNMPAgentManagerService(BundleContext context) throws Exception {
        Properties properties = this.getConfigServiceProxy().getProperties(PROPERTY_GROUP);
        String[] mSNMPAgentManagerServices = new String[]{ISNMPAgentManager.class.getName()};
        Hashtable<String, String> mSNMPAgentManagerProperties = new Hashtable<String, String>();
        ((Dictionary)mSNMPAgentManagerProperties).put("org.eclipse.aperi.webservice.name", "SNMPAgentManager");
        this.cSNMPAgentManager = new SNMPAgentManager();
        this.cSNMPAgentManager.startup();
        this.cSNMPAgentManagerServiceRegistration = context.registerService(mSNMPAgentManagerServices, (Object)this.cSNMPAgentManager, mSNMPAgentManagerProperties);
    }

    public void stopSNMPAgentManagerService(BundleContext context) throws Exception {
        if (this.cSNMPAgentManagerServiceRegistration != null) {
            this.cSNMPAgentManagerServiceRegistration.unregister();
        }
        this.cSNMPAgentManager.shutdown();
        this.cSNMPAgentManager = null;
    }

    protected void startOutbandScanner(Properties properties) {
        this.outbandScanners = new HashSet();
        int num = this.getCountProperty(PROPERTY_NUM_OUTBAND_SCANNERS, 5, properties);
        for (int i = 0; i < num; ++i) {
            this.outbandScanners.add(new OutbandScanner());
        }
    }

    protected void stopOutbandScanner() {
        for (OutbandScanner scanner : this.outbandScanners) {
            scanner.shutdown();
        }
    }

    protected void startInbandScanner(Properties properties) {
        this.inbandScanners = new HashSet();
        int num = this.getCountProperty(PROPERTY_NUM_INBAND_SCANNERS, 5, properties);
        for (int i = 0; i < num; ++i) {
            this.inbandScanners.add(new InbandScanner());
        }
    }

    protected void stopInbandScanner() {
        for (InbandScanner scanner : this.inbandScanners) {
            scanner.shutdown();
        }
    }

    protected void startTSANMParser(Properties properties) {
        this.tsanmParsers = new HashSet();
        int num = this.getCountProperty(PROPERTY_NUM_LEGACY_FABRIC_PARSERS, 5, properties);
        for (int i = 0; i < num; ++i) {
            this.tsanmParsers.add(new TSANMLegacyParser());
        }
    }

    protected void stopTSANMParser() {
        for (TSANMLegacyParser parser : this.tsanmParsers) {
            parser.shutdown();
        }
    }

    public IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)_serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }

    private int getCountProperty(String property, int defaultValue, Properties properties) {
        int num = defaultValue;
        try {
            String value = properties.getProperty(property);
            if (value != null) {
                num = Integer.parseInt(value);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return num;
    }

    static {
        configServiceProxy = null;
    }
}

