/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric.discovery;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.TSANMLegacyParser;
import org.eclipse.aperi.discovery.tsanm.InbandScanner;
import org.eclipse.aperi.interfaces.ParameterException;

class DiscoverViaInband
extends DiscoverProcess {
    public static final HashMap mapping = new HashMap();

    public DiscoverViaInband() {
        super("Discover Via INBAND", false, new String[]{"AGENT", "SCANNER"}, new String[]{String[].class.getName(), String.class.getName()});
    }

    public Result process(Request discoverRequest, Map parameters) throws ParameterException {
        String[] agent = (String[])DiscoverViaInband.getParameter((Map)parameters, (String)"AGENT", (String)String[].class.getName());
        String scanner = (String)DiscoverViaInband.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        JobInfo job = new JobInfo();
        job.setDiscoverRequest(new Integer(discoverRequest.getId()).toString());
        job.setResourceQueue(InbandScanner.queueName);
        job.setResourceId(agent[0]);
        String prefix = (String)mapping.get(scanner);
        if (prefix == null) {
            prefix = "Unknown";
        }
        job.setRequestId(prefix + ":" + agent[0]);
        job.setRequest((Response)new ObjectResponse((Object)scanner, job));
        job.setTarget(agent);
        JobInfo processJob = (JobInfo)job.clone();
        processJob.setResourceQueue(TSANMLegacyParser.queueName);
        job.setNextJob(processJob);
        JobEngine.getInstance().addJob(job);
        return new Result(0);
    }

    public String getScannerId(Map parameters) throws ParameterException {
        String[] agent = (String[])DiscoverViaInband.getParameter((Map)parameters, (String)"AGENT", (String)String[].class.getName());
        String scanner = (String)DiscoverViaInband.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        String prefix = (String)mapping.get(scanner);
        if (prefix == null) {
            throw new ParameterException("Scanner " + scanner + " not recognized.");
        }
        return prefix + ":" + agent[0];
    }

    public int getAuthoritativeReferenceType(Map parameters) throws ParameterException {
        String[] agent = (String[])DiscoverViaInband.getParameter((Map)parameters, (String)"AGENT", (String)String[].class.getName());
        String scanner = (String)DiscoverViaInband.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        String prefix = (String)mapping.get(scanner);
        if (prefix == null) {
            throw new ParameterException("Scanner " + scanner + " not recognized.");
        }
        if (prefix.equals("PI2")) {
            return 5;
        }
        return -1;
    }

    public int getAuthoritativeReferenceId(Map parameters) throws ParameterException {
        String[] agent = (String[])DiscoverViaInband.getParameter((Map)parameters, (String)"AGENT", (String)String[].class.getName());
        String scanner = (String)DiscoverViaInband.getParameter((Map)parameters, (String)"SCANNER", (String)String.class.getName());
        String prefix = (String)mapping.get(scanner);
        if (prefix == null) {
            throw new ParameterException("Scanner " + scanner + " not recognized.");
        }
        if (prefix.equals("PI2")) {
            return Integer.parseInt(agent[2]);
        }
        return -1;
    }

    static {
        mapping.put("Topology", "PI1");
        mapping.put("AttributePEOnly", "PI2");
    }
}

