/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.eclipse.aperi.sanmgmt.event.DestinationFactory;
import org.eclipse.aperi.sanmgmt.event.SnmpTrapProcessor;
import org.eclipse.aperi.sanmgmt.event.TecEventProcessor;
import org.eclipse.aperi.sanmgmt.event.data.SANEvent;
import org.eclipse.aperi.sanmgmt.event.data.SnmpAddress;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.snmp.data.OctetString;

public class SANEventMessageHandler
implements MessageListener {
    private static final long serialVersionUID = 20001130L;
    protected transient ILogger msgLogger = null;
    protected transient ILogger traceLogger = null;
    static final String className = SANEventMessageHandler.class.getName();
    private DestinationFactory destFactory = null;
    private TecEventProcessor tecEventThread = null;
    private Hashtable snmpThreads = new Hashtable();

    public SANEventMessageHandler(DestinationFactory destFactory) {
        String methodName = "SANEventMessageHandler";
        this.traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.event");
        this.msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.event");
        if (this.msgLogger != null) {
            this.msgLogger.setMessageFile("org.eclipse.aperi.sanmgmt.event.resources.SANEventService");
        }
        this.destFactory = destFactory;
    }

    public void onMessage(Message message) {
        String methodName = "onMessage";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "onMessage");
        }
        ObjectMessage objectMessage = (ObjectMessage)message;
        SnmpAddress sa = new SnmpAddress();
        OctetString defaultCommunityName = new OctetString("public", true);
        Object snmpList = null;
        SANEvent myEvent = null;
        Object eventFilter = null;
        try {
            myEvent = (SANEvent)objectMessage.getObject();
            this.logEvent(myEvent);
        }
        catch (Exception e) {
            if (this.msgLogger != null) {
                this.msgLogger.message(IRecordType.TYPE_ERR, (Object)className, "onMessage", "SANEventMessage_errorProcessingEvent");
                this.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "onMessage", (Throwable)e);
            }
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "onMessage", (Throwable)e);
            }
            return;
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "onMessage");
        }
    }

    private void logEvent(SANEvent event) throws IOException, JMSException {
        String methodName = "logEvent";
        this.msgLogger.message(IRecordType.TYPE_INFO, (Object)className, "logEvent", "SANEventService_logEvent", (Object)event);
    }

    public void close() {
        String methodName = "close";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Enumeration keys = this.snmpThreads.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.removeSnmpTrapProcessor(key);
        }
        if (this.tecEventThread != null) {
            this.tecEventThread.stop();
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private void removeSnmpTrapProcessor(String key) {
        String methodName;
        block5: {
            methodName = "removeSnmpTrapProcessor";
            if (this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
            }
            try {
                SnmpTrapProcessor spt = (SnmpTrapProcessor)this.snmpThreads.get(key);
                if (spt != null) {
                    spt.stop();
                }
                this.snmpThreads.remove(key);
                this.traceLogger.text(IRecordType.TYPE_INFO, (Object)className, methodName, "SnmpTrapProcessor for " + key + " removed.");
            }
            catch (Exception ee) {
                if (!this.traceLogger.isLogging()) break block5;
                String messageInfo = "Can't remove SnmpTrapProcessor for " + key + " from hashtable.";
                this.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, messageInfo);
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ee);
            }
        }
        if (this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }
}

