/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event.data;

import java.io.Serializable;
import org.eclipse.aperi.sanmgmt.event.data.NoSnmpDestinationException;

public class SnmpAddress
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20001130L;
    private String destination = null;
    private int port = -1;
    private String communityName = null;

    public SnmpAddress() {
    }

    public SnmpAddress(String snmpDestination, int snmpPort, String communityName) throws NoSnmpDestinationException {
        if (snmpDestination == null) {
            throw new NoSnmpDestinationException();
        }
        this.destination = snmpDestination;
        this.port = snmpPort;
        this.communityName = communityName;
    }

    public String getCommunityName() {
        return this.communityName;
    }

    public String getSnmpDestination() throws NoSnmpDestinationException {
        if (this.destination == null) {
            throw new NoSnmpDestinationException();
        }
        return this.destination;
    }

    public int getSnmpPort() {
        return this.port;
    }

    public void setCommunityName(String community) {
        this.communityName = community;
    }

    public void setSnmpDestination(String dest) throws NoSnmpDestinationException {
        if (dest == null) {
            throw new NoSnmpDestinationException();
        }
        this.destination = dest;
    }

    public void setSnmpPort(int port) {
        this.port = port;
    }

    public boolean equals(Object snmpAddr) {
        boolean retCode = false;
        if (snmpAddr instanceof SnmpAddress) {
            SnmpAddress addr = (SnmpAddress)snmpAddr;
            retCode = (this.destination == null ? addr.destination == null : this.destination.equals(addr.destination)) && this.port == addr.port && (this.communityName == null ? addr.communityName == null : this.communityName.equals(addr.communityName));
        }
        return retCode;
    }

    public String toString() {
        return this.destination + "?" + this.port + "?" + this.communityName;
    }
}

