/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event.test;

import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;
import org.eclipse.aperi.sanmgmt.event.data.SANEvent;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.FactoryCreationFailedException;
import org.eclipse.aperi.sanmgmt.middleware.messaging.exception.UnknownFactoryTypeException;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.TimeTicks;

class SANEventPublisher {
    SANEventPublisher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws JMSException {
        Factory factory = null;
        TopicPublisher publisher = null;
        long sysUpTime = System.currentTimeMillis();
        try {
            factory = FactoryFactory.createFactory((int)1, null);
            ObjectMessage template = factory.createMessage(null);
            template.setStringProperty("PUBLISHER_ID", "TESPublisher");
            SANEvent event = new SANEvent();
            String messageId = "BTAxxxxxE";
            String trapDescription = "SAN Manager Service has been started successfully";
            String localHostName = "sanbox10.sanjose.ibm.com";
            String localHostAddress = "9.43.236.71";
            long timeAtTrap = System.currentTimeMillis();
            SnmpTrap myTrap = new SnmpTrap();
            myTrap.genericTrap = 6;
            myTrap.agentAddr = new IPAddress(localHostAddress);
            myTrap.timeStamp = new TimeTicks((timeAtTrap - sysUpTime) / 10L);
            myTrap.enterprise = new OID("1.3.6.1.4.1.2.6.173.5.1");
            myTrap.specificTrap = 1;
            myTrap.addVarBind("1.3.6.1.4.1.2.6.173.1.1", (Serializable)new OctetString(trapDescription, true));
            myTrap.addVarBind("1.3.6.1.4.1.2.6.173.1.9", (Serializable)new OctetString(messageId, true));
            myTrap.addVarBind("1.3.6.1.4.1.2.6.173.1.59", (Serializable)new OctetString("SanManger", true));
            myTrap.addVarBind("1.3.6.1.4.1.2.6.173.1.60", (Serializable)new OctetString("startup/shutdown", true));
            event.setsanTrap(myTrap);
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            attributes.put("serviceName", "SanManager");
            attributes.put("serviceState", "startup/shutdown");
            event.setTECAttributes("ServiceEvent", "", "", "Aperi Storage Manager", "SANManagerService", trapDescription, messageId, "HARMLESS", attributes);
            publisher = factory.createPublisher(event.getClass().getName(), (Message)template);
            ObjectMessage eventMsg = factory.createMessage((Serializable)event);
            eventMsg.setJMSPriority(2);
            publisher.publish((Message)eventMsg);
        }
        catch (UnknownFactoryTypeException e) {
            System.out.println("UnknownFactoryTypeException: " + e.toString());
        }
        catch (FactoryCreationFailedException e) {
            System.out.println("FactoryCreationFailedException: " + e.toString());
        }
        catch (JMSException e) {
            System.out.println("JMSException: " + e.toString());
        }
        finally {
            if (publisher != null) {
                publisher.close();
            }
            if (factory != null) {
                factory.close();
            }
        }
    }
}

