/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.hostquery;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.aperi.agent.Activator;
import org.eclipse.aperi.agent.hostquery.HostQuery;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.util.InterpResolver;

public class HostInfo {
    private ILogger trace_logger;
    private ILogger message_logger;
    String osName;
    String jvmVersion;
    String hostName;
    int hostPort;
    String hostIP;

    public HostInfo() {
        block6: {
            this.trace_logger = HostQuery.trace_logger;
            this.message_logger = HostQuery.message_logger;
            String methodName = "HostInfo";
            if (this.trace_logger.isLogging()) {
                this.trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)"HostInfo", "HostInfo_Constructor");
            }
            this.osName = System.getProperty("os.name");
            this.jvmVersion = System.getProperty("java.version");
            this.hostPort = this.getAgentPort();
            if (this.jvmVersion == null) {
                this.jvmVersion = "null jvm";
            }
            if (this.trace_logger.isLogging()) {
                this.trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "HostInfo", "System.is " + System.getProperty("java.vm.version"));
            }
            try {
                this.hostName = this.determineHost();
                this.hostIP = this.chooseIP();
            }
            catch (Exception e) {
                if (!this.trace_logger.isLogging()) break block6;
                this.trace_logger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "HostInfo", (Throwable)e);
            }
        }
        if (this.trace_logger.isLogging()) {
            this.trace_logger.exit(IRecordType.TYPE_EXIT, (Object)"HostInfo", "HostInfo_Constructor", (Object)("hostName= " + this.hostName));
        }
    }

    private String chooseIP() throws UnknownHostException {
        InetAddress addr;
        String IP = null;
        String methodName = "chooseIP";
        if (this.trace_logger.isLogging()) {
            this.trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)"HostInfo", "chooseIP");
        }
        IP = this.isExternal(addr = InetAddress.getLocalHost()) ? addr.getHostAddress() : this.getIPAddress(this.hostName);
        if (this.trace_logger.isLogging()) {
            this.trace_logger.exit(IRecordType.TYPE_EXIT, (Object)"HostInfo", "chooseIP", (Object)("IP= " + IP));
        }
        return IP;
    }

    private String determineHost() {
        String hostName;
        block5: {
            if (this.trace_logger.isLogging()) {
                this.trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)"HostInfo", "determineHost");
            }
            hostName = null;
            Process p = null;
            try {
                String exeDir = Variables.getExecutableDirectory();
                p = InterpResolver.isWindows() ? Runtime.getRuntime().exec("\"" + exeDir + File.separator + "gethostname" + "\"") : Runtime.getRuntime().exec(exeDir + "gethostname");
                InputStream ins = p.getInputStream();
                InputStreamReader isr = new InputStreamReader(ins);
                BufferedReader br = new BufferedReader(isr);
                hostName = br.readLine();
                br.close();
            }
            catch (Exception e) {
                if (this.message_logger.isLogging()) {
                    this.message_logger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, "determineHost", "BTShostNameFail");
                }
                if (!this.trace_logger.isLogging()) break block5;
                this.trace_logger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "determineHost", (Throwable)e);
            }
        }
        if (this.trace_logger.isLogging()) {
            this.trace_logger.exit(IRecordType.TYPE_EXIT, (Object)"HostInfo", "determineHost", (Object)("hostName= " + hostName));
        }
        return hostName;
    }

    private String getIPAddress(String hostName) throws UnknownHostException {
        InetAddress[] myAdr = InetAddress.getAllByName(hostName);
        int linkLocalIndx = -1;
        int siteLocalIndx = -1;
        int loopbackIndx = -1;
        int multicastIndx = -1;
        for (int i = 0; i < myAdr.length; ++i) {
            int address = this.getIntAddress(myAdr[i]);
            if (this.isExternal(myAdr[i])) {
                return myAdr[i].getHostAddress();
            }
            if (this.isSiteLocalAddress(address)) {
                if (linkLocalIndx != -1) continue;
                linkLocalIndx = i;
                continue;
            }
            if (this.isLinkLocalAddress(address)) {
                if (siteLocalIndx != -1) continue;
                siteLocalIndx = i;
                continue;
            }
            if (this.isLoopbackAddress(myAdr[i])) {
                if (loopbackIndx != -1) continue;
                loopbackIndx = i;
                continue;
            }
            if (!this.isMulticastAddress(address) || multicastIndx != -1) continue;
            multicastIndx = i;
        }
        if (siteLocalIndx >= 0) {
            return myAdr[siteLocalIndx].getHostAddress();
        }
        if (linkLocalIndx >= 0) {
            return myAdr[linkLocalIndx].getHostAddress();
        }
        if (loopbackIndx >= 0) {
            return myAdr[loopbackIndx].getHostAddress();
        }
        if (multicastIndx >= 0) {
            return myAdr[multicastIndx].getHostAddress();
        }
        if (myAdr.length > 0) {
            return myAdr[0].getHostAddress();
        }
        return null;
    }

    private int getIntAddress(InetAddress ia) {
        int address = 0;
        byte[] addr = ia.getAddress();
        if (addr != null && addr.length == 4) {
            address = addr[3] & 0xFF;
            address |= addr[2] << 8 & 0xFF00;
            address |= addr[1] << 16 & 0xFF0000;
            address |= addr[0] << 24 & 0xFF000000;
        }
        return address;
    }

    private boolean isExternal(InetAddress ia) {
        int address = this.getIntAddress(ia);
        return !this.isSiteLocalAddress(address) && !this.isLinkLocalAddress(address) && !this.isMulticastAddress(address) && !this.isLoopbackAddress(ia);
    }

    private boolean isSiteLocalAddress(int address) {
        return (address >>> 24 & 0xFF) == 10 || (address >>> 24 & 0xFF) == 172 && (address >>> 16 & 0xF0) == 16 || (address >>> 24 & 0xFF) == 192 && (address >>> 16 & 0xFF) == 168;
    }

    private boolean isLinkLocalAddress(int address) {
        return (address >>> 24 & 0xFF) == 169 && (address >>> 16 & 0xFF) == 254;
    }

    private boolean isLoopbackAddress(InetAddress ia) {
        byte[] byteAddr = ia.getAddress();
        return byteAddr[0] == 127;
    }

    private boolean isMulticastAddress(int address) {
        return (address & 0xF0000000) == -536870912;
    }

    private int getAgentPort() {
        IConfigService configService = (IConfigService)Activator.getService(IConfigService.class);
        String hostPort = configService.getProperty("agent.port", "setup");
        return Integer.parseInt(hostPort);
    }
}

