/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.hostquery;

import com.ibm.log.Level;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.aperi.agent.Activator;
import org.eclipse.aperi.agent.hostquery.HostInfo;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.diskmgr.hostservice.manager.interfaces.ISANDiskMgrHostService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.subagent.common.HostQueryInfo;
import org.eclipse.aperi.sanmgmt.subagent.common.SubagentInfo;
import org.eclipse.aperi.sanmgmt.subagent.hostquery.interfaces.IHostQuery;

public class HostQuery
implements IHostQuery,
IService,
Runnable {
    static final String TRACE_LOGGER_NAME = "aperi.logger.trace.SANAgentHostQuery";
    static final String MESSAGE_LOGGER_NAME = "aperi.logger.message.SANAgentHostQuery";
    static final String BUNDLENAME = "org.eclipse.aperi.sanmgmt.subagent.hostquery.HostQueryMessages";
    static ILogger trace_logger;
    static ILogger message_logger;
    static final long RETRY_REGISTRY_PERIOD = 20000L;
    private ISANDiskMgrHostService hms = null;
    private Thread queryThread = null;
    private boolean shutFlag = false;
    private HostQueryInfo hostQueryInfo = null;
    private Status status = new Status(5, 9);

    public HostQueryInfo getHostInfo() {
        String methodName = "getHostInfo";
        if (trace_logger.isLogging()) {
            trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getHostInfo");
        }
        if (trace_logger.isLogging()) {
            trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "getHostInfo", " AgentHostQuery: Host osname=" + this.hostQueryInfo.osName + ", jvmVersion=" + this.hostQueryInfo.jvmVersion + ", hostName=" + this.hostQueryInfo.hostName + ", hostPort=" + this.hostQueryInfo.hostPort + ", hostIP=" + this.hostQueryInfo.hostIP + ", guid=" + this.hostQueryInfo.GUID.toString());
        }
        if (trace_logger.isLogging()) {
            trace_logger.exit(IRecordType.TYPE_EXIT, (Object)this, "getHostInfo");
        }
        return this.hostQueryInfo;
    }

    public boolean startup() {
        String method = "startup";
        String managerLocation = null;
        String managerPort = null;
        int port = 0;
        if (trace_logger.isLogging()) {
            trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)this.getClass().getName(), "startup");
        }
        this.status.setRunStatus(9);
        SubagentInfo[] subagentlist = null;
        HostInfo hostinfo = new HostInfo();
        this.hostQueryInfo = new HostQueryInfo(hostinfo.osName, hostinfo.jvmVersion, hostinfo.hostName, Integer.toString(hostinfo.hostPort), hostinfo.hostIP, subagentlist, GUID.readGUID(), "5.0.0");
        IConfigService configService = (IConfigService)Activator.getService(IConfigService.class);
        if (configService != null) {
            String pIP;
            String pName = configService.getProperty("my.name", "user");
            if (pName != null && (pName = pName.trim()).length() > 0) {
                this.hostQueryInfo.hostName = pName;
            }
            if ((pIP = configService.getProperty("my.ip", "user")) != null && (pIP = pIP.trim()).length() > 0) {
                this.hostQueryInfo.hostIP = pIP;
            }
        }
        if (this.hostQueryInfo.hostName == null) {
            if (trace_logger.isLogging()) {
                trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "startup", "Failed to retrieve HostName, Unable to start HostQuery ");
            }
            this.shutFlag = true;
            this.status.setRunStatus(2);
            return false;
        }
        if (configService != null) {
            managerLocation = configService.getProperty("manager.loc", "setup");
            managerPort = configService.getProperty("manager.port", "setup");
            if (managerLocation == null || managerPort == null) {
                if (trace_logger.isLogging()) {
                    trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "startup", "dbParm failed to get managerLoc or managerPort properties ");
                }
                this.shutFlag = true;
                return false;
            }
        } else {
            if (trace_logger.isLogging()) {
                trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "startup", "Failed to get a connection to the ConfigService.");
            }
            this.shutFlag = true;
            this.status.setRunStatus(2);
            return false;
        }
        port = new Integer(managerPort);
        this.hms = (ISANDiskMgrHostService)ConnectorClient.getService((String)managerLocation, (int)port, ISANDiskMgrHostService.class, (String)"SANHostMgr");
        this.shutFlag = false;
        if (this.hostQueryInfo.GUID != null) {
            this.hostQueryInfo = this.getHostInfo();
            this.queryThread = new Thread((Runnable)this, "SANAgentHostQuery");
            this.queryThread.start();
            this.status.setRunStatus(8);
            if (message_logger.isLogging()) {
                message_logger.message(IRecordType.TYPE_INFO, (Object)this, "startup", "BTSserviceStartup", (Object)this.getName());
            }
        } else {
            this.status.setRunStatus(2);
            if (trace_logger.isLogging()) {
                trace_logger.text(IRecordType.TYPE_ERROR_EXC, (Object)this, "startup", "HostQuery Service failed to start.  Failed to read the GUID");
                trace_logger.exit(IRecordType.TYPE_EXIT, (Object)this.getClass().getName(), "startup");
            }
            return false;
        }
        if (trace_logger.isLogging()) {
            trace_logger.exit(IRecordType.TYPE_EXIT, (Object)this.getClass().getName(), "startup");
        }
        return true;
    }

    public boolean shutdown() {
        String method = "shutdown";
        if (trace_logger.isLogging()) {
            trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)this.getClass().getName(), "shutdown");
        }
        this.shutFlag = true;
        this.queryThread.interrupt();
        try {
            this.queryThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        message_logger.message(IRecordType.TYPE_INFO, (Object)this, "shutdown", "BTSserviceShutdown", (Object)this.getName());
        if (trace_logger.isLogging()) {
            trace_logger.exit(IRecordType.TYPE_EXIT, (Object)this.getClass().getName(), "shutdown");
        }
        return true;
    }

    public void run() {
        String method = "run";
        int heartbeatfailCount = 1;
        if (trace_logger.isLogging()) {
            trace_logger.entry(IRecordType.TYPE_API, (Object)this.getClass().getName(), "run");
        }
        while (!this.shutFlag) {
            block13: {
                try {
                    this.hms.agentHeartbeat(this.hostQueryInfo);
                    if (trace_logger.isLogging()) {
                        trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "run", " HostQuery: Agent Heartbeat sent.");
                    }
                    if (heartbeatfailCount > 0) {
                        if (message_logger.isLogging()) {
                            message_logger.message(IRecordType.TYPE_INFO, (Object)this, "run", "BTSheartbeatStart", (Object)"agentHeartbeat");
                        }
                        if (trace_logger.isLogging()) {
                            trace_logger.text(IRecordType.TYPE_MISC_DATA, (Object)this, "run", " HostQuery: Agent Heartbeat started...");
                        }
                        heartbeatfailCount = 0;
                    }
                }
                catch (Exception e) {
                    if (heartbeatfailCount >= 10) break block13;
                    if (message_logger.isLogging()) {
                        message_logger.message(IRecordType.TYPE_ERROR_EXC, (Object)this, "run", "BTSheartbeatFail", (Object)"agentHeartbeat");
                    }
                    if (trace_logger.isLogging()) {
                        trace_logger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, "run", (Throwable)e);
                    }
                    ++heartbeatfailCount;
                }
            }
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                if (!trace_logger.isLogging()) continue;
                trace_logger.exception(Level.WARN, (Object)this, "run", (Throwable)e);
            }
        }
        if (trace_logger.isLogging()) {
            trace_logger.exit(IRecordType.TYPE_EXIT, (Object)this.getClass().getName(), "run");
        }
    }

    public String getName() {
        return "SANAgentHostQuery";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("HostQuery_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("HostQuery_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getDescription() {
        return this.getLocalizedDescription(Locale.getDefault());
    }

    public Hashtable getRoleMap() {
        Hashtable roleMap = new Hashtable();
        return roleMap;
    }

    static {
        block2: {
            trace_logger = null;
            message_logger = null;
            try {
                trace_logger = LogManagerFactory.getTraceLogger((String)TRACE_LOGGER_NAME);
                message_logger = LogManagerFactory.getMessageLogger((String)MESSAGE_LOGGER_NAME);
                message_logger.setMessageFile(BUNDLENAME);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!trace_logger.isLogging()) break block2;
                trace_logger.entry(IRecordType.TYPE_ENTRY, (Object)"HostQuery Class", "Exception On Creating Logger " + e);
            }
        }
    }
}

