/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.inbandchangeagent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.aperi.agent.Activator;
import org.eclipse.aperi.agent.inbandchangeagent.InbandChangeAgentConstants;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.IChangeAgent;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.IEventCorrelatorFactory;
import org.eclipse.aperi.sanmgmt.sanmgr.eventcorrelator.interfaces.InstantiationFailedException;
import org.eclipse.aperi.sanmgmt.util.InterpResolver;

public class InbandChangeAgent
implements IService,
IChangeAgent,
Runnable {
    private static final String FILE_NAME = "InbandEvents";
    static final String className = InbandChangeAgent.class.getName();
    static ILogger msgLogger = InbandChangeAgentConstants.msgLogger;
    static ILogger traceLogger = InbandChangeAgentConstants.traceLogger;
    public static final String MINIMUM_EVENTCORRELATORFACTORY_VERSION = null;
    private Thread scannerThread = null;
    private String command;
    private boolean shutdownInvoked = false;
    private StringBuffer nativeBinDirectory = null;
    private StringBuffer subagentHomeDirectory = null;
    private StringBuffer valuePath = null;
    private StringBuffer valueSystemroot = null;
    private StringBuffer valueLdlibrarypath = null;
    public static final String w32ix86 = "w32-ix86";
    public static final String aix5 = "aix";
    public static final String winnt = "Windows NT";
    public static final String win2k = "Windows 2000";
    private Process p = null;
    InputStream p_stdout;
    static String exeName1 = "oslevel -r";
    static String exeName2 = "lslpp -l";
    private String xmlEvent = "";
    private int period;
    private String mgrHost = null;
    private int mgrPort = 0;
    private String propertyFileLocation = null;
    private String executableLocation = null;
    IEventCorrelatorFactory eventCorrelatorFactory = null;
    private Status status = new Status();

    public InbandChangeAgent() {
        this.status.setRunStatus(3);
        String methodName = "InbandChangeAgent";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        this.shutdownInvoked = false;
        this.setPulseRate(20);
        String baseDir = Variables.getBaseDirectory();
        if (baseDir == null || baseDir.equalsIgnoreCase("")) {
            this.propertyFileLocation = FILE_NAME;
            this.executableLocation = "." + File.separator;
        } else {
            this.propertyFileLocation = baseDir + File.separator + FILE_NAME;
            this.executableLocation = baseDir + File.separator + "bin" + File.separator + this.getInterp() + File.separator;
        }
    }

    private IEventCorrelatorFactory getEventCorrelator() throws InstantiationFailedException {
        String methodName = "getEventCorrelator";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (this.eventCorrelatorFactory == null) {
            try {
                this.eventCorrelatorFactory = (IEventCorrelatorFactory)ConnectorClient.getService((String)this.mgrHost, (int)this.mgrPort, IEventCorrelatorFactory.class, (String)"SANEventCorrelatorFactory");
            }
            catch (Exception e) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "InbandChangeAgent_contactEventCorrelatorError");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                throw new InstantiationFailedException();
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.eventCorrelatorFactory;
    }

    public void setPulseRate(int rate) {
        String methodName = "setPulseRate";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName, (Object)("Rate = " + rate + " seconds."));
        }
        this.period = rate * 1000;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private int runScanner() {
        int rc;
        String methodName;
        block79: {
            methodName = "runScanner";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            rc = -1;
            boolean more = true;
            StringBuffer results = new StringBuffer();
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss a zzz");
            String timeStamp = simpleDateFormat.format(date);
            String[] envPassed = new String[4];
            try {
                block80: {
                    int tt;
                    block78: {
                        File oldXMLfile = new File(this.propertyFileLocation);
                        oldXMLfile.delete();
                        for (tt = 0; oldXMLfile.exists() && tt < 10; ++tt) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            oldXMLfile.delete();
                        }
                        try {
                            String interpValue = this.getInterp();
                            envPassed[0] = interpValue != null && interpValue.equals(w32ix86) ? new String("PATH=" + this.valuePath + ";" + this.nativeBinDirectory.toString() + ";" + this.executableLocation) : new String("PATH=" + this.valuePath + ":" + this.nativeBinDirectory.toString() + ":" + this.executableLocation);
                            envPassed[1] = new String("TSNM_SM_HOME=" + this.subagentHomeDirectory.toString());
                            String hostOsName = new String(System.getProperty("os.name"));
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "hostOsName is " + hostOsName);
                            }
                            envPassed[2] = new String("SystemRoot=" + this.valueSystemroot);
                            envPassed[3] = new String("LD_LIBRARY_PATH=" + this.valueLdlibrarypath + ":" + this.nativeBinDirectory.toString());
                            if (this.shutdownInvoked) {
                                if (traceLogger.isLogging()) {
                                    traceLogger.exit(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, (Object)"Shutdown invoked, will not invoke EventScanner");
                                }
                                if (traceLogger.isLogging()) {
                                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                                }
                                rc = -1;
                                return rc;
                            }
                            if (interpValue.equals(aix5) && this.command.indexOf("Event2") != -1) {
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Event command invoked is " + this.command);
                                }
                                this.p = Runtime.getRuntime().exec(this.command);
                            } else {
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Environment to be passed to scanner is " + envPassed[0] + " " + envPassed[1] + " " + envPassed[2] + " " + envPassed[3]);
                                }
                                this.p = Runtime.getRuntime().exec(this.command, envPassed);
                            }
                            if (this.p != null) {
                                this.p.waitFor();
                            } else {
                                rc = 0;
                            }
                            if (this.p != null) {
                                block77: {
                                    block76: {
                                        block75: {
                                            rc = this.p.exitValue();
                                            try {
                                                this.p.getErrorStream().close();
                                                if (traceLogger != null && traceLogger.isLogging()) {
                                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed error stream ");
                                                }
                                            }
                                            catch (Exception closeStreamException) {
                                                if (traceLogger == null || !traceLogger.isLogging()) break block75;
                                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing error stream for process");
                                            }
                                        }
                                        try {
                                            this.p.getInputStream().close();
                                            if (traceLogger != null && traceLogger.isLogging()) {
                                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed input stream ");
                                            }
                                        }
                                        catch (Exception closeStreamException) {
                                            if (traceLogger == null || !traceLogger.isLogging()) break block76;
                                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing input stream for process");
                                        }
                                    }
                                    try {
                                        this.p.getOutputStream().close();
                                        if (traceLogger != null && traceLogger.isLogging()) {
                                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed output stream ");
                                        }
                                    }
                                    catch (Exception closeStreamException) {
                                        if (traceLogger == null || !traceLogger.isLogging()) break block77;
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing output stream for process");
                                    }
                                }
                                try {
                                    this.p.destroy();
                                }
                                catch (Exception closeStreamException) {
                                    if (traceLogger != null && traceLogger.isLogging()) {
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception destroying process");
                                    }
                                    break block78;
                                }
                            }
                            rc = 0;
                        }
                        catch (IOException ioe) {
                            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)ioe);
                            if (traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ioe);
                            }
                            rc = -1;
                        }
                    }
                    if (rc != 0) break block79;
                    File newXMLfile = new File(this.propertyFileLocation);
                    boolean lookForXMLfile = !newXMLfile.exists();
                    for (tt = 0; lookForXMLfile && tt < 300; ++tt) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        lookForXMLfile = !newXMLfile.exists();
                    }
                    if (newXMLfile.exists()) {
                        boolean bReRead = true;
                        int readCnt = 0;
                        while (bReRead && readCnt < 5) {
                            Vector<String> newXMLV = new Vector<String>();
                            try {
                                String aLine = null;
                                BufferedReader p_file = new BufferedReader(new FileReader(this.propertyFileLocation));
                                aLine = p_file.readLine();
                                while (aLine != null) {
                                    newXMLV.add(aLine);
                                    aLine = p_file.readLine();
                                }
                                p_file.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            ++readCnt;
                            if (newXMLV.size() > 0) {
                                boolean bFoundIt = false;
                                String dsTest = "</InbandEvents>";
                                String aLine = null;
                                Enumeration e = newXMLV.elements();
                                while (e.hasMoreElements()) {
                                    aLine = (String)e.nextElement();
                                    if (aLine.indexOf(dsTest) == -1) continue;
                                    bFoundIt = true;
                                    break;
                                }
                                if (bFoundIt) {
                                    bReRead = false;
                                    continue;
                                }
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException ie) {}
                                continue;
                            }
                            if (readCnt == 3) {
                                bReRead = false;
                                continue;
                            }
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException ie) {}
                        }
                    }
                    this.xmlEvent = new String();
                    if (!newXMLfile.exists()) break block79;
                    FileInputStream fileInputStream = new FileInputStream(this.propertyFileLocation);
                    BufferedReader dataInputStream = new BufferedReader(new InputStreamReader(fileInputStream));
                    while (more) {
                        try {
                            String line = dataInputStream.readLine();
                            if (line.indexOf("TIMESTAMP") != -1) {
                                int pos = line.indexOf("TIMESTAMP");
                                StringBuffer work = new StringBuffer(line.substring(1, pos));
                                work.append(timeStamp);
                                work.append("\">");
                                line = new String(work);
                            }
                            if (line.equals("")) continue;
                            results.append(line + "\n");
                        }
                        catch (Exception e) {
                            more = false;
                        }
                    }
                    try {
                        if (dataInputStream != null) {
                            dataInputStream.close();
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed file stream ");
                            }
                        } else if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change dataInputStream is null did not close file stream ");
                        }
                    }
                    catch (Exception closeStreamException) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block80;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing file stream ");
                    }
                }
                this.xmlEvent = new String(results);
            }
            catch (Exception e) {
                block83: {
                    block82: {
                        block81: {
                            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "InbandChangeAgent_ReadEventFileError");
                            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                            if (traceLogger.isLogging()) {
                                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                            }
                            rc = -1;
                            try {
                                if (this.p != null) {
                                    this.p.getErrorStream().close();
                                    if (traceLogger != null && traceLogger.isLogging()) {
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed error stream ");
                                    }
                                }
                            }
                            catch (Exception closeStreamException) {
                                if (traceLogger == null || !traceLogger.isLogging()) break block81;
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing error stream for process");
                            }
                        }
                        try {
                            if (this.p != null) {
                                this.p.getInputStream().close();
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed input stream ");
                                }
                            }
                        }
                        catch (Exception closeStreamException) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block82;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing input stream for process");
                        }
                    }
                    try {
                        if (this.p != null) {
                            this.p.getOutputStream().close();
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed output stream ");
                            }
                        }
                    }
                    catch (Exception closeStreamException) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block83;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing output stream for process");
                    }
                }
                try {
                    if (this.p != null) {
                        this.p.destroy();
                    }
                }
                catch (Exception closeStreamException) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block79;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception destroying process");
                }
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return rc;
    }

    public void run() {
        String methodName = "run";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        while (this.scannerThread != null) {
            block12: {
                int returnCode;
                block11: {
                    try {
                        this.eventCorrelatorFactory = this.getEventCorrelator();
                    }
                    catch (Exception exception) {
                        this.eventCorrelatorFactory = null;
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "InbandChangeAgent_contactEventCorrelatorError");
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)exception);
                        if (!traceLogger.isLogging()) break block11;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exception);
                    }
                }
                if (this.eventCorrelatorFactory != null && (returnCode = this.runScanner()) == 0) {
                    try {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "INBANDEVENTS XML --- " + this.xmlEvent);
                        }
                        if (!this.xmlEvent.equals("")) {
                            this.eventCorrelatorFactory.postEvent(this.xmlEvent);
                        }
                    }
                    catch (Exception e) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "InbandChangeAgent_contactEventCorrelatorError");
                        msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (!traceLogger.isLogging()) break block12;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    }
                }
            }
            try {
                Thread.sleep(this.period);
            }
            catch (InterruptedException exception) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "InbandChangeAgent_InterruptedException");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)exception);
                if (!traceLogger.isLogging()) continue;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)exception);
            }
        }
    }

    public void onConfirmation(int eventId, boolean status, String additionalInfo) {
        String methodName = "onConfirmation";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void onException(int eventId, Exception exception) {
        String methodName = "onException";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public void onSpecialMessage(String message) {
        String methodName = "onSpecialMessage";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public boolean isAlive() {
        return true;
    }

    public String getName() {
        return "SANAgentInbandChangeAgent";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("InbandChangeAgent_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("InbandChangeAgent_Description");
    }

    public Status getStatus() {
        return new Status(5, 8);
    }

    public String getVersion() {
        return "5.0.0";
    }

    public boolean shutdown() {
        String methodName;
        block25: {
            methodName = "shutdown";
            String[] envPassed = new String[4];
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            this.status.setRunStatus(11);
            this.shutdownInvoked = true;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "value of shutdownInvoked is " + this.shutdownInvoked);
            }
            Thread dyingThread = this.scannerThread;
            this.scannerThread.interrupt();
            this.scannerThread = null;
            try {
                block28: {
                    block27: {
                        block26: {
                            dyingThread.join(15000L);
                            String osName = System.getProperty("os.name");
                            this.command = osName.indexOf("windows") != -1 || osName.indexOf("Windows") != -1 || osName.indexOf("WINDOWS") != -1 ? "\"" + this.executableLocation + "Event" + "\"" + " -close" : (osName != null && osName.equals("AIX") ? this.determineCommandForAIXHost(false) : this.executableLocation + "Event" + " -close");
                            String interpValue = this.getInterp();
                            envPassed[0] = interpValue != null && interpValue.equals(w32ix86) ? new String("PATH=" + this.valuePath + ";" + this.nativeBinDirectory.toString() + ";" + this.executableLocation) : new String("PATH=" + this.valuePath + ":" + this.nativeBinDirectory.toString() + ":" + this.executableLocation);
                            envPassed[1] = new String("TSNM_SM_HOME=" + this.subagentHomeDirectory.toString());
                            String hostOsName = new String(System.getProperty("os.name"));
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "hostOsName is " + hostOsName);
                            }
                            envPassed[2] = new String("SystemRoot=" + this.valueSystemroot);
                            envPassed[3] = new String("LD_LIBRARY_PATH=" + this.valueLdlibrarypath + ":" + this.nativeBinDirectory.toString());
                            if (interpValue.equals(aix5) && this.command.indexOf("Event2") != -1) {
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Event command invoked is " + this.command);
                                }
                                this.p = Runtime.getRuntime().exec(this.command);
                            } else {
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Environment to be passed to scanner is " + envPassed[0] + " " + envPassed[1] + " " + envPassed[2] + " " + envPassed[3]);
                                }
                                this.p = Runtime.getRuntime().exec(this.command, envPassed);
                            }
                            if (this.p != null) {
                                this.p.waitFor();
                            }
                            if (this.p == null) break block25;
                            try {
                                this.p.getErrorStream().close();
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed error stream ");
                                }
                            }
                            catch (Exception closeStreamException) {
                                if (traceLogger == null || !traceLogger.isLogging()) break block26;
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing error stream for process");
                            }
                        }
                        try {
                            this.p.getInputStream().close();
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed input stream ");
                            }
                        }
                        catch (Exception closeStreamException) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block27;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing input stream for process");
                        }
                    }
                    try {
                        this.p.getOutputStream().close();
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed output stream ");
                        }
                    }
                    catch (Exception closeStreamException) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block28;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing output stream for process");
                    }
                }
                try {
                    this.p.destroy();
                }
                catch (Exception closeStreamException) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception destroying process");
                    }
                }
            }
            catch (InterruptedException e) {
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "InbandChangeAgent_InterruptedException");
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
            catch (IOException ioe) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)ioe);
                if (!traceLogger.isLogging()) break block25;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)ioe);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    public boolean startup() {
        String methodName;
        block18: {
            methodName = "startup";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            this.status.setRunStatus(9);
            IConfigService dbparm = (IConfigService)Activator.getService(IConfigService.class);
            this.mgrHost = dbparm.getProperty("manager.loc", "setup");
            this.mgrPort = new Integer(dbparm.getProperty("manager.port", "setup"));
            String osName = System.getProperty("os.name");
            this.command = osName.indexOf("windows") != -1 || osName.indexOf("Windows") != -1 || osName.indexOf("WINDOWS") != -1 ? "\"" + this.executableLocation + "Event" + "\"" + " " + "\"" + this.propertyFileLocation + "\"" : (osName != null && osName.equals("AIX") ? this.determineCommandForAIXHost(true) : this.executableLocation + "Event" + " " + this.propertyFileLocation);
            try {
                String interpValue;
                String envValue;
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "command is " + this.command);
                }
                this.nativeBinDirectory = new StringBuffer(Variables.getNativeLibDirectory());
                if (this.nativeBinDirectory == null) {
                    this.nativeBinDirectory = new StringBuffer("");
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "nativeBinDirectory is " + this.nativeBinDirectory);
                }
                this.subagentHomeDirectory = new StringBuffer(Variables.getBaseDirectory());
                if (this.subagentHomeDirectory == null) {
                    this.subagentHomeDirectory = new StringBuffer("");
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "subAgentHomeDirectory is " + this.subagentHomeDirectory);
                }
                this.valuePath = (envValue = Variables.getEnvironmentValue((String)"PATH")) != null ? new StringBuffer(envValue) : new StringBuffer("");
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "getEnvValue for PATH returned " + this.valuePath);
                }
                if ((interpValue = this.getInterp()) != null && interpValue.equals(w32ix86)) {
                    envValue = Variables.getEnvironmentValue((String)"SYSTEMROOT");
                    this.valueSystemroot = envValue != null ? new StringBuffer(envValue) : new StringBuffer("");
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "getEnvValue for SYSTEMROOT returned " + this.valueSystemroot);
                    }
                } else {
                    this.valueSystemroot = new StringBuffer("");
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "getEnvValue for SYSTEMROOT returned " + this.valueSystemroot);
                    }
                }
                if (interpValue != null && interpValue.equals(w32ix86)) {
                    this.valueLdlibrarypath = new StringBuffer("");
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "getEnvValue for LD_LIBRARY_PATH returned " + this.valueLdlibrarypath);
                    }
                } else {
                    envValue = Variables.getEnvironmentValue((String)"LD_LIBRARY_PATH");
                    this.valueLdlibrarypath = envValue != null ? new StringBuffer(envValue) : new StringBuffer("");
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "getEnvValue for LD_LIBRARY_PATH returned " + this.valueLdlibrarypath);
                    }
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!traceLogger.isLogging()) break block18;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        this.scannerThread = new Thread((Runnable)this, "SANAgentInbandChangeAgent");
        this.scannerThread.start();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return true;
    }

    public String getDescription() {
        String methodName = "getDescription";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getDescription");
        }
        String defaultDescription = "Listens for inband events";
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getDescription");
        }
        return defaultDescription;
    }

    public String getInterp() {
        String osArch;
        String osVersion;
        String methodName = "getInterp";
        String osName = System.getProperty("os.name");
        String interp = InterpResolver.getInterp((String)osName, (String)(osVersion = System.getProperty("os.version")), (String)(osArch = System.getProperty("os.arch")));
        if (interp != null && interp.equals("unknown") || interp == null) {
            interp = System.getProperty("orb.interp");
        }
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_EXIT, (Object)this, methodName, (Object)("Interp for " + osName + " version " + osVersion + " arch " + osArch + " is " + interp));
        }
        return interp;
    }

    private void exec1() {
        block3: {
            String methodName = "exec1";
            try {
                this.p = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return Runtime.getRuntime().exec(exeName1);
                    }
                });
                this.p_stdout = this.p.getInputStream();
            }
            catch (Exception e) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block3;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
    }

    private void exec2() {
        block3: {
            String methodName = "exec2";
            try {
                this.p = (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return Runtime.getRuntime().exec(exeName2);
                    }
                });
                this.p_stdout = this.p.getInputStream();
            }
            catch (Exception e) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block3;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
    }

    private void endExec() {
        block20: {
            String methodName = "endExec";
            try {
                block19: {
                    block18: {
                        block17: {
                            this.p_stdout.close();
                            this.p.waitFor();
                            this.p.exitValue();
                            try {
                                if (this.p != null) {
                                    this.p.getErrorStream().close();
                                    if (traceLogger != null && traceLogger.isLogging()) {
                                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed error stream in endExec");
                                    }
                                } else if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent p is null did not close error stream in endExec");
                                }
                            }
                            catch (Exception closeStreamException) {
                                if (traceLogger == null || !traceLogger.isLogging()) break block17;
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing error stream in endExec");
                            }
                        }
                        try {
                            if (this.p != null) {
                                this.p.getOutputStream().close();
                                if (traceLogger != null && traceLogger.isLogging()) {
                                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent closed output stream in endExec");
                                }
                            } else if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change p is null did not close output stream in endExec");
                            }
                        }
                        catch (Exception closeStreamException) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block18;
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception closing output stream in endExec");
                        }
                    }
                    try {
                        this.p.destroy();
                    }
                    catch (Exception closeStreamException) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block19;
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "inband change agent ran into exception destroying process endExec");
                    }
                }
                this.p = null;
            }
            catch (Exception e) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block20;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
    }

    private String readLine() {
        StringBuffer line = new StringBuffer();
        int ch = 0;
        int numCharsInLine = 0;
        try {
            while ((ch = this.p_stdout.read()) != 10 && ch != -1) {
                ++numCharsInLine;
                line.append((char)ch);
            }
        }
        catch (Exception e) {
            return null;
        }
        if (numCharsInLine > 0) {
            return line.toString();
        }
        return null;
    }

    String determineCommandForAIXHost(boolean needStartUpCommand) {
        block38: {
            int index = 0;
            int oslevel = 0;
            boolean protocolDriverInstalled = false;
            String methodName = "determineCommandForAIXHost";
            String osVersion = System.getProperty("os.version");
            if (osVersion != null && osVersion.equals("5.1")) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Will invoke Event since host is running AIX 5.1");
                }
                this.command = needStartUpCommand ? this.executableLocation + "Event" + " " + this.propertyFileLocation : this.executableLocation + "Event -close";
            } else if (osVersion != null && (osVersion.equals("5.2") || osVersion.equals("5.3"))) {
                try {
                    this.exec1();
                    String line = this.readLine();
                    this.endExec();
                    oslevel = line == null ? 0 : ((index = line.indexOf("-")) == -1 || index == line.length() ? 0 : new Integer(line.substring(index + 1)));
                    this.exec2();
                    do {
                        if ((line = this.readLine()) == null || line.indexOf("Event Protocol") == -1) continue;
                        protocolDriverInstalled = true;
                        break;
                    } while (line != null);
                    this.endExec();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "oslevel is " + oslevel + " protocolDriverInstalled is " + protocolDriverInstalled);
                    }
                    if (osVersion.equals("5.2") && oslevel >= 2) {
                        if (protocolDriverInstalled) {
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "InbandChangeAgent_UninstallProtocolDriver");
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Protocol driver needs to be uninstalled to prevent interference with EventScanner.");
                            }
                        }
                        this.command = needStartUpCommand ? this.executableLocation + "Event2" + " " + this.propertyFileLocation : this.executableLocation + "Event2 -close";
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Will invoke Event2 since host is running AIX 5.2 with atleast maintenance level 2");
                        }
                    } else if (osVersion.equals("5.2") && oslevel < 2) {
                        if (protocolDriverInstalled) {
                            this.command = needStartUpCommand ? this.executableLocation + "Event" + " " + this.propertyFileLocation : this.executableLocation + "Event -close";
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "InbandChangeAgent_UninstallProtocolDriver");
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Protocol driver needs to be uninstalled to prevent interference with EventScanner.");
                            }
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "InbandChangeAgent_ApplyAIX52MaintenanceLevel2OrHigher");
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Need to apply atleast maintenance level 2 to AIX 5.2.");
                            }
                        } else {
                            this.command = "";
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "InbandChangeAgent_ApplyAIX52MaintenanceLevel2OrHigher");
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Need to apply atleast maintenance level 2 to AIX 5.2.");
                            }
                        }
                    }
                    if (osVersion.equals("5.3") && oslevel >= 1) {
                        if (protocolDriverInstalled) {
                            if (msgLogger != null) {
                                msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "InbandChangeAgent_UninstallProtocolDriver");
                            }
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Protocol driver needs to be uninstalled to prevent interference with EventScanner.");
                            }
                        }
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Will invoke Event2 since host is running AIX 5.3 with atleast maintenance level 1");
                        }
                        this.command = needStartUpCommand ? this.executableLocation + "Event2" + " " + this.propertyFileLocation : this.executableLocation + "Event2 -close";
                        break block38;
                    }
                    if (!osVersion.equals("5.3") || oslevel >= 1) break block38;
                    if (protocolDriverInstalled) {
                        this.command = needStartUpCommand ? this.executableLocation + "Event" + " " + this.propertyFileLocation : this.executableLocation + "Event -close";
                        if (msgLogger != null) {
                            msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "InbandChangeAgent_UninstallProtocolDriver");
                        }
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Protocol driver needs to be uninstalled to prevent interference with EventScanner.");
                        }
                        if (msgLogger != null) {
                            msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "InbandChangeAgent_ApplyAIX53MaintenanceLevel1OrHigher");
                        }
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Need to apply atleast maintenance level 1 to AIX 5.3.");
                        }
                        break block38;
                    }
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "InbandChangeAgent_ApplyAIX53MaintenanceLevel1OrHigher");
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Need to apply atleast maintenance level 1 to AIX 5.3.");
                    }
                    this.command = "";
                }
                catch (Exception e) {
                    this.command = "";
                }
            } else {
                this.command = needStartUpCommand ? this.executableLocation + "Event2" + " " + this.propertyFileLocation : this.executableLocation + "Event2 -close";
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERR, (Object)className, methodName, "InbandChangeAgent_UnsupportedOSLevel");
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "AIX managed host is running a unsupported AIX OS level.");
                }
            }
        }
        return this.command;
    }

    public Hashtable getRoleMap() {
        Hashtable roleMap = new Hashtable();
        return roleMap;
    }
}

