/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.client;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import org.eclipse.aperi.connector.internal.SecurityContext;
import org.eclipse.aperi.connector.internal.client.SoapClient;

public class SoapServiceProxy
extends SoapClient
implements InvocationHandler,
Serializable {
    static final long serialVersionUID = 426243323L;
    public String hostUrl;
    public String service;
    private boolean isInitialized = false;

    private SoapServiceProxy(String hostUrl, String serviceName, SecurityContext sc) {
        super(sc);
        this.hostUrl = hostUrl;
        this.service = serviceName;
    }

    public static Object newInstance(String host, int port, String serviceName, Class c, SecurityContext sc) {
        String url = host + ":" + port;
        return Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)new SoapServiceProxy(url, serviceName, sc));
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        try {
            if (!this.isInitialized) {
                this.init(this.hostUrl, this.service);
                this.isInitialized = true;
            }
            this.setMethod(m, args);
            return this.invoke();
        }
        catch (UndeclaredThrowableException ute) {
            throw ute.getUndeclaredThrowable();
        }
    }
}

