/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.IKeyStoreMgr;
import org.eclipse.aperi.connector.log.LogHelper;

public class KeyStoreMgr
implements IKeyStoreMgr {
    private KeyStore keystore = null;
    private String keystorePWD = null;
    private static IKeyStoreMgr instance = null;

    public static IKeyStoreMgr getIKeyStoreMgr() {
        String METHOD = "getIKeyStoreMgr";
        if (instance == null) {
            String impl = Config.getProperty("connector.ssl.keystore.mgr.impl");
            if (impl != null) {
                try {
                    Class<?> c = Class.forName(impl);
                    instance = (IKeyStoreMgr)c.newInstance();
                }
                catch (Exception e) {
                    LogHelper.log("CNT025W", IKeyStoreMgr.class, "getIKeyStoreMgr", impl);
                    LogHelper.logException(e, IKeyStoreMgr.class, "getIKeyStoreMgr");
                }
            }
            if (instance == null) {
                instance = new KeyStoreMgr();
            }
        }
        return instance;
    }

    private KeyStoreMgr() {
    }

    public KeyStore getKeyStore() throws KeyStoreException {
        String METHOD = "getKeyStore";
        if (this.keystore == null) {
            this.keystore = KeyStore.getInstance("JKS");
            String filename = Config.getProperty("connector.ssl.keystore");
            InputStream is = null;
            try {
                is = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                LogHelper.log("CNT022W", KeyStoreMgr.class, "getKeystore", filename);
                is = KeyStoreMgr.class.getResourceAsStream("/org/eclipse/aperi/connector/internal/ssl/defaultKeystore.jks");
            }
            try {
                this.keystore.load(is, this.getPassword());
            }
            catch (NoSuchAlgorithmException e) {
                LogHelper.log("CNT023E", KeyStoreMgr.class, "getKeyStore", this.keystore.getProvider().getName());
                LogHelper.logException(e, KeyStoreMgr.class, "getKeyStore");
                throw new KeyStoreException(e);
            }
            catch (IOException e) {
                LogHelper.log("CNT024E", KeyStoreMgr.class, "getKeyStore");
                LogHelper.logException(e, KeyStoreMgr.class, "getKeyStore");
                throw new KeyStoreException(e);
            }
            catch (Exception e) {
                LogHelper.traceException(e, KeyStoreMgr.class, "getKeyStore");
                throw new KeyStoreException(e);
            }
        }
        return this.keystore;
    }

    public char[] getPassword() {
        if (this.keystorePWD == null) {
            this.keystorePWD = Config.getProperty("connector.ssl.keystorepassword");
        }
        return this.keystorePWD.toCharArray();
    }
}

