/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.job;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Link;
import org.eclipse.aperi.agent.util.ListOfLinks;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.request.Request;

public class JobManager {
    private ListOfLinks runningJobs = new ListOfLinks();

    public void waitUntilJobsComplete() {
        this.runningJobs.waitUntilEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRunningJobs(Set jobs) {
        ListOfLinks listOfLinks = this.runningJobs;
        synchronized (listOfLinks) {
            Iterator iterator = this.runningJobs.iterator();
            while (iterator.hasNext()) {
                jobs.add(iterator.next());
            }
        }
    }

    public synchronized StartedJob getJobByRunNumber(int runNumber) {
        StartedJob job = null;
        Iterator iterator = this.runningJobs.iterator();
        while (iterator.hasNext()) {
            job = (StartedJob)iterator.next();
            if (job.getJobRun().getRunNumber() == runNumber) continue;
        }
        return job;
    }

    public Link jobInit(StartedJob job) {
        Link link = null;
        if (Agent.state < 2) {
            link = this.addJob(job);
        }
        return link;
    }

    public void jobWait(StartedJob job) {
        job.setJobStatus((byte)87);
        job.setStarted(this.waitToStart(job.getJobRun().getDesiredStartTime()));
    }

    public void jobExec(StartedJob job) {
        job.setJobStatus((byte)69);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeJob(int returnCode, Link link) {
        if (returnCode == -4096) {
            this.removeJob(link);
        } else {
            StartedJob job = (StartedJob)link.datum;
            Date now = new Date();
            job.setFinished(now.getTime());
            if (job.getJobStatus() == 69) {
                job.setJobStatus((byte)67);
            }
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
            request.subType = "org.eclipse.aperi.server.handler.scheduler.ScheduleHandler";
            request.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
            request.machineName = Agent.localName;
            request.userName = null;
            request.requestData = job;
            request.flags = (byte)2;
            ListOfLinks listOfLinks = this.runningJobs;
            synchronized (listOfLinks) {
                this.runningJobs.unlink(link);
                Agent.reporter.add(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Link addJob(StartedJob job) {
        Link jobLink;
        ListOfLinks listOfLinks = this.runningJobs;
        synchronized (listOfLinks) {
            jobLink = this.runningJobs.append(job);
        }
        return jobLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJob(Link link) {
        ListOfLinks listOfLinks = this.runningJobs;
        synchronized (listOfLinks) {
            this.runningJobs.unlink(link);
        }
    }

    private long waitToStart(long desiredStartTime) {
        long now;
        while ((now = System.currentTimeMillis()) < desiredStartTime) {
            try {
                Thread.sleep(desiredStartTime - now);
            }
            catch (InterruptedException e) {}
        }
        return now;
    }
}

