/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.script;

import java.io.File;
import java.io.PrintWriter;
import org.eclipse.aperi.agent.handler.script.AbstractScriptHandler;
import org.eclipse.aperi.agent.handler.script.ScriptContext;
import org.eclipse.aperi.agent.handler.script.ScriptReaper;
import org.eclipse.aperi.agent.handler.script.WindowsScriptReaper;
import org.eclipse.aperi.agent.handler.script.unix.IPlatformSpecific;
import org.eclipse.aperi.agent.handler.script.unix.UnixScriptContext;
import org.eclipse.aperi.agent.nas.NasUtil;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.WindowsCommandContext;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.backend.WindowsScript;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class WindowsScriptRunner
implements IAssignable {
    public static String systemDirectory;
    private String logFile;
    private PrintWriter out;
    private RunScriptReq requestData;
    private boolean purge;

    private static native void init(String var0);

    private static native long spawn(String var0, String var1, String var2, long var3, long var5) throws LocalizableException;

    public static native int waitForProcess(long var0) throws LocalizableException;

    private WindowsScriptRunner(RunScriptReq pRequestData, String pLogFile, PrintWriter pOut, boolean pPurge) {
        this.requestData = pRequestData;
        this.logFile = pLogFile;
        this.out = pOut;
        this.purge = pPurge;
    }

    public static AbstractScriptHandler makeHandler() {
        return new WindowsScriptHandler();
    }

    public void execute() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)WindowsScriptRunner.class.getName(), (String)"execute", (String)"");
        }
        PrintWriter oldLog = MessageLog.getThreadLog();
        MessageLog.setThreadLog((PrintWriter)this.out);
        String tempScript = null;
        String displayedName = null;
        String arg0 = this.requestData.scrArgv[0];
        WindowsScript ws = JobUtil.resolveWindowsScript((String)arg0);
        if (ws != null) {
            displayedName = ws.wsResolvedName;
        } else if (Agent.honorSentScripts && this.requestData.scrData != null && this.requestData.scrData[0] != null) {
            File temp;
            displayedName = arg0;
            int dot = arg0.lastIndexOf(46);
            if (dot >= 0) {
                this.requestData.scrExtension = arg0.substring(dot + 1);
            }
            String ext = '.' + this.requestData.scrExtension;
            if (dot < 0) {
                displayedName = displayedName + ext;
            }
            if ((temp = AbstractScriptHandler.writeTempFile("SCR", ext, this.requestData.scrData[0])) != null) {
                int index = WindowsScript.indexForExtension((String)this.requestData.scrExtension);
                tempScript = temp.getName();
                ws = new WindowsScript(index, tempScript);
            }
        }
        if (ws == null) {
            MessageLog.logMessage((String)"AGT0132E", (Object)arg0);
            MessageLog.setThreadLog((PrintWriter)oldLog);
            this.out.close();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)WindowsScriptRunner.class.getName(), (String)"execute");
            }
            return;
        }
        ScriptContext ctx = new ScriptContext();
        try {
            ctx.tempFiles = AbstractScriptHandler.makeMoreTempFiles(this.requestData, tempScript, this.purge);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)WindowsScriptRunner.class.getName(), (String)"execute", (Throwable)e);
            }
            MessageLog.setThreadLog((PrintWriter)oldLog);
            this.out.close();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)WindowsScriptRunner.class.getName(), (String)"execute");
            }
            return;
        }
        ctx.logFileName = this.logFile;
        String exe = null;
        StringBuffer cmdBuf = new StringBuffer();
        switch (ws.wsInterpreter) {
            case 0: {
                exe = JobUtil.scriptsDir + '\\' + ws.wsResolvedName;
                cmdBuf.append(arg0);
                break;
            }
            case 1: {
                exe = systemDirectory + "\\CMD.EXE";
                cmdBuf.append("CMD /C ");
                cmdBuf.append(ws.wsResolvedName);
                break;
            }
            case 2: {
                exe = systemDirectory + "\\CSCRIPT.EXE";
                cmdBuf.append("CSCRIPT ");
                cmdBuf.append(ws.wsResolvedName);
            }
        }
        int startLength = cmdBuf.length();
        for (int i = 1; i < this.requestData.scrArgv.length; ++i) {
            boolean hasSpaces;
            cmdBuf.append(' ');
            String parm = this.requestData.scrArgv[i];
            if (parm == null) continue;
            boolean bl = hasSpaces = parm.indexOf(32) >= 0;
            if (hasSpaces) {
                cmdBuf.append('\"');
            }
            cmdBuf.append(parm);
            if (!hasSpaces) continue;
            cmdBuf.append('\"');
        }
        String commandLine = cmdBuf.toString();
        MessageLog.logMessage((String)"AGT0133I", (Object)displayedName, (Object)commandLine.substring(startLength));
        this.out.println("--------------------- BEGIN OUTPUT ---------------------");
        boolean ok = false;
        try {
            ctx.handle = WindowsScriptRunner.spawn(exe, commandLine, this.logFile, 0L, 0L);
            ok = true;
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)WindowsScriptRunner.class.getName(), (String)"execute", (Throwable)e);
            }
            e.print();
        }
        if (ok) {
            WindowsScriptReaper.addJob(ctx, oldLog, this.out);
        } else {
            MessageLog.setThreadLog((PrintWriter)oldLog);
            this.out.close();
            ScriptReaper.removeTempFiles(ctx);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)WindowsScriptRunner.class.getName(), (String)"execute");
        }
    }

    public static IPlatformSpecific makePlatformSpecific() {
        return new WinPlatformSpecific();
    }

    static {
        WindowsScriptRunner.init(Variables.homeDirectory);
    }

    private static class WinPlatformSpecific
    implements IPlatformSpecific {
        private WinPlatformSpecific() {
        }

        public void start(UnixScriptContext uContext) throws LocalizableException {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)WinPlatformSpecific.class.getName(), (String)"start", (String)"uContext");
            }
            if (!(uContext instanceof WindowsCommandContext)) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)WinPlatformSpecific.class.getName(), (String)"start");
                }
                throw new RuntimeException(MessageLog.getMessage((String)"STA0427E"));
            }
            WindowsCommandContext context = (WindowsCommandContext)uContext;
            long userHandle = 0L;
            if (context.user != null) {
                userHandle = NasUtil.logonUser(context.domain, context.user, context.password);
            }
            context.handle = WindowsScriptRunner.spawn(context.exe, context.commandLine, context.logFileName, userHandle, context.envBlock);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)WinPlatformSpecific.class.getName(), (String)"start");
            }
        }
    }

    private static class WindowsScriptHandler
    extends AbstractScriptHandler {
        private WindowsScriptHandler() {
        }

        public IAssignable makeRunner(RunScriptReq pRequestData, String pLogFile, PrintWriter pOut, boolean purge) {
            return new WindowsScriptRunner(pRequestData, pLogFile, pOut, purge);
        }
    }
}

