/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.script.unix;

import java.io.File;
import java.io.PrintWriter;
import org.eclipse.aperi.agent.handler.script.AbstractScriptHandler;
import org.eclipse.aperi.agent.handler.script.ScriptReaper;
import org.eclipse.aperi.agent.handler.script.unix.IPlatformSpecific;
import org.eclipse.aperi.agent.handler.script.unix.Shared;
import org.eclipse.aperi.agent.handler.script.unix.UnixScriptContext;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.worker.IAssignable;
import org.eclipse.aperi.backend.JobUtil;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class UnixScriptRunner
implements IAssignable {
    private static IPlatformSpecific platformSpecific = new Starter();
    private String logFile;
    private PrintWriter out;
    private RunScriptReq requestData;
    private boolean purge;

    private static native void makeExecutable(String var0);

    private UnixScriptRunner(RunScriptReq pRequestData, String pLogFile, PrintWriter pOut, boolean pPurge) {
        this.requestData = pRequestData;
        this.logFile = pLogFile;
        this.out = pOut;
        this.purge = pPurge;
    }

    public static AbstractScriptHandler makeHandler() {
        return new UnixScriptHandler();
    }

    public static IPlatformSpecific getPlatformSpecific() {
        return platformSpecific;
    }

    public void execute() {
        File temp;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UnixScriptRunner.class.getName(), (String)"execute", (String)"");
        }
        PrintWriter oldLog = MessageLog.getThreadLog();
        MessageLog.setThreadLog((PrintWriter)this.out);
        String tempScript = null;
        StringBuffer buf = new StringBuffer();
        String arg0 = this.requestData.scrArgv[0];
        String program = JobUtil.resolveUnixScript((String)arg0, (StringBuffer)buf);
        String displayedName = buf.toString();
        if (program == null && Agent.honorSentScripts && this.requestData.scrData != null && this.requestData.scrData[0] != null && (temp = AbstractScriptHandler.writeTempFile("SCR", null, this.requestData.scrData[0])) != null) {
            program = tempScript = temp.getName();
            buf.setLength(0);
            buf.append(JobUtil.scriptsDir);
            buf.append('/');
            buf.append(program);
            UnixScriptRunner.makeExecutable(buf.toString());
        }
        if (program == null) {
            MessageLog.logMessage((String)"AGT0132E", (Object)displayedName);
            MessageLog.setThreadLog((PrintWriter)oldLog);
            this.out.close();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UnixScriptRunner.class.getName(), (String)"execute");
            }
            return;
        }
        UnixScriptContext ctx = new UnixScriptContext();
        try {
            ctx.tempFiles = AbstractScriptHandler.makeMoreTempFiles(this.requestData, tempScript, this.purge);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)UnixScriptRunner.class.getName(), (String)"execute", (Throwable)e);
            }
            MessageLog.setThreadLog((PrintWriter)oldLog);
            this.out.close();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UnixScriptRunner.class.getName(), (String)"execute");
            }
            return;
        }
        ctx.logFileName = this.logFile;
        ctx.argv = this.requestData.scrArgv;
        ctx.argv[0] = program;
        buf.setLength(0);
        for (int i = 1; i < ctx.argv.length; ++i) {
            buf.append(' ');
            if (ctx.argv[i] == null) {
                ctx.argv[i] = " ";
            }
            buf.append(ctx.argv[i]);
        }
        MessageLog.logMessage((String)"AGT0133I", (Object)displayedName, (Object)buf.toString());
        this.out.println("--------------------- BEGIN OUTPUT ---------------------");
        boolean failed = true;
        try {
            platformSpecific.start(ctx);
            failed = false;
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)UnixScriptRunner.class.getName(), (String)"execute", (Throwable)e);
            }
            e.print();
        }
        ctx.argv = null;
        MessageLog.setThreadLog((PrintWriter)oldLog);
        this.out.close();
        if (failed) {
            ScriptReaper.removeTempFiles(ctx);
        } else {
            int exitStatus;
            try {
                exitStatus = Shared.awaitChild(ctx.handle);
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)UnixScriptRunner.class.getName(), (String)"execute", (Throwable)e);
                }
                e.print();
                exitStatus = -1;
            }
            ctx.scriptExited(exitStatus);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UnixScriptRunner.class.getName(), (String)"execute");
        }
    }

    private static class UnixScriptHandler
    extends AbstractScriptHandler {
        private UnixScriptHandler() {
        }

        public IAssignable makeRunner(RunScriptReq pRequestData, String pLogFile, PrintWriter pOut, boolean purge) {
            return new UnixScriptRunner(pRequestData, pLogFile, pOut, purge);
        }
    }

    private static class Starter
    implements IPlatformSpecific {
        private Starter() {
        }

        public void start(UnixScriptContext context) throws LocalizableException {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Starter.class.getName(), (String)"start", (String)"context");
            }
            Shared.fork(context);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Starter.class.getName(), (String)"start");
            }
        }
    }
}

