/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.handler.status;

import java.net.Socket;
import java.util.Date;
import java.util.HashSet;
import org.eclipse.aperi.agent.handler.IAgentRequestHandler;
import org.eclipse.aperi.agent.req.AgentStatusReq;
import org.eclipse.aperi.agent.req.AgtStatusResp;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.AuthChecker;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class StatusHandler
implements IAgentRequestHandler {
    public void handle(Request request, Response response, Socket connection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatusHandler.class.getName(), (String)"handle", (String)"request, response, connection");
        }
        if (!RequestChecker.isDesiredType(AgentStatusReq.class, (Request)request, (Response)response)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StatusHandler.class.getName(), (String)"handle");
            }
            return;
        }
        boolean brief = !((AgentStatusReq)request.requestData).isVerbose();
        boolean ok = AuthChecker.check(request, response, connection, brief);
        if (brief || !ok) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StatusHandler.class.getName(), (String)"handle");
            }
            return;
        }
        AgtStatusResp responseData = new AgtStatusResp();
        responseData.upSince = Agent.started;
        Date now = new Date();
        responseData.upTime = now.getTime() - responseData.upSince;
        responseData.vmSize = Runtime.getRuntime().totalMemory();
        responseData.manufacturer = Agent.hardwareID.manufacturer;
        responseData.hostName = Agent.hardwareID.hostName;
        responseData.osType = Agent.hardwareID.osType;
        responseData.cpuArchitecture = Agent.hardwareID.cpuArchitecture;
        responseData.jobs = new HashSet();
        Agent.jobManager.getRunningJobs(responseData.jobs);
        Agent.reporter.addUnreported(responseData.jobs);
        response.responseData = responseData;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatusHandler.class.getName(), (String)"handle");
        }
    }
}

