/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.agent.exec.CmdExecer;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class AutoMounts
extends Mounts {
    private static final int ETC_FILES = 0;
    private static final int YELLOW_PAGES = 1;
    private static final int NISPLUS = 2;
    private static final String NSSWITCH_CONF = "/etc/nsswitch.conf";
    private static final String[] nameServiceNames = new String[]{"files", "nis", "nisplus"};
    private Map mapFilesProcessed;
    private int[] nameServices;
    private List mounts;
    private Iterator iterator;

    private static String readExtendedLine(BufferedReader in, MutableBoolean atEOF) throws IOException {
        String s;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AutoMounts.class.getName(), (String)"readExtendedLine", (String)"in, atEOF");
        }
        if ((s = in.readLine()) == null || !s.endsWith("\\")) {
            if (s == null) {
                atEOF.value = true;
            }
            String traceResult = s;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AutoMounts.class.getName(), (String)"readExtendedLine", (Object)traceResult);
            }
            return traceResult;
        }
        StringBuffer buf = new StringBuffer(s);
        buf.setLength(buf.length() - 1);
        boolean going = true;
        while (going && (s = in.readLine()) != null) {
            buf.append(s);
            if (s.endsWith("\\")) {
                buf.setLength(buf.length() - 1);
                continue;
            }
            going = false;
        }
        if (s == null) {
            atEOF.value = true;
        }
        String traceResult = buf.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AutoMounts.class.getName(), (String)"readExtendedLine", (Object)traceResult);
        }
        return traceResult;
    }

    private static boolean isSingleCharacterToken(char c) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AutoMounts.class.getName(), (String)"isSingleCharacterToken", (String)"c");
        }
        boolean bl = traceResult = c == '[' || c == '=' || c == ']';
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AutoMounts.class.getName(), (String)"isSingleCharacterToken", (boolean)traceResult);
        }
        return traceResult;
    }

    private static String nextToken(String line, MutableInteger pPos) {
        int pos;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AutoMounts.class.getName(), (String)"nextToken", (String)"line, pPos");
        }
        char c = '\u0000';
        int length = line.length();
        for (pos = pPos.value; pos < length && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
        }
        if (pos >= length) {
            String traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AutoMounts.class.getName(), (String)"nextToken", traceResult);
            }
            return traceResult;
        }
        if (AutoMounts.isSingleCharacterToken(c)) {
            pPos.value = pos + 1;
            char[] array = new char[]{c};
            String traceResult = new String(array);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AutoMounts.class.getName(), (String)"nextToken", (Object)traceResult);
            }
            return traceResult;
        }
        int saved = pos;
        while (++pos < length && !Character.isWhitespace(c = line.charAt(pos)) && !AutoMounts.isSingleCharacterToken(c)) {
        }
        pPos.value = pos;
        String traceResult = line.substring(saved, pos);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AutoMounts.class.getName(), (String)"nextToken", (Object)traceResult);
        }
        return traceResult;
    }

    private boolean processAutoFSMap(AutomountMap mapFile) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AutoMounts.class.getName(), (String)"processAutoFSMap", (String)"mapFile");
        }
        boolean result = true;
        while (mapFile.lastServiceQueried < this.nameServices.length) {
            Parser parser = null;
            int nameService = this.nameServices[mapFile.lastServiceQueried];
            switch (nameService) {
                case 0: {
                    parser = new EtcFileParser(mapFile);
                    break;
                }
                case 1: {
                    parser = new YellowPagesParser(mapFile);
                    break;
                }
                case 2: {
                    parser = new NISPlusParser(mapFile);
                }
            }
            if (!parser.go()) {
                result = false;
            }
            ++mapFile.lastServiceQueried;
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AutoMounts.class.getName(), (String)"processAutoFSMap", (boolean)traceResult);
        }
        return traceResult;
    }

    private boolean processAutoFSMap(String resource, String localPath) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AutoMounts.class.getName(), (String)"processAutoFSMap", (String)"resource, localPath");
        }
        AutomountMap mapFile = new AutomountMap(resource, localPath);
        this.mapFilesProcessed.put(resource, mapFile);
        boolean traceResult = this.processAutoFSMap(mapFile);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AutoMounts.class.getName(), (String)"processAutoFSMap", (boolean)traceResult);
        }
        return traceResult;
    }

    private boolean parseNSSwitch() {
        int i;
        String piece;
        String line;
        MutableInteger pos;
        boolean exceptionOccurred;
        boolean found;
        block23: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)AutoMounts.class.getName(), (String)"parseNSSwitch", (String)"");
            }
            FileReader reader = null;
            try {
                reader = new FileReader(NSSWITCH_CONF);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)AutoMounts.class.getName(), (String)"parseNSSwitch", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0029E", (Exception)e);
            }
            if (reader == null) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)AutoMounts.class.getName(), (String)"parseNSSwitch", (boolean)traceResult);
                }
                return traceResult;
            }
            BufferedReader in = new BufferedReader(reader);
            found = false;
            exceptionOccurred = false;
            pos = new MutableInteger();
            line = null;
            piece = null;
            MutableBoolean atEOF = new MutableBoolean(false);
            try {
                while (!found && !atEOF.value) {
                    line = AutoMounts.readExtendedLine(in, atEOF);
                    if (line == null) continue;
                    pos.value = 0;
                    piece = AutoMounts.nextToken(line, pos);
                    if (piece == null || !piece.startsWith("automount")) continue;
                    found = true;
                }
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)AutoMounts.class.getName(), (String)"parseNSSwitch", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0133E", (Exception)e, (Object)NSSWITCH_CONF);
                exceptionOccurred = true;
            }
            try {
                in.close();
            }
            catch (IOException ignored) {
                if (!TraceLogger.enableTrace) break block23;
                TraceLogger.exception((String)AutoMounts.class.getName(), (String)"parseNSSwitch", (Throwable)ignored);
            }
        }
        if (!found) {
            boolean traceResult;
            boolean bl = traceResult = !exceptionOccurred;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AutoMounts.class.getName(), (String)"parseNSSwitch", (boolean)traceResult);
            }
            return traceResult;
        }
        LinkedList<MutableInteger> list = new LinkedList<MutableInteger>();
        boolean[] foundArray = new boolean[nameServiceNames.length];
        while (true) {
            if ((piece = AutoMounts.nextToken(line, pos)) != null && piece.equals("[")) {
                i = line.indexOf(93, pos.value);
                if (i < 0) {
                    pos.value = line.length();
                    continue;
                }
                pos.value = i + 1;
                continue;
            }
            if (piece != null) {
                found = false;
                i = 0;
                while (!found && i < nameServiceNames.length) {
                    if (piece.equals(nameServiceNames[i])) {
                        found = true;
                        continue;
                    }
                    ++i;
                }
                if (found && !foundArray[i]) {
                    foundArray[i] = true;
                    list.add(new MutableInteger(i));
                }
            }
            if (piece == null) break;
        }
        i = 0;
        this.nameServices = new int[list.size()];
        for (MutableInteger obj : list) {
            this.nameServices[i] = obj.value;
            ++i;
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AutoMounts.class.getName(), (String)"parseNSSwitch", (boolean)traceResult);
        }
        return traceResult;
    }

    public boolean openMnttab() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AutoMounts.class.getName(), (String)"openMnttab", (String)"");
        }
        boolean ok = this.parseNSSwitch();
        if (this.nameServices == null) {
            boolean traceResult = ok;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AutoMounts.class.getName(), (String)"openMnttab", (boolean)traceResult);
            }
            return traceResult;
        }
        this.mounts = new LinkedList();
        this.mapFilesProcessed = new HashMap();
        this.processAutoFSMap("auto_master", null);
        this.mapFilesProcessed = null;
        this.iterator = this.mounts.iterator();
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AutoMounts.class.getName(), (String)"openMnttab", (boolean)traceResult);
        }
        return traceResult;
    }

    public boolean nextMount() {
        boolean result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AutoMounts.class.getName(), (String)"nextMount", (String)"");
        }
        if (result = this.iterator.hasNext()) {
            Mounts mount = (Mounts)this.iterator.next();
            this.special = mount.special;
            this.mountPoint = mount.mountPoint;
            this.type = mount.type;
            this.flags = mount.flags;
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AutoMounts.class.getName(), (String)"nextMount", (boolean)traceResult);
        }
        return traceResult;
    }

    private class NISPlusParser
    extends CommandParser {
        public NISPlusParser(AutomountMap pMapFile) {
            super(pMapFile);
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)NISPlusParser.class.getName(), (String)"NISPlusParser", (String)"pMapFile");
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)NISPlusParser.class.getName(), (String)"NISPlusParser");
            }
        }

        public BufferedReader open(MutableBoolean aOK) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)NISPlusParser.class.getName(), (String)"open", (String)"aOK");
            }
            String[] argv = new String[]{"/usr/bin/niscat", this.mapFile.name + ".org_dir"};
            BufferedReader traceResult = this.open(argv, aOK);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)NISPlusParser.class.getName(), (String)"open", (Object)traceResult);
            }
            return traceResult;
        }
    }

    private class YellowPagesParser
    extends CommandParser {
        public YellowPagesParser(AutomountMap pMapFile) {
            super(pMapFile);
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)YellowPagesParser.class.getName(), (String)"YellowPagesParser", (String)"pMapFile");
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)YellowPagesParser.class.getName(), (String)"YellowPagesParser");
            }
        }

        public BufferedReader open(MutableBoolean aOK) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)YellowPagesParser.class.getName(), (String)"open", (String)"aOK");
            }
            String[] argv = new String[]{"/usr/bin/ypcat", "-k", this.mapFile.name};
            BufferedReader traceResult = this.open(argv, aOK);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)YellowPagesParser.class.getName(), (String)"open", (Object)traceResult);
            }
            return traceResult;
        }
    }

    private abstract class CommandParser
    extends Parser {
        private File tempFile;

        public CommandParser(AutomountMap pMapFile) {
            super(pMapFile);
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CommandParser.class.getName(), (String)"CommandParser", (String)"pMapFile");
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommandParser.class.getName(), (String)"CommandParser");
            }
        }

        protected void cleanUp() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CommandParser.class.getName(), (String)"cleanUp", (String)"");
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
                this.tempFile = null;
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommandParser.class.getName(), (String)"cleanUp");
            }
        }

        protected BufferedReader open(String[] commandLine, MutableBoolean aOK) {
            BufferedReader result;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CommandParser.class.getName(), (String)"open", (String)"commandLine, aOK");
            }
            this.tempFile = null;
            aOK.value = false;
            CmdExecer execer = new CmdExecer(commandLine);
            if (!execer.exec()) {
                aOK.value = true;
                BufferedReader traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)CommandParser.class.getName(), (String)"open", traceResult);
                }
                return traceResult;
            }
            try {
                this.tempFile = File.createTempFile("TRLLS", null);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)CommandParser.class.getName(), (String)"open", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)e);
            }
            FileWriter writer = null;
            if (this.tempFile != null) {
                try {
                    writer = new FileWriter(this.tempFile);
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)CommandParser.class.getName(), (String)"open", (Throwable)e);
                    }
                    MessageLog.logMessage((String)"GEN0002E", (Object)e.getMessage());
                }
            }
            if (writer == null) {
                execer.close();
                this.cleanUp();
                BufferedReader traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)CommandParser.class.getName(), (String)"open", traceResult);
                }
                return traceResult;
            }
            BufferedWriter out = new BufferedWriter(writer);
            boolean triedClose = false;
            boolean wasWriting = false;
            try {
                String s;
                while ((s = execer.stdout.readLine()) != null) {
                    wasWriting = true;
                    out.write(s);
                    out.newLine();
                    wasWriting = false;
                }
                wasWriting = true;
                triedClose = true;
                out.close();
                aOK.value = true;
            }
            catch (IOException e) {
                Object[] args;
                String s;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)CommandParser.class.getName(), (String)"open", (Throwable)e);
                }
                if (wasWriting) {
                    s = "GEN0152E";
                    args = new Object[]{this.tempFile.getPath()};
                } else {
                    s = "AGT0016E";
                    args = null;
                }
                MessageLog.logException((String)s, (Exception)e, (Object[])args);
            }
            execer.close();
            if (!aOK.value) {
                block29: {
                    if (!triedClose) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (IOException ignored) {
                            if (!TraceLogger.enableTrace) break block29;
                            TraceLogger.exception((String)CommandParser.class.getName(), (String)"open", (Throwable)ignored);
                        }
                    }
                }
                this.cleanUp();
                BufferedReader traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)CommandParser.class.getName(), (String)"open", traceResult);
                }
                return traceResult;
            }
            FileReader reader = null;
            try {
                reader = new FileReader(this.tempFile);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)CommandParser.class.getName(), (String)"open", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0029E", (Exception)e);
                aOK.value = false;
            }
            if (reader != null) {
                result = new BufferedReader(reader);
            } else {
                result = null;
                this.cleanUp();
            }
            BufferedReader traceResult = result;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CommandParser.class.getName(), (String)"open", (Object)traceResult);
            }
            return traceResult;
        }
    }

    private class EtcFileParser
    extends Parser {
        public EtcFileParser(AutomountMap pMapFile) {
            super(pMapFile);
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)EtcFileParser.class.getName(), (String)"EtcFileParser", (String)"pMapFile");
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)EtcFileParser.class.getName(), (String)"EtcFileParser");
            }
        }

        protected BufferedReader open(MutableBoolean aOK) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)EtcFileParser.class.getName(), (String)"open", (String)"aOK");
            }
            aOK.value = true;
            String path = "/etc/" + this.mapFile.name;
            BufferedReader traceResult = this.doOpen(path, null);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)EtcFileParser.class.getName(), (String)"open", (Object)traceResult);
            }
            return traceResult;
        }

        protected boolean handleInclude(String resource) {
            boolean result;
            int length;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)EtcFileParser.class.getName(), (String)"handleInclude", (String)"resource");
            }
            if (!resource.regionMatches(1, this.mapFile.name, 0, length = resource.length() - 1)) {
                result = true;
            } else {
                ++this.mapFile.lastServiceQueried;
                result = AutoMounts.this.processAutoFSMap(this.mapFile);
            }
            boolean traceResult = result;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)EtcFileParser.class.getName(), (String)"handleInclude", (boolean)traceResult);
            }
            return traceResult;
        }
    }

    private abstract class Parser {
        protected AutomountMap mapFile;
        private int level;

        public Parser(AutomountMap pMapFile) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Parser.class.getName(), (String)"Parser", (String)"pMapFile");
            }
            this.mapFile = pMapFile;
            this.level = this.mapFile.lastServiceQueried;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Parser.class.getName(), (String)"Parser");
            }
        }

        protected abstract BufferedReader open(MutableBoolean var1);

        protected BufferedReader doOpen(String path, MutableBoolean aOK) {
            FileReader reader;
            block5: {
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)Parser.class.getName(), (String)"doOpen", (String)"path, aOK");
                }
                reader = null;
                try {
                    reader = new FileReader(path);
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Parser.class.getName(), (String)"doOpen", (Throwable)e);
                    }
                    if (aOK == null) break block5;
                    MessageLog.logException((String)"GEN0029E", (Exception)e);
                    aOK.value = false;
                }
            }
            BufferedReader result = reader == null ? null : new BufferedReader(reader);
            BufferedReader traceResult = result;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Parser.class.getName(), (String)"doOpen", (Object)traceResult);
            }
            return traceResult;
        }

        protected boolean handleInclude(String included) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Parser.class.getName(), (String)"handleInclude", (String)"included");
            }
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Parser.class.getName(), (String)"handleInclude", (boolean)traceResult);
            }
            return traceResult;
        }

        protected void cleanUp() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Parser.class.getName(), (String)"cleanUp", (String)"");
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Parser.class.getName(), (String)"cleanUp");
            }
        }

        private String extractFSType(String line, int pos, int length) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Parser.class.getName(), (String)"extractFSType", (String)"line, pos, length");
            }
            String result = null;
            do {
                int next;
                if ((next = line.indexOf(44, pos)) < 0) {
                    next = length;
                }
                if (line.regionMatches(pos, "fstype=", 0, 7)) {
                    result = line.substring(pos + 7, next);
                }
                pos = next + 1;
            } while (result == null && pos < length);
            String traceResult = result;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Parser.class.getName(), (String)"extractFSType", (Object)traceResult);
            }
            return traceResult;
        }

        private boolean handleAutoFS(String localPath, String resource) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Parser.class.getName(), (String)"handleAutoFS", (String)"localPath, resource");
            }
            if (AutoMounts.this.mapFilesProcessed.containsKey(resource)) {
                boolean traceResult = true;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Parser.class.getName(), (String)"handleAutoFS", (boolean)traceResult);
                }
                return traceResult;
            }
            if (resource.indexOf(58) >= 0) {
                Object[] args = new Object[]{this.mapFile.name, localPath, resource};
                MessageLog.logMessage((String)"NAA0112I", (Object[])args);
            }
            boolean traceResult = AutoMounts.this.processAutoFSMap(resource, localPath);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Parser.class.getName(), (String)"handleAutoFS", (boolean)traceResult);
            }
            return traceResult;
        }

        private boolean handleNFSImport(String localPath, String resource) {
            int colon;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)Parser.class.getName(), (String)"handleNFSImport", (String)"localPath, resource");
            }
            if ((colon = resource.indexOf(58)) <= 0) {
                Object[] args = new Object[]{this.mapFile.name, localPath, resource};
                MessageLog.logMessage((String)"NAA0113W", (Object[])args);
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)Parser.class.getName(), (String)"handleNFSImport", (boolean)traceResult);
                }
                return traceResult;
            }
            String host = resource.substring(0, colon);
            boolean massageNeeded = false;
            int pos = host.indexOf(44);
            if (pos > 0) {
                host = host.substring(0, pos);
                massageNeeded = true;
            }
            if ((pos = host.indexOf(40)) > 0) {
                host = host.substring(0, pos);
                massageNeeded = true;
            }
            if (massageNeeded) {
                resource = host + resource.substring(colon);
            }
            Mounts mount = new Mounts();
            mount.special = resource;
            mount.mountPoint = localPath;
            mount.type = "nfs";
            mount.flags = 14;
            AutoMounts.this.mounts.add(mount);
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Parser.class.getName(), (String)"handleNFSImport", (boolean)traceResult);
            }
            return traceResult;
        }

        public boolean go() {
            boolean ok;
            block22: {
                MutableBoolean boolObj;
                BufferedReader in;
                if (TraceLogger.enableTrace) {
                    TraceLogger.entry((String)Parser.class.getName(), (String)"go", (String)"");
                }
                if ((in = this.open(boolObj = new MutableBoolean())) == null) {
                    boolean traceResult = boolObj.value;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)Parser.class.getName(), (String)"go", (boolean)traceResult);
                    }
                    return traceResult;
                }
                MutableInteger pos = new MutableInteger();
                MutableBoolean atEOF = new MutableBoolean(false);
                ok = true;
                try {
                    while (!atEOF.value) {
                        boolean tOK;
                        int p;
                        String line = AutoMounts.readExtendedLine(in, atEOF);
                        if (line == null) continue;
                        pos.value = 0;
                        String key = AutoMounts.nextToken(line, pos);
                        if (key == null) continue;
                        String localPath = this.mapFile.fullyQualified(key, boolObj);
                        if (localPath == null) {
                            if (!boolObj.value || this.handleInclude(key)) continue;
                            ok = false;
                            continue;
                        }
                        int length = line.length();
                        boolean recurse = this.mapFile.isMaster();
                        String resource = null;
                        String fsType = null;
                        boolean atEOL = false;
                        while (!(atEOL || resource != null && fsType != null)) {
                            String s = AutoMounts.nextToken(line, pos);
                            if (s == null) {
                                atEOL = true;
                                continue;
                            }
                            if (s.charAt(0) != '-') {
                                if (resource != null) continue;
                                resource = s;
                                continue;
                            }
                            if (s.equals("-null") || s.equals("-hosts") || s.equals("-xfn")) {
                                resource = null;
                                atEOL = true;
                                continue;
                            }
                            int start = pos.value - s.length() + 1;
                            while (pos.value < length && !Character.isWhitespace(line.charAt(pos.value))) {
                                ++pos.value;
                            }
                            if (fsType != null || (s = this.extractFSType(line, start, pos.value)) == null) continue;
                            fsType = s;
                        }
                        if (fsType != null) {
                            if (fsType.equals("autofs")) {
                                recurse = true;
                            } else if (!fsType.equals("nfs")) {
                                resource = null;
                            }
                        }
                        if (resource == null) continue;
                        if (key.charAt(0) != '/' && (p = resource.indexOf(38)) >= 0) {
                            StringBuffer buf = new StringBuffer(length);
                            int oldPos = 0;
                            do {
                                buf.append(resource.substring(oldPos, p));
                                buf.append(key);
                            } while ((p = resource.indexOf(38, oldPos = p + 1)) >= oldPos);
                            buf.append(resource.substring(oldPos));
                            resource = buf.toString();
                        }
                        if (tOK = !recurse ? this.handleNFSImport(localPath, resource) : this.handleAutoFS(localPath, resource)) continue;
                        ok = false;
                    }
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)Parser.class.getName(), (String)"go", (Throwable)e);
                    }
                    String nameService = nameServiceNames[AutoMounts.this.nameServices[this.level]];
                    Object[] args = new Object[]{this.mapFile.name, nameService};
                    MessageLog.logException((String)"NAA0111W", (Exception)e, (Object[])args);
                    ok = false;
                }
                try {
                    in.close();
                }
                catch (IOException ignored) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception((String)Parser.class.getName(), (String)"go", (Throwable)ignored);
                }
            }
            this.cleanUp();
            boolean traceResult = ok;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Parser.class.getName(), (String)"go", (boolean)traceResult);
            }
            return traceResult;
        }
    }

    private static class AutomountMap {
        public int lastServiceQueried;
        public final String name;
        private String directory;
        private Map subdirs;

        public AutomountMap(String pName, String pDirectory) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)AutomountMap.class.getName(), (String)"AutomountMap", (String)"pName, pDirectory");
            }
            this.name = pName;
            this.lastServiceQueried = 0;
            this.directory = pDirectory;
            this.subdirs = new HashMap();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AutomountMap.class.getName(), (String)"AutomountMap");
            }
        }

        public boolean isMaster() {
            boolean traceResult;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)AutomountMap.class.getName(), (String)"isMaster", (String)"");
            }
            boolean bl = traceResult = this.directory == null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AutomountMap.class.getName(), (String)"isMaster", (boolean)traceResult);
            }
            return traceResult;
        }

        public String fullyQualified(String subdir, MutableBoolean startsWithPlus) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)AutomountMap.class.getName(), (String)"fullyQualified", (String)"subdir, startsWithPlus");
            }
            startsWithPlus.value = false;
            if (subdir.length() == 0) {
                String traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)AutomountMap.class.getName(), (String)"fullyQualified", traceResult);
                }
                return traceResult;
            }
            char c = subdir.charAt(0);
            switch (c) {
                case '+': {
                    startsWithPlus.value = true;
                }
                case '#': 
                case '*': {
                    String traceResult = null;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)AutomountMap.class.getName(), (String)"fullyQualified", traceResult);
                    }
                    return traceResult;
                }
            }
            String result = null;
            if (this.isMaster()) {
                if (c == '/') {
                    result = subdir;
                }
            } else if (c != '/') {
                result = subdir;
            }
            if (result != null) {
                if (this.subdirs.containsKey(result)) {
                    result = null;
                } else {
                    this.subdirs.put(result, result);
                    if (!this.isMaster()) {
                        result = this.directory + '/' + result;
                    }
                }
            }
            String traceResult = result;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AutomountMap.class.getName(), (String)"fullyQualified", (Object)traceResult);
            }
            return traceResult;
        }
    }
}

