/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.nas.netapp;

import java.io.Serializable;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpVarBind;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class TableHandler {
    protected OID oid;
    protected long[] array;
    protected NasFiler filer;
    protected Computer comp;
    protected SnmpSession listener;
    protected String badTypeMsgID;
    protected int tableOIDLength;

    private static boolean agreeUpTo(long[] a1, long[] a2, int l) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TableHandler.class.getName(), (String)"agreeUpTo", (String)"a1, a2, l");
        }
        boolean match = true;
        while (match && l > 0) {
            if (a1[--l] == a2[l]) continue;
            match = false;
        }
        boolean traceResult = match;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TableHandler.class.getName(), (String)"agreeUpTo", (boolean)traceResult);
        }
        return traceResult;
    }

    public TableHandler(OID pOID, NasFiler pFiler, SnmpSession pListener) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TableHandler.class.getName(), (String)"TableHandler", (String)"pOID, pFiler, pListener");
        }
        this.oid = pOID;
        this.array = this.oid.value;
        this.filer = pFiler;
        this.comp = this.filer.nfComputer;
        this.listener = pListener;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TableHandler.class.getName(), (String)"TableHandler");
        }
    }

    protected abstract String checkNameLength();

    protected abstract boolean typeOK(Serializable var1);

    protected abstract void process(Serializable var1) throws GeneralException;

    private boolean inTable(long[] returnedArray) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TableHandler.class.getName(), (String)"inTable", (String)"returnedArray");
        }
        boolean bl = traceResult = returnedArray.length >= this.tableOIDLength && TableHandler.agreeUpTo(this.array, returnedArray, this.tableOIDLength);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TableHandler.class.getName(), (String)"inTable", (boolean)traceResult);
        }
        return traceResult;
    }

    public boolean go() {
        boolean ok;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TableHandler.class.getName(), (String)"go", (String)"");
        }
        String msgID = "NAA0079E";
        GeneralException exc = null;
        boolean going = true;
        SnmpPDU requestPDU = this.listener.makePDU();
        SnmpVarBind requestVB = new SnmpVarBind(this.oid);
        requestPDU.addVarBind(requestVB);
        requestPDU.operation = 1;
        while (going && exc == null) {
            Object s;
            SnmpVarBind varbind = null;
            SnmpPDU responsePDU = this.listener.send(requestPDU);
            if (responsePDU != null) {
                if (responsePDU.errorStatus == 101) {
                    msgID = "NAA0075E";
                    exc = this.makeGeneralException(responsePDU);
                    continue;
                }
                if (responsePDU.errorStatus != 0) {
                    msgID = "NAA0078E";
                    exc = this.makeGeneralException(responsePDU);
                    continue;
                }
                if (responsePDU.varBindListSize() > 0) {
                    varbind = responsePDU.varBindAt(0);
                }
            }
            if (varbind == null) {
                s = MessageLog.getMessage((String)"NAA0080E");
                exc = new GeneralException((String)s);
                continue;
            }
            OID returnedOID = varbind.getOID();
            if (returnedOID == null) {
                s = MessageLog.getMessage((String)"NAA0082E");
                exc = new GeneralException((String)s);
                continue;
            }
            long[] returnedArray = returnedOID.value;
            if (!this.inTable(returnedArray)) {
                going = false;
                continue;
            }
            this.array = returnedArray;
            requestVB.set_oid(new OID(this.array));
            s = this.checkNameLength();
            if (s != null) {
                exc = new GeneralException(MessageLog.getMessage((String)s));
                continue;
            }
            Serializable value = varbind.getVar();
            s = value == null ? "null" : (this.typeOK(value) ? null : value.getClass().getName());
            if (s == null) {
                try {
                    this.process(value);
                }
                catch (GeneralException exception) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)TableHandler.class.getName(), (String)"go", (Throwable)exception);
                    }
                    exc = exception;
                }
                continue;
            }
            s = MessageLog.getMessage((String)this.badTypeMsgID, (Object)s);
            exc = new GeneralException((String)s);
        }
        boolean bl = ok = exc == null;
        if (!ok) {
            MessageLog.logException((String)msgID, exc, (Object)this.filer.nfName);
            MessageLog.logMessage((String)"NAA0081I", (Object)this.oid.toString());
        }
        boolean traceResult = ok;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TableHandler.class.getName(), (String)"go", (boolean)traceResult);
        }
        return traceResult;
    }

    private GeneralException makeGeneralException(SnmpPDU pdu) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TableHandler.class.getName(), (String)"makeGeneralException", (String)"pdu");
        }
        String s = MessageLog.getMessage((String)"NAA0005W");
        GeneralException traceResult = new GeneralException(s);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TableHandler.class.getName(), (String)"makeGeneralException", (Object)((Object)traceResult));
        }
        return traceResult;
    }
}

