/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.probe;

import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.agent.nas.netapp.ProbeNetAppFiler;
import org.eclipse.aperi.agent.probe.CommonProbe;
import org.eclipse.aperi.agent.probe.HBAAPIWWN;
import org.eclipse.aperi.agent.probe.ProbeWin32;
import org.eclipse.aperi.agent.probe.WWNviaHBAAPI;
import org.eclipse.aperi.agent.svp.Agent;
import org.eclipse.aperi.agent.util.Mounts;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class Probe
extends CommonProbe {
    public HBAAPIWWN hbaList = null;

    private native boolean getExports();

    public static native boolean enumExports(Computer var0, String var1);

    public int probe(ProbeDefResp pProbeDef) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Probe.class.getName(), (String)"probe", (String)"pProbeDef");
        }
        this.probeDef = pProbeDef;
        this.computer = new Computer();
        this.computer.cmpOSType = Agent.hardwareID.osType;
        this.computer.cmpCPUArchitecture = Agent.hardwareID.cpuArchitecture;
        this.computer.cmpID = ComputerID.cachedCID.computerID;
        this.rc = 8;
        this.platformSpecific();
        if (this.rc > 4) {
            int traceResult = this.rc;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"probe", (int)traceResult);
            }
            return traceResult;
        }
        this.computer.cmpLastBootTime = Agent.systemBoot;
        this.tallyGlobals();
        this.tallyFS(this.computer);
        if (!this.getExports()) {
            this.rc = 4;
        }
        Probe.sortExports(this.computer);
        if (this instanceof ProbeWin32) {
            this.correlateExports();
        }
        int traceResult = this.rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Probe.class.getName(), (String)"probe", (int)traceResult);
        }
        return traceResult;
    }

    private void handleNFSMount(Mounts mount) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Probe.class.getName(), (String)"handleNFSMount", (String)"mount");
        }
        if (this.probeDef.pdNasFiler == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleNFSMount");
            }
            return;
        }
        String s = mount.special;
        int pos = s.indexOf(":/");
        if (pos <= 0) {
            MessageLog.logMessage((String)"NAA0039W", (Object)s);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleNFSMount");
            }
            return;
        }
        String hostName = s.substring(0, pos).toLowerCase();
        NasFiler nf = this.probeDef.pdNasFiler;
        while (nf != null && !nf.nfNetworkName.equals(hostName)) {
            nf = nf.nfNext;
        }
        if (nf == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleNFSMount");
            }
            return;
        }
        String mountPoint = s.substring(pos + 1);
        Filesystem prev = null;
        Filesystem fs = nf.nfFilesystems;
        while (fs != null && !fs.fsMountPoint.equals(mountPoint)) {
            prev = fs;
            fs = fs.fsNext;
        }
        if (fs == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleNFSMount");
            }
            return;
        }
        if (prev == null) {
            nf.nfFilesystems = fs.fsNext;
        } else {
            prev.fsNext = fs.fsNext;
        }
        if (mount.statFS(fs) != 0) {
            this.rc = 4;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleNFSMount");
            }
            return;
        }
        fs.fsScanningCompID = ComputerID.cachedCID.computerID;
        fs.fsType = (short)-1;
        NasFiler filer = this.computer.cmpNasFiler;
        while (filer != null && filer.nfComputerID != nf.nfComputerID) {
            filer = filer.nfNext;
        }
        if (filer == null) {
            filer = new NasFiler();
            filer.nfComputerID = nf.nfComputerID;
            filer.nfName = nf.nfName;
            filer.nfNetworkName = nf.nfNetworkName;
            filer.nfIPAddress = nf.nfIPAddress;
            filer.nfManufacturer = nf.nfManufacturer;
            Probe.makeNASComputer(filer);
            if (!Probe.enumExports(filer.nfComputer, filer.nfNetworkName)) {
                this.rc = 4;
            }
            Probe.sortExports(filer.nfComputer);
            filer.nfNext = this.computer.cmpNasFiler;
            this.computer.cmpNasFiler = filer;
        }
        Probe.addFSToFiler(filer, fs);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Probe.class.getName(), (String)"handleNFSMount");
        }
    }

    private void handleSANFSMount(Mounts mount) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Probe.class.getName(), (String)"handleSANFSMount", (String)"mount");
        }
        if (this.probeDef.pdNasFiler == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleSANFSMount");
            }
            return;
        }
        String sanfsClusterName = mount.special;
        if (sanfsClusterName.length() <= 0) {
            MessageLog.logMessage((String)"NAA0116I", (Object)sanfsClusterName);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleSANFSMount");
            }
            return;
        }
        int rc = 0;
        NasFiler nf = this.probeDef.pdNasFiler;
        while (nf != null && nf.nfOSType != 23 && nf.nfName.compareToIgnoreCase(sanfsClusterName) != 0) {
            nf = nf.nfNext;
        }
        if (nf == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleSANFSMount");
            }
            return;
        }
        Filesystem fs = nf.nfFilesystems;
        if (fs == null) {
            rc = 4;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleSANFSMount");
            }
            return;
        }
        if (mount.statFS(fs) != 0) {
            rc = 4;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleSANFSMount");
            }
            return;
        }
        fs.fsScanningCompID = ComputerID.cachedCID.computerID;
        fs.fsType = (short)18;
        fs.fsFreeInodes = -1;
        fs.fsMaxFiles = -1;
        fs.fsUsedInodes = -1;
        NasFiler filer = this.computer.cmpNasFiler;
        while (filer != null && filer.nfComputerID != nf.nfComputerID) {
            filer = filer.nfNext;
        }
        if (filer == null) {
            filer = new NasFiler();
            filer.nfComputerID = nf.nfComputerID;
            filer.nfName = nf.nfName;
            filer.nfNetworkName = nf.nfNetworkName;
            filer.nfIPAddress = nf.nfIPAddress;
            filer.nfManufacturer = nf.nfManufacturer;
            Probe.makeNASComputer(filer);
            filer.nfComputer.cmpOSType = (short)23;
            filer.nfComputer.cmpFilesystemFreeSpace += fs.fsFreeSpace;
            filer.nfNext = this.computer.cmpNasFiler;
            this.computer.cmpNasFiler = filer;
        }
        Probe.addFSToFiler(filer, fs);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Probe.class.getName(), (String)"handleSANFSMount");
        }
    }

    protected int handleTMPFS(Mounts mounts) {
        LogicalDisk logicalDisk;
        Filesystem filesystem;
        int result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Probe.class.getName(), (String)"handleTMPFS", (String)"mounts");
        }
        if ((result = mounts.statFS(filesystem = new Filesystem())) > 0) {
            int traceResult = result;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleTMPFS", (int)traceResult);
            }
            return traceResult;
        }
        filesystem.fsType = (short)10;
        filesystem.fsMountPoint = mounts.mountPoint;
        filesystem.fsLogicalDisk = logicalDisk = new LogicalDisk();
        logicalDisk.ldFilesystem = filesystem;
        logicalDisk.ldType = (byte)4;
        logicalDisk.ldCollectionList = null;
        StringBuffer buf = new StringBuffer(40);
        buf.append("VM_");
        buf.append(Integer.toHexString(ComputerID.cachedCID.computerID));
        logicalDisk.ldTruePath = logicalDisk.ldPath = buf.toString();
        logicalDisk.ldCapacity = this.computer.cmpRAM + this.computer.cmpSwapSpace;
        logicalDisk.ldCapacity <<= 11;
        logicalDisk.ldNext = this.computer.cmpLogicalDisk;
        this.computer.cmpLogicalDisk = logicalDisk;
        int traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Probe.class.getName(), (String)"handleTMPFS", (int)traceResult);
        }
        return traceResult;
    }

    private boolean handleAllNFSMounts(Mounts mounts) {
        boolean traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Probe.class.getName(), (String)"handleAllNFSMounts", (String)"mounts");
        }
        if (!mounts.openMnttab()) {
            boolean traceResult2 = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"handleAllNFSMounts", (boolean)traceResult2);
            }
            return traceResult2;
        }
        while (this.rc <= 4 && mounts.nextMount()) {
            if (Agent.stopNow) {
                MessageLog.logMessage((String)"AGT0157E");
                this.rc = 8;
                continue;
            }
            if (mounts.type != null && mounts.type.startsWith("nfs")) {
                this.handleNFSMount(mounts);
                continue;
            }
            if (mounts.type == null || !mounts.type.equalsIgnoreCase("sanfs")) continue;
            this.handleSANFSMount(mounts);
        }
        boolean bl = traceResult = this.rc <= 4;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Probe.class.getName(), (String)"handleAllNFSMounts", (boolean)traceResult);
        }
        return traceResult;
    }

    public int probeNAS(ProbeDefResp def, Computer comp) {
        Mounts mounts;
        NasFiler next;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Probe.class.getName(), (String)"probeNAS", (String)"def, comp");
        }
        this.computer = comp;
        this.probeDef = def;
        NasFiler head = null;
        NasFiler prev = null;
        NasFiler filer = this.probeDef.pdNasFiler;
        while (filer != null) {
            next = filer.nfNext;
            if (!Constants.supportsFullProbe((short)filer.nfOSType)) {
                prev = filer;
            } else {
                if (prev != null) {
                    prev.nfNext = next;
                } else {
                    this.probeDef.pdNasFiler = next;
                }
                filer.nfNext = head;
                head = filer;
            }
            filer = next;
        }
        this.rc = 0;
        while (this.rc <= 4 && head != null) {
            next = head.nfNext;
            ProbeNetAppFiler prober = new ProbeNetAppFiler();
            int tRC = Agent.stopNow ? 8 : prober.probe(head, null);
            if (tRC > 4) {
                this.rc = 4;
            } else {
                if (tRC > this.rc) {
                    this.rc = tRC;
                }
                if (!Probe.enumExports(head.nfComputer, head.nfNetworkName)) {
                    this.rc = 4;
                }
                Probe.sortExports(head.nfComputer);
                head.nfNext = this.computer.cmpNasFiler;
                this.computer.cmpNasFiler = head;
            }
            head = next;
        }
        if (this.rc > 4) {
            int traceResult = this.rc;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"probeNAS", (int)traceResult);
            }
            return traceResult;
        }
        if (this.probeDef.pdNasFiler != null && !this.handleAllNFSMounts(mounts = new Mounts())) {
            int traceResult = 8;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Probe.class.getName(), (String)"probeNAS", (int)traceResult);
            }
            return traceResult;
        }
        int traceResult = this.rc;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Probe.class.getName(), (String)"probeNAS", (int)traceResult);
        }
        return traceResult;
    }

    protected void getHBAPortWWNs() {
        WWNviaHBAAPI enumerator = new WWNviaHBAAPI();
        this.hbaList = null;
        try {
            this.hbaList = enumerator.findWWNs();
        }
        catch (LocalizableException e) {
            e.print();
        }
    }

    protected void correlateHBAs() {
        HBAAPIWWN hbas = this.hbaList;
        Controller ctlr = this.computer.cmpController;
        while (ctlr != null && hbas != null) {
            ctlr.ctlrHBAPortWWN = hbas.wwName;
            hbas = hbas.wwNext;
            ctlr = ctlr.ctlrNext;
        }
        if (hbas != null) {
            int inst = 1;
            while (hbas != null) {
                Controller ctlr_new = new Controller();
                ctlr_new.ctlrID = -1;
                ctlr_new.ctlrType = (short)-1;
                ctlr_new.ctlrDriverDescription = "HBA WWN";
                ctlr_new.ctlrDriverName = "HBA WWN";
                int n = inst;
                inst = (short)(inst + 1);
                ctlr_new.ctlrInstance = (short)n;
                ctlr_new.ctlrBusNumber = 0;
                ctlr_new.ctlrTarget = (short)-1;
                ctlr_new.ctlrHBAPortWWN = hbas.wwName;
                ctlr_new.ctlrNext = this.computer.cmpController;
                this.computer.cmpController = ctlr_new;
                hbas = hbas.wwNext;
            }
        }
    }

    private static native void initIDs();

    public void correlateExports() {
    }

    static {
        Probe.initIDs();
    }
}

