/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.diskmgr.manager;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TopicPublisher;
import org.eclipse.aperi.sanmgmt.diskmgr.manager.LogTrace;
import org.eclipse.aperi.sanmgmt.event.data.SANEvent;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OID;
import org.eclipse.aperi.snmp.data.OctetString;
import org.eclipse.aperi.snmp.data.TimeTicks;

public final class Event {
    static final String className = Event.class.getName();

    public static SnmpTrap createServiceSnmpTrap(long sysUpTime, OID oid, int specific, String description, String messageID, String serviceName, LogTrace logs) {
        String methodName = "createServiceSnmpTrap";
        int genericTrap = 6;
        if (logs.trace.isLogging()) {
            logs.trace.entry((Object)className, "createServiceSnmpTrap");
        }
        SnmpTrap myTrap = new SnmpTrap();
        try {
            myTrap.genericTrap = genericTrap;
            String ipAddress = InetAddress.getLocalHost().getHostAddress();
            String hostName = InetAddress.getByName(ipAddress).getHostName();
            myTrap.agentAddr = new IPAddress(ipAddress);
            long timeAtTrap = System.currentTimeMillis() - sysUpTime;
            myTrap.timeStamp = new TimeTicks(timeAtTrap / 10L);
            myTrap.enterprise = oid;
            myTrap.specificTrap = specific;
            myTrap.addVarBind("1.3.6.1.4.1.2.6.173.1.1", (Serializable)new OctetString(description, true));
            myTrap.addVarBind("1.3.6.1.4.1.2.6.173.1.9", (Serializable)new OctetString(messageID, true));
            myTrap.addVarBind("1.3.6.1.4.1.2.6.173.1.59", (Serializable)new OctetString(serviceName, true));
            myTrap.addVarBind("1.3.6.1.4.1.2.6.173.1.60", (Serializable)new OctetString("startup/shutdown", true));
            myTrap.addVarBind("1.3.6.1.4.1.2.6.173.1.2", (Serializable)new OctetString(hostName, true));
        }
        catch (Exception e) {
            logs.messages.exception((Object)className, "createServiceSnmpTrap", (Throwable)e);
            if (logs.trace.isLogging()) {
                logs.trace.exception((Object)className, "createServiceSnmpTrap", (Throwable)e);
            }
            myTrap = null;
        }
        if (logs.trace.isLogging()) {
            logs.trace.exit((Object)className, "createServiceSnmpTrap");
        }
        return myTrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void fireSNMPEvent(String pKey, String pName, SnmpTrap trap, LogTrace logs) {
        String methodName = "fireSNMPEvent";
        if (logs.trace.isLogging()) {
            logs.trace.entry((Object)className, "fireSNMPEvent");
        }
        Factory factory = null;
        TopicPublisher publisher = null;
        try {
            factory = FactoryFactory.createFactory(2, null);
            SANEvent event = new SANEvent();
            event.setsanTrap(trap);
            event.setTECEventClass("ServiceEvent");
            event.setTECSeverity("HARMLESS");
            ObjectMessage template = factory.createMessage(null);
            template.setStringProperty(pKey, pName);
            publisher = factory.createPublisher(event.getClass().getName(), (Message)template);
            ObjectMessage publishedEvent = factory.createMessage(event);
            publisher.publish((Message)publishedEvent);
        }
        catch (Exception e) {
            logs.messages.exception((Object)className, "fireSNMPEvent", (Throwable)e);
            if (logs.trace.isLogging()) {
                logs.trace.exception((Object)className, "fireSNMPEvent", (Throwable)e);
            }
        }
        finally {
            block17: {
                try {
                    if (publisher != null) {
                        publisher.close();
                    }
                    if (factory != null) {
                        factory.close();
                    }
                }
                catch (Exception e) {
                    logs.messages.exception((Object)className, "fireSNMPEvent", (Throwable)e);
                    if (!logs.trace.isLogging()) break block17;
                    logs.trace.exception((Object)className, "fireSNMPEvent", (Throwable)e);
                }
            }
        }
        if (logs.trace.isLogging()) {
            logs.trace.exit((Object)className, "fireSNMPEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void fireTECEvent(String pKey, String pName, String comp, String func, String msgID, String msg, String sev, LogTrace logs) {
        String methodName = "fireTECEvent";
        if (logs.trace.isLogging()) {
            logs.trace.entry((Object)className, "fireTECEvent", (Object)comp, (Object)msg);
        }
        Factory factory = null;
        TopicPublisher publisher = null;
        try {
            String ipAddress;
            String hostName;
            Hashtable<String, String> attributes;
            SANEvent event;
            block18: {
                factory = FactoryFactory.createFactory(2, null);
                event = new SANEvent();
                attributes = new Hashtable<String, String>();
                attributes.put("serviceName", func);
                attributes.put("serviceState", "startup/shutdown");
                hostName = "";
                ipAddress = "";
                try {
                    ipAddress = InetAddress.getLocalHost().getHostAddress();
                    hostName = InetAddress.getByName(ipAddress).getHostName();
                }
                catch (UnknownHostException e) {
                    if (!logs.trace.isLogging()) break block18;
                    logs.trace.exception((Object)className, "fireTECEvent", (Throwable)e);
                }
            }
            event.setTECAttributes("ServiceEvent", hostName, ipAddress, "Aperi Storage Manager", func, msgID, msg, "HARMLESS", attributes);
            ObjectMessage template = factory.createMessage(null);
            template.setStringProperty(pKey, pName);
            publisher = factory.createPublisher(event.getClass().getName(), (Message)template);
            ObjectMessage publishedEvent = factory.createMessage(event);
            publisher.publish((Message)publishedEvent);
        }
        catch (Exception e) {
            logs.messages.exception((Object)className, "fireTECEvent", (Throwable)e);
            if (logs.trace.isLogging()) {
                logs.trace.exception((Object)className, "fireTECEvent", (Throwable)e);
            }
        }
        finally {
            block20: {
                try {
                    if (publisher != null) {
                        publisher.close();
                    }
                    if (factory != null) {
                        factory.close();
                    }
                }
                catch (Exception e) {
                    logs.messages.exception((Object)className, "fireTECEvent", (Throwable)e);
                    if (!logs.trace.isLogging()) break block20;
                    logs.trace.exception((Object)className, "fireTECEvent", (Throwable)e);
                }
            }
        }
        if (logs.trace.isLogging()) {
            logs.trace.exit((Object)className, "fireTECEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void fireSNMPTECEvent(String pKey, String pName, SnmpTrap trap, String comp, String func, String msgID, String msg, String sev, LogTrace logs) {
        String methodName = "fireSNMPTECEvent";
        if (logs.trace.isLogging()) {
            logs.trace.entry((Object)className, "fireSNMPTECEvent");
        }
        Factory factory = null;
        TopicPublisher publisher = null;
        try {
            String ipAddress;
            String hostName;
            Hashtable<String, String> attributes;
            SANEvent event;
            block18: {
                factory = FactoryFactory.createFactory(2, null);
                event = new SANEvent();
                event.setsanTrap(trap);
                attributes = new Hashtable<String, String>();
                attributes.put("serviceName", func);
                attributes.put("serviceState", "startup/shutdown");
                hostName = "";
                ipAddress = "";
                try {
                    ipAddress = InetAddress.getLocalHost().getHostAddress();
                    hostName = InetAddress.getByName(ipAddress).getHostName();
                }
                catch (UnknownHostException e) {
                    if (!logs.trace.isLogging()) break block18;
                    logs.trace.exception((Object)className, "fireSNMPTECEvent", (Throwable)e);
                }
            }
            event.setTECAttributes("ServiceEvent", hostName, ipAddress, "Aperi Storage Manager", func, msgID, msg, "HARMLESS", attributes);
            ObjectMessage template = factory.createMessage(null);
            template.setStringProperty(pKey, pName);
            publisher = factory.createPublisher(event.getClass().getName(), (Message)template);
            ObjectMessage publishedEvent = factory.createMessage(event);
            publisher.publish((Message)publishedEvent);
        }
        catch (Exception e) {
            logs.messages.exception((Object)className, "fireSNMPTECEvent", (Throwable)e);
            if (logs.trace.isLogging()) {
                logs.trace.exception((Object)className, "fireSNMPTECEvent", (Throwable)e);
            }
        }
        finally {
            block20: {
                try {
                    if (publisher != null) {
                        publisher.close();
                    }
                    if (factory != null) {
                        factory.close();
                    }
                }
                catch (Exception e) {
                    logs.messages.exception((Object)className, "fireSNMPTECEvent", (Throwable)e);
                    if (!logs.trace.isLogging()) break block20;
                    logs.trace.exception((Object)className, "fireSNMPTECEvent", (Throwable)e);
                }
            }
        }
        if (logs.trace.isLogging()) {
            logs.trace.exit((Object)className, "fireSNMPTECEvent");
        }
    }
}

