/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.io.File;
import java.io.FilenameFilter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.ConfigSettings;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class JobLogDeletionHandler
implements FilenameFilter {
    public static final int RESTART = -4096;
    public static String scriptsDir;
    private static NumberFormat schedRunFormat;
    private static NumberFormat jobRunFormat;
    private String dirPath = null;
    public static final String MESSAGE_NAME = "aperi.logger.message.JobDeletionHandler";
    public static final String TRACE_NAME = "aperi.logger.trace.JobDeletionHandler";
    public static String MSG_FILE;
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    static final String className;
    private long purgeBefore;
    private boolean purgeNecessary;
    private int retainDays = -100;
    private int retention = -100;

    public boolean accept(File dir, String name) {
        String methodName = "accept";
        int length = name.length();
        if (length < 20) {
            return false;
        }
        if (!name.endsWith(".log")) {
            return false;
        }
        String noExt = name.substring(0, length - 4);
        int pos = noExt.indexOf(46);
        if (pos < 0) {
            return false;
        }
        File file = new File(dir, name);
        long ts = file.lastModified();
        if (ts < this.purgeBefore) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "accept", "The File " + file.getName() + " is marked for deletion ");
            }
            return true;
        }
        return false;
    }

    private JobLogDeletionHandler() {
        String methodName = "constructor";
        this.dirPath = this.getDeviceServerLogDir();
        this.getLogRetentionValuesFromDb();
        if (this.retainDays <= 0) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "constructor", "invalid log file retention value.");
            }
            this.purgeBefore = Long.MIN_VALUE;
        } else {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "constructor", "Log file retention is " + this.retainDays + " days");
            }
            long delta = this.retainDays;
            delta *= 86400000L;
            try {
                this.purgeBefore = CurrentTime.getTimestamp().getTime() - delta;
                this.purgeNecessary = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (traceLogger != null && traceLogger.isLogging()) {
                    TraceLogger.exception(JobLogDeletionHandler.class.getName(), "constructor", e);
                }
                return;
            }
        }
        if (this.retention > 0) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFO, className, "constructor", "Number of copies to retain is " + this.retention);
            }
            this.purgeNecessary = true;
        }
    }

    public static void purgeLogFiles(int schedule_id, int current_sid_run_number) {
        String methodName = "purgeLogFiles";
        JobLogDeletionHandler purger = new JobLogDeletionHandler();
        if (!purger.purgeNecessary) {
            return;
        }
        purger.purgeLogsForSchedule(schedule_id, current_sid_run_number, purger.retention);
        File dir = new File(purger.dirPath);
        String[] files = dir.list(purger);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dir, files[i]);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, className, "purgeLogFiles", "Deleting the expired file " + file.getName());
                }
                file.delete();
            }
        }
    }

    private void purgeLogsForSchedule(int scheduleId, int current_sid_run_number, int retention) {
        String methodName = "purgeLogsForSchedule";
        if (scheduleId <= 0 || current_sid_run_number <= 0) {
            return;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "purgeLogsForSchedule", "Schedule Id = " + Integer.toString(scheduleId) + " sid_run_number= " + Integer.toString(current_sid_run_number) + " retention is " + Integer.toString(retention));
        }
        int sidNumberToPurge = current_sid_run_number - retention;
        ArrayList logFilesToDelete = this.getLogFileNames(scheduleId, sidNumberToPurge);
        for (int i = 0; i < logFilesToDelete.size(); ++i) {
            if (traceLogger == null || !traceLogger.isLogging()) continue;
            traceLogger.text(IRecordType.TYPE_INFO, className, "purgeLogsForSchedule", "Marking file " + (String)logFilesToDelete.get(i) + " For deletion");
        }
        this.purgeLogFiles(logFilesToDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void getLogRetentionValuesFromDb() {
        block26: {
            Exception e222222;
            ConfigSettings.ConfigSettingsCursor cursor;
            DBConnection dbConn;
            block23: {
                block22: {
                    String methodName = "getLogRetentionValuesFromDb";
                    dbConn = ServiceUtils.getConnection();
                    String schema = dbConn.getSchema();
                    Object logRetentionValues = null;
                    Hashtable settings = new Hashtable();
                    cursor = null;
                    cursor = ConfigSettings.getCursor(dbConn, null, null);
                    if (cursor.next()) {
                        ConfigSettings cfgSettings = cursor.getObject();
                        this.retainDays = cfgSettings.getRetainDays();
                        this.retention = cfgSettings.getRetainCopies();
                    }
                    if (traceLogger == null || !traceLogger.isLogging()) break block22;
                    traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Retain copies =" + Integer.toString(this.retention) + " retain Days =" + Integer.toString(this.retainDays));
                }
                Object var9_9 = null;
                if (cursor == null) break block23;
                try {
                    cursor.close();
                }
                catch (Exception e222222) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block23;
                    traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while committing the DB Connection");
                }
            }
            if (dbConn != null) {
                block24: {
                    try {
                        dbConn.commit();
                    }
                    catch (Exception e222222) {
                        e222222.printStackTrace();
                        if (traceLogger == null || !traceLogger.isLogging()) break block24;
                        traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while closing the DB Connection");
                    }
                }
                try {
                    dbConn.close();
                }
                catch (Exception e222222) {
                    e222222.printStackTrace();
                }
            }
            break block26;
            {
                catch (Exception e3) {
                    Exception e222222;
                    block27: {
                        block25: {
                            e3.printStackTrace();
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_ALL, className, "getLogRetentionValuesFromDb", "Exception while retrieving retention values from the DB ");
                            }
                            Object var9_10 = null;
                            if (cursor != null) {
                                try {
                                    cursor.close();
                                }
                                catch (Exception e222222) {
                                    if (traceLogger == null || !traceLogger.isLogging()) break block25;
                                    traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while committing the DB Connection");
                                }
                            }
                        }
                        if (dbConn == null) break block26;
                        try {
                            dbConn.commit();
                        }
                        catch (Exception e222222) {
                            e222222.printStackTrace();
                            if (traceLogger == null || !traceLogger.isLogging()) break block27;
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while closing the DB Connection");
                        }
                    }
                    try {
                        dbConn.close();
                    }
                    catch (Exception e222222) {
                        e222222.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e222222;
                block28: {
                    Object var9_11 = null;
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Exception e222222) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block28;
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while committing the DB Connection");
                        }
                    }
                }
                if (dbConn != null) {
                    block29: {
                        try {
                            dbConn.commit();
                        }
                        catch (Exception e222222) {
                            e222222.printStackTrace();
                            if (traceLogger == null || !traceLogger.isLogging()) break block29;
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getLogRetentionValuesFromDb", "Exception while closing the DB Connection");
                        }
                    }
                    try {
                        dbConn.close();
                    }
                    catch (Exception e222222) {
                        e222222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList getLogFileNames(int schedule_id, int sid_run_number) {
        ArrayList<String> logFileList;
        block28: {
            Exception e222222;
            DBResultSet logFileDbr;
            DBConnection connection;
            block26: {
                block25: {
                    String methodName = "getLogFileNames";
                    logFileList = new ArrayList<String>();
                    connection = ServiceUtils.getConnection();
                    String logFileSql = "SELECT Log_file_name FROM  T_RUN_JOBS AS T_RUN_JOBS  WHERE T_RUN_JOBS.SID_RUN_NUMBER <= " + Integer.toString(sid_run_number) + " And T_RUN_JOBS.SCHEDULE_ID= " + Integer.toString(schedule_id);
                    String logFileDeletionSql = "delete FROM  T_RUN_JOBS AS T_RUN_JOBS  WHERE T_RUN_JOBS.SID_RUN_NUMBER <= " + Integer.toString(sid_run_number) + " And T_RUN_JOBS.SCHEDULE_ID= " + Integer.toString(schedule_id);
                    logFileDbr = null;
                    logFileDbr = ComplexQuery.sqlQuery(connection, logFileSql, new Hashtable());
                    if (logFileDbr != null) {
                        while (logFileDbr.next()) {
                            String fileName = logFileDbr.getString("Log_file_name");
                            if (!fileName.startsWith(this.getDeviceServerLogDir())) continue;
                            logFileList.add(fileName);
                        }
                    }
                    if (logFileList.size() != 0 || traceLogger == null || !traceLogger.isLogging()) break block25;
                    traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "No file names returned for scheduleId =" + Integer.toString(schedule_id) + " And sid_run_number<= " + Integer.toString(sid_run_number));
                }
                Object var11_11 = null;
                if (logFileDbr == null) break block26;
                try {
                    logFileDbr.close();
                }
                catch (Exception e222222) {
                    e222222.printStackTrace();
                    if (traceLogger == null || !traceLogger.isLogging()) break block26;
                    traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while closing the logFile DB Result Set");
                }
            }
            if (connection != null) {
                block27: {
                    try {
                        connection.commit();
                    }
                    catch (Exception e222222) {
                        e222222.printStackTrace();
                        if (traceLogger == null || !traceLogger.isLogging()) break block27;
                        traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while committing the DB Connection");
                    }
                }
                try {
                    connection.close();
                }
                catch (Exception e222222) {
                    e222222.printStackTrace();
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while closing the DB Connection");
                    }
                    break block28;
                }
            }
            break block28;
            {
                catch (Exception e3) {
                    Exception e222222;
                    block30: {
                        block29: {
                            e3.printStackTrace();
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_WARN, className, "getLogFileNames", "Exception while getting log file names from the DB ");
                            }
                            Object var11_12 = null;
                            if (logFileDbr != null) {
                                try {
                                    logFileDbr.close();
                                }
                                catch (Exception e222222) {
                                    e222222.printStackTrace();
                                    if (traceLogger == null || !traceLogger.isLogging()) break block29;
                                    traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while closing the logFile DB Result Set");
                                }
                            }
                        }
                        if (connection == null) break block28;
                        try {
                            connection.commit();
                        }
                        catch (Exception e222222) {
                            e222222.printStackTrace();
                            if (traceLogger == null || !traceLogger.isLogging()) break block30;
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while committing the DB Connection");
                        }
                    }
                    try {
                        connection.close();
                    }
                    catch (Exception e222222) {
                        e222222.printStackTrace();
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while closing the DB Connection");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block33: {
                    Exception e222222;
                    block31: {
                        Object var11_13 = null;
                        if (logFileDbr != null) {
                            try {
                                logFileDbr.close();
                            }
                            catch (Exception e222222) {
                                e222222.printStackTrace();
                                if (traceLogger == null || !traceLogger.isLogging()) break block31;
                                traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while closing the logFile DB Result Set");
                            }
                        }
                    }
                    if (connection != null) {
                        block32: {
                            try {
                                connection.commit();
                            }
                            catch (Exception e222222) {
                                e222222.printStackTrace();
                                if (traceLogger == null || !traceLogger.isLogging()) break block32;
                                traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while committing the DB Connection");
                            }
                        }
                        try {
                            connection.close();
                        }
                        catch (Exception e222222) {
                            e222222.printStackTrace();
                            if (traceLogger == null || !traceLogger.isLogging()) break block33;
                            traceLogger.text(IRecordType.TYPE_INFO, className, "getLogFileNames", "Exception while closing the DB Connection");
                        }
                    }
                }
                throw throwable;
            }
        }
        return logFileList;
    }

    private String getDeviceServerLogDir() {
        String baseDir = Variables.getBaseDirectory();
        String logDir = baseDir + File.separator + "log" + File.separator;
        return logDir;
    }

    private void purgeLogFiles(ArrayList fileNames) {
        String methodName = "purgeLogFiles";
        if (fileNames != null) {
            for (int i = 0; i < fileNames.size(); ++i) {
                File file = new File((String)fileNames.get(i));
                if (file.exists()) {
                    file.delete();
                    continue;
                }
                if (traceLogger == null || !traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_INFO, className, "purgeLogFiles", "Could not delete non existent File " + file.getName());
            }
        }
    }

    static {
        MSG_FILE = "org.eclipse.aperi.resources.Discover";
        msgLogger = null;
        traceLogger = null;
        className = JobLogDeletionHandler.class.getName();
        msgLogger = LogManagerFactory.getMessageLogger(MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
        schedRunFormat = new DecimalFormat("0000");
        jobRunFormat = new DecimalFormat("00000000");
    }
}

